/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.impl.render;

import com.kingdee.cosmic.ctrl.kds.core.IExtRender;
import com.kingdee.cosmic.ctrl.kds.core.IMouseController;
import com.kingdee.cosmic.ctrl.kds.core.RenderUtil;
import com.kingdee.cosmic.ctrl.kds.core.SpreadView;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.impl.state.mouse.ColMouseController;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.cosmic.ctrl.kds.model.struct.SortedAttributeSpanArray;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;

public final class ColExtRender
implements IExtRender {
    private SpreadContext _context;

    public ColExtRender(SpreadContext context) {
        this._context = context;
    }

    @Override
    public int getPaintMode() {
        ColMouseController cs;
        IMouseController mc = this._context.getSpread().getMouseController(1);
        if (mc instanceof ColMouseController && (cs = (ColMouseController)mc).isResizing()) {
            return 2;
        }
        return 0;
    }

    @Override
    public void paint(Graphics2D g2d, SpreadView view, int paintMode) {
        if (paintMode == 2) {
            ColMouseController cs = (ColMouseController)view.getMouseController();
            Sheet sheet = view.getSpread().getBook().getActiveSheet();
            this.paintImpl(g2d, sheet, cs.getOffset(), cs.getCurCol(), cs.getCurColVirtualW(), cs.getPressCol());
        }
    }

    public void paintImpl(Graphics2D g2d, Sheet sheet, int offset, int curCol, int curColWidth, int pressCol) {
        int firstX;
        Rectangle clip = g2d.getClipBounds();
        clip.width -= offset;
        int firstCol = SheetBaseMath.colAtPoint(sheet, clip.getLocation());
        if (firstCol < 0) {
            return;
        }
        if (firstCol > pressCol) {
            firstCol = pressCol;
        }
        int endCol = SheetBaseMath.colAtPoint(sheet, new Point(clip.x + clip.width - 1, clip.y + clip.height - 1));
        endCol = SheetBaseMath.dealInvalidCol(endCol);
        SortedAttributeSpanArray colSpans = sheet.getColSpans();
        int endX = firstX = SheetBaseMath.getColX(sheet, firstCol) - 1;
        int y1 = 0;
        int h = sheet.getColHeaderHeight();
        int y2 = h - 1;
        int defW = sheet.getDefColWidth();
        int preIndex = colSpans.searchSpan(firstCol - 1);
        boolean preIsHide = preIndex >= 0 && !colSpans.getAttributeSpan(preIndex).isVisible();
        SortedAttributeSpanArray.AttributeSpan span = null;
        for (int column = firstCol; column <= endCol; ++column) {
            int width;
            if (column > curCol && column <= pressCol) continue;
            boolean isHide = false;
            boolean isDefault = true;
            if (column == curCol) {
                width = curColWidth;
            } else {
                int index = colSpans.searchSpan(column);
                if (index >= 0) {
                    span = colSpans.getAttributeSpan(index);
                    if (span.isVisible()) {
                        isHide = false;
                        isDefault = false;
                    } else {
                        preIsHide = true;
                        column = span.getEnd();
                        continue;
                    }
                }
                width = isDefault ? defW : span.getLength();
            }
            int spacing = SheetBaseMath.getColSpacing();
            Rectangle rect = new Rectangle(endX + 1, y1, width + spacing, sheet.getColHeaderHeight());
            g2d.setColor(RenderUtil.HEAD_GRID_COLOR);
            if (column == pressCol + 1 && pressCol > curCol) {
                preIsHide = true;
            }
            if (preIsHide) {
                g2d.fillRect(endX + 1, y1, 1, h);
            }
            preIsHide = isHide;
            g2d.fillRect(endX, y1, 1, h);
            endX += width + spacing;
            String txt = SheetBaseMath.getColumnName(sheet, column);
            RenderUtil.paintHeaderContent(g2d, sheet, txt, rect);
            RenderUtil.paintHeaderBackground(g2d, sheet.getSheetOption().getSelection().getSelectModeAtCol(column), rect);
        }
        g2d.setColor(RenderUtil.HEAD_GRID_COLOR);
        g2d.fillRect(endX, y1, 1, h);
        g2d.fillRect(firstX, y1, endX - firstX + 1, 1);
        g2d.fillRect(firstX, y2, endX - firstX + 1, 1);
    }
}

