/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.impl.state;

import com.kingdee.cosmic.ctrl.kds.core.SpreadView;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.impl.facade.fairy.FairyButton;
import com.kingdee.cosmic.ctrl.kds.impl.state.DefaultState;
import com.kingdee.cosmic.ctrl.kds.impl.state.SpreadStateManager;
import com.kingdee.cosmic.ctrl.kds.model.struct.Range;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.event.BookChangeEvent;
import com.kingdee.cosmic.ctrl.kds.model.struct.event.SheetChangeEvent;
import java.awt.Component;

public class PasteState
extends DefaultState {
    private SpreadView _dstView;
    private Sheet _dstSheet;
    private Range _dstRange;

    PasteState(SpreadContext context, Range dstRange) {
        super(context);
        this.init(dstRange);
    }

    void init(Range dstRange) {
        this._dstRange = dstRange;
        this._dstView = this._context.getSpread().getActiveView();
        this._dstSheet = this._context.getBook().getActiveSheet();
    }

    @Override
    public boolean cancel(int forceKey) {
        return this.stop(forceKey);
    }

    @Override
    public int getKey() {
        return SpreadStateManager.Key_Pasted;
    }

    @Override
    public boolean start(int preKey) {
        this._context.getFacadeManager().showPasteOption(this._dstView, this._dstRange);
        return true;
    }

    @Override
    public boolean stop(int forceKey) {
        FairyButton fb = this._context.getFacadeManager().getPasteOptionButton();
        this._dstView.remove((Component)((Object)fb));
        this._dstView.repaint(fb.getBounds());
        this._dstSheet = null;
        return true;
    }

    @Override
    public void changed(BookChangeEvent e) {
        if (e.isSheetActive()) {
            FairyButton fb = this._context.getFacadeManager().getPasteOptionButton();
            fb.setVisible(this._dstSheet == this._context.getBook().getActiveSheet());
        }
    }

    @Override
    public void changed(SheetChangeEvent e) {
        if (e.hasState(SheetChangeEvent.Changed_UndoRedo)) {
            FairyButton fb = this._context.getFacadeManager().getPasteOptionButton();
            fb.setVisible(false);
        }
    }
}

