/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.impl.state.mouse;

import com.kingdee.cosmic.ctrl.common.hyperlink.HyperLink;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.common.util.ThreadLocalUtil;
import com.kingdee.cosmic.ctrl.ext.rd.celltree.TreeCellPopMenuHelper;
import com.kingdee.cosmic.ctrl.ext.rd.celltree.TreeCellUtil;
import com.kingdee.cosmic.ctrl.ext.rd.ui.views.peview.style.AbstractStyleArea;
import com.kingdee.cosmic.ctrl.ext.util.MiscUtil;
import com.kingdee.cosmic.ctrl.extcommon.util.ObjectCache;
import com.kingdee.cosmic.ctrl.extcommon.util.SOAUtil;
import com.kingdee.cosmic.ctrl.extcommon.util.SortedObjectArray;
import com.kingdee.cosmic.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import com.kingdee.cosmic.ctrl.kds.core.KDSpread;
import com.kingdee.cosmic.ctrl.kds.core.SpreadView;
import com.kingdee.cosmic.ctrl.kds.expans.model.ExtConst;
import com.kingdee.cosmic.ctrl.kds.expans.model.ExtProps;
import com.kingdee.cosmic.ctrl.kds.expans.model.collection.SortedExtPropFormulasArray;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ETTargets;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtTransitionTarget;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExternalTargets;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.HyperlinkCalculableProps;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ICalculableProps;
import com.kingdee.cosmic.ctrl.kds.impl.SelectionAdapter;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.impl.action.SpreadAction;
import com.kingdee.cosmic.ctrl.kds.impl.facade.MultiLanguageKeys;
import com.kingdee.cosmic.ctrl.kds.impl.icons.ResourceManager;
import com.kingdee.cosmic.ctrl.kds.impl.render.DragRubberRender;
import com.kingdee.cosmic.ctrl.kds.impl.state.SpreadStateManager;
import com.kingdee.cosmic.ctrl.kds.impl.state.mouse.DefaultMouseController;
import com.kingdee.cosmic.ctrl.kds.impl.state.mouse.DefaultMouseState;
import com.kingdee.cosmic.ctrl.kds.impl.state.mouse.IMouseState;
import com.kingdee.cosmic.ctrl.kds.impl.state.mouse.IMouseStateController;
import com.kingdee.cosmic.ctrl.kds.impl.state.mouse.OutlineGroupColHeaderMouseController;
import com.kingdee.cosmic.ctrl.kds.impl.state.mouse.OutlineGroupRowHeaderMouseController;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.CellBlock;
import com.kingdee.cosmic.ctrl.kds.model.struct.Column;
import com.kingdee.cosmic.ctrl.kds.model.struct.FillType;
import com.kingdee.cosmic.ctrl.kds.model.struct.KDClipboard;
import com.kingdee.cosmic.ctrl.kds.model.struct.MergeBlocks;
import com.kingdee.cosmic.ctrl.kds.model.struct.PasteMode;
import com.kingdee.cosmic.ctrl.kds.model.struct.PrintSetup;
import com.kingdee.cosmic.ctrl.kds.model.struct.Protection;
import com.kingdee.cosmic.ctrl.kds.model.struct.Range;
import com.kingdee.cosmic.ctrl.kds.model.struct.Row;
import com.kingdee.cosmic.ctrl.kds.model.struct.Selection;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.cosmic.ctrl.kds.model.struct.SortedAttributeSpanArray;
import com.kingdee.cosmic.ctrl.kds.model.struct.Span;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedObject;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.HotSpot;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.INativeEmbedment;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.EChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.QingChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.subrpt.SubReportEmbed;
import com.kingdee.cosmic.ctrl.kds.model.struct.event.SheetChangeEvent;
import com.kingdee.cosmic.ctrl.kds.model.util.SortedCellBlockArray;
import com.kingdee.cosmic.ctrl.kds.model.util.SortedSpanArray;
import com.kingdee.cosmic.ctrl.kds.print.PrintManager;
import com.kingdee.cosmic.ctrl.kds.util.EmbedMove;
import com.kingdee.cosmic.ctrl.print.printjob.table.PlugablePaginationAdvice;
import com.kingdee.cosmic.ctrl.print.printjob.table.SheetPlugablePaginationAdvice;
import com.kingdee.cosmic.ctrl.print.printjob.table.SheetPrintJob;
import com.kingdee.cosmic.ctrl.swing.KDMenuItem;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.apache.log4j.Logger;

public class TableMouseController
extends DefaultMouseController {
    private static final Logger logger = LogUtil.getPackageLogger(TableMouseController.class);
    protected SpreadContext _context;
    private Rectangle _bufRect1 = new Rectangle();
    private Rectangle _bufRect2 = new Rectangle();
    private static final int SELECT = 1;
    private static final int MOVE = 2;
    private static final int FILL = 3;
    private static final int GRAPH = 4;
    private static final int StyleFetch = 5;
    private static final int StyleBrush = 6;
    private static final int InvalidGraph = 7;
    private static final int PaginationRowGridMove = 8;
    private static final int PaginationColGridMove = 9;
    private int _stateFlag = 1;
    private IMouseState ss = new SelectCellsState();
    private IMouseState ms = new MoveCellsState();
    private IMouseState fs = new FillCellsState();
    private IMouseState gs = new GraphState();
    private IMouseState prgs;
    private IMouseState pcgs;
    private boolean cellSelect = true;

    public TableMouseController(SpreadContext context) {
        this._context = context;
        this.prgs = new PaginationRowGridState(context);
        this.pcgs = new PaginationColGridState(context);
        this.gs = new GraphState(context);
    }

    public void setCellSelect(boolean cellSelect) {
        this.cellSelect = cellSelect;
    }

    public boolean isCellSelect() {
        return this.cellSelect;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        CellBlock cb;
        Point p = e.getPoint();
        SpreadView view = (SpreadView)e.getSource();
        Book book = view.getSpread().getBook();
        Sheet sheet = book.getActiveSheet();
        if (sheet == null) {
            sheet = book.getSheet(0);
        }
        if (sheet == null) {
            return;
        }
        EmbedhLayer gl = sheet.getEmbedments(false);
        Protection pro = sheet.getSheetOption().getProtection(false);
        if (gl != null) {
            HotSpot hs;
            if (pro == null || pro.allowEditObjects()) {
                hs = gl.getTouchHotSpot(p);
                if (hs != null) {
                    this._stateFlag = 4;
                    int type = hs.getType();
                    if (type == 8 || type == 7) {
                        view.setCursor(Cursor.getPredefinedCursor(8));
                        return;
                    }
                    if (type == 5 || type == 6) {
                        view.setCursor(Cursor.getPredefinedCursor(11));
                        return;
                    }
                    if (type == 1 || type == 4) {
                        view.setCursor(Cursor.getPredefinedCursor(5));
                        return;
                    }
                    if (type == 2 || type == 3) {
                        view.setCursor(Cursor.getPredefinedCursor(4));
                        return;
                    }
                } else {
                    EmbedObject gr = gl.getTouchEmbed(p);
                    if (gr != null) {
                        this._stateFlag = 4;
                        if (!(gr instanceof SubReportEmbed)) {
                            view.setCursor(Cursor.getPredefinedCursor(13));
                        }
                        return;
                    }
                    if (gl.isFocusArea(p) != null) {
                        this._stateFlag = 4;
                        view.setCursor(Cursor.getPredefinedCursor(13));
                        return;
                    }
                    if (gl.getFocusedEmbed(p) != null) {
                        this._stateFlag = 4;
                        view.setCursor(Cursor.getPredefinedCursor(0));
                        return;
                    }
                }
            } else {
                hs = gl.getTouchHotSpot(p);
                if (hs != null) {
                    this._stateFlag = 7;
                    return;
                }
                EmbedObject gr = gl.getTouchEmbed(p);
                if (gr != null) {
                    this._stateFlag = 7;
                    return;
                }
                if (gl.isFocusArea(p) != null) {
                    this._stateFlag = 7;
                    return;
                }
            }
        }
        int[] rowSnapshots = sheet.getRowPaginationPointsSnapshot();
        int[] colSnapshots = sheet.getColPaginationPointsSnapshot();
        if (rowSnapshots != null && colSnapshots != null) {
            int i;
            int maxRow = sheet.getMaxRowIndex();
            int maxCol = sheet.getMaxColIndex();
            int viewX = view.getVisibleRect().x;
            int viewY = view.getVisibleRect().y;
            for (i = 0; i < colSnapshots.length; ++i) {
                if (colSnapshots[i] == 0) continue;
                cb = CellBlock.getCellBlock(0, colSnapshots[i], maxRow, colSnapshots[i]);
                this._bufRect1 = SheetBaseMath.getBlockRect(sheet, cb, true, this._bufRect1);
                if (!SheetBaseMath.getSelectionRightRect(viewY, this._bufRect1, false, false, this._bufRect2).contains(p)) continue;
                view.setCursor(Cursor.getPredefinedCursor(10));
                this._stateFlag = 9;
                return;
            }
            for (i = 0; i < rowSnapshots.length; ++i) {
                if (rowSnapshots[i] == 0) continue;
                cb = CellBlock.getCellBlock(rowSnapshots[i], 0, rowSnapshots[i], maxCol);
                this._bufRect1 = SheetBaseMath.getBlockRect(sheet, cb, true, this._bufRect1);
                if (!SheetBaseMath.getSelectionBottomRect(viewX, this._bufRect1, false, false, this._bufRect2).contains(p)) continue;
                view.setCursor(Cursor.getPredefinedCursor(8));
                this._stateFlag = 8;
                return;
            }
        }
        this.showComment(e);
        Selection sel = sheet.getSheetOption().getSelection();
        this._stateFlag = 1;
        if (sel.isSingleBlock() && !this._context.getStateManager().isState2(SpreadStateManager.Key_Range_Select)) {
            SpreadAction action;
            int viewX = view.getVisibleRect().x;
            int viewY = view.getVisibleRect().y;
            boolean isRow = sel.isRowBlocks();
            boolean isCol = sel.isColBlocks();
            this._bufRect1 = SheetBaseMath.getBlockRect(sheet, sel.getActiveBlock(), true, this._bufRect1);
            if (SheetBaseMath.getSelectionTopRect(this._bufRect1, isRow, isCol, this._bufRect2).contains(p) || SheetBaseMath.getSelectionLeftRect(this._bufRect1, isRow, isCol, this._bufRect2).contains(p) || SheetBaseMath.getSelectionBottomRect(viewX, this._bufRect1, isRow, isCol, this._bufRect2).contains(p) || SheetBaseMath.getSelectionRightRect(viewY, this._bufRect1, isRow, isCol, this._bufRect2).contains(p)) {
                action = this._context.getActionManager().getAction("Cut");
                if (action == null || action.isEnabled()) {
                    Cell cell;
                    boolean bMove = true;
                    if (MiscUtil.isExecutedBook(book) && (cell = sheet.getFirstCell(sel.getActiveBlock(), false)) != null) {
                        boolean bl = bMove = cell.getSubReportInfo() == null;
                    }
                    if (bMove) {
                        this._stateFlag = 2;
                    }
                }
            } else if (SheetBaseMath.getSelectionCornerRect(viewX, viewY, this._bufRect1, isRow, isCol, this._bufRect2).contains(p) && ((action = this._context.getActionManager().getAction("Fill")) == null || action.isEnabled())) {
                this._stateFlag = 3;
            }
        }
        if (this._context.getStateManager().isState(SpreadStateManager.Key_Style_Brush)) {
            this._stateFlag = 6;
        } else if (this._context.getStateManager().isState(SpreadStateManager.Key_Style_Fetch)) {
            this._stateFlag = 5;
        }
        switch (this._stateFlag) {
            case 2: {
                view.setCursor(Cursor.getPredefinedCursor(13));
                break;
            }
            case 3: {
                view.setCursor(Cursor.getPredefinedCursor(1));
                break;
            }
            case 6: {
                view.setCursor(ResourceManager.getCustomCursor8Based(view, "tbtn_stylebrush.gif"));
                break;
            }
            case 5: {
                view.setCursor(ResourceManager.getCustomCursor(view, "selectcomponent_enable.gif"));
                break;
            }
            default: {
                int r = SheetBaseMath.rowAtPoint(sheet, p);
                int c = SheetBaseMath.colAtPoint(sheet, p);
                boolean bHand = false;
                Cell cell = sheet.getCell(r, c, false);
                if (cell != null) {
                    bHand = cell.getHyperLink() != null;
                } else {
                    cb = sheet.getMergeBlock(r, c);
                    if (cb != null) {
                        cell = sheet.getFirstCell(cb, false);
                        boolean bl = bHand = cell.getHyperLink() != null;
                    }
                }
                if (bHand) {
                    view.setCursor(Cursor.getPredefinedCursor(12));
                    break;
                }
                view.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    @Override
    public IMouseState prePressing(MouseEvent e) {
        IMouseState ms;
        SpreadStateManager sMgr = this._context.getStateManager();
        if (!sMgr.isState2(SpreadStateManager.Key_Range_Select) && !sMgr.stopEditing()) {
            return null;
        }
        IMouseStateController msc = this._context.getUserStateController();
        if (msc != null && (ms = msc.prePressing(e)) != null) {
            return ms;
        }
        this._context.getSpread().setActiveView((SpreadView)e.getSource());
        switch (this._stateFlag) {
            case 3: {
                return this.fs;
            }
            case 2: {
                return this.ms;
            }
            case 4: {
                return this.gs;
            }
            case 1: 
            case 5: 
            case 6: {
                return this.ss;
            }
            case 8: {
                return this.prgs;
            }
            case 9: {
                return this.pcgs;
            }
        }
        return null;
    }

    private void showComment(MouseEvent e) {
        Point p = e.getPoint();
        SpreadView view = (SpreadView)e.getSource();
        Sheet sheet = view.getSpread().getBook().getActiveSheet();
        int row = SheetBaseMath.rowAtPoint(sheet, p);
        int col = SheetBaseMath.colAtPoint(sheet, p);
        MergeBlocks merger = sheet.getSheetOption().getMerger(false);
        CellBlock mergeBlock = null;
        if (merger != null) {
            mergeBlock = merger.searchBlock(row, col);
        }
        Cell cell = null;
        cell = mergeBlock == null ? sheet.getCell(row, col, false) : sheet.getCell(mergeBlock.getRow(), mergeBlock.getCol(), false);
        if (cell == null || cell.getComment() == null) {
            this._context.getFacadeManager().showCommentComponent((SpreadView)e.getSource(), row, col, false);
        } else {
            this._context.getFacadeManager().showCommentComponent((SpreadView)e.getSource(), cell.getRow(), cell.getCol(), true);
        }
    }

    private boolean needShowPopup(MouseEvent e) {
        return e.getButton() == 3 && e.getClickCount() == 1;
    }

    private boolean needReSelect(MouseEvent e) {
        SpreadView view = (SpreadView)e.getSource();
        Sheet sheet = view.getSpread().getBook().getActiveSheet();
        Point p = e.getPoint();
        int row = SheetBaseMath.rowAtPoint(sheet, p);
        int col = SheetBaseMath.colAtPoint(sheet, p);
        return !sheet.getSheetOption().getSelection().contains(row, col);
    }

    private void showPopupMenu(MouseEvent e) {
        SpreadView view = (SpreadView)e.getSource();
        this._context.getPopMenuManager().getPopMenu().show(view, e.getX(), e.getY());
    }

    protected Area calcDragFillInteior(Sheet sheet, CellBlock block, int pos, boolean yDir) {
        this._bufRect1 = SheetBaseMath.getBlockRect(sheet, yDir ? pos : block.getRow(), yDir ? block.getCol() : pos, block.getRow2(), block.getCol2(), true, this._bufRect1);
        return new Area(this._bufRect1);
    }

    protected Area calcDragFillBorder(Sheet sheet, CellBlock block) {
        this._bufRect1 = SheetBaseMath.getBlockRect(sheet, block, true, this._bufRect1);
        this._bufRect2.setRect(this._bufRect1.getX() - 1.0, this._bufRect1.getY() - 1.0, this._bufRect1.getWidth() + 2.0, this._bufRect1.getHeight() + 2.0);
        SheetBaseMath.bufferRect(this._bufRect1, 2, 2, -4, -4);
        Area dragArea = new Area(this._bufRect2);
        dragArea.subtract(new Area(this._bufRect1));
        return dragArea;
    }

    class FillCellsState
    extends DefaultMouseState {
        CellBlock _srcBlock;
        Rectangle _srcRect;
        Rectangle _srcRectBuffer;
        Rectangle _spotRectBuffer;
        Point _focus1;
        Point _focus2;
        boolean _sameY;
        boolean _started;
        boolean _lastDir;
        int _lastRow;
        int _lastCol;
        CellBlock _dstBlock;
        boolean _keeped;
        SortedSpanArray _rowArray;
        SortedSpanArray _colArray;

        FillCellsState() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int temp;
            Sheet sheet = TableMouseController.this._context.getBook().getActiveSheet();
            Selection sel = sheet.getSheetOption().getSelection();
            this._srcBlock = sel.getActiveBlock();
            int leftBuffer = 0;
            if (this._srcBlock.getCol() > 0) {
                leftBuffer = SheetBaseMath.getColWidth(sheet, this._srcBlock.getCol() - 1) / 2;
            }
            int rightBuffer = 0;
            if (this._srcBlock.getCol2() < 65535) {
                rightBuffer = SheetBaseMath.getColWidth(sheet, this._srcBlock.getCol2() + 1) / 2;
            }
            int topBuffer = 0;
            if (this._srcBlock.getRow() > 0) {
                topBuffer = SheetBaseMath.getRowHeight(sheet, this._srcBlock.getRow() - 1) / 2;
            }
            int bottomBuffer = 0;
            if (this._srcBlock.getRow2() < 1048575) {
                bottomBuffer = SheetBaseMath.getRowHeight(sheet, this._srcBlock.getRow2() + 1) / 2;
            }
            this._srcRect = SheetBaseMath.getBlockRect(sheet, this._srcBlock, true);
            int innerDeltX = SheetBaseMath.getColWidth(sheet, this._srcBlock.getCol2()) / 2;
            int innerDeltY = SheetBaseMath.getRowHeight(sheet, this._srcBlock.getRow2()) / 2;
            this._spotRectBuffer = new Rectangle(this._srcRect.x + this._srcRect.width - innerDeltX, this._srcRect.y + this._srcRect.height - innerDeltY, innerDeltX + rightBuffer + 1, innerDeltY + bottomBuffer + 1);
            this._srcRectBuffer = new Rectangle(this._srcRect.x - leftBuffer, this._srcRect.y - topBuffer, this._srcRect.width + leftBuffer + rightBuffer, this._srcRect.height + topBuffer + bottomBuffer);
            if (this._srcRect.getWidth() > this._srcRect.getHeight()) {
                this._sameY = true;
                temp = (this._srcRect.height - 1) / 2;
                this._focus1 = new Point(this._srcRect.x + temp, this._srcRect.y + temp);
                this._focus2 = new Point(this._srcRect.x + this._srcRect.width - 1 - temp, this._srcRect.y + temp);
            } else {
                this._sameY = false;
                temp = (this._srcRect.width - 1) / 2;
                this._focus1 = new Point(this._srcRect.x + temp, this._srcRect.y + temp);
                this._focus2 = new Point(this._srcRect.x + temp, this._srcRect.y + this._srcRect.height - 1 - temp);
            }
            this._keeped = true;
            this._started = false;
            this._dstBlock = CellBlock.getCellBlock(0, 0);
            if (this._srcBlock.isRow() || this._srcBlock.isCol()) {
                this._rowArray = null;
                this._colArray = null;
            } else {
                SortedCellBlockArray cMergeBlocks;
                MergeBlocks merger = sheet.getSheetOption().getMerger(false);
                if (merger != null && (cMergeBlocks = merger.getTouchedBlocks(this._srcBlock)) != null) {
                    this._rowArray = cMergeBlocks.toRowSpans(false);
                    this._rowArray.offset(-this._srcBlock.getRow());
                    this._colArray = cMergeBlocks.toColumnSpans(false);
                    this._colArray.offset(-this._srcBlock.getCol());
                    return;
                }
                this._rowArray = null;
                this._colArray = null;
            }
            this.getRubberRender().clear();
        }

        private int getActualRow(int row) {
            int index;
            int h;
            if (this._rowArray == null || this._rowArray.isEmpty()) {
                return row;
            }
            int startRow = this._srcBlock.getRow();
            int delt = row - startRow;
            int remain = delt % (h = this._srcBlock.getHeight());
            if (remain < 0) {
                remain = h + remain;
            }
            if ((index = this._rowArray.searchRowCol(remain)) >= 0) {
                int realRow = delt < 0 ? ((Span)this._rowArray.get(index)).getStart() : ((Span)this._rowArray.get(index)).getEnd();
                return row + realRow - remain;
            }
            return row;
        }

        private int getActualCol(int col) {
            int index;
            int w;
            if (this._colArray == null || this._colArray.isEmpty()) {
                return col;
            }
            int startCol = this._srcBlock.getCol();
            int delt = col - startCol;
            int remain = delt % (w = this._srcBlock.getWidth());
            if (remain < 0) {
                remain = w + remain;
            }
            if ((index = this._colArray.searchRowCol(remain)) >= 0) {
                int realCol = delt < 0 ? ((Span)this._colArray.get(index)).getStart() : ((Span)this._colArray.get(index)).getEnd();
                return col + realCol - remain;
            }
            return col;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            boolean needRepaint;
            boolean isColOver;
            boolean isRowOver;
            Point p = e.getPoint();
            SpreadView view = (SpreadView)e.getSource();
            Sheet sheet = view.getSpread().getBook().getActiveSheet();
            int row = SheetBaseMath.dealInvalidRow(SheetBaseMath.rowAtPoint(sheet, p));
            int col = SheetBaseMath.dealInvalidCol(SheetBaseMath.colAtPoint(sheet, p));
            view.scrollCellVisible(row, col);
            boolean isUp = this.isUp(p);
            boolean bl = isRowOver = p.getY() > (double)(SheetBaseMath.getRowY(sheet, row) + SheetBaseMath.getRowHeight(sheet, row) / 2);
            row = isRowOver && row == this._srcBlock.getRow() - 1 || !isRowOver && row == this._srcBlock.getRow() ? -1 : (isUp ? (isRowOver ? row + 1 : row) : (isRowOver ? row : row - 1));
            boolean isLeft = this.isLeft(p);
            boolean bl2 = isColOver = p.getX() > (double)(SheetBaseMath.getColX(sheet, col) + SheetBaseMath.getColWidth(sheet, col) / 2);
            if (isColOver && col == this._srcBlock.getCol() - 1 || !isColOver && col == this._srcBlock.getCol()) {
                col = -1;
            } else {
                int n = isLeft ? (isColOver ? col + 1 : col) : (col = isColOver ? col : col - 1);
            }
            if (row >= 0 && (row = this.getActualRow(row)) < 0) {
                return;
            }
            if (col >= 0 && (col = this.getActualCol(col)) < 0) {
                return;
            }
            boolean yDir = this.yDir(p);
            boolean bInSpotRectBuffer = this.inSpotRectBuffer(e);
            boolean bFirstStart = !this._started && !bInSpotRectBuffer;
            boolean bChanged = this._started && (yDir != this._lastDir || yDir && this._lastRow != row || !yDir && this._lastCol != col);
            boolean bl3 = needRepaint = bFirstStart || bChanged;
            if (needRepaint) {
                this._keeped = false;
                if (this._started && bInSpotRectBuffer) {
                    this._keeped = true;
                    this._dstBlock.setRowCol(this._srcBlock);
                    this.getRubberRender().paint(view, TableMouseController.this.calcDragFillBorder(sheet, this._dstBlock));
                } else if (yDir) {
                    if (row == -1) {
                        this._dstBlock.setRowCol(this._srcBlock);
                        int rowY = SheetBaseMath.getRowY(sheet, this._srcBlock.getRow());
                        Area area = new Area(new Rectangle2D.Double(this._srcRect.getX() - 1.0, rowY - 1, this._srcRect.getWidth() + 2.0, 3.0));
                        this.getRubberRender().paint(view, area);
                    } else if (row == this._srcBlock.getRow2()) {
                        this._keeped = true;
                        this._dstBlock.setRowCol(this._srcBlock);
                        this.getRubberRender().paint(view, TableMouseController.this.calcDragFillBorder(sheet, this._dstBlock));
                    } else if (row > this._srcBlock.getRow2()) {
                        this._dstBlock.setRowCol(this._srcBlock.getRow(), this._srcBlock.getCol(), row, this._srcBlock.getCol2());
                        this.getRubberRender().paint(view, TableMouseController.this.calcDragFillBorder(sheet, this._dstBlock));
                    } else if (row < this._srcBlock.getRow()) {
                        this._dstBlock.setRowCol(row, this._srcBlock.getCol(), this._srcBlock.getRow2(), this._srcBlock.getCol2());
                        this.getRubberRender().paint(view, TableMouseController.this.calcDragFillBorder(sheet, this._dstBlock));
                    } else {
                        this._dstBlock.setRowCol(this._srcBlock.getRow(), this._srcBlock.getCol(), row, this._srcBlock.getCol2());
                        Area area = TableMouseController.this.calcDragFillBorder(sheet, this._dstBlock);
                        this.getRubberRender().paint(view, area);
                        this._dstBlock.setRowCol(row + 1, this._srcBlock.getCol(), this._srcBlock.getRow2(), this._srcBlock.getCol2());
                    }
                } else if (col == -1) {
                    this._dstBlock.setRowCol(this._srcBlock);
                    int colX = SheetBaseMath.getColX(sheet, this._srcBlock.getCol());
                    Area area = new Area(new Rectangle(colX - 1, this._srcRect.y - 1, 3, this._srcRect.height + 2));
                    this.getRubberRender().paint(view, area);
                } else if (col == this._srcBlock.getCol2()) {
                    this._keeped = true;
                    this._dstBlock.setRowCol(this._srcBlock);
                    this.getRubberRender().paint(view, TableMouseController.this.calcDragFillBorder(sheet, this._dstBlock));
                } else if (col > this._srcBlock.getCol2()) {
                    this._dstBlock.setRowCol(this._srcBlock.getRow(), this._srcBlock.getCol(), this._srcBlock.getRow2(), col);
                    this.getRubberRender().paint(view, TableMouseController.this.calcDragFillBorder(sheet, this._dstBlock));
                } else if (col < this._srcBlock.getCol()) {
                    this._dstBlock.setRowCol(this._srcBlock.getRow(), col, this._srcBlock.getRow2(), this._srcBlock.getCol2());
                    this.getRubberRender().paint(view, TableMouseController.this.calcDragFillBorder(sheet, this._dstBlock));
                } else {
                    this._dstBlock.setRowCol(this._srcBlock.getRow(), this._srcBlock.getCol(), this._srcBlock.getRow2(), col);
                    Area area = TableMouseController.this.calcDragFillBorder(sheet, this._dstBlock);
                    this.getRubberRender().paint(view, area);
                    this._dstBlock.setRowCol(this._srcBlock.getRow(), col + 1, this._srcBlock.getRow2(), this._srcBlock.getCol2());
                }
                this._lastRow = row;
                this._lastCol = col;
                this._lastDir = yDir;
                this._started = true;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            SpreadView view = (SpreadView)e.getSource();
            if (this._keeped) {
                TableMouseController.this._context.getRenderManager().getDraggedRubberRender().endPaint(view);
            } else if (this._dstBlock.contains(this._srcBlock) && !this._srcBlock.contains(this._dstBlock)) {
                if (TableMouseController.this.needShowPopup(e)) {
                    TableMouseController.this._context.getFacadeManager().getFillOptionPopup(view, TableMouseController.this._context.getRangeManager().getRange(this._srcBlock), this._dstBlock).show((Component)view, e.getX(), e.getY());
                } else {
                    TableMouseController.this._context.getRenderManager().getDraggedRubberRender().endPaint(view);
                    Range rg = TableMouseController.this._context.getRangeManager().getSelectionRangeInBook();
                    FillType resultType = new FillType(0);
                    if (rg.fill(this._dstBlock, FillType.DEFAULT, resultType)) {
                        TableMouseController.this._context.getStateManager().addState(TableMouseController.this._context.getStateManager().createFilledState(this._dstBlock, rg, resultType));
                    }
                }
            } else {
                TableMouseController.this._context.getRenderManager().getDraggedRubberRender().endPaint(view);
                TableMouseController.this._context.getStateManager().cancel();
                TableMouseController.this._context.getRangeManager().getSelectionRange().fill(this._dstBlock, null, null);
            }
        }

        private DragRubberRender getRubberRender() {
            return TableMouseController.this._context.getRenderManager().getDraggedRubberRender();
        }

        private boolean yDir(Point p) {
            if (this._srcBlock.isRow()) {
                return true;
            }
            if (this._srcBlock.isCol()) {
                return false;
            }
            int x = p.x;
            int y = p.y;
            int x1 = this._focus1.x;
            int y1 = this._focus1.y;
            int x2 = this._focus2.x;
            int y2 = this._focus2.y;
            if (this.inbufferRect(p)) {
                return this._srcRect.getMaxY() - (double)y > this._srcRect.getMaxX() - (double)x;
            }
            if (this._sameY) {
                return !(x > x2 && Math.abs(y - y2) < x - x2 || x < x1 && Math.abs(y - y1) < x1 - x);
            }
            return y > y2 && Math.abs(x - x2) < y - y2 || y < y1 && Math.abs(x - x1) < y1 - y;
        }

        private boolean isUp(Point p) {
            return this._srcRect.y > p.y;
        }

        private boolean isLeft(Point p) {
            return this._srcRect.x > p.x;
        }

        private boolean inSpotRectBuffer(MouseEvent e) {
            SpreadView view = (SpreadView)e.getSource();
            Sheet sheet = view.getSpread().getBook().getActiveSheet();
            if (this._srcBlock.isRow()) {
                int col = view.getFirstCol();
                int row = this._srcBlock.getRow2();
                int left = 0;
                if (col > 0) {
                    left = SheetBaseMath.getColWidth(sheet, col - 1) / 2;
                }
                int right = SheetBaseMath.getColWidth(sheet, col) / 2;
                int top = SheetBaseMath.getRowHeight(sheet, row) / 2;
                int bottom = 0;
                if (row < 1048575) {
                    bottom = SheetBaseMath.getRowHeight(sheet, row + 1) / 2;
                }
                this._spotRectBuffer = new Rectangle(this._srcRect.x - left, this._srcRect.y + this._srcRect.height - top, left + right + 1, top + bottom + 1);
            } else if (this._srcBlock.isCol()) {
                int row = view.getFirstRow();
                int col = this._srcBlock.getCol2();
                int left = SheetBaseMath.getColWidth(sheet, col) / 2;
                int right = 0;
                if (col < 65535) {
                    right = SheetBaseMath.getColWidth(sheet, col + 1) / 2;
                }
                int top = 0;
                if (row > 0) {
                    top = SheetBaseMath.getRowHeight(sheet, row - 1) / 2;
                }
                int bottom = SheetBaseMath.getRowHeight(sheet, row) / 2;
                this._spotRectBuffer = new Rectangle(this._srcRect.width + this._srcRect.x - left, this._srcRect.y - top, left + right + 1, top + bottom + 1);
            }
            return this._spotRectBuffer.contains(e.getPoint());
        }

        private boolean inbufferRect(Point2D p) {
            return this._srcRectBuffer.contains(p);
        }
    }

    class MoveCellsState
    extends DefaultMouseState {
        int _pressRow;
        int _pressCol;
        int _lastRow;
        int _lastCol;

        MoveCellsState() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Point point = e.getPoint();
            SpreadView view = (SpreadView)e.getSource();
            Sheet sheet = view.getSpread().getBook().getActiveSheet();
            Selection sel = sheet.getSheetOption().getSelection();
            this._pressRow = SheetBaseMath.rowAtPoint(sheet, point);
            this._pressRow = SheetBaseMath.dealInvalidRow(this._pressRow);
            this._pressCol = SheetBaseMath.colAtPoint(sheet, point);
            this._pressCol = SheetBaseMath.dealInvalidRow(this._pressCol);
            if (this._pressRow < 0 || this._pressCol < 0) {
                return;
            }
            CellBlock block = sel.getActiveBlock();
            if (this._pressRow > block.getRow2()) {
                --this._pressRow;
            } else if (this._pressRow < block.getRow()) {
                ++this._pressRow;
            }
            if (this._pressCol > block.getCol2()) {
                --this._pressCol;
            } else if (this._pressCol < block.getCol()) {
                ++this._pressCol;
            }
            this._lastRow = this._pressRow;
            this._lastCol = this._pressCol;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Point point = e.getPoint();
            SpreadView view = (SpreadView)e.getSource();
            Sheet sheet = view.getSpread().getBook().getActiveSheet();
            Selection sel = sheet.getSheetOption().getSelection();
            int row = SheetBaseMath.rowAtPoint(sheet, point);
            row = SheetBaseMath.dealInvalidRow(row);
            int col = SheetBaseMath.colAtPoint(sheet, point);
            col = SheetBaseMath.dealInvalidCol(col);
            CellBlock block = sel.getActiveBlock();
            int dr = row - this._pressRow;
            int dc = col - this._pressCol;
            int newR = block.getRow() + dr;
            int newC = block.getCol() + dc;
            int newR2 = block.getRow2() + dr;
            int newC2 = block.getCol2() + dc;
            if (newR < 0) {
                newR = 0;
                newR2 = newR + block.getHeight() - 1;
                row = this._pressRow - block.getRow() + newR;
            } else if (newR2 > 1048575) {
                newR2 = 1048575;
                newR = newR2 - block.getHeight() + 1;
                row = this._pressRow - block.getRow2() + newR2;
            }
            if (newC < 0) {
                newC = 0;
                newC2 = newC + block.getWidth() - 1;
                col = this._pressCol - block.getCol() + newC;
            } else if (newC2 > 65535) {
                newC2 = 65535;
                newC = newC2 - block.getWidth() + 1;
                col = this._pressCol - block.getCol2() + newC2;
            }
            if (row != this._lastRow || col != this._lastCol) {
                view.scrollCellVisible(row, col);
                Area area = TableMouseController.this.calcDragFillBorder(sheet, CellBlock.getCellBlock(newR, newC, newR2, newC2));
                TableMouseController.this._context.getRenderManager().getDraggedRubberRender().paint(view, area);
                this._lastRow = row;
                this._lastCol = col;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            SpreadView view = (SpreadView)e.getSource();
            TableMouseController.this._context.getRenderManager().getDraggedRubberRender().endPaint(view);
            KDSpread spread = view.getSpread();
            Sheet sheet = spread.getBook().getActiveSheet();
            Selection sel = sheet.getSheetOption().getSelection();
            CellBlock block = sel.getActiveBlock();
            if (this._lastRow != this._pressRow || this._lastCol != this._pressCol) {
                int dr = this._lastRow - this._pressRow;
                int dc = this._lastCol - this._pressCol;
                int newR = block.getRow() + dr;
                int newC = block.getCol() + dc;
                int newR2 = block.getRow2() + dr;
                int newC2 = block.getCol2() + dc;
                CellBlock cb = CellBlock.getCellBlock(newR, newC, newR2, newC2);
                if (TableMouseController.this._context.getBook().getActiveSheet().getCellsIterator(cb, false, false).next() != null && !TableMouseController.this._context.getFacadeManager().showConfirmMessageBox(MultiLanguageKeys.getLocalText("Key_ReplaceCell"))) {
                    return;
                }
                CellBlock sb = sel.getActiveBlock();
                if (!sb.equals(cb)) {
                    sheet.getBook().getUndoManager().startGroup();
                    boolean enable = KDClipboard.isEnableSpreadSheet();
                    KDClipboard.enableSpreadSheet(false);
                    boolean offset = KDClipboard.isOffset();
                    KDClipboard.setOffset(true);
                    Range srcRange = TableMouseController.this._context.getRangeManager().getRange(sb);
                    boolean bok = srcRange.cut();
                    if (bok) {
                        bok |= srcRange.clear(true, true, true, true, new String[0]);
                        Protection pro = sheet.getSheetOption().getProtection(false);
                        if (pro != null && pro.isProtected()) {
                            StyleAttributes sa = Styles.getEmptySA();
                            sa.setLocked(false);
                            srcRange.setStyle(sa, Styles.getEmptySA());
                        }
                        bok |= TableMouseController.this._context.getRangeManager().getRange(cb).paste(PasteMode.ALL, new String[0]);
                    }
                    KDClipboard.enableSpreadSheet(enable);
                    KDClipboard.setOffset(offset);
                    if (bok) {
                        sheet.getBook().getUndoManager().endGroup();
                    } else {
                        sheet.getBook().getUndoManager().cancelGroup();
                    }
                    TableMouseController.this._context.getSelection().changeSelection(cb, 2);
                }
                TableMouseController.this._context.getStateManager().stop();
            }
        }
    }

    class SelectCellsState
    extends DefaultMouseState {
        private ActionListener _al = new ActionHander();
        int _pressRow;
        int _pressCol;
        int _lastRow;
        int _lastCol;
        private boolean _bLink;

        SelectCellsState() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            SpreadView view = (SpreadView)e.getSource();
            SpreadStateManager sm = TableMouseController.this._context.getStateManager();
            if (sm.isState(SpreadStateManager.Key_Style_Fetch)) {
                sm.stop();
                view.setCursor(Cursor.getDefaultCursor());
            } else if (sm.isState(SpreadStateManager.Key_Style_Brush)) {
                Range r = TableMouseController.this._context.getRangeManager().getSelectionRangeInBook();
                SpreadAction brushAction = TableMouseController.this._context.getActionManager().getAction("inner_StyleBrush", false);
                AbstractStyleArea styleArea = (AbstractStyleArea)brushAction.getValue("StyleArea");
                if (styleArea != null) {
                    styleArea.setSelectedRangeStyle();
                    this.changeCursor(view, brushAction);
                } else if (r.paste(PasteMode.FORMATS, null)) {
                    this.changeCursor(view, brushAction);
                }
            } else if (!sm.isState(SpreadStateManager.Key_Range_Select)) {
                Book book = view.getSpread().getBook();
                Sheet sheet = book.getActiveSheet();
                book.fireSheetChange(sheet, null, SheetChangeEvent.Changed_AfterSelection);
            }
            String msg = this.calSumAndAvg(view);
            TableMouseController.this._context.updateMesage(msg);
        }

        private String calSumAndAvg(SpreadView view) {
            CellBlock cellBlock;
            Book book = view.getSpread().getBook();
            Range range = book.getSelectionRange();
            Object[] array = range.getArray();
            if (array != null && array.length > 0 && (cellBlock = (CellBlock)array[0]).isSingleCell() && array.length > 1 && (CellBlock)array[1] == null) {
                return "";
            }
            Sheet.ICellsIterator rangeCellsIterator = book.getRangeCellsIterator(range, false, true);
            BigDecimal totalBig = new BigDecimal("0");
            BigDecimal avgBig = new BigDecimal("0");
            int cellCount = 0;
            int rumericalTotal = 0;
            int isNotBig = 0;
            while (rangeCellsIterator.hasNext()) {
                Object value;
                Cell cell = rangeCellsIterator.next();
                if (cell.isHidden()) continue;
                Variant var = cell.getValue();
                Object object = value = var != null ? var.getValue() : null;
                if (var == null || value == null || var.getVt() == 12 || var.getVt() == 13) {
                    ++isNotBig;
                    continue;
                }
                if (value instanceof Number) {
                    if (value instanceof BigDecimal) {
                        ++rumericalTotal;
                        totalBig = totalBig.add((BigDecimal)value);
                    }
                    if (value instanceof Double) {
                        ++rumericalTotal;
                        totalBig = totalBig.add(BigDecimal.valueOf((Double)value));
                    }
                    if (value instanceof Integer) {
                        ++rumericalTotal;
                        totalBig = totalBig.add(new BigDecimal((Integer)value));
                    }
                }
                if (value instanceof String && StringUtil.isNumber((String)((String)value))) {
                    try {
                        Variant numberVar = Variant.stringToNumberVar((String)value);
                        if (numberVar.getValue() instanceof Number) {
                            ++rumericalTotal;
                            totalBig = totalBig.add((BigDecimal)numberVar.getValue());
                        }
                    }
                    catch (SyntaxErrorException e) {
                        logger.error((Object)"err", (Throwable)e);
                    }
                }
                ++cellCount;
                ++isNotBig;
            }
            if (rumericalTotal > 0) {
                avgBig = totalBig.divide(BigDecimal.valueOf(rumericalTotal), 2, 4);
            }
            if (cellCount > 1 && rumericalTotal > 1) {
                return CtrlEXTMessages.getMLS("averageValue", "\u5e73\u5747\u503c: ") + avgBig + CtrlEXTMessages.getMLS("counting", "   \u8ba1\u6570: ") + isNotBig + CtrlEXTMessages.getMLS("suming", "   \u6c42\u548c: ") + totalBig;
            }
            return "";
        }

        private void changeCursor(SpreadView view, SpreadAction brushAction) {
            boolean continious = false;
            if (brushAction != null) {
                Object obj = brushAction.getValue("continious");
                boolean bl = continious = obj != null ? (Boolean)obj : false;
            }
            if (continious) {
                view.setCursor(ResourceManager.getCustomCursor8Based(view, "tbtn_stylebrush.gif"));
                return;
            }
            TableMouseController.this._context.getStateManager().stop();
            view.setCursor(Cursor.getDefaultCursor());
            if (brushAction != null) {
                brushAction.putValue("StyleArea", null);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1) {
                Range activeCellRange;
                HyperLink link;
                Row rowT;
                boolean treeHandled;
                Point point = e.getPoint();
                SpreadView view = (SpreadView)e.getSource();
                Sheet sheet = view.getSpread().getBook().getActiveSheet();
                int row = SheetBaseMath.rowAtPoint(sheet, point);
                int col = SheetBaseMath.colAtPoint(sheet, point);
                Cell cell = sheet.getCell(row, col, false);
                CellBlock merge = sheet.getMergeBlock(row, col);
                Rectangle rect = null;
                boolean isTempCell = false;
                boolean isTempRow = false;
                Row rowObj = sheet.getRow(row, false);
                if (cell == null && merge != null) {
                    if (rowObj == null) {
                        isTempRow = true;
                        rowObj = sheet.getRow(row, true);
                    }
                    cell = rowObj.getCell(col, true);
                    isTempCell = row != merge.getRow() || col != merge.getCol();
                }
                if (!(treeHandled = this.handleMouseClickedWhenColumnCellTreeDisplay(cell, point, view, col, rect = merge == null ? SheetBaseMath.getCellRect(sheet, row, col, false) : SheetBaseMath.getBlockRect(sheet, merge.getRow(), merge.getCol(), merge.getRow2(), merge.getCol2(), false)))) {
                    treeHandled = this.handleMouseClickedWhenRowCellTreeDisplay(cell, point, view, row, rect);
                }
                if (isTempCell && (rowT = sheet.getRow(row, false)) != null) {
                    rowT.remove(cell.getIntMark());
                }
                if (isTempRow) {
                    sheet.getRows().remove(rowObj.getIntMark());
                }
                if (e.getClickCount() >= 2) {
                    TableMouseController.this._context.getStateManager().addState(TableMouseController.this._context.getStateManager().createEditState(e));
                } else if (this._bLink && !treeHandled && (link = (activeCellRange = TableMouseController.this._context.getRangeManager().getActiveCellRange()).getHyerLink()) != null) {
                    ExternalTargets ebt;
                    Cell activeCell = activeCellRange.getCurrentSheet().getActiveCell();
                    if (activeCell == null) {
                        return;
                    }
                    ExtProps ep = activeCell.getExtProps(true);
                    SortedExtPropFormulasArray formulas = ep.getFormulas(false);
                    if (formulas == null || formulas.isEmpty()) {
                        TableMouseController.this._context.getHyperLinkHandler().execute(link);
                        return;
                    }
                    ICalculableProps prop = formulas.get(ExtConst.FORMULA_HYPERLINK);
                    Map<String, Object> tars = ((HyperlinkCalculableProps)prop).getTargets();
                    String linkTo = link.getLinkTo();
                    final String[] arrLinkTo = linkTo.split(";");
                    final ArrayList<String> alias = new ArrayList<String>(4);
                    ETTargets ett = (ETTargets)tars.get("EXTRPT");
                    if (ett != null) {
                        List targets = ett.getTargets();
                        for (Object target : targets) {
                            alias.add(((ExtTransitionTarget)target).getReportProps().getAlias());
                        }
                    }
                    if ((ebt = (ExternalTargets)tars.get("EXTERNAL")) != null) {
                        List<Map<String, Object>> targets = ebt.getAllAssembledTargets();
                        for (Map map : targets) {
                            alias.add((String)map.get("DISPLAY_NAME"));
                        }
                    }
                    if (ebt == null && ett == null && arrLinkTo.length == 1) {
                        this.executeETTLink(new HyperLink(link.getText(), arrLinkTo[0]));
                        return;
                    }
                    if (arrLinkTo.length == 1) {
                        this.executeETTLink(new HyperLink(link.getText(), arrLinkTo[0]));
                        return;
                    }
                    JPopupMenu popMenu = new JPopupMenu();
                    for (int i = 0; i < arrLinkTo.length; ++i) {
                        KDMenuItem kDMenuItem = new KDMenuItem();
                        final int item = i;
                        kDMenuItem.addMouseListener((MouseListener)new MouseAdapter(){

                            @Override
                            public void mousePressed(MouseEvent e) {
                                super.mousePressed(e);
                                if (item == alias.size()) {
                                    HyperLink hyperLink = new HyperLink(link.getText(), arrLinkTo[item]);
                                    SelectCellsState.this.executeETTLink(hyperLink);
                                } else if (arrLinkTo[item].contains("#")) {
                                    HyperLink hyperLink = new HyperLink(arrLinkTo[item], arrLinkTo[item]);
                                    SelectCellsState.this.executeETTLink(hyperLink);
                                } else {
                                    String extAlias = (String)alias.get(item);
                                    HyperLink hyperLink = new HyperLink(link.getText(), arrLinkTo[item]);
                                    SelectCellsState.this.executeETTLink(hyperLink, extAlias);
                                }
                            }
                        });
                        if ("rptInner:".equals(arrLinkTo[i])) {
                            kDMenuItem.setText(CtrlEXTMessages.getMLS("innerLinkage", "\u8054\u52a8"));
                            popMenu.add((Component)kDMenuItem, 0);
                            continue;
                        }
                        if (arrLinkTo[i].contains("#")) {
                            String linkto = arrLinkTo[i];
                            if (arrLinkTo[i].contains("'")) {
                                String SheetName = linkto.substring(linkto.indexOf("'"), linkto.lastIndexOf("'") + 1);
                                String CellIndex = linkto.substring(linkto.indexOf("!"));
                                kDMenuItem.setText(CtrlEXTMessages.getMLS("hyperlinkTo2", "\u8d85\u94fe\u63a5\u5230\"#1\"").replace("#1", SheetName + CellIndex));
                            } else {
                                kDMenuItem.setText(CtrlEXTMessages.getMLS("hyperlinkTo2", "\u8d85\u94fe\u63a5\u5230\"#1\"").replace("#1", linkto.substring(1)));
                            }
                            popMenu.add((JMenuItem)kDMenuItem);
                            continue;
                        }
                        String extAlias = (String)alias.get(i);
                        if ((extAlias = this.trimAliasDot(extAlias)) != null && extAlias.length() > 20) {
                            extAlias = extAlias.substring(0, 20) + "...";
                        }
                        if (extAlias == null) {
                            extAlias = "";
                        }
                        kDMenuItem.setText(CtrlEXTMessages.getMLS("linkedTo", "\u8054\u67e5\u5230\"#1\"").replace("#1", extAlias));
                        popMenu.add((JMenuItem)kDMenuItem);
                    }
                    popMenu.setLocation(e.getX(), e.getY());
                    popMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        }

        private String trimAliasDot(String alias) {
            if (alias != null) {
                if (alias.startsWith("\u201c") && alias.endsWith("\u201c")) {
                    alias = alias.replaceFirst("\u201c", "");
                    alias = alias.substring(0, alias.length() - 1);
                } else if (alias.startsWith("\"") && alias.endsWith("\"")) {
                    alias = alias.replaceFirst("\"", "");
                    alias = alias.substring(0, alias.indexOf("\""));
                }
            }
            return alias;
        }

        private void executeETTLink(HyperLink link) {
            TableMouseController.this._context.getHyperLinkHandler().execute(link);
        }

        private void executeETTLink(HyperLink link, String alias) {
            try {
                ThreadLocalUtil.set((String)"alias", (Object)alias);
                TableMouseController.this._context.getHyperLinkHandler().execute(link);
            }
            finally {
                ThreadLocalUtil.remove((String)"alias");
            }
        }

        protected boolean handleMouseClickedWhenColumnCellTreeDisplay(Cell cell, Point point, SpreadView view, int col, Rectangle rect) {
            if (cell == null) {
                return false;
            }
            Sheet sheet = cell.getSheet();
            Column column = sheet.getColumn(col, false);
            if (column != null) {
                if (!TreeCellUtil.isColumnCellTreeDisplay(cell)) {
                    return false;
                }
                Book book = view.getSpread().getBook();
                book.getUndoManager().startGroup();
                boolean ret = false;
                ret = cell.getSheet().isAboveOfOutlineGroup() ? this.handleCellTreeWithAbove(rect, cell, point) : this.handleCellTreeWithBelow(rect, cell, point);
                book.getUndoManager().endGroup();
                return ret;
            }
            return false;
        }

        protected boolean handleMouseClickedWhenRowCellTreeDisplay(Cell cell, Point point, SpreadView view, int row, Rectangle rect) {
            if (cell == null) {
                return false;
            }
            Sheet sheet = cell.getSheet();
            Row rowObject = sheet.getRow(row, false);
            if (rowObject != null) {
                if (!TreeCellUtil.isRowCellTreeDisplay(cell)) {
                    return false;
                }
                Book book = view.getSpread().getBook();
                book.getUndoManager().startGroup();
                boolean ret = false;
                ret = cell.getSheet().isLeftToOutlineGroup() ? this.handleCellTreeWithLeft(rect, cell, point) : this.handleCellTreeWithRight(rect, cell, point);
                book.getUndoManager().endGroup();
                return ret;
            }
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected boolean handleCellTreeWithRight(Rectangle rect, Cell cell, Point point) {
            int cellWidth = 14;
            Sheet sheet = cell.getSheet();
            int colId = SheetBaseMath.colAtPoint(sheet, point);
            SortedAttributeSpanArray sasa = sheet.getColSpans();
            int spanPos = sasa.searchSpan(colId);
            int level = -1;
            if (spanPos < 0) {
                spanPos = sasa.searchSpan(colId - 1);
                if (spanPos < 0 || ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel() <= 0) return false;
                level = 0;
            } else {
                level = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel();
            }
            int prevColLevel = 0;
            int prevSpanPos = sasa.searchSpan(colId - 1);
            if (prevSpanPos >= 0) {
                prevColLevel = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(prevSpanPos)).getOutlineGroupLevel();
            }
            boolean isOff = false;
            boolean isDot = false;
            if (level >= prevColLevel) {
                isDot = true;
            } else {
                isOff = !((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(prevSpanPos)).isVisible();
            }
            int colX = SheetBaseMath.getColX(sheet, colId);
            int colWidth = SheetBaseMath.getColWidth(sheet, colId);
            int basePos = rect.y + (cellWidth - 3) * level;
            int rectY1 = basePos + 2;
            int rectX1 = colX + 2 + (colWidth - cellWidth) / 2;
            int rectY2 = basePos + 2 + cellWidth;
            int rectX2 = rectX1 + cellWidth;
            int pressedX = point.x;
            int pressedY = point.y;
            if (!isDot && pressedX > rectX1 && pressedX < rectX2 && pressedY > rectY1 && pressedY < rectY2) {
                OutlineGroupColHeaderMouseController.switchTheHandlerWhenRight(sheet, colId, sasa, level, isOff);
                return true;
            } else {
                int virtualLevel = (pressedY - cellWidth / 2 - rect.y) / (cellWidth - 3);
                if (virtualLevel >= level) {
                    return false;
                }
                int lineY = rect.y + virtualLevel * (cellWidth - 3) + cellWidth / 2;
                int lineY2 = rect.y + (virtualLevel + 1) * (cellWidth - 3) + cellWidth / 2;
                int distance1 = Math.abs(lineY - pressedY);
                int distance2 = Math.abs(lineY2 - pressedY);
                int distance = 0;
                if (distance1 > distance2) {
                    distance = distance2;
                    ++virtualLevel;
                } else {
                    distance = distance1;
                }
                if (distance > cellWidth / 4) {
                    return false;
                }
                boolean conjunctive = false;
                int m = colId + 1;
                while (true) {
                    int iteratedLevel;
                    int iteratedSpanPos = sasa.searchSpan(m);
                    SortedAttributeSpanArray.AttributeSpan span = null;
                    if (iteratedSpanPos < 0) {
                        iteratedLevel = 0;
                    } else {
                        span = (SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(iteratedSpanPos);
                        iteratedLevel = span.getOutlineGroupLevel();
                    }
                    if (iteratedLevel == virtualLevel) {
                        conjunctive = true;
                        break;
                    }
                    if (iteratedLevel < virtualLevel) break;
                    if (span != null) {
                        m = span.getEnd();
                    }
                    ++m;
                }
                if (!conjunctive) return true;
                OutlineGroupColHeaderMouseController.switchTheHandlerWhenRight(sheet, m, sasa, virtualLevel, isOff);
            }
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean handleCellTreeWithLeft(Rectangle rect, Cell cell, Point point) {
            Sheet sheet = cell.getSheet();
            int colId = SheetBaseMath.colAtPoint(sheet, point);
            SortedAttributeSpanArray sasa = sheet.getColSpans();
            int cellWidth = 14;
            int spanPos = sasa.searchSpan(colId);
            int level = -1;
            int nextColId = colId + 1;
            int step = 1;
            CellBlock block = cell.getMerge(true);
            if (block != null) {
                nextColId = block.getCol2() + 1;
                step += block.getCol2() - block.getCol();
            }
            if (spanPos < 0) {
                spanPos = sasa.searchSpan(nextColId);
                if (spanPos < 0 || ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel() <= 0) return false;
                level = 0;
            } else {
                level = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel();
            }
            int nextColLevel = 0;
            int nextSpanPos = sasa.searchSpan(nextColId);
            if (nextSpanPos >= 0) {
                nextColLevel = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(nextSpanPos)).getOutlineGroupLevel();
            }
            boolean isOff = false;
            boolean isDot = false;
            if (level >= nextColLevel) {
                isDot = true;
            } else {
                isOff = !((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(nextSpanPos)).isVisible();
            }
            int colWidth = SheetBaseMath.getColWidth(sheet, colId);
            if (block != null) {
                colWidth = rect.width;
            }
            int basePos = rect.y + (cellWidth - 3) * level;
            int rectY1 = basePos + 2;
            int rectX1 = rect.x + 2 + (colWidth - cellWidth) / 2;
            int rectY2 = basePos + 2 + cellWidth;
            int rectX2 = rectX1 + cellWidth;
            int pressedX = point.x;
            int pressedY = point.y;
            if (!isDot && pressedX > rectX1 && pressedX < rectX2 && pressedY > rectY1 && pressedY < rectY2) {
                OutlineGroupColHeaderMouseController.switchTheHandlerWhenLeft(sheet, nextColId - 1, sasa, level, isOff, 1);
                return true;
            } else {
                int virtualLevel = (pressedY - cellWidth / 2 - rect.y) / (cellWidth - 3);
                if (virtualLevel >= level) {
                    return false;
                }
                int lineY = rect.y + virtualLevel * (cellWidth - 3) + cellWidth / 2;
                int lineY2 = rect.y + (virtualLevel + 1) * (cellWidth - 3) + cellWidth / 2;
                int distance1 = Math.abs(lineY - pressedY);
                int distance2 = Math.abs(lineY2 - pressedY);
                int distance = 0;
                if (distance1 > distance2) {
                    distance = distance2;
                    ++virtualLevel;
                } else {
                    distance = distance1;
                }
                if (distance > cellWidth / 4) {
                    return false;
                }
                boolean conjunctive = false;
                int m = colId - step;
                while (true) {
                    int iteratedLevel;
                    int iteratedSpanPos = sasa.searchSpan(m);
                    SortedAttributeSpanArray.AttributeSpan span = null;
                    if (iteratedSpanPos < 0) {
                        iteratedLevel = 0;
                    } else {
                        span = (SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(iteratedSpanPos);
                        iteratedLevel = span.getOutlineGroupLevel();
                    }
                    if (iteratedLevel == virtualLevel) {
                        conjunctive = true;
                        break;
                    }
                    if (iteratedLevel < virtualLevel) break;
                    if (span != null) {
                        m = span.getStart();
                    }
                    m -= step;
                }
                if (!conjunctive) return true;
                OutlineGroupColHeaderMouseController.switchTheHandlerWhenLeft(sheet, m, sasa, virtualLevel, isOff, step);
            }
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected boolean handleCellTreeWithAbove(Rectangle rect, Cell cell, Point point) {
            Sheet sheet = cell.getSheet();
            int cellWidth = 14;
            int rowId = SheetBaseMath.rowAtPoint(sheet, point);
            SortedAttributeSpanArray sasa = sheet.getRowSpans();
            CellBlock block = cell.getMerge(true);
            int nextRowId = rowId + 1;
            int spanPos = -1;
            if (block != null) {
                spanPos = sasa.searchSpan(block.getRow2());
                nextRowId = block.getRow2() + 1;
            } else {
                spanPos = sasa.searchSpan(rowId);
            }
            int level = -1;
            int step = 1;
            if (spanPos < 0) {
                spanPos = sasa.searchSpan(nextRowId);
                if (spanPos < 0 || ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel() <= 0) return false;
                level = 0;
            } else {
                level = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel();
            }
            int nextRowLevel = 0;
            int nextSpanPos = sasa.searchSpan(nextRowId);
            if (nextSpanPos >= 0) {
                nextRowLevel = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(nextSpanPos)).getOutlineGroupLevel();
            }
            boolean isOff = false;
            boolean isDot = false;
            if (level >= nextRowLevel) {
                isDot = true;
            } else {
                isOff = !((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(nextSpanPos)).isVisible();
            }
            int rowHeight = SheetBaseMath.getRowHeight(sheet, rowId);
            if (block != null) {
                rowHeight = rect.height;
            }
            int basePos = rect.x + (cellWidth - 3) * level;
            int rectX1 = basePos + 2;
            int rectY1 = rect.y + (rowHeight - cellWidth) / 2 + 2;
            int rectX2 = basePos + 2 + cellWidth;
            int rectY2 = rect.y + (rowHeight - cellWidth) / 2 + 2 + cellWidth;
            int pressedX = point.x;
            int pressedY = point.y;
            if (!isDot && pressedX > rectX1 && pressedX < rectX2 && pressedY > rectY1 && pressedY < rectY2) {
                OutlineGroupRowHeaderMouseController.switchTheHandlerWhenAbove(sheet, nextRowId - 1, sasa, level, isOff, 1);
                return true;
            } else {
                int virtualLevel = (pressedX - cellWidth / 2 - rect.x) / (cellWidth - 3);
                if (virtualLevel >= level) {
                    return false;
                }
                int lineX = rect.x + virtualLevel * (cellWidth - 3) + cellWidth / 2;
                int lineX2 = rect.x + (virtualLevel + 1) * (cellWidth - 3) + cellWidth / 2;
                int distance1 = Math.abs(lineX - pressedX);
                int distance2 = Math.abs(lineX2 - pressedX);
                int distance = 0;
                if (distance1 > distance2) {
                    distance = distance2;
                    ++virtualLevel;
                } else {
                    distance = distance1;
                }
                if (distance > cellWidth / 4) {
                    return false;
                }
                boolean conjunctive = false;
                int m = rowId - step;
                while (true) {
                    int iteratedLevel;
                    int iteratedSpanPos = sasa.searchSpan(m);
                    SortedAttributeSpanArray.AttributeSpan span = null;
                    if (iteratedSpanPos < 0) {
                        iteratedLevel = 0;
                    } else {
                        span = (SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(iteratedSpanPos);
                        iteratedLevel = span.getOutlineGroupLevel();
                    }
                    if (iteratedLevel == virtualLevel) {
                        conjunctive = true;
                        break;
                    }
                    if (iteratedLevel < virtualLevel) break;
                    if (span != null) {
                        m = span.getStart();
                    }
                    m -= step;
                }
                if (!conjunctive) return true;
                OutlineGroupRowHeaderMouseController.switchTheHandlerWhenAbove(sheet, m, sasa, virtualLevel, isOff, step);
            }
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected boolean handleCellTreeWithBelow(Rectangle rect, Cell cell, Point point) {
            Sheet sheet = cell.getSheet();
            int cellWidth = 14;
            int rowId = SheetBaseMath.rowAtPoint(sheet, point);
            SortedAttributeSpanArray sasa = sheet.getRowSpans();
            int spanPos = sasa.searchSpan(rowId);
            int level = -1;
            if (spanPos < 0) {
                spanPos = sasa.searchSpan(rowId - 1);
                if (spanPos < 0 || ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel() <= 0) return false;
                level = 0;
            } else {
                level = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel();
            }
            int prevRowLevel = 0;
            int prevSpanPos = sasa.searchSpan(rowId - 1);
            if (prevSpanPos >= 0) {
                prevRowLevel = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(prevSpanPos)).getOutlineGroupLevel();
            }
            boolean isOff = false;
            boolean isDot = false;
            if (level >= prevRowLevel) {
                isDot = true;
            } else {
                isOff = !((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(prevSpanPos)).isVisible();
            }
            int rowY = SheetBaseMath.getRowY(sheet, rowId);
            int rowHeight = SheetBaseMath.getRowHeight(sheet, rowId);
            int basePos = rect.x + (cellWidth - 3) * level;
            int rectX1 = basePos + 2;
            int rectY1 = rowY + (rowHeight - cellWidth) / 2 + 2;
            int rectX2 = basePos + 2 + cellWidth;
            int rectY2 = rowY + (rowHeight - cellWidth) / 2 + 2 + cellWidth;
            int pressedX = point.x;
            int pressedY = point.y;
            if (!isDot && pressedX > rectX1 && pressedX < rectX2 && pressedY > rectY1 && pressedY < rectY2) {
                OutlineGroupRowHeaderMouseController.switchTheHandlerWhenBelow(sheet, rowId, sasa, level, isOff);
                return true;
            } else {
                int virtualLevel = (pressedX - cellWidth / 2 - rect.x) / (cellWidth - 3);
                if (virtualLevel >= level) {
                    return false;
                }
                int lineX = rect.x + virtualLevel * (cellWidth - 3) + cellWidth / 2;
                int lineX2 = rect.x + (virtualLevel + 1) * (cellWidth - 3) + cellWidth / 2;
                int distance1 = Math.abs(lineX - pressedX);
                int distance2 = Math.abs(lineX2 - pressedX);
                int distance = 0;
                if (distance1 > distance2) {
                    distance = distance2;
                    ++virtualLevel;
                } else {
                    distance = distance1;
                }
                if (distance > cellWidth / 4) {
                    return false;
                }
                boolean conjunctive = false;
                int m = rowId + 1;
                while (true) {
                    int iteratedLevel;
                    int iteratedSpanPos = sasa.searchSpan(m);
                    SortedAttributeSpanArray.AttributeSpan span = null;
                    if (iteratedSpanPos < 0) {
                        iteratedLevel = 0;
                    } else {
                        span = (SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(iteratedSpanPos);
                        iteratedLevel = span.getOutlineGroupLevel();
                    }
                    if (iteratedLevel == virtualLevel) {
                        conjunctive = true;
                        break;
                    }
                    if (iteratedLevel < virtualLevel) break;
                    if (span != null) {
                        m = span.getEnd();
                    }
                    ++m;
                }
                if (!conjunctive) return true;
                OutlineGroupRowHeaderMouseController.switchTheHandlerWhenBelow(cell.getSheet(), m, sasa, virtualLevel, isOff);
            }
            return true;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            SpreadView view = (SpreadView)e.getSource();
            Sheet sheet = view.getSpread().getBook().getActiveSheet();
            EmbedhLayer gl = sheet.getEmbedments(false);
            if (gl != null) {
                gl.cancelSelectedEmbeds();
            }
            this._bLink = true;
            TableMouseController.this._context.getThreadManager().getTimer(1000, this._al).start();
            boolean needShowPopup = TableMouseController.this.needShowPopup(e);
            boolean needReSelect = true;
            if (needShowPopup) {
                needReSelect = TableMouseController.this.needReSelect(e);
            }
            if (needReSelect) {
                Point point = e.getPoint();
                SelectionAdapter sel = TableMouseController.this._context.getSelection();
                int row = SheetBaseMath.rowAtPoint(sheet, point);
                int col = SheetBaseMath.colAtPoint(sheet, point);
                if (row < 0 || col < 0) {
                    return;
                }
                if (TableMouseController.this.cellSelect) {
                    if (e.isShiftDown()) {
                        if (sel.changeSelection(CellBlock.getCellBlock(sel.getSelectionData().getActiveRow(), sel.getSelectionData().getActiveCol(), row, col), 3)) {
                            view.getSpread().setActiveView(view);
                            this._lastRow = row;
                            this._lastCol = col;
                        }
                    } else {
                        boolean b = sel.changeSelection(CellBlock.getCellBlock(row, col, row, col), e.isControlDown() ? 1 : 2);
                        if (b) {
                            view.getSpread().setActiveView(view);
                            this._pressRow = row;
                            this._pressCol = col;
                            this._lastRow = row;
                            this._lastCol = col;
                        }
                    }
                } else if (e.isShiftDown()) {
                    boolean b = sel.changeSelection(CellBlock.getCellBlock(row, col, row, col), e.isControlDown() ? 1 : 2);
                    if (b && sel.changeSelection(CellBlock.getCellBlock(this._lastRow, 0, row, 65535), 3)) {
                        view.getSpread().setActiveView(view);
                        this._lastRow = row;
                        this._lastCol = col;
                    }
                } else {
                    boolean b = sel.changeSelection(CellBlock.getCellBlock(row, 0, row, 65535), e.isControlDown() ? 1 : 2);
                    if (b) {
                        view.getSpread().setActiveView(view);
                        this._pressRow = row;
                        this._pressCol = col;
                        this._lastRow = row;
                        this._lastCol = col;
                    }
                }
            }
            if (needShowPopup) {
                boolean b = this.shouldShowCellTreePopMenu(e);
                TableMouseController.this._context.getPopMenuManager().setCellTreeMenuVisible(b);
                if (b) {
                    Point point = e.getPoint();
                    TreeCellPopMenuHelper helper = TreeCellPopMenuHelper.getInstance(sheet, point);
                    TableMouseController.this._context.getPopMenuManager().setTreeCellPopMenuHelper(helper);
                }
                TableMouseController.this.showPopupMenu(e);
            }
        }

        private boolean shouldShowCellTreePopMenu(MouseEvent e) {
            Point point = e.getPoint();
            SpreadView view = (SpreadView)e.getSource();
            Sheet sheet = view.getSpread().getBook().getActiveSheet();
            int row = SheetBaseMath.rowAtPoint(sheet, point);
            int col = SheetBaseMath.colAtPoint(sheet, point);
            Cell cell = sheet.getCell(row, col, false);
            Rectangle rect = SheetBaseMath.getCellRect(sheet, row, col, false);
            if (cell == null) {
                return false;
            }
            boolean result = false;
            result = this.shouldShowCellTreePopMenuWhenColumn(cell, point, rect);
            if (result) {
                return result;
            }
            result = this.shouldShowCellTreePopMenuWhenRow(cell, point, rect);
            return result;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean shouldShowCellTreePopMenuWhenColumn(Cell cell, Point point, Rectangle rect) {
            Sheet sheet = cell.getSheet();
            Column column = sheet.getColumn(cell.getCol(), false);
            if (column == null) return false;
            if (!TreeCellUtil.isColumnCellTreeDisplay(cell)) {
                return false;
            }
            int cellWidth = 14;
            int rowId = SheetBaseMath.rowAtPoint(sheet, point);
            SortedAttributeSpanArray sasa = sheet.getRowSpans();
            int spanPos = sasa.searchSpan(rowId);
            int level = -1;
            int nextRow = rowId - 1;
            if (sheet.isAboveOfOutlineGroup()) {
                nextRow = rowId + 1;
            }
            if (spanPos < 0) {
                spanPos = sasa.searchSpan(nextRow);
                if (spanPos < 0 || ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel() <= 0) return false;
                level = 0;
            } else {
                level = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel();
            }
            int prevRowLevel = 0;
            int prevSpanPos = sasa.searchSpan(nextRow);
            if (prevSpanPos >= 0) {
                prevRowLevel = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(prevSpanPos)).getOutlineGroupLevel();
            }
            boolean isDot = false;
            if (level >= prevRowLevel) {
                isDot = true;
            }
            int rowY = SheetBaseMath.getRowY(sheet, rowId);
            int rowHeight = SheetBaseMath.getRowHeight(sheet, rowId);
            int basePos = rect.x + (cellWidth - 3) * level;
            int rectX1 = basePos + 2;
            int rectY1 = rowY + (rowHeight - cellWidth) / 2 + 2;
            int rectX2 = basePos + 2 + cellWidth;
            int rectY2 = rowY + (rowHeight - cellWidth) / 2 + 2 + cellWidth;
            int pressedX = point.x;
            int pressedY = point.y;
            return !isDot && pressedX > rectX1 && pressedX < rectX2 && pressedY > rectY1 && pressedY < rectY2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean shouldShowCellTreePopMenuWhenRow(Cell cell, Point point, Rectangle rect) {
            Sheet sheet = cell.getSheet();
            Row row = sheet.getRow(cell.getRow(), false);
            if (row == null) return false;
            if (!TreeCellUtil.isRowCellTreeDisplay(cell)) {
                return false;
            }
            int colId = SheetBaseMath.colAtPoint(sheet, point);
            SortedAttributeSpanArray sasa = sheet.getColSpans();
            int cellWidth = 14;
            int spanPos = sasa.searchSpan(colId);
            int level = -1;
            int nextCol = colId + 1;
            if (!sheet.isLeftToOutlineGroup()) {
                nextCol = colId - 1;
            }
            if (spanPos < 0) {
                spanPos = sasa.searchSpan(nextCol);
                if (spanPos < 0 || ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel() <= 0) return false;
                level = 0;
            } else {
                level = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel();
            }
            int nextColLevel = 0;
            int nextSpanPos = sasa.searchSpan(nextCol);
            if (nextSpanPos >= 0) {
                nextColLevel = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(nextSpanPos)).getOutlineGroupLevel();
            }
            boolean isDot = false;
            if (level >= nextColLevel) {
                isDot = true;
            }
            int colX = SheetBaseMath.getColX(sheet, colId);
            int colWidth = SheetBaseMath.getColWidth(sheet, colId);
            int basePos = rect.y + (cellWidth - 3) * level;
            int rectY1 = basePos + 2;
            int rectX1 = colX + 2 + (colWidth - cellWidth) / 2;
            int rectY2 = basePos + 2 + cellWidth;
            int rectX2 = rectX1 + cellWidth;
            int pressedX = point.x;
            int pressedY = point.y;
            return !isDot && pressedX > rectX1 && pressedX < rectX2 && pressedY > rectY1 && pressedY < rectY2;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Point point = e.getPoint();
            SpreadView view = (SpreadView)e.getSource();
            Sheet sheet = view.getSpread().getBook().getActiveSheet();
            SelectionAdapter sel = TableMouseController.this._context.getSelection();
            int row = SheetBaseMath.rowAtPoint(sheet, point);
            row = SheetBaseMath.dealInvalidRow(row);
            int col = SheetBaseMath.colAtPoint(sheet, point);
            col = SheetBaseMath.dealInvalidCol(col);
            if (this._lastRow != row || this._lastCol != col) {
                CellBlock updateB = e.isShiftDown() ? CellBlock.getCellBlock(sheet.getActiveRow(), sheet.getActiveCol(), row, col) : CellBlock.getCellBlock(this._pressRow, this._pressCol, row, col);
                if (TableMouseController.this.cellSelect) {
                    sel.changeSelection(updateB, 3);
                } else if (e.isShiftDown()) {
                    if (sel.changeSelection(CellBlock.getCellBlock(sel.getSelectionData().getActiveRow(), 0, row, 65535), 3)) {
                        view.getSpread().setActiveView(view);
                        this._lastRow = row;
                        this._lastCol = col;
                    }
                } else {
                    boolean b = sel.changeSelection(CellBlock.getCellBlock(sel.getSelectionData().getActiveRow(), 0, row, 65535), e.isControlDown() ? 1 : 2);
                    if (b) {
                        view.getSpread().setActiveView(view);
                        this._pressRow = row;
                        this._pressCol = col;
                        this._lastRow = row;
                        this._lastCol = col;
                    }
                }
                view.scrollCellVisible(row, col);
                this._lastRow = row;
                this._lastCol = col;
            }
        }

        private class ActionHander
        implements ActionListener {
            private ActionHander() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                KDSpread spread;
                if (TableMouseController.this._context != null && TableMouseController.this._context.getSpread() != null && TableMouseController.this._context.getSpread().getActiveView() != null && (spread = TableMouseController.this._context.getSpread()) != null && spread.getActiveView() != null) {
                    spread.getActiveView().setCursor(Cursor.getDefaultCursor());
                }
                if (TableMouseController.this._context != null) {
                    TableMouseController.this._context.getThreadManager().getTimer(1000, SelectCellsState.this._al).stop();
                }
                SelectCellsState.this._bLink = false;
            }
        }
    }

    class GraphState
    extends DefaultMouseState {
        HotSpot _curHotSpot;
        Point _pressP;
        Point _curP;
        EmbedObject _curGraph;
        SpreadContext context;
        private int dx;
        private int dy;

        public GraphState() {
        }

        private GraphState(SpreadContext context) {
            this.context = context;
        }

        private void repaginationAndRepaint() {
            if (this.context == null) {
                return;
            }
            Sheet sheet = this.context.getBook().getActiveSheet();
            SheetPlugablePaginationAdvice ppa = (SheetPlugablePaginationAdvice)sheet.getPlugablePaginationAdvice(true);
            if (ppa == null) {
                return;
            }
            PrintManager pm = this.context.getPrintManager();
            pm.reloadPrintJob();
            SheetPrintJob job = (SheetPrintJob)pm.getMultiPrintManager().getPrintJob(sheet.getID());
            job.preparePagination();
            sheet.setRowPaginationPointsSnapshot(job.getTablePrintPagination().getRowPaginationPointsSnapshot());
            sheet.setColPaginationPointsSnapshot(job.getTablePrintPagination().getColPaginationPointsSnapshot());
            pm.getMultiPrintManager().clear();
            this.context.repaint();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this._curHotSpot = null;
            this._curGraph = null;
            Point p = e.getPoint();
            Sheet sheet = ((SpreadView)e.getSource()).getSpread().getBook().getActiveSheet();
            int selMode = 2;
            if (e.isShiftDown()) {
                selMode = 3;
            } else if (e.isControlDown()) {
                selMode = 1;
            }
            EmbedhLayer gl = sheet.getEmbedments(false);
            Object o = gl.selectEmbed(p, selMode);
            if (o instanceof HotSpot) {
                this._curHotSpot = (HotSpot)o;
                this._curGraph = this._curHotSpot.getOwner();
            } else if (o instanceof EmbedObject) {
                this._curGraph = (EmbedObject)o;
            }
            this._pressP = p;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Point p;
            if ((e.getModifiers() & 0x10) == 0) {
                return;
            }
            this._curP = p = e.getPoint();
            SpreadView view = (SpreadView)e.getSource();
            Sheet sheet = view.getSpread().getBook().getActiveSheet();
            int row = SheetBaseMath.rowAtPoint(sheet, p);
            row = SheetBaseMath.dealInvalidRow(row);
            int col = SheetBaseMath.colAtPoint(sheet, p);
            col = SheetBaseMath.dealInvalidCol(col);
            view.scrollCellVisible(row, col);
            this.dx = this._curP.x - this._pressP.x;
            this.dy = this._curP.y - this._pressP.y;
            EmbedhLayer gl = sheet.getEmbedments(false);
            Shape shape = gl.getOffsetShape(this._curHotSpot, this.dx, this.dy);
            Rectangle rect = shape.getBounds();
            EmbedObject embed = gl.getActiveSelectedEmbed();
            if (embed == null) {
                return;
            }
            if (!e.isAltDown()) {
                this.calMoveOrResize(rect, embed);
            }
            if (rect.getX() < 0.0) {
                this.dx = -embed.getX();
            }
            if (rect.getY() < 0.0) {
                this.dy = -embed.getY();
            }
            shape = gl.getOffsetShape(this._curHotSpot, this.dx, this.dy);
            DragRubberRender render = TableMouseController.this._context.getRenderManager().getDraggedRubberRender();
            render.setBeFill(false);
            render.paint(view, shape);
        }

        private void calMoveOrResize(Rectangle rect, EmbedObject embed) {
            int oldX = embed.getX();
            int oldY = embed.getY();
            if (this._curHotSpot != null) {
                int type = this._curHotSpot.getType();
                if (type == 5 || type == 1 || type == 3) {
                    this.dx = EmbedMove.xy2MultipleOfStep((int)rect.getX()) - oldX;
                }
                if (type == 7 || type == 1 || type == 2) {
                    this.dy = EmbedMove.xy2MultipleOfStep((int)rect.getY()) - oldY;
                }
                if (type == 6 || type == 4 || type == 2) {
                    this.dx = EmbedMove.xy2MultipleOfStep((int)(rect.getX() + rect.getWidth())) - (oldX + embed.getWidth());
                }
                if (type == 8 || type == 4 || type == 3) {
                    this.dy = EmbedMove.xy2MultipleOfStep((int)(rect.getY() + rect.getHeight())) - (oldY + embed.getHeight());
                }
            } else {
                this.dx = EmbedMove.xy2MultipleOfStep((int)rect.getX()) - oldX;
                this.dy = EmbedMove.xy2MultipleOfStep((int)rect.getY()) - oldY;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            int i;
            JPopupMenu jm;
            Point p;
            this._curP = p = e.getPoint();
            SpreadView view = (SpreadView)e.getSource();
            EmbedhLayer gl = view.getSpread().getBook().getActiveSheet().getEmbedments(false);
            if ((e.getModifiers() & 0x10) != 0) {
                JPopupMenu jm2;
                gl.getSelectionRange().offsetSelectedGraphs(this._curHotSpot, this.dx, this.dy);
                this.dx = 0;
                this.dy = 0;
                DragRubberRender render = TableMouseController.this._context.getRenderManager().getDraggedRubberRender();
                render.endPaint(view);
                render.setBeFill(true);
                EmbedObject chart = gl.getFocusedEmbed(p);
                if (chart instanceof INativeEmbedment && (jm2 = TableMouseController.this._context.getPopMenuManager().getEmbedPopMenu(this._curGraph)) != null) {
                    Rectangle rect = null;
                    if (chart instanceof FlashChart) {
                        rect = ((FlashChart)chart).getTransformRect();
                    } else if (chart instanceof EChart) {
                        rect = ((EChart)chart).getTransformRect();
                    } else if (chart instanceof QingChart) {
                        rect = ((QingChart)chart).getTransformRect();
                    }
                    if (null != rect) {
                        jm2.show(view, rect.x, rect.y + rect.height);
                    }
                }
            } else if (TableMouseController.this.needShowPopup(e) && gl.selectionSize() == 1 && this._curHotSpot == null && (jm = TableMouseController.this._context.getPopMenuManager().getEmbedPopMenu(this._curGraph)) != null) {
                jm.show(view, e.getX(), e.getY());
            }
            if (TableMouseController.this._context != null && TableMouseController.this._context.getBook().getActiveSheet().isPageView()) {
                this.repaginationAndRepaint();
            }
            ArrayList<EmbedObject> allSelectedEmbed = new ArrayList<EmbedObject>();
            for (i = 0; i < gl.selectionSize(); ++i) {
                allSelectedEmbed.add(gl.getSelectedEmbed(i));
            }
            gl.cancelSelectedEmbeds();
            for (i = 0; i < allSelectedEmbed.size(); ++i) {
                gl.selectEmbed((EmbedObject)allSelectedEmbed.get(i), 1);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }
    }

    class PaginationColGridState
    extends DefaultMouseState {
        private int fromIndex;
        private int toIndex;
        private int maxColIndex;
        private int[] colSnapshots;
        private SortedObjectArray shrinkedCols;
        private SortedObjectArray extendedCols;
        private SheetPlugablePaginationAdvice ppa;
        private Sheet sheet;
        private SpreadContext context;

        PaginationColGridState(SpreadContext context) {
            this.context = context;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int index;
            Point p = e.getPoint();
            this.toIndex = index = SheetBaseMath.colAtPoint(this.sheet, p);
            this.sheet.setMovingColShadowPosition(index);
            this.context.repaint();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int col;
            SpreadView view = (SpreadView)e.getSource();
            this.sheet = view.getSpread().getBook().getActiveSheet();
            if (this.sheet == null) {
                this.sheet = view.getSpread().getBook().getSheet(0);
            }
            if (this.sheet == null) {
                return;
            }
            Point p = e.getPoint();
            p = new Point(p.x - 2, p.y);
            this.fromIndex = col = SheetBaseMath.colAtPoint(this.sheet, p);
            this.toIndex = col;
            this.colSnapshots = this.sheet.getColPaginationPointsSnapshot();
            this.maxColIndex = this.colSnapshots == null ? this.sheet.getMaxColIndex() : this.colSnapshots[this.colSnapshots.length - 1];
            this.ppa = (SheetPlugablePaginationAdvice)this.sheet.getPlugablePaginationAdvice(true);
            this.shrinkedCols = SOAUtil.common2ext(this.ppa.getColShrinkedBreakObjectArray());
            this.extendedCols = SOAUtil.common2ext(this.ppa.getColExtendedBreakObjectArray());
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.fromIndex == this.toIndex) {
                this.context.getFacadeManager().showErrorMessageBox(MultiLanguageKeys.getLocalText("Key_PaginationView_EqualMoving"), 0);
                this.sheet.setMovingColShadowPosition(-1);
                this.context.repaint();
                return;
            }
            if (this.toIndex > this.maxColIndex) {
                this.context.getFacadeManager().showErrorMessageBox(MultiLanguageKeys.getLocalText("Key_PaginationView_BeyondMaxIndex"), 0);
                this.sheet.setMovingColShadowPosition(-1);
                this.context.repaint();
                return;
            }
            if (this.fromIndex > this.toIndex) {
                this.recomputeAdvicesForColLeftReleased();
            } else {
                this.recomputeAdvicesForColRightReleased();
            }
            this.ppa.setColShrinkedBreaks(SOAUtil.ext2common(this.shrinkedCols));
            this.ppa.setColExtendedBreaks(SOAUtil.ext2common(this.extendedCols));
            this.sheet.setMovingColShadowPosition(-1);
            this.repaginationAndRepaint();
            PrintSetup ps = this.sheet.getSheetOption().getPrintSetup(false);
            ps.setScale(SheetBaseMath.getProperScaleRate(TableMouseController.this._context));
            this.repaginationAndRepaint();
        }

        private void recomputeAdvicesForColLeftReleased() {
            boolean lastPassedColStatusIsExtended = false;
            int lastPassedColIndex = this.fromIndex;
            boolean toIndexAdded = false;
            for (int i = 0; i < this.colSnapshots.length; ++i) {
                if (this.colSnapshots[i] < this.toIndex || this.colSnapshots[i] >= this.fromIndex || this.colSnapshots[i] >= lastPassedColIndex) continue;
                lastPassedColIndex = this.colSnapshots[i];
            }
            SortedObjectArray newExtendedCols = new SortedObjectArray();
            if (this.extendedCols != null) {
                for (int i = 0; i < this.extendedCols.size(); ++i) {
                    int eCol = (Integer)this.extendedCols.get(i);
                    if (eCol < this.toIndex) {
                        newExtendedCols.insert(ObjectCache.getInteger(eCol));
                    } else if (eCol > this.fromIndex) {
                        newExtendedCols.insert(ObjectCache.getInteger(eCol - (this.fromIndex - this.toIndex)));
                    } else if (eCol == this.toIndex) {
                        newExtendedCols.insert(ObjectCache.getInteger(this.toIndex));
                        toIndexAdded = true;
                    }
                    if (lastPassedColIndex != eCol) continue;
                    lastPassedColStatusIsExtended = true;
                }
            }
            SortedObjectArray newShrinkedCols = new SortedObjectArray();
            if (this.shrinkedCols != null) {
                for (int i = 0; i < this.shrinkedCols.size(); ++i) {
                    int sCol = (Integer)this.shrinkedCols.get(i);
                    if (sCol < this.toIndex) {
                        newShrinkedCols.insert(ObjectCache.getInteger(sCol));
                        continue;
                    }
                    if (sCol > this.fromIndex) {
                        newShrinkedCols.insert(ObjectCache.getInteger(sCol - (this.fromIndex - this.toIndex)));
                        continue;
                    }
                    if (sCol != this.toIndex) continue;
                    newShrinkedCols.insert(ObjectCache.getInteger(this.toIndex));
                    toIndexAdded = true;
                }
            }
            if (lastPassedColStatusIsExtended && lastPassedColIndex != this.toIndex) {
                int fromColIndex = 0;
                for (int i = 0; i < this.colSnapshots.length; ++i) {
                    if (this.colSnapshots[i] >= lastPassedColIndex || this.colSnapshots[i] <= fromColIndex) continue;
                    fromColIndex = this.colSnapshots[i];
                }
                int normalPageBreakAt = this.getColPageBreakIndexInNormalPagination(fromColIndex, 1);
                if (normalPageBreakAt < this.toIndex) {
                    newExtendedCols.insert(ObjectCache.getInteger(this.toIndex));
                } else {
                    newShrinkedCols.insert(ObjectCache.getInteger(this.toIndex));
                }
            } else if (!toIndexAdded) {
                newShrinkedCols.insert(ObjectCache.getInteger(this.toIndex));
            }
            this.shrinkedCols = newShrinkedCols;
            this.extendedCols = newExtendedCols;
        }

        private void recomputeAdvicesForColRightReleased() {
            int leftBreak = 0;
            for (int i = 0; i < this.colSnapshots.length; ++i) {
                if (this.colSnapshots[i] >= this.fromIndex || this.colSnapshots[i] <= leftBreak) continue;
                leftBreak = this.colSnapshots[i];
            }
            int page1Break = this.getColPageBreakIndexInNormalPagination(leftBreak, 1);
            int page2Break = this.getColPageBreakIndexInNormalPagination(leftBreak, 2);
            if (this.toIndex > page2Break) {
                this.context.getFacadeManager().showErrorMessageBox(MultiLanguageKeys.getLocalText("Key_PaginationView_ExtendedBreak_OverMoving"), 0);
                return;
            }
            SortedObjectArray newExtendedCols = new SortedObjectArray();
            if (this.extendedCols != null) {
                for (int i = 0; i < this.extendedCols.size(); ++i) {
                    int eCol = (Integer)this.extendedCols.get(i);
                    if (eCol < this.fromIndex) {
                        newExtendedCols.insert(ObjectCache.getInteger(eCol));
                        continue;
                    }
                    if (eCol <= this.fromIndex) continue;
                    newExtendedCols.insert(ObjectCache.getInteger(eCol + (this.toIndex - this.fromIndex)));
                }
            }
            SortedObjectArray newShrinkedCols = new SortedObjectArray();
            if (this.shrinkedCols != null) {
                for (int i = 0; i < this.shrinkedCols.size(); ++i) {
                    int sCol = (Integer)this.shrinkedCols.get(i);
                    if (sCol < this.fromIndex) {
                        newShrinkedCols.insert(ObjectCache.getInteger(sCol));
                        continue;
                    }
                    if (sCol <= this.fromIndex) continue;
                    newShrinkedCols.insert(ObjectCache.getInteger(sCol + (this.toIndex - this.fromIndex)));
                }
            }
            if (this.toIndex != this.sheet.getMaxColIndex()) {
                if (this.toIndex <= page1Break) {
                    newShrinkedCols.insert(ObjectCache.getInteger(this.toIndex));
                } else {
                    newExtendedCols.insert(ObjectCache.getInteger(this.toIndex));
                }
            }
            this.shrinkedCols = newShrinkedCols;
            this.extendedCols = newExtendedCols;
        }

        private int getColPageBreakIndexInNormalPagination(int fromIndex, int pageNo) {
            if (pageNo <= 0) {
                throw new IllegalArgumentException(CtrlEXTMessages.getMLS("canOnlyReadSubsequentPageInterval", "\u53ea\u80fd\u8bfb\u53d6\u540e\u7eed\u5206\u9875\u95f4\u9694") + ", Argument can not be zero or below zero.");
            }
            Sheet sheet = this.context.getBook().getActiveSheet();
            PrintManager pm = this.context.getPrintManager();
            pm.reloadPrintJob();
            SheetPrintJob job = (SheetPrintJob)pm.getMultiPrintManager().getPrintJob(sheet.getID());
            SheetPlugablePaginationAdvice sppa = new SheetPlugablePaginationAdvice();
            if (fromIndex != 0) {
                SortedObjectArray soa = new SortedObjectArray();
                soa.insert(ObjectCache.getInteger(fromIndex));
                sppa.setColShrinkedBreaks(SOAUtil.ext2common(soa));
            }
            sheet.setPlugablePaginationAdvice((PlugablePaginationAdvice)sppa);
            job.preparePagination();
            int[] colPaginationPointsSnapshot = job.getTablePrintPagination().getColPaginationPointsSnapshot();
            int dest = Integer.MAX_VALUE;
            while (pageNo > 0) {
                dest = Integer.MAX_VALUE;
                for (int i = 0; i < colPaginationPointsSnapshot.length; ++i) {
                    if (colPaginationPointsSnapshot[i] <= fromIndex || colPaginationPointsSnapshot[i] >= dest) continue;
                    dest = colPaginationPointsSnapshot[i];
                }
                fromIndex = dest;
                --pageNo;
            }
            pm.getMultiPrintManager().clear();
            return dest;
        }

        private void repaginationAndRepaint() {
            PrintManager pm = this.context.getPrintManager();
            pm.reloadPrintJob();
            SheetPrintJob job = (SheetPrintJob)pm.getMultiPrintManager().getPrintJob(this.sheet.getID());
            this.sheet.setPlugablePaginationAdvice((PlugablePaginationAdvice)this.ppa);
            job.preparePagination();
            this.sheet.setColPaginationPointsSnapshot(job.getTablePrintPagination().getColPaginationPointsSnapshot());
            this.sheet.setRowPaginationPointsSnapshot(job.getTablePrintPagination().getRowPaginationPointsSnapshot());
            pm.getMultiPrintManager().clear();
            this.context.repaint();
        }
    }

    class PaginationRowGridState
    extends DefaultMouseState {
        private int fromIndex;
        private int toIndex;
        private int maxRowIndex;
        private int[] rowSnapshots;
        private SortedObjectArray shrinkedRows;
        private SortedObjectArray extendedRows;
        private SheetPlugablePaginationAdvice ppa;
        private Sheet sheet;
        private SpreadContext context;

        PaginationRowGridState(SpreadContext context) {
            this.context = context;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int index;
            Point p = e.getPoint();
            this.toIndex = index = SheetBaseMath.rowAtPoint(this.sheet, p);
            this.sheet.setMovingRowShadowPosition(index);
            this.context.repaint();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int row;
            SpreadView view = (SpreadView)e.getSource();
            this.sheet = view.getSpread().getBook().getActiveSheet();
            if (this.sheet == null) {
                this.sheet = view.getSpread().getBook().getSheet(0);
            }
            if (this.sheet == null) {
                return;
            }
            Point p = e.getPoint();
            p = new Point(p.x, p.y - 2);
            this.fromIndex = row = SheetBaseMath.rowAtPoint(this.sheet, p);
            this.toIndex = row;
            this.rowSnapshots = this.sheet.getRowPaginationPointsSnapshot();
            this.maxRowIndex = this.rowSnapshots == null ? this.sheet.getMaxRowIndex() : this.rowSnapshots[this.rowSnapshots.length - 1];
            this.ppa = (SheetPlugablePaginationAdvice)this.sheet.getPlugablePaginationAdvice(true);
            this.shrinkedRows = SOAUtil.common2ext(this.ppa.getRowShrinkedBreakObjectArray());
            this.extendedRows = SOAUtil.common2ext(this.ppa.getRowExtendedBreakObjectArray());
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.fromIndex == this.toIndex) {
                this.context.getFacadeManager().showErrorMessageBox(MultiLanguageKeys.getLocalText("Key_PaginationView_EqualMoving"), 0);
                this.sheet.setMovingRowShadowPosition(-1);
                this.context.repaint();
                return;
            }
            if (this.toIndex > this.maxRowIndex) {
                this.context.getFacadeManager().showErrorMessageBox(MultiLanguageKeys.getLocalText("Key_PaginationView_BeyondMaxIndex"), 0);
                this.sheet.setMovingRowShadowPosition(-1);
                this.context.repaint();
                return;
            }
            if (this.fromIndex > this.toIndex) {
                this.recomputeAdvicesForRowUpReleased();
            } else {
                this.recomputeAdvicesForRowDownReleased();
            }
            this.ppa.setRowShrinkedBreaks(SOAUtil.ext2common(this.shrinkedRows));
            this.ppa.setRowExtendedBreaks(SOAUtil.ext2common(this.extendedRows));
            this.sheet.setMovingRowShadowPosition(-1);
            this.repaginationAndRepaint();
            PrintSetup ps = this.sheet.getSheetOption().getPrintSetup(false);
            ps.setScale(SheetBaseMath.getProperScaleRate(TableMouseController.this._context));
            this.repaginationAndRepaint();
        }

        private void recomputeAdvicesForRowUpReleased() {
            boolean lastPassedRowStatusIsExtended = false;
            int lastPassedRowIndex = this.fromIndex;
            boolean toIndexAdded = false;
            for (int i = 0; i < this.rowSnapshots.length; ++i) {
                if (this.rowSnapshots[i] < this.toIndex || this.rowSnapshots[i] >= this.fromIndex || this.rowSnapshots[i] >= lastPassedRowIndex) continue;
                lastPassedRowIndex = this.rowSnapshots[i];
            }
            SortedObjectArray newExtendedRows = new SortedObjectArray();
            if (this.extendedRows != null) {
                for (int i = 0; i < this.extendedRows.size(); ++i) {
                    int eRow = (Integer)this.extendedRows.get(i);
                    if (eRow < this.toIndex) {
                        newExtendedRows.insert(ObjectCache.getInteger(eRow));
                    } else if (eRow > this.fromIndex) {
                        newExtendedRows.insert(ObjectCache.getInteger(eRow - (this.fromIndex - this.toIndex)));
                    } else if (eRow == this.toIndex) {
                        newExtendedRows.insert(ObjectCache.getInteger(this.toIndex));
                        toIndexAdded = true;
                    }
                    if (lastPassedRowIndex != eRow) continue;
                    lastPassedRowStatusIsExtended = true;
                }
            }
            SortedObjectArray newShrinkedRows = new SortedObjectArray();
            if (this.shrinkedRows != null) {
                for (int i = 0; i < this.shrinkedRows.size(); ++i) {
                    int sRow = (Integer)this.shrinkedRows.get(i);
                    if (sRow < this.toIndex) {
                        newShrinkedRows.insert(ObjectCache.getInteger(sRow));
                        continue;
                    }
                    if (sRow > this.fromIndex) {
                        newShrinkedRows.insert(ObjectCache.getInteger(sRow - (this.fromIndex - this.toIndex)));
                        continue;
                    }
                    if (sRow != this.toIndex) continue;
                    newShrinkedRows.insert(ObjectCache.getInteger(this.toIndex));
                    toIndexAdded = true;
                }
            }
            if (lastPassedRowStatusIsExtended && lastPassedRowIndex != this.toIndex) {
                int fromRowIndex = 0;
                for (int i = 0; i < this.rowSnapshots.length; ++i) {
                    if (this.rowSnapshots[i] >= lastPassedRowIndex || this.rowSnapshots[i] <= fromRowIndex) continue;
                    fromRowIndex = this.rowSnapshots[i];
                }
                int normalPageBreakAt = this.getRowPageBreakIndexInNormalPagination(fromRowIndex, 1);
                if (normalPageBreakAt < this.toIndex) {
                    newExtendedRows.insert(ObjectCache.getInteger(this.toIndex));
                } else {
                    newShrinkedRows.insert(ObjectCache.getInteger(this.toIndex));
                }
            } else if (!toIndexAdded) {
                newShrinkedRows.insert(ObjectCache.getInteger(this.toIndex));
            }
            this.shrinkedRows = newShrinkedRows;
            this.extendedRows = newExtendedRows;
        }

        private void recomputeAdvicesForRowDownReleased() {
            int leftBreak = 0;
            for (int i = 0; i < this.rowSnapshots.length; ++i) {
                if (this.rowSnapshots[i] >= this.fromIndex || this.rowSnapshots[i] <= leftBreak) continue;
                leftBreak = this.rowSnapshots[i];
            }
            int page1Break = this.getRowPageBreakIndexInNormalPagination(leftBreak, 1);
            int page2Break = this.getRowPageBreakIndexInNormalPagination(leftBreak, 2);
            if (this.toIndex > page2Break) {
                this.context.getFacadeManager().showErrorMessageBox(MultiLanguageKeys.getLocalText("Key_PaginationView_ExtendedBreak_OverMoving"), 0);
                return;
            }
            SortedObjectArray newExtendedRows = new SortedObjectArray();
            if (this.extendedRows != null) {
                for (int i = 0; i < this.extendedRows.size(); ++i) {
                    int eRow = (Integer)this.extendedRows.get(i);
                    if (eRow < this.fromIndex) {
                        newExtendedRows.insert(ObjectCache.getInteger(eRow));
                        continue;
                    }
                    if (eRow <= this.fromIndex) continue;
                    newExtendedRows.insert(ObjectCache.getInteger(eRow + (this.toIndex - this.fromIndex)));
                }
            }
            SortedObjectArray newShrinkedRows = new SortedObjectArray();
            if (this.shrinkedRows != null) {
                for (int i = 0; i < this.shrinkedRows.size(); ++i) {
                    int eRow = (Integer)this.shrinkedRows.get(i);
                    if (eRow < this.fromIndex) {
                        newShrinkedRows.insert(ObjectCache.getInteger(eRow));
                        continue;
                    }
                    if (eRow <= this.fromIndex) continue;
                    newShrinkedRows.insert(ObjectCache.getInteger(eRow + (this.toIndex - this.fromIndex)));
                }
            }
            if (this.toIndex != this.sheet.getMaxRowIndex()) {
                if (this.toIndex <= page1Break) {
                    newShrinkedRows.insert(ObjectCache.getInteger(this.toIndex));
                } else {
                    newExtendedRows.insert(ObjectCache.getInteger(this.toIndex));
                }
            }
            this.shrinkedRows = newShrinkedRows;
            this.extendedRows = newExtendedRows;
        }

        private int getRowPageBreakIndexInNormalPagination(int fromIndex, int pageNo) {
            if (pageNo <= 0) {
                throw new IllegalArgumentException("Argument can not be zero or below zero.");
            }
            Sheet sheet = this.context.getBook().getActiveSheet();
            PrintManager pm = this.context.getPrintManager();
            pm.reloadPrintJob();
            SheetPrintJob job = (SheetPrintJob)pm.getMultiPrintManager().getPrintJob(sheet.getID());
            SheetPlugablePaginationAdvice sppa = new SheetPlugablePaginationAdvice();
            if (fromIndex != 0) {
                SortedObjectArray soa = new SortedObjectArray();
                soa.insert(ObjectCache.getInteger(fromIndex));
                sppa.setRowShrinkedBreaks(SOAUtil.ext2common(soa));
            }
            sheet.setPlugablePaginationAdvice((PlugablePaginationAdvice)sppa);
            job.preparePagination();
            int[] rowPaginationPointsSnapshot = job.getTablePrintPagination().getRowPaginationPointsSnapshot();
            int dest = Integer.MAX_VALUE;
            while (pageNo > 0) {
                dest = Integer.MAX_VALUE;
                for (int i = 0; i < rowPaginationPointsSnapshot.length; ++i) {
                    if (rowPaginationPointsSnapshot[i] <= fromIndex || rowPaginationPointsSnapshot[i] >= dest) continue;
                    dest = rowPaginationPointsSnapshot[i];
                }
                fromIndex = dest;
                --pageNo;
            }
            pm.getMultiPrintManager().clear();
            return dest;
        }

        private void repaginationAndRepaint() {
            PrintManager pm = this.context.getPrintManager();
            pm.reloadPrintJob();
            SheetPrintJob job = (SheetPrintJob)pm.getMultiPrintManager().getPrintJob(this.sheet.getID());
            this.sheet.setPlugablePaginationAdvice((PlugablePaginationAdvice)this.ppa);
            job.preparePagination();
            this.sheet.setRowPaginationPointsSnapshot(job.getTablePrintPagination().getRowPaginationPointsSnapshot());
            this.sheet.setColPaginationPointsSnapshot(job.getTablePrintPagination().getColPaginationPointsSnapshot());
            pm.getMultiPrintManager().clear();
            this.context.repaint();
        }
    }
}

