/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.impl.state.util;

import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import com.kingdee.cosmic.ctrl.kds.core.ICellDisplayProvider;
import com.kingdee.cosmic.ctrl.kds.core.KDSpread;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadCellTextRender;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.CellBlock;
import com.kingdee.cosmic.ctrl.kds.model.struct.Range;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.cosmic.ctrl.kds.model.struct.SortedAttributeSpanArray;
import com.kingdee.cosmic.ctrl.swing.KDFont;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.LineMetrics;

public interface KDSpreadHelper {
    public static void autoFitRowHeight(KDSpread spread) {
        Book book = spread.getBook();
        Cell cell = book.getActiveSheet().getActiveCell();
        if (cell == null) {
            return;
        }
        Sheet sheet = spread.getBook().getActiveSheet();
        int viewMode = sheet.getSheetOption().getCellDisplayMode();
        ICellDisplayProvider prov = spread.getCellDisplayProvider();
        Object value = prov.getBaseValue(cell, viewMode);
        Range rowRange = sheet.getRowRange(cell.getRow(), cell.getRow());
        Integer oldHeight = rowRange.getRowHeight();
        if (value instanceof String && cell.getStyle().isWrapText()) {
            Graphics2D g2d = (Graphics2D)spread.getGraphics();
            float height = 0.0f;
            IBasicRender cellRender = prov.getBaseRender(cell, viewMode);
            if (cellRender instanceof SpreadCellTextRender) {
                float h;
                CellBlock mergeBlock;
                int pos = sheet.getColSpans().searchSpan(cell.getCol());
                SortedAttributeSpanArray.AttributeSpan span = null;
                if (pos >= 0) {
                    span = (SortedAttributeSpanArray.AttributeSpan)sheet.getColSpans().getSpan(pos);
                }
                float colWidth = span != null ? (float)span.getLength() : (float)sheet.getDefColWidth();
                float rowHeight = sheet.getDefRowHeight();
                if (null == span && (mergeBlock = book.getActiveSheet().getMergeBlock(cell)) != null) {
                    Rectangle bufRect = new Rectangle();
                    SheetBaseMath.getBlockRect(cell.getSheet(), mergeBlock, false, bufRect);
                    Rectangle bd = bufRect.getBounds();
                    colWidth = bd.width;
                    rowHeight = bd.height;
                }
                if ((h = ((SpreadCellTextRender)cellRender).getPreferredHeight(g2d, new Rectangle(0, 0, (int)colWidth, (int)rowHeight), value, cell.getStyle())) > height) {
                    height = h;
                }
                if (height > 0.0f && height > (float)oldHeight.intValue()) {
                    rowRange.setRowHeight((int)height + 4);
                }
            }
            if (cell.getStyle().isVerticalText()) {
                KDSpreadHelper.autoFitVerticalTextHeight(spread, cell, value.toString(), rowRange, oldHeight);
            }
        } else if (value instanceof String && cell.getStyle().isVerticalText()) {
            KDSpreadHelper.autoFitVerticalTextHeight(spread, cell, value.toString(), rowRange, oldHeight);
        }
    }

    public static void autoFitVerticalTextHeight(KDSpread spread, Cell cell, String value, Range rowRange, Integer oldHeight) {
        Graphics2D g = (Graphics2D)spread.getGraphics();
        KDFont f = cell.getStyle().getKDFont();
        g.setColor(cell.getStyle().getFontColor());
        g.setFont((Font)f);
        LineMetrics lm = f.getLineMetrics(value, g.getFontRenderContext());
        double fontHeight = lm.getAscent() + lm.getDescent();
        float height = 0.0f;
        int sourceHeight = (int)(fontHeight * (double)value.length());
        if ((float)sourceHeight > height) {
            height = sourceHeight;
        }
        if (height > 0.0f && height > (float)oldHeight.intValue()) {
            rowRange.setRowHeight((int)height + 4);
        }
    }

    public static void paintWrapTextCell(KDSpread spread) {
        Book book = spread.getBook();
        Cell cell = book.getActiveSheet().getActiveCell();
        if (cell == null) {
            return;
        }
        if (null == cell.getMerge(false) && !cell.getStyle().isWrapText() && cell.getValue().isString() && StringUtil.isWrapString((String)((String)cell.getValue().getValue()))) {
            StyleAttributes sa = Styles.getSA((ShareStyleAttributes)cell.getStyle());
            sa.setWrapText(true);
            cell.setSSA((ShareStyleAttributes)sa);
        }
    }
}

