/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.io.htm;

import chrriis.dj.nativeswing.common.Utils;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.fulfil.ExecutorUtil;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.FlashHelper;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.pic.ImageUtils;
import com.kingdee.cosmic.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kdf.util.render.CellBackgroundRender;
import com.kingdee.cosmic.ctrl.kdf.util.render.splitrectangle.ISplitRectInfo;
import com.kingdee.cosmic.ctrl.kdf.util.render.splitrectangle.SplitRectTextRender;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.HyperlinkCalculableProps;
import com.kingdee.cosmic.ctrl.kds.io.BookIOUtil;
import com.kingdee.cosmic.ctrl.kds.io.htm.ImageSave;
import com.kingdee.cosmic.ctrl.kds.io.htm.SheetHyperLinksProps;
import com.kingdee.cosmic.ctrl.kds.io.htm.explorer.AbstractHyperLinkHelper;
import com.kingdee.cosmic.ctrl.kds.io.htm.explorer.HtmlHeader;
import com.kingdee.cosmic.ctrl.kds.io.htm.explorer.HtmlSheetModel;
import com.kingdee.cosmic.ctrl.kds.io.htm.explorer.HtmlTableControllor;
import com.kingdee.cosmic.ctrl.kds.io.htm.explorer.MeasureHelper;
import com.kingdee.cosmic.ctrl.kds.io.htm.explorer.PageContext;
import com.kingdee.cosmic.ctrl.kds.io.htm.explorer.SimpleHtmlAttributeSpan;
import com.kingdee.cosmic.ctrl.kds.io.htm.explorer.event.WebMouseEvent;
import com.kingdee.cosmic.ctrl.kds.io.htm.extweb.Style2Css;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.CellBlock;
import com.kingdee.cosmic.ctrl.kds.model.struct.DiagonalHeader;
import com.kingdee.cosmic.ctrl.kds.model.struct.Range;
import com.kingdee.cosmic.ctrl.kds.model.struct.Row;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.cosmic.ctrl.kds.model.struct.SortedAttributeSpanArray;
import com.kingdee.cosmic.ctrl.kds.model.struct.SortedSpanArray;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedObject;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.image.EmbedImage;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.image.IImageModel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class HtmlExporter {
    private static final Logger logger = LogUtil.getPackageLogger(HtmlExporter.class);
    private PageContext _pagingCxt;
    private HtmlSheetModel _hsModel;
    private HtmlTableControllor _hsControllor;
    private Sheet _sheet;
    private WeakReference _sheetRef;
    private HtmlHeader _header;
    private HtmlBuffer _htmlBuffer;
    private String _pageId;
    private Style2Css _2Css;
    private HashMap _imagePathCache;
    private String _fileSavePath = "";
    private String _filePrefixPath = "";
    private boolean _enforceShowGraph = false;
    private static final String BLANK = "&nbsp;";
    private AbstractHyperLinkHelper _linkHelper;
    private static final String DIAGONAL_PREFIX = "diagonal_";
    private static final String EMBED_PREFIX = "embed_";
    private final Object lock = new Object();
    private Map divNameMap = new HashMap();

    public HtmlExporter(Sheet sheet, PageContext paingCxt, int rowSum, String pageId) {
        this(sheet, paingCxt, rowSum, pageId, null);
    }

    public HtmlExporter(Sheet sheet, PageContext paingCxt, int rowSum, String pageId, AbstractHyperLinkHelper hyperHelper) {
        this._sheetRef = new WeakReference<Sheet>(sheet);
        this._sheet = sheet;
        this._hsModel = new HtmlSheetModel(sheet);
        this._header = new HtmlHeader(sheet, "", "");
        this._hsControllor = new HtmlTableControllor();
        paingCxt.init(sheet, this._hsModel, this._header.getRow(), rowSum);
        this._pagingCxt = paingCxt;
        this._2Css = new Style2Css(sheet);
        this._2Css.setTree(true);
        this._pageId = pageId;
        this._imagePathCache = new HashMap();
        this.scanStyle(sheet);
        this._linkHelper = hyperHelper;
    }

    public void setFileSavePath(String fileSavePath) {
        this._fileSavePath = fileSavePath;
    }

    public void setFilePrefixPath(String filePrefixPath) {
        this._filePrefixPath = filePrefixPath;
    }

    public PageContext getPagingContext() {
        return this._pagingCxt;
    }

    public String exportDiv() {
        this.lockSheet();
        HtmlBuffer buffer = new HtmlBuffer();
        this._pagingCxt.clearMeasureHelper();
        this._linkHelper.clear();
        this.preBuildEmbedObject();
        String end = "</div> \n\r";
        this.buildTable();
        String start = this.buildDivHeader();
        buffer.append(start);
        buffer.append(this._htmlBuffer.toString());
        buffer.append(this.generateCssTag());
        buffer.append("\n<div style=\"display:none;height:0\" sue=\"data\">");
        buffer.append(this._linkHelper.report2Json());
        buffer.append(this._linkHelper.params2Json());
        buffer.append("</div>");
        buffer.append(end);
        this.unlockSheet();
        return buffer.toString();
    }

    private String buildDivHeader() {
        StringBuilder sb = new StringBuilder();
        int height = this._pagingCxt.getTotalHeight();
        sb.append("<div style=\"");
        if (this._header.hasHeader()) {
            sb.append(" overflow: scroll;");
        } else if (this._pagingCxt.isScreenCountEnable()) {
            sb.append(" overflow : scroll;");
        }
        sb.append(" position:relative;margin:5px 5px 5px 5px;");
        if (this._header.isHorizontalHeaderSet()) {
            sb.append("width: 100%;");
            if (height > 700 && !this._pagingCxt.isScreenCountEnable()) {
                height -= 100;
            }
            sb.append("height:").append(height).append("px;");
        } else {
            sb.append("width : 100%;");
            sb.append("height:").append(height).append("px;");
        }
        sb.append("\">");
        return sb.toString();
    }

    private void buildTable() {
        Iterator rowIter = this._pagingCxt.iterator();
        boolean firstRow = true;
        this._htmlBuffer = new HtmlBuffer();
        this._htmlBuffer.append("<table class=\"");
        this._htmlBuffer.append('x' + Integer.toString(this.getSheet().getStyle().getUID()));
        this._htmlBuffer.append("\" style='border-collapse: collapse;table-layout:fixed;'>");
        boolean needRefreshColumns = this._hsControllor.isNeedExportHeader(this);
        if (this._header.hasHeader()) {
            this.buildHeader();
        }
        this._htmlBuffer.append(this._header.getHeader());
        if (needRefreshColumns) {
            this._hsModel.refresh_Columns();
        }
        int preRowIndex = -1;
        while (rowIter.hasNext()) {
            Integer index = (Integer)rowIter.next();
            if (!firstRow && index - preRowIndex > 1) {
                int jumpLine = index - preRowIndex - 1;
                for (int ii = 0; ii < jumpLine; ++ii) {
                    this.buildNullRow(preRowIndex + ii + 1, this._htmlBuffer);
                }
            }
            preRowIndex = index;
            Row row = this.getSheet().getRow(index, false);
            if (row == null) {
                this.buildNullRow(index, this._htmlBuffer);
                continue;
            }
            if (firstRow) {
                firstRow = false;
                this.calculateColumnWidth(row);
            }
            this.buildRow(row, this._htmlBuffer);
        }
        this._htmlBuffer.append("</table>\n\r");
        this._enforceShowGraph = !this._pagingCxt.hasNextPage();
        this.transformEmbedObject();
    }

    private void buildNullRow(int nullRowLine, HtmlBuffer htmlBuffer) {
        int height = 0;
        if (!Sheet.isHideRow(this.getSheet(), nullRowLine)) {
            height = this._pagingCxt.getRowHeight(nullRowLine, null, this.getSheet().getRowSpans());
        }
        htmlBuffer.append("<tr style = 'height: ");
        htmlBuffer.append(Integer.toString(height)).append("px'/>");
    }

    private void buildHeader() {
        if (!this._header.hasHeader()) {
            return;
        }
        Iterator rowIter = this._pagingCxt.headerIterator(this._header.getRow());
        boolean exported = false;
        HtmlBuffer htmlBuffer = new HtmlBuffer();
        while (rowIter.hasNext()) {
            Integer index = (Integer)rowIter.next();
            Row row = this.getSheet().getRow(index, false);
            if (row == null) continue;
            this.buildRow(row, htmlBuffer);
            exported = true;
        }
        if (exported) {
            this._header.setHtml(htmlBuffer);
        }
    }

    void buildRow(Row row, HtmlBuffer htmlBuffer) {
        int[] columns = this._hsModel.getVisibleColumns();
        int size = columns.length;
        int height = 0;
        Cell useCell = null;
        for (int index = 0; index < size && null == (useCell = row.getCell(columns[index], false)); ++index) {
        }
        htmlBuffer.append("<tr ");
        boolean rowWrapText = false;
        if (this.isSheetNeededWrapText(row.getSheet())) {
            rowWrapText = this.isRowNeededWrapText(this._hsModel, row.getSheet(), row);
        }
        if (!rowWrapText) {
            htmlBuffer.append("style = 'height: ");
            height = this._pagingCxt.getRowHeight(row.getRow(), useCell, this.getSheet().getRowSpans());
            htmlBuffer.append(Integer.toString(height)).append("px'");
        }
        htmlBuffer.append(">\r\n");
        for (int index = 0; index < size; ++index) {
            Cell cell = row.getCell(columns[index], true);
            this.buildCell(cell, htmlBuffer);
        }
        htmlBuffer.append("</tr>\n\r");
    }

    boolean isSheetNeededWrapText(Sheet sheet) {
        Object resized = sheet.getUserObjectValue("resizedInRuntime");
        return resized != null && Boolean.parseBoolean((String)resized);
    }

    boolean isRowNeededWrapText(HtmlSheetModel hsModel, Sheet sheet, Row row) {
        int[] columns = hsModel.getVisibleColumns();
        int size = columns.length;
        for (int index = 0; index < size; ++index) {
            Cell cell = row.getCell(columns[index], false);
            if (null == cell || StringUtil.isEmptyString((String)cell.getText())) continue;
            Range range = sheet.getRange(cell.getRow(), cell.getCol(), cell.getRow(), cell.getCol());
            StyleAttributes sa = Styles.getEmptySA();
            StyleAttributes borderSa = Styles.getEmptySA();
            range.getStyle(sa, borderSa);
            if (!sa.isWrapText()) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void buildCell(Cell cell, HtmlBuffer htmlBuffer) {
        int remain;
        if (cell == null) {
            htmlBuffer.append("<td class=\"xemptyclz\"></td>\r\n");
            return;
        }
        String splitClass = "";
        int uid = 0;
        boolean crossPageMb = false;
        boolean bInnerMerger = false;
        boolean isFirstMergedCell = false;
        boolean shouldHideData = false;
        CellBlock mb = cell.getSheet().getMergeBlock(cell);
        boolean bl = bInnerMerger = mb != null && (mb.getRow() != cell.getRow() || mb.getCol() != cell.getCol());
        if (bInnerMerger) {
            if (!this._pagingCxt.isPaging() || this._pagingCxt.getStartRow() != cell.getRow()) return;
            int firstCellCol = mb.getCol();
            Cell firstCell = this.getSheet().getCell(mb.getRow(), firstCellCol, false);
            if (firstCell == null || firstCellCol != cell.getCol()) return;
            uid = this.addCellStyle(firstCell);
            crossPageMb = true;
        }
        isFirstMergedCell = cell.isFirstMergedCell();
        DiagonalHeader dh = cell.getDiagonalHeader();
        if (dh != null) {
            shouldHideData = true;
        }
        htmlBuffer.append("<td ");
        if (isFirstMergedCell) {
            int height = mb.getHeight();
            int width = this._pagingCxt.getActualColCount(cell.getCol(), mb.getWidth());
            if (width - 1 > 0) {
                htmlBuffer.append(" ").append("colspan='").append(width).append('\'');
            }
            if (height - 1 > 0) {
                if (this._pagingCxt.isPaging()) {
                    remain = this._pagingCxt.getTheoreticalRemainRows();
                    height = Math.min(height, remain);
                }
                htmlBuffer.append(" ").append("rowspan='").append(height).append('\'');
            }
        } else if (crossPageMb) {
            int width = this._pagingCxt.getActualColCount(cell.getCol(), mb.getWidth());
            int height = mb.getHeight() - this._pagingCxt.getStartRow() + mb.getRow();
            if (width - 1 > 0) {
                htmlBuffer.append(" ").append("colspan='").append(width).append('\'');
            }
            if (height - 1 > 0) {
                remain = this._pagingCxt.getTheoreticalRemainRows();
                height = Math.min(height, remain);
                htmlBuffer.append(" ").append("rowspan='").append(height).append('\'');
            }
        }
        uid = crossPageMb ? uid : this.addCellStyle(cell);
        splitClass = this._header.getLockCssClass(cell.getRow(), cell.getCol());
        if ("".equals(splitClass)) {
            htmlBuffer.append("class=\"");
            htmlBuffer.append('x' + Integer.toString(uid));
            htmlBuffer.append("\"");
            htmlBuffer.append(this.fixAlignment(cell));
            htmlBuffer.append(">\r\n");
        } else {
            htmlBuffer.append("class=\"");
            htmlBuffer.append('x' + Integer.toString(uid));
            htmlBuffer.append("").append(' ');
            htmlBuffer.append(this._header.getLockCssClass(cell.getRow(), cell.getCol())).append(' ');
            htmlBuffer.append(this._header.getVerticalBoundaryLine(cell.getCol())).append(' ');
            htmlBuffer.append(this._header.getHorizontalBoundaryLine(cell.getRow()));
            htmlBuffer.append("\"");
            htmlBuffer.append(this.fixAlignment(cell));
            htmlBuffer.append(">\r\n");
        }
        if (!shouldHideData) {
            htmlBuffer.append(this.buildCellData(cell));
        }
        if (dh != null) {
            htmlBuffer.append(this.getDiagonalHeaderText(dh));
            String url = (String)this._imagePathCache.get(cell.getStyle().getUID());
            Color color = cell.getStyle().getBackground();
            Color transparent = new Color(255, 255, 255, 0);
            int height = 0;
            int row2 = dh.getRow2();
            for (int i = dh.getRow(); i <= row2; ++i) {
                int rowHeight = MeasureHelper.getItemLength(cell.getRow(), this.getSheet().getRowSpans(), cell, true);
                height += rowHeight;
            }
            if (color.equals(transparent)) {
                htmlBuffer.append("<div style=\"top:0%;left:0%;width:100%;height:").append(height).append(";filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='").append(url).append("',sizingMethod='image');").append("\" >").append("</div>");
            } else {
                htmlBuffer.append("<div style=\"top:0%;left:0%;width:100%;height:").append(height).append("px;background-image: url('").append(url).append("');").append("background-repeat:no-repeat;").append("\" >").append("</div>");
            }
        }
        htmlBuffer.append("</td>\r\n");
    }

    private String getDiagonalHeaderText(DiagonalHeader dh) {
        int size = dh.size();
        StringBuilder buf = new StringBuilder(size * 5);
        buf.append("<span style=\"display:none;height:0\">");
        for (int i = size - 1; i >= 0; --i) {
            buf.append(dh.getTriangleInfo(i).getText()).append('&');
        }
        buf.deleteCharAt(buf.length() - 1);
        buf.append("</span>");
        return buf.toString();
    }

    private String fixAlignment(Cell cell) {
        Style style = cell.getStyle();
        Styles.HorizontalAlignment alignment = (Styles.HorizontalAlignment)style.get(ShareStyleAttributes.HORIZONTAL_ALIGN);
        if (alignment != null && alignment.getValue() == 0) {
            Variant value = cell.getValue();
            if (value.isNumber() || value.isDate()) {
                return "style=\"text-align:right\" ";
            }
            if (value.getVt() == 8) {
                return "style=\"text-align:center\" ";
            }
            return "style=\"text-align:left\" ";
        }
        return "";
    }

    private String buildCellData(Cell cell) {
        Object obj;
        HyperlinkCalculableProps hyperLinkCalProps;
        StringBuilder content;
        block15: {
            int[] type;
            String br;
            String spanEE;
            String spanEC;
            String spanM;
            String spanS;
            String emptySpan;
            block17: {
                block16: {
                    emptySpan = "<span>&nbsp;&nbsp;</span>";
                    spanS = "<span location=\"";
                    spanM = "\" sue='extWorksheetExpandImg'id='" + this._pageId + "' style='cursor:pointer' ";
                    spanEC = "class = 'extTreeHandle_c'>&nbsp</span>";
                    spanEE = "class = 'extTreeHandle_e'>&nbsp;</span>";
                    br = "";
                    if (this._hsModel.isHorizonTree()) {
                        br = "<br><br>";
                    }
                    content = new StringBuilder();
                    if (!this._hsModel.isTree()) break block15;
                    if (!this._hsModel.isHorizonTree() || cell.getRow() != this._hsModel.getTreePos()) break block16;
                    type = this._hsModel.displayType(cell.getCol());
                    break block17;
                }
                if (cell.getCol() != this._hsModel.getTreePos()) break block15;
                type = this._hsModel.displayType(cell.getRow());
            }
            int num = type[1];
            for (int i = 0; i < num; ++i) {
                content.append(emptySpan);
                content.append(br);
            }
            switch (type[0]) {
                case 0: {
                    content.append(emptySpan);
                    content.append(br);
                    break;
                }
                case 1: {
                    String location = cell.getRow() + "," + cell.getCol();
                    content.append(spanS).append(location).append(spanM).append(spanEC);
                    content.append(br);
                    break;
                }
                case -1: {
                    String location = cell.getRow() + "," + cell.getCol();
                    content.append(spanS).append(location).append(spanM).append(spanEE);
                    content.append(br);
                }
            }
        }
        if ((hyperLinkCalProps = AbstractHyperLinkHelper.getHyperLink(cell)) != null && this._linkHelper != null) {
            String[] linkStr = this._linkHelper.registTarget(hyperLinkCalProps, cell);
            content.append("<a href=\"JavaScript:void(0);\" onclick=\"openHyperLink(this)\" style=\"cursor:pointer\" ");
            content.append(linkStr[0]);
            content.append(linkStr[1]);
            content.append(" >");
        }
        Style ssa = cell.getStyle();
        int index = ShareStyleAttributes.WRAP_TEXT;
        boolean wrapText = false;
        if (ssa.hasAttributes(index) && Boolean.TRUE.equals(obj = ssa.get(index))) {
            wrapText = true;
        }
        if (wrapText) {
            content.append(cell.getText().replaceAll(" ", BLANK).replaceAll("\n", "<br>"));
        } else {
            content.append(cell.getText().replaceAll(" ", BLANK));
        }
        if (hyperLinkCalProps != null) {
            content.append("</a>");
        }
        return content.toString();
    }

    private void calculateColumnWidth(Row row) {
        SortedAttributeSpanArray spans = this.getSheet().getColSpans();
        int[] columns = this._hsModel.getVisibleColumns();
        int maxRow = this.getSheet().getMaxRowIndex();
        Cell cell = null;
        for (int index = 0; index < columns.length; ++index) {
            this._htmlBuffer.append("<col width =");
            int colIndex = columns[index];
            for (int rowI = row.getRow(); rowI < maxRow && (cell = this.getSheet().getCell(rowI, colIndex, false)) == null; ++rowI) {
            }
            int width = this._pagingCxt.getColWidth(colIndex, cell, spans);
            this._htmlBuffer.append(width + "px;/>");
        }
    }

    private String generateCssTag() {
        String cssString = this._2Css.toCss();
        StringBuilder styleTagBuffer = new StringBuilder();
        styleTagBuffer.append("<style type=\"text/css\">");
        styleTagBuffer.append("\r\n");
        styleTagBuffer.append(cssString);
        styleTagBuffer.append("</style>");
        return styleTagBuffer.toString();
    }

    public String doMouseEvent(WebMouseEvent event) {
        this._hsControllor.doEvent(event, this._hsModel, this._header.getRow());
        return "";
    }

    private int addCellStyle(Cell cell) {
        String path;
        DiagonalHeader dh = cell.getDiagonalHeader();
        if (dh != null && (path = this.createAndPersistImage(cell.getSheet(), (Object)dh, cell)) != null) {
            this.addImagePathEntry(cell.getStyle().getUID(), path);
        }
        this._2Css.addStyle(cell.getStyle());
        return cell.getStyle().getUID();
    }

    private void scanStyle(Sheet sheet) {
        this._2Css.addStyle(sheet.getStyle());
        SortedAttributeSpanArray rowSpans = sheet.getRowSpans();
        int size = rowSpans.size();
        for (int j = 0; j < size; ++j) {
            SortedAttributeSpanArray.AttributeSpan span = rowSpans.getAttributeSpan(j);
            this._2Css.addStyle(span.getStyle());
        }
        SortedAttributeSpanArray colSpans = sheet.getColSpans();
        size = colSpans.size();
        for (int j = 0; j < size; ++j) {
            this._2Css.addStyle(colSpans.getAttributeSpan(j).getStyle());
        }
    }

    private void addImagePathEntry(int styleUuid, String path) {
        if (styleUuid != 0 && path != null && !path.trim().equals("")) {
            Integer key = styleUuid;
            this._imagePathCache.put(key, path);
        }
    }

    private String createAndPersistImage(Sheet sheet, Object o, Cell cell) {
        BufferedImage image = null;
        if (o instanceof ISplitRectInfo) {
            image = this.generateImageForDiagonalHeader(sheet, (ISplitRectInfo)o, cell);
        } else if (o instanceof EmbedObject) {
            EmbedImage ei;
            if (o instanceof EmbedImage && (ei = (EmbedImage)o) != null) {
                try {
                    if (ei.getImage() != null) {
                        return this.createImageForAnyTypeImage((EmbedImage)o);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            image = this.generateImageForEmbedLayer(sheet, (EmbedObject)o);
        } else {
            return "";
        }
        String prefix = "";
        prefix = cell != null ? DIAGONAL_PREFIX : EMBED_PREFIX;
        File imageFile = null;
        try {
            imageFile = File.createTempFile(prefix, ".png", new File(FilenameUtils.normalize((String)this._fileSavePath)));
        }
        catch (IOException e1) {
            return null;
        }
        try {
            ImageIO.write((RenderedImage)image, "png", imageFile);
        }
        catch (IOException e) {
            return null;
        }
        return this._filePrefixPath + imageFile.getName();
    }

    private BufferedImage generateImageForEmbedLayer(Sheet sheet, EmbedObject eo) {
        if (sheet == null || eo == null) {
            return null;
        }
        Rectangle rect = eo.getBounds();
        double width = rect.getWidth();
        double height = rect.getHeight();
        int x = rect.x;
        int y = rect.y;
        BufferedImage image = new BufferedImage((int)width + 1, (int)height + 1, 2);
        Graphics g = image.getGraphics();
        g.translate(-x, -y);
        eo.paintData(g);
        g.dispose();
        return image;
    }

    private String createImageForAnyTypeImage(EmbedImage o) {
        String result = "";
        IImageModel model = o.getModel();
        if (model != null) {
            try {
                byte[] data = model.getImageData();
                if (data == null) {
                    return result;
                }
                String suffix = ImageUtils.retrieveImageType(data);
                ImageSave imagesave = new ImageSave(data, EMBED_PREFIX, suffix, this._fileSavePath);
                suffix = this._filePrefixPath + imagesave.getImageName();
                imagesave.save();
                return suffix;
            }
            catch (IOException e) {
                return result;
            }
        }
        return result;
    }

    private BufferedImage generateImageForDiagonalHeader(Sheet sheet, ISplitRectInfo o, Cell cell) {
        if (cell == null || o == null) {
            return null;
        }
        int row = cell.getRow();
        int col = cell.getCol();
        int height = 0;
        int width = 0;
        CellBlock mergeBlock = cell.getMerge(true);
        SortedAttributeSpanArray colSpans = sheet.getColSpans();
        SortedAttributeSpanArray rowSpans = sheet.getRowSpans();
        width = this.getCellWidthOrHeight(sheet, colSpans, true, col, mergeBlock);
        height = this.getCellWidthOrHeight(sheet, rowSpans, false, row, mergeBlock);
        BufferedImage image = new BufferedImage(width, height, 2);
        SplitRectTextRender render = new SplitRectTextRender();
        CellBackgroundRender backgroundRender = new CellBackgroundRender();
        Rectangle cellShape = new Rectangle(width, height);
        backgroundRender.draw(image.getGraphics(), (Shape)cellShape, (Object)cell, cell.getStyle());
        render.draw(image.getGraphics(), (Shape)cellShape, (Object)o, cell.getStyle());
        return image;
    }

    private int getCellWidthOrHeight(Sheet sheet, SortedAttributeSpanArray spans, boolean gettingWidth, int pos, CellBlock mergedBlock) {
        int length = 0;
        int defaultLength = 0;
        defaultLength = gettingWidth ? sheet.getOriginalDefColWidth() : sheet.getOriginalDefRowHeight();
        if (mergedBlock != null) {
            length = this.getMergedBlockWidthOrHeight(sheet, spans, mergedBlock, gettingWidth);
            return length;
        }
        if (spans == null || spans.size() == 0) {
            length = defaultLength;
        } else {
            int index = spans.searchSpan(pos);
            if (index < 0) {
                length = defaultLength;
            } else {
                SortedAttributeSpanArray.AttributeSpan span = spans.getAttributeSpan(index);
                length = span.getLength();
            }
        }
        return length;
    }

    private int getMergedBlockWidthOrHeight(Sheet sheet, SortedAttributeSpanArray spans, CellBlock mergedBlock, boolean gettingWidth) {
        if (sheet == null) {
            return -1;
        }
        int row = mergedBlock.getRow();
        int row2 = mergedBlock.getRow2();
        int col = mergedBlock.getCol();
        int col2 = mergedBlock.getCol2();
        int length = 0;
        if (gettingWidth) {
            for (int i = col; i <= col2; ++i) {
                length += this.getCellWidthOrHeight(sheet, spans, gettingWidth, i, null);
            }
        } else {
            for (int r = row; r <= row2; ++r) {
                length += this.getCellWidthOrHeight(sheet, spans, gettingWidth, r, null);
            }
        }
        return length;
    }

    private void transformEmbedObject() {
        EmbedhLayer layer = this.getSheet().getEmbedments(false);
        if (layer != null) {
            String name = "";
            for (int i = 0; i < layer.size(); ++i) {
                EmbedObject eo = layer.getEmbed(i);
                if (this._pagingCxt.isPaging()) {
                    int rowBeginY = SheetBaseMath.getRowY(this._sheet, this._pagingCxt.getStartRow());
                    int rowEndY = SheetBaseMath.getRowY(this._sheet, this._pagingCxt.getEndRow());
                    int eoBeginY = eo.getY();
                    if (eoBeginY < rowBeginY || rowEndY < eoBeginY && !this._enforceShowGraph) continue;
                }
                Rectangle rect = eo.getBounds();
                if (rect.width <= 0 || rect.height <= 0) continue;
                name = this.createAndPersistImage(this.getSheet(), eo, null);
                this.buildEmbedObject(name, eo);
            }
            this._enforceShowGraph = false;
        }
    }

    private void preBuildEmbedObject() {
        EmbedhLayer layer = this.getSheet().getEmbedments(false);
        if (layer != null) {
            for (int i = 0; i < layer.size(); ++i) {
                EmbedObject eo = layer.getEmbed(i);
                Rectangle rect = eo.getBounds();
                if (rect.width <= 0 || rect.height <= 0) continue;
                Point2D.Double point = new Point2D.Double(rect.getX() + 2.0, rect.getY() + 2.0);
                int col = SheetBaseMath.colAtPoint(this.getSheet(), point);
                int row = SheetBaseMath.rowAtPoint(this.getSheet(), point);
                this._pagingCxt.addAttentionX(col);
                this._pagingCxt.addAttentionY(row);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildEmbedObject(String name, EmbedObject eo) {
        if (name == null || name.trim().equals("") || eo == null) {
            return;
        }
        StringBuilder buffer = new StringBuilder();
        Object object = this.lock;
        synchronized (object) {
            SecureRandom random = new SecureRandom();
            int counter = random.nextInt() & 0xFFFF;
            String divId = "graph_report" + String.valueOf(counter);
            this.divNameMap.put(eo.getName(), divId);
        }
        String eoStyle = "position:absolute;border:0px solid silver;background:white;z-index:9999;";
        Rectangle rect = eo.getBounds();
        Point2D.Double point = new Point2D.Double(rect.getX() + 2.0, rect.getY() + 2.0);
        int col = SheetBaseMath.colAtPoint(this.getSheet(), point);
        int row = SheetBaseMath.rowAtPoint(this.getSheet(), point);
        rect = this._pagingCxt.getEmbedObjectRect(row, col, rect);
        String height = String.valueOf(rect.getHeight() + 1.0);
        String width = String.valueOf(rect.getWidth() + 1.0);
        String x = String.valueOf(rect.getX());
        String y = String.valueOf(rect.getY());
        if (eo instanceof FlashChart) {
            FlashChart chart = (FlashChart)eo;
            FlashChartModel model = chart.getModel();
            String xml = model.getXml();
            FlashHelper.unpackSWF_SERVER(null, model.getChartType());
            String falshName = model.getBean().getChartType().getSWFFileName();
            String chartName = model.getBean().getChartType().getName();
            buffer.append("\r\n <div id=\"");
            buffer.append((String)this.divNameMap.get(eo.getName()));
            buffer.append('\"');
            buffer.append(" style=\"");
            buffer.append("position:absolute;border:0px solid silver;background:white;z-index:0;");
            buffer.append("left:").append(x).append("px;");
            buffer.append("top:").append(y).append("px;");
            buffer.append("width:").append(width).append("px;");
            buffer.append("height:").append(height).append("px;");
            buffer.append("\">");
            buffer.append("\r\n <Object style=\"width:100%;height:100%;\" events=\"true\"");
            buffer.append("codebase=\"http://fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0\"");
            buffer.append("id=\"myEmbeddedObject\"");
            buffer.append("classid=\"clsid:d27cdb6e-ae6d-11cf-96b8-444553540000\">");
            buffer.append("<param value=\"").append(this._filePrefixPath).append(falshName).append("\" name=\"movie\"/>");
            buffer.append("<param value=\"false\" name=\"menu\"/> ");
            buffer.append("<param name=\"quality\" value=\"high\" />");
            buffer.append("<param name=\"bgcolor\" value=\"#ffffff\" />");
            buffer.append("<param name=\"wmode\" value=\"Opaque\" />");
            buffer.append("<param name=\"wmode\" value=\"transparent\" />");
            buffer.append("<PARAM value=\"debugMode=0&amp;allowFullScreen=true&amp;menu=false&amp;dataXML=");
            buffer.append(Utils.encodeURL((String)xml));
            buffer.append("\" name=\"flashVars\"/>");
            buffer.append("<embed style=\"width:100%;height:100%;\" src=\"").append(this._filePrefixPath).append(falshName).append("\" quality=\"high\" bgcolor=\"#ffffff\" width=\"").append(width).append("\" height=\"").append(height).append("\" name=\"").append(chartName).append("\" align=\"middle\" allowScriptAccess=\"sameDomain\" type=\"application/x-shockwave-flash\" pluginspage=\"http://www.macromedia.com/go/getflashplayer\" />");
            buffer.append("\r\n </Object>");
            buffer.append("\r\n </div>");
        } else {
            buffer.append("\r\n <div id=\"");
            buffer.append((String)this.divNameMap.get(eo.getName()));
            buffer.append('\"');
            buffer.append(" style=\"");
            buffer.append(eoStyle);
            buffer.append("left:").append(x).append("px;");
            buffer.append("top:").append(y).append("px;");
            buffer.append("width:").append(width).append("px;");
            buffer.append("height:").append(height).append("px;");
            buffer.append("\">");
            buffer.append("\r\n <img style=\"width:100%;height:100%;\" src=\"");
            buffer.append(name);
            buffer.append("\">");
            buffer.append("\r\n </div>");
        }
        String content = buffer.toString();
        this._htmlBuffer.append(content);
    }

    public void setHyperLinkHelper(AbstractHyperLinkHelper helper) {
        this._linkHelper = helper;
    }

    public void setHyperLinksProps(SheetHyperLinksProps hyperLinksProps) {
    }

    private Sheet getSheet() {
        Sheet sheet = null;
        if (this._sheet == null) {
            Object obj = this._sheetRef.get();
            sheet = (Sheet)obj;
        } else {
            sheet = this._sheet;
        }
        return sheet;
    }

    private void lockSheet() {
        this._sheet = this.getSheet();
    }

    private void unlockSheet() {
    }

    public Book getPrintBook(Book book) {
        Book book2 = null;
        try {
            book2 = BookIOUtil.unpack(BookIOUtil.pack(book));
            book2.setCalculate(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (book2 == null) {
            return null;
        }
        int layerSize = 0;
        for (int i = 0; i < book2.getSheetCount(); ++i) {
            EmbedhLayer layer = book2.getSheet(i).getEmbedments(false);
            if (layer != null) {
                layerSize = layer.size();
                layer.selectAllEmbeds();
                layer.removeSelectedEmbeds();
                for (int j = 0; j < layerSize; ++j) {
                    layer.addEmbed(book.getSheet(i).getEmbedments(false).getEmbed(j));
                }
            }
            Sheet oldSheet = null;
            try {
                oldSheet = book.getSheetByName(book2.getSheetName(i));
            }
            catch (SyntaxErrorException e) {
                logger.error((Object)"err", (Throwable)e);
            }
            ExecutorUtil.calcDisplayValue(oldSheet, book2.getSheet(i));
        }
        Sheet sheet = book2.getActiveSheet();
        SortedAttributeSpanArray spans = sheet.getRowSpans();
        SortedSpanArray items = this._hsModel.getItems();
        if (null != items) {
            SimpleHtmlAttributeSpan itemSpan = null;
            int synIdx = 0;
            int size = spans.size();
            for (int i = 0; i < size; ++i) {
                SortedAttributeSpanArray.AttributeSpan span = spans.getAttributeSpan(i);
                if (null == span) continue;
                itemSpan = (SimpleHtmlAttributeSpan)items.get(synIdx);
                span.setCollapse(itemSpan.isCollapse());
                span.setVisible(!itemSpan.isHidden());
                ++synIdx;
            }
        }
        return book2;
    }

    public static class HtmlBuffer {
        private StringBuffer buffer = new StringBuffer(4096);
        private OutputStream writer = null;

        public OutputStream getWriter() {
            return this.writer;
        }

        public void setWriter(OutputStream writer) {
            this.writer = writer;
        }

        public StringBuffer append(String s) {
            this.buffer.append(s);
            if (this.writer != null) {
                try {
                    String str = this.buffer.toString();
                    byte[] tempBytes = str.getBytes("utf-8");
                    if (tempBytes.length >= 524288) {
                        this.writer.write(tempBytes);
                        this.writer.flush();
                        this.buffer.delete(0, this.buffer.length());
                    }
                    tempBytes = null;
                    Object var2_2 = null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return this.buffer;
        }

        public String toString() {
            return this.buffer.toString();
        }
    }
}

