/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.io.htm;

import chrriis.dj.nativeswing.common.Utils;
import com.kingdee.cosmic.ctrl.common.util.ArrayUtil;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.FlashHelper;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.pic.ImageUtils;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kdf.util.render.CellBackgroundRender;
import com.kingdee.cosmic.ctrl.kdf.util.render.splitrectangle.ISplitRectInfo;
import com.kingdee.cosmic.ctrl.kdf.util.render.splitrectangle.SplitRectTextRender;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import com.kingdee.cosmic.ctrl.kds.io.htm.ImageSave;
import com.kingdee.cosmic.ctrl.kds.io.htm.SheetHyperLinksProps;
import com.kingdee.cosmic.ctrl.kds.io.htm.extweb.DefaultDivDimStrategy;
import com.kingdee.cosmic.ctrl.kds.io.htm.extweb.DivDim;
import com.kingdee.cosmic.ctrl.kds.io.htm.extweb.IDivDimStrategy;
import com.kingdee.cosmic.ctrl.kds.io.htm.extweb.MeasureCalculator;
import com.kingdee.cosmic.ctrl.kds.io.htm.extweb.ReportHeader;
import com.kingdee.cosmic.ctrl.kds.io.htm.extweb.SortedLengthArray;
import com.kingdee.cosmic.ctrl.kds.io.htm.extweb.Style2Css;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.CellBlock;
import com.kingdee.cosmic.ctrl.kds.model.struct.DiagonalHeader;
import com.kingdee.cosmic.ctrl.kds.model.struct.MergeBlocks;
import com.kingdee.cosmic.ctrl.kds.model.struct.Row;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.cosmic.ctrl.kds.model.struct.SortedAttributeSpanArray;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedObject;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.image.EmbedImage;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.image.IImageModel;
import com.kingdee.cosmic.ctrl.kds.model.util.SortedCellBlockArray;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class KdsToHtmlExporter {
    private static Logger logger = LogUtil.getLogger(KdsToHtmlExporter.class);
    private HtmlBuffer _sb = new HtmlBuffer();
    private Sheet _sheet = null;
    private String _filePrefixPath = "";
    private File _outFile = null;
    private String _fileSavePath = "";
    private HashMap _imagePathCache;
    private SortedLengthArray _colWidths;
    private SortedLengthArray _rowHeights;
    private static final String DIAGONAL_PREFIX = "diagonal_";
    private static final String EMBED_PREFIX = "embed_";
    private static final String BLANK = "&nbsp;";
    private int _row1;
    private int _row2;
    private boolean _hasScreenRow = false;
    private int _screenHeight;
    private boolean _paging = false;
    private boolean _enforceShowGraph = false;
    private boolean heightAdaptive = false;
    private SortedCellBlockArray _borderMergeBlocks;
    private BitSet _mergeBlocksMarks;
    private Style2Css _2Css;
    private IDivDimStrategy _divDimStrategy;
    private MeasureCalculator _measuleCalc;
    private ReportHeader _header;
    private SheetHyperLinksProps _hyperLinksProps;
    private DivDim _divDim = null;
    private final Object lock = new Object();
    private Map divNameMap = new HashMap();

    public KdsToHtmlExporter(Sheet sheet, File outFile) {
        this._sheet = sheet;
        this._outFile = outFile;
        this._imagePathCache = new HashMap();
        this._colWidths = new SortedLengthArray();
        this._rowHeights = new SortedLengthArray();
        if (outFile != null) {
            this._filePrefixPath = outFile.getName() + ".files" + File.separator;
            this.initImageSavePath();
        }
        this.heightAdaptive = this.isResizedInRuntime();
        this._2Css = new Style2Css(this._sheet);
    }

    public boolean isResizedInRuntime() {
        return this._sheet.getUserObject("resizedInRuntime") != null;
    }

    public void setEnforceShowGraph(boolean enforceShowGraph) {
        this._enforceShowGraph = enforceShowGraph;
    }

    public void setRow1(int row1) {
        this._row1 = row1;
    }

    public void setScreenHeight(int height) {
        this._screenHeight = height;
    }

    public void setScreenRow(boolean hasScreenRow) {
        this._hasScreenRow = hasScreenRow;
    }

    public void setRow2(int row2) {
        this._row2 = row2;
    }

    public String getFileSavePath() {
        return this._fileSavePath;
    }

    public void setFileSavePath(String savePath) {
        this._fileSavePath = savePath;
    }

    public String getFilePrefixPath() {
        return this._filePrefixPath;
    }

    public void setFilePrefixPath(String imagePath) {
        this._filePrefixPath = imagePath;
    }

    private int getDefaultRowHeightOrColWidth(int index, boolean isColumn) {
        return this._measuleCalc.getDefaultRowHeightOrColWidth(index, isColumn);
    }

    private void initImageSavePath() {
        File saveDir = new File(FilenameUtils.normalize((String)(this._outFile.getParent() + File.separator + this._filePrefixPath)));
        if (!saveDir.exists()) {
            saveDir.mkdirs();
        }
        this._fileSavePath = saveDir.getAbsolutePath();
    }

    private int getCellWidthOrHeight(Sheet sheet, SortedAttributeSpanArray spans, boolean gettingWidth, int pos, CellBlock mergedBlock) {
        int length = 0;
        int defaultLength = 0;
        defaultLength = gettingWidth ? sheet.getOriginalDefColWidth() : sheet.getOriginalDefRowHeight();
        if (mergedBlock != null) {
            length = this.getMergedBlockWidthOrHeight(sheet, spans, mergedBlock, gettingWidth);
            return length;
        }
        if (spans == null || spans.size() == 0) {
            length = defaultLength;
        } else {
            int index = spans.searchSpan(pos);
            if (index < 0) {
                length = defaultLength;
            } else {
                SortedAttributeSpanArray.AttributeSpan span = spans.getAttributeSpan(index);
                length = span.getLength();
            }
        }
        return length;
    }

    private int getMergedBlockWidthOrHeight(Sheet sheet, SortedAttributeSpanArray spans, CellBlock mergedBlock, boolean gettingWidth) {
        if (sheet == null) {
            return -1;
        }
        int row = mergedBlock.getRow();
        int row2 = mergedBlock.getRow2();
        int col = mergedBlock.getCol();
        int col2 = mergedBlock.getCol2();
        int length = 0;
        if (gettingWidth) {
            for (int i = col; i <= col2; ++i) {
                length += this.getCellWidthOrHeight(sheet, spans, gettingWidth, i, null);
            }
        } else {
            for (int r = row; r <= row2; ++r) {
                length += this.getCellWidthOrHeight(sheet, spans, gettingWidth, r, null);
            }
        }
        return length;
    }

    private BufferedImage generateImageForEmbedLayer(Sheet sheet, EmbedObject eo) {
        if (sheet == null || eo == null) {
            return null;
        }
        Rectangle rect = eo.getBounds();
        double width = rect.getWidth();
        double height = rect.getHeight();
        int x = rect.x;
        int y = rect.y;
        BufferedImage image = new BufferedImage((int)width + 1, (int)height + 1, 2);
        Graphics g = image.getGraphics();
        g.translate(-x, -y);
        eo.paintData(g);
        g.dispose();
        return image;
    }

    private String createImageForAnyTypeImage(EmbedImage o) {
        String result = "";
        IImageModel model = o.getModel();
        if (model != null) {
            try {
                byte[] data = model.getImageData();
                if (data == null) {
                    return result;
                }
                String suffix = ImageUtils.retrieveImageType(data);
                ImageSave imagesave = new ImageSave(data, EMBED_PREFIX, suffix, this._fileSavePath);
                suffix = this._filePrefixPath + imagesave.getImageName();
                imagesave.save();
                return suffix;
            }
            catch (IOException e) {
                return result;
            }
        }
        return result;
    }

    private BufferedImage generateImageForDiagonalHeader(Sheet sheet, ISplitRectInfo o, Cell cell) {
        if (cell == null || o == null) {
            return null;
        }
        int row = cell.getRow();
        int col = cell.getCol();
        int height = 0;
        int width = 0;
        CellBlock mergeBlock = cell.getMerge(true);
        SortedAttributeSpanArray colSpans = sheet.getColSpans();
        SortedAttributeSpanArray rowSpans = sheet.getRowSpans();
        width = this.getCellWidthOrHeight(sheet, colSpans, true, col, mergeBlock);
        height = this.getCellWidthOrHeight(sheet, rowSpans, false, row, mergeBlock);
        BufferedImage image = new BufferedImage(width, height, 2);
        SplitRectTextRender render = new SplitRectTextRender();
        CellBackgroundRender backgroundRender = new CellBackgroundRender();
        Rectangle cellShape = new Rectangle(width, height);
        backgroundRender.draw(image.getGraphics(), (Shape)cellShape, (Object)cell, cell.getStyle());
        render.draw(image.getGraphics(), (Shape)cellShape, (Object)o, cell.getStyle());
        return image;
    }

    private String createAndPersistImage(Sheet sheet, Object o, Cell cell) {
        BufferedImage image = null;
        if (o instanceof ISplitRectInfo) {
            image = this.generateImageForDiagonalHeader(sheet, (ISplitRectInfo)o, cell);
        } else if (o instanceof EmbedObject) {
            EmbedImage ei;
            if (o instanceof EmbedImage && (ei = (EmbedImage)o) != null) {
                try {
                    if (ei.getImage() != null) {
                        return this.createImageForAnyTypeImage((EmbedImage)o);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            image = this.generateImageForEmbedLayer(sheet, (EmbedObject)o);
        } else {
            return "";
        }
        String prefix = "";
        prefix = cell != null ? DIAGONAL_PREFIX : EMBED_PREFIX;
        File imageFile = null;
        try {
            imageFile = File.createTempFile(prefix, ".png", new File(FilenameUtils.normalize((String)this._fileSavePath)));
        }
        catch (IOException e1) {
            return null;
        }
        try {
            ImageIO.write((RenderedImage)image, "png", imageFile);
        }
        catch (IOException e) {
            return null;
        }
        return this._filePrefixPath + imageFile.getName();
    }

    private void scanStyle(Sheet sheet) {
        MergeBlocks mbs;
        this._2Css.addStyle(sheet.getStyle());
        Sheet.ICellsIterator iter = this._paging ? sheet.getCellsIterator(this._row1, 0, this._row2, sheet.getMaxColIndex(), false, false) : sheet.getCellsIterator(0, 0, sheet.getMaxRowIndex(), sheet.getMaxColIndex(), false, false);
        while (iter.hasNext()) {
            String path;
            Cell cell = iter.next();
            DiagonalHeader dh = cell.getDiagonalHeader();
            if (dh != null && (path = this.createAndPersistImage(sheet, (Object)dh, cell)) != null) {
                this.addImagePathEntry(cell.getStyle().getUID(), path);
            }
            this._2Css.addStyle(cell.getStyle());
        }
        SortedAttributeSpanArray rowSpans = sheet.getRowSpans();
        int size = rowSpans.size();
        for (int j = 0; j < size; ++j) {
            SortedAttributeSpanArray.AttributeSpan span = rowSpans.getAttributeSpan(j);
            if (span.getStart() > this._row1 || span.getEnd() < this._row2) continue;
            this._2Css.addStyle(span.getStyle());
        }
        SortedAttributeSpanArray colSpans = sheet.getColSpans();
        size = colSpans.size();
        for (int j = 0; j < size; ++j) {
            this._2Css.addStyle(colSpans.getAttributeSpan(j).getStyle());
        }
        if (this._paging && (mbs = this._sheet.getMerger(false)) != null) {
            this._borderMergeBlocks = mbs.getTouchedBlocks(this._row1, 0, this._row1, 65535);
            if (this._borderMergeBlocks != null) {
                int len = this._borderMergeBlocks.size();
                this._mergeBlocksMarks = new BitSet(this._borderMergeBlocks.getBlock(len - 1).getCol2());
                for (int i = 0; i < len; ++i) {
                    CellBlock cb = this._borderMergeBlocks.getBlock(i);
                    int col = cb.getCol();
                    this._2Css.addStyle(sheet.getCell(cb.getRow(), col, false).getStyle());
                    this._mergeBlocksMarks.set(col);
                }
            }
        }
    }

    private void addImagePathEntry(int styleUuid, String path) {
        if (styleUuid != 0 && path != null && !path.trim().equals("")) {
            Integer key = styleUuid;
            this._imagePathCache.put(key, path);
        }
    }

    public void exportHtml() throws IOException {
        long start = System.currentTimeMillis();
        this._sb = null;
        this._sb = new HtmlBuffer();
        this.scanStyle(this._sheet);
        this._measuleCalc = new MeasureCalculator(this._sheet, this._row1, this._row2, this._paging);
        this._measuleCalc.calc();
        this._colWidths = this._measuleCalc.getColWidths();
        this._rowHeights = this._measuleCalc.getRowHeights();
        FileOutputStream out = new FileOutputStream(this._outFile);
        this._sb.setWriter(out);
        this.generateHtmlPage();
        this.clearCache();
        this.buildJavaScriptBlock();
        this._sb.append("</body>\n");
        this._sb.append("</html>\n");
        out.write(this._sb.toString().getBytes("utf-8"));
        out.close();
        long end = System.currentTimeMillis();
        System.out.println(end - start + "ms");
    }

    public String exportDiv() throws IOException {
        long begin = System.currentTimeMillis();
        this._paging = true;
        this._sb = new HtmlBuffer();
        if (this._header == null) {
            this._header = new ReportHeader(this._sheet, this._filePrefixPath, this._fileSavePath);
            this._header.buildHeader();
        }
        this._sb.append("<div style=\"");
        if (this._hasScreenRow || this._header.isHeaderSet()) {
            this._sb.append(" overflow: scroll;");
        }
        this._sb.append(" position:relative;margin:5px 5px 5px 5px;");
        this._row1 += this._header.getRow();
        this._row2 += this._header.getRow();
        this.scanStyle(this._sheet);
        this._2Css.mergeStyle(this._header.getStyles());
        this._measuleCalc = new MeasureCalculator(this._sheet, this._row1, this._row2, this._paging);
        this._measuleCalc.calc();
        this._colWidths = this._measuleCalc.getColWidths();
        this._rowHeights = this._measuleCalc.getRowHeights();
        this._divDimStrategy = new DefaultDivDimStrategy(this._sheet, this._row1, this._row2, this._paging, this._colWidths, this._rowHeights, this._enforceShowGraph, this._measuleCalc, true);
        this._divDim = this._divDimStrategy.calc();
        int height = this._hasScreenRow ? this._screenHeight : this._divDim.getHeight() + this._header.getHeight() + 50;
        if (this._header.isHorizontalHeaderSet()) {
            this._sb.append("width: 100%;");
            if (height > 700 && !this._hasScreenRow) {
                height -= 100;
            }
            this._sb.append("height:").append(height).append("px;");
        } else {
            this._sb.append("width: 100%;");
            this._sb.append("height:").append(height).append("px;");
        }
        this._sb.append("\">");
        this.generteHtmTable();
        this._sb.append(this.generateCssTag());
        this.clearCache();
        this._sb.append("\n<div style=\"display:none;height:0\" sue=\"data\">");
        this._sb.append(this._hyperLinksProps.getIdx2ReportPropsJson());
        this._sb.append(this._hyperLinksProps.getIdx2ParamsValueJson());
        this._sb.append("</div>");
        this._sb.append("</div>\n");
        this._borderMergeBlocks = null;
        this._mergeBlocksMarks = null;
        long end = System.currentTimeMillis();
        System.out.println("\u6d88\u8017\uff1a" + (end - begin) / 1000L);
        return this._sb.toString();
    }

    public String buildHeader(ReportHeader header) throws IOException {
        this._paging = true;
        this._sb = new HtmlBuffer();
        this._header = header;
        this.scanStyle(this._sheet);
        this._measuleCalc = new MeasureCalculator(this._sheet, this._row1, this._row2, this._paging);
        this._measuleCalc.calc();
        this._colWidths = this._measuleCalc.getColWidths();
        this._rowHeights = this._measuleCalc.getRowHeights();
        this._divDimStrategy = new DefaultDivDimStrategy(this._sheet, this._row1, this._row2, this._paging, this._colWidths, this._rowHeights, this._enforceShowGraph, this._measuleCalc, true);
        this._divDim = this._divDimStrategy.calc();
        this.transformTableTowsWhenPaging(this._sheet);
        this._borderMergeBlocks = null;
        this._mergeBlocksMarks = null;
        this.clearCache();
        return this._sb.toString();
    }

    private void clearCache() {
        this._colWidths.clear();
        this._imagePathCache.clear();
        this._rowHeights.clear();
    }

    public boolean writeToCssFile(File cssFile) throws IOException {
        if (cssFile == null) {
            return false;
        }
        try (FileOutputStream out = new FileOutputStream(cssFile);){
            String styleTagString = this.generateCssTag();
            out.write(styleTagString.getBytes("utf-8"));
        }
        catch (IOException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return true;
    }

    private String generateCssTag() {
        String cssString = this._2Css.toCss();
        StringBuilder styleTagBuffer = new StringBuilder();
        styleTagBuffer.append("<style type=\"text/css\">");
        styleTagBuffer.append("\r\n");
        styleTagBuffer.append(cssString);
        styleTagBuffer.append("</style>");
        return styleTagBuffer.toString();
    }

    private void generateHtmlPage() throws IOException {
        this._sb.append("<html\n");
        this._sb.append("xmlns=\"http://www.w3.org/TR/REC-html40\">\n");
        this._sb.append("<head>\n<meta http-equiv=Content-Type content=\"text/html; charset=utf-8\"></head>\n");
        this._sb.append(this.generateCssTag());
        this._sb.append("<body>");
        this._sb.append("<div style=\"position: relative;\">");
        this.generteHtmTable();
        this._sb.append("</div>");
    }

    private void generteHtmTable() throws IOException {
        Style ssa = this._sheet.getStyle();
        this._sb.append("<Table style='border-collapse: collapse;table-layout:fixed;'\n");
        int uid = ssa.getUID();
        if (ssa != null && uid != 0) {
            this._sb.append(" class='").append('x').append(uid).append('\'');
        }
        this._sb.append(">");
        this.transformTableColumn(this._sheet);
        if (this._header != null) {
            this._sb.append(this._header.getHtml());
        }
        if (this._paging) {
            this.transformTableTowsWhenPaging(this._sheet);
        } else {
            this.transformTableRows(this._sheet);
        }
        this._sb.append("</Table>\n");
        this.transformEmbedObject(this._sheet);
    }

    private void buildRowSpan(SortedAttributeSpanArray.AttributeSpan rowSpan, int rowIdx) throws IOException {
        this._sb.append("<tr");
        Style ssa = rowSpan.getStyle();
        if (ssa != null && !ssa.isEmpty()) {
            this._sb.append(" ").append("class='").append('x').append(String.valueOf(ssa.getUID())).append('\'');
        }
        this._sb.append(" style='");
        double length = this._rowHeights.getLength(rowIdx);
        if (!ArrayUtil.isEqual((Double)length, (Double)0.0)) {
            this._sb.append(" height:").append(length).append("px");
        }
        this._sb.append("'>");
        this._sb.append("\r\n");
        this.buildCells(this._sheet.getRow(rowIdx, false));
        this._sb.append("</tr>\r\n");
    }

    private void buildCells(Row row) throws IOException {
        block5: {
            if (null == row || row.isEmptyContent()) break block5;
            if (row.getRow() == this._row1 && this._paging && this._borderMergeBlocks != null) {
                int maxIndex = row.getMaxIntMark();
                maxIndex = Math.max(maxIndex, this._borderMergeBlocks.getBlock(this._borderMergeBlocks.size() - 1).getCol2());
                for (int i = 0; i <= maxIndex; ++i) {
                    Cell cell;
                    if (this._mergeBlocksMarks.get(i)) {
                        CellBlock cb = this._borderMergeBlocks.searchBlock(this._row1, i);
                        cell = this._sheet.getCell(cb.getRow(), i, false);
                        this.buildCell(cell, cb);
                        i = cb.getCol2();
                        continue;
                    }
                    cell = row.getCell(i, true);
                    this.buildCell(cell);
                }
            } else {
                int maxIndex = row.getMaxIntMark();
                for (int i = 0; i <= maxIndex; ++i) {
                    Cell cell = row.getCell(i, true);
                    this.buildCell(cell);
                }
            }
        }
    }

    private void buildCell(Cell cell, CellBlock mb) throws IOException {
        Style ssa;
        this._sb.append("<td");
        int width = mb.getWidth();
        int height = mb.getHeight() - this._row1 + mb.getRow();
        if (width - 1 > 0) {
            this._sb.append(" ").append("colspan='").append(width).append('\'');
        }
        if (height - 1 > 0) {
            height = this._row1 + height > this._row2 ? this._row2 - this._row1 + 1 : height;
            this._sb.append(" ").append("rowspan='").append(height).append('\'');
        }
        if ((ssa = cell.getStyle()) != null && !ssa.isEmpty()) {
            this._sb.append(" class=\"").append('x').append(String.valueOf(ssa.getUID()));
            if (this._header != null) {
                this._sb.append("").append(' ');
                this._sb.append(this._header.getLockCssClass(cell.getRow(), cell.getCol())).append(' ');
                this._sb.append(this._header.getVerticalBoundaryLine(cell.getCol())).append(' ');
                this._sb.append(this._header.getHorizontalBoundaryLine(cell.getRow()));
            }
            this._sb.append("\"");
        } else if (this._header != null) {
            this._sb.append(" class=\"");
            this._sb.append(this._header.getLockCssClass(cell.getRow(), cell.getCol())).append(' ');
            this._sb.append(this._header.getVerticalBoundaryLine(cell.getCol())).append(' ');
            this._sb.append(this._header.getHorizontalBoundaryLine(cell.getRow()));
            this._sb.append("\"");
        }
        this._sb.append(" r='").append(this._row1).append("' c='").append(cell.getCol()).append("' ");
        this.buildCellData(cell, true);
        this._sb.append("</td>\r\n");
    }

    private boolean buildCell(Cell cell) throws IOException {
        Style ssa;
        boolean bInnerMerger;
        int r = cell.getRow();
        int c2 = cell.getCol();
        CellBlock mb = cell.getSheet().getMergeBlock(cell);
        boolean bl = bInnerMerger = mb != null && (mb.getRow() != r || mb.getCol() != c2);
        if (bInnerMerger) {
            return false;
        }
        boolean isFirstMergedCell = cell.isFirstMergedCell();
        this._sb.append("<td");
        DiagonalHeader dh = cell.getDiagonalHeader();
        boolean shouldHideData = false;
        if (dh != null) {
            shouldHideData = true;
        }
        String formula = cell.getFormula();
        if (isFirstMergedCell) {
            if (mb.getWidth() - 1 > 0) {
                this._sb.append(" ").append("colspan='").append(mb.getWidth()).append('\'');
            }
            if (mb.getHeight() - 1 > 0) {
                int height = mb.getHeight();
                height = this._paging ? (this._row1 + height > this._row2 ? this._row2 - this._row1 + 1 : height) : height;
                this._sb.append(" ").append("rowspan='").append(height).append('\'');
            }
        }
        if ((ssa = cell.getStyle()) != null) {
            if (cell.getValue() == Variant.nullVariant) {
                this._2Css.addStyle(ssa);
            }
            this._sb.append(" class=\"").append('x').append(String.valueOf(ssa.getUID()));
            if (this._header != null) {
                this._sb.append("").append(' ');
                this._sb.append(this._header.getLockCssClass(cell.getRow(), cell.getCol())).append(' ');
                this._sb.append(this._header.getVerticalBoundaryLine(cell.getCol())).append(' ');
                this._sb.append(this._header.getHorizontalBoundaryLine(cell.getRow()));
            }
            this._sb.append("\"");
        } else if (this._header != null) {
            this._sb.append(" class=\"");
            this._sb.append(this._header.getLockCssClass(cell.getRow(), cell.getCol())).append(' ');
            this._sb.append(this._header.getVerticalBoundaryLine(cell.getCol())).append(' ');
            this._sb.append(this._header.getHorizontalBoundaryLine(cell.getRow()));
            this._sb.append("\"");
        }
        this._sb.append(" r='").append(r).append("' c='").append(c2).append("' ");
        if (!shouldHideData) {
            this.buildCellData(cell, StringUtil.isEmptyString((String)formula) ? false : formula.startsWith("'"));
        } else {
            this._sb.append(">");
        }
        if (dh != null) {
            this._sb.append(this.getDiagonalHeaderText(dh));
            String url = (String)this._imagePathCache.get(cell.getStyle().getUID());
            Color color = cell.getStyle().getBackground();
            Color transparent = new Color(255, 255, 255, 0);
            int height = 0;
            int row2 = dh.getRow2();
            for (int i = dh.getRow(); i <= row2; ++i) {
                int rowHeight = this._rowHeights.getLength(i);
                if (rowHeight < 0) {
                    rowHeight = this.getDefaultRowHeightOrColWidth(i, false);
                }
                height += rowHeight;
            }
            if (color.equals(transparent)) {
                this._sb.append("<div style=\"top:0%;left:0%;width:100%;height:").append(height).append(";filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='").append(url).append("',sizingMethod='image');").append("\" >").append("</div>");
            } else {
                this._sb.append("<div style=\"top:0%;left:0%;width:100%;height:").append(height).append("px;background-image: url('").append(url).append("');").append("background-repeat:no-repeat;").append("\" >").append("</div>");
            }
        }
        this._sb.append("</td>\r\n");
        return true;
    }

    String getDiagonalHeaderText(DiagonalHeader dh) {
        int size = dh.size();
        StringBuilder buf = new StringBuilder(size * 5);
        buf.append("<span style=\"display:none;height:0\">");
        for (int i = size - 1; i >= 0; --i) {
            buf.append(dh.getTriangleInfo(i).getText()).append('&');
        }
        buf.deleteCharAt(buf.length() - 1);
        buf.append("</span>");
        return buf.toString();
    }

    static String toXmlString(String str) {
        if (str == null) {
            return null;
        }
        String ret = str.replaceAll("&", "&amp;");
        ret = ret.replaceAll("\"", "&quot;");
        ret = ret.replaceAll("<", "&lt;");
        ret = ret.replaceAll(">", "&gt;");
        return ret;
    }

    private void fixAlignment(Cell cell) {
        Style style = cell.getStyle();
        Styles.HorizontalAlignment alignment = (Styles.HorizontalAlignment)style.get(ShareStyleAttributes.HORIZONTAL_ALIGN);
        if (alignment != null && alignment.getValue() == 0) {
            Variant value = cell.getValue();
            if (value.isNumber() || value.isDate()) {
                this._sb.append("style=\"text-align:right\" ");
            } else if (value.getVt() == 8) {
                this._sb.append("style=\"text-align:center\" ");
            } else {
                this._sb.append("style=\"text-align:left\" ");
            }
        }
    }

    private void buildCellData(Cell cell, boolean ticked) throws IOException {
        if (!cell.isEmptyContent()) {
            if (!StringUtil.isEmptyString((String)cell.getText())) {
                Object obj;
                boolean hyperLinkCell;
                this._sb.append(" ");
                this.fixAlignment(cell);
                this._sb.append(">");
                boolean bl = hyperLinkCell = this._hyperLinksProps != null && this._hyperLinksProps.getHyperLinkCells().contains(cell);
                if (hyperLinkCell) {
                    this._sb.append("<a href=\"JavaScript:void(0);\" onclick=\"openHyperLink(this)\" style=\"cursor:pointer\" ");
                    List idxLst = (List)this._hyperLinksProps.getCell2TargetIdx().get(cell);
                    if (idxLst != null) {
                        Map paramsMap = this._hyperLinksProps.getIdx2TargetParams();
                        StringBuilder paramsBuf = new StringBuilder(100);
                        paramsBuf.append(" params = '[");
                        this._sb.append(" reports = '[");
                        List pJsonLst = (List)paramsMap.get(cell);
                        int size = idxLst.size();
                        for (int i = 0; i < size; ++i) {
                            Object integerKey = idxLst.get(i);
                            this._sb.append(integerKey.toString());
                            paramsBuf.append(pJsonLst.get(i));
                            if (i == size - 1) continue;
                            this._sb.append(",");
                            paramsBuf.append(',');
                        }
                        this._sb.append("]' ");
                        paramsBuf.append("]' ");
                        this._sb.append(paramsBuf.toString()).append(" >");
                    }
                }
                Style ssa = cell.getStyle();
                int index = ShareStyleAttributes.WRAP_TEXT;
                boolean wrapText = false;
                if (ssa.hasAttributes(index) && Boolean.TRUE.equals(obj = ssa.get(index))) {
                    wrapText = true;
                }
                if (wrapText) {
                    this._sb.append(cell.getText().replaceAll(" ", BLANK).replaceAll("\n", "<br>"));
                } else {
                    this._sb.append(cell.getText().replaceAll(" ", BLANK));
                }
                if (hyperLinkCell) {
                    this._sb.append("</a>");
                }
            } else {
                this._sb.append(">").append(BLANK);
            }
        } else {
            this._sb.append(">");
        }
    }

    private String generateJavaScriptFile() throws IOException {
        URL url = KdsToHtmlExporter.class.getResource("divdrag");
        File baseJs = new File(url.toString().substring(6));
        try (FileInputStream in = new FileInputStream(baseJs);){
            File js = File.createTempFile("reportjs", ".js", new File(FilenameUtils.normalize((String)this._fileSavePath)));
            try (FileOutputStream out = new FileOutputStream(js);){
                int len;
                String newJsBlock = this.buildJavaScript();
                byte[] buf = new byte[1024];
                while ((len = ((InputStream)in).read(buf)) != -1) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                ((OutputStream)out).write(newJsBlock.getBytes(StandardCharsets.UTF_8));
            }
            String string = js.getName();
            return string;
        }
    }

    private void buildJavaScriptBlock() {
        this._sb.append("<script type=\"text/javascript\" charset=\"utf-8\" src=\"");
        try {
            this._sb.append(this._filePrefixPath).append(this.generateJavaScriptFile());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._sb.append("\">").append("</script>");
    }

    private String buildJavaScript() {
        StringBuilder tempBuf = new StringBuilder();
        tempBuf.append("new divDrag(");
        Iterator iterator = this.divNameMap.values().iterator();
        while (iterator.hasNext()) {
            String value = (String)iterator.next();
            if (value == null) continue;
            tempBuf.append("$('").append(value).append("')");
            if (!iterator.hasNext()) continue;
            tempBuf.append(',');
        }
        tempBuf.append(");");
        return tempBuf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildEmbedObject(String name, EmbedObject eo) {
        if (name == null || name.trim().equals("") || eo == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            SecureRandom random = new SecureRandom();
            int counter = random.nextInt() & 0xFFFF;
            String divId = "graph_report" + String.valueOf(counter);
            this.divNameMap.put(eo.getName(), divId);
        }
        String eoStyle = "position:absolute;border:0px solid silver;background:white;z-index:9999;";
        Rectangle rect = eo.getBounds();
        String height = String.valueOf(rect.getHeight() + 1.0);
        String width = String.valueOf(rect.getWidth() + 1.0);
        String x = String.valueOf(rect.getX());
        String y = String.valueOf(rect.getY());
        if (eo instanceof FlashChart) {
            FlashChart chart = (FlashChart)eo;
            FlashChartModel model = chart.getModel();
            String xml = model.getXml();
            FlashHelper.unpackSWF_SERVER(null, model.getChartType());
            String falshName = model.getBean().getChartType().getSWFFileName();
            String chartName = model.getBean().getChartType().getName();
            this._sb.append("\r\n <div id=\"");
            this._sb.append((String)this.divNameMap.get(eo.getName()));
            this._sb.append("\"");
            this._sb.append(" style=\"");
            this._sb.append("position:absolute;border:0px solid silver;background:white;z-index:0;");
            this._sb.append("left:").append(x).append("px;");
            this._sb.append("top:").append(y).append("px;");
            this._sb.append("width:").append(width).append("px;");
            this._sb.append("height:").append(height).append("px;");
            this._sb.append("\">");
            this._sb.append("\r\n <Object style=\"width:100%;height:100%;\" events=\"true\"");
            this._sb.append("codebase=\"http://fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0\"");
            this._sb.append("id=\"myEmbeddedObject\"");
            this._sb.append("classid=\"clsid:d27cdb6e-ae6d-11cf-96b8-444553540000\">");
            this._sb.append("<param value=\"").append(this._filePrefixPath).append(falshName).append("\" name=\"movie\"/>");
            this._sb.append("<param value=\"false\" name=\"menu\"/> ");
            this._sb.append("<param name=\"quality\" value=\"high\" />");
            this._sb.append("<param name=\"bgcolor\" value=\"#ffffff\" />");
            this._sb.append("<param name=\"wmode\" value=\"Opaque\" />");
            this._sb.append("<param name=\"wmode\" value=\"transparent\" />");
            this._sb.append("<PARAM value=\"debugMode=0&amp;allowFullScreen=true&amp;menu=false&amp;dataXML=");
            this._sb.append(Utils.encodeURL((String)xml));
            this._sb.append("\" name=\"flashVars\"/>");
            this._sb.append("<embed style=\"width:100%;height:100%;\" src=\"").append(this._filePrefixPath).append(falshName).append("\" quality=\"high\" bgcolor=\"#ffffff\" width=\"").append(width).append("\" height=\"").append(height).append("\" name=\"").append(chartName).append("\" align=\"middle\" allowScriptAccess=\"sameDomain\" type=\"application/x-shockwave-flash\" pluginspage=\"http://www.macromedia.com/go/getflashplayer\" />");
            this._sb.append("\r\n </Object>");
            this._sb.append("\r\n </div>");
        } else {
            if (eo instanceof EmbedImage) {
                Point2D.Double point = new Point2D.Double(rect.getX() + 2.0, rect.getY() + 2.0);
                int col = SheetBaseMath.colAtPoint(this._sheet, point);
                int row = SheetBaseMath.rowAtPoint(this._sheet, point);
                Point2D leftTop = this.calculateCellPoint(row, col);
                x = String.valueOf(leftTop.getX());
                y = String.valueOf(leftTop.getY());
            }
            this._sb.append("\r\n <div id=\"");
            this._sb.append((String)this.divNameMap.get(eo.getName()));
            this._sb.append("\"");
            this._sb.append(" style=\"");
            this._sb.append(eoStyle);
            this._sb.append("left:").append(x).append("px;");
            this._sb.append("top:").append(y).append("px;");
            this._sb.append("width:").append(width).append("px;");
            this._sb.append("height:").append(height).append("px;");
            this._sb.append("\">");
            this._sb.append("\r\n <img style=\"width:100%;height:100%;\" src=\"");
            this._sb.append(name);
            this._sb.append("\">");
            this._sb.append("\r\n </div>");
        }
    }

    private Point2D calculateCellPoint(int row, int col) {
        int x = 0;
        int startRow = 0;
        int startCol = 0;
        startRow = this._paging ? this._row1 : 0;
        for (int j = startCol = 0; j < col; ++j) {
            int index = this._colWidths.getLength(j);
            if (index < 0) {
                x = this.getDefaultRowHeightOrColWidth(j, true);
                continue;
            }
            x += index;
        }
        int y = 0;
        for (int i = startRow; i < row; ++i) {
            int index = this._rowHeights.getLength(i);
            if (index < 0) {
                y += this.getDefaultRowHeightOrColWidth(i, false);
                continue;
            }
            y += index;
        }
        return new Point2D.Double(x, y);
    }

    private void transformEmbedObject(Sheet sheet2) {
        EmbedhLayer layer = sheet2.getEmbedments(false);
        if (layer != null) {
            String name = "";
            for (int i = 0; i < layer.size(); ++i) {
                EmbedObject eo = layer.getEmbed(i);
                if (this._paging) {
                    int rowBeginY = SheetBaseMath.getRowY(this._sheet, this._row1);
                    int rowEndY = SheetBaseMath.getRowY(this._sheet, this._row2);
                    int eoBeginY = eo.getY();
                    if (eoBeginY < rowBeginY || rowEndY < eoBeginY && !this._enforceShowGraph) continue;
                }
                Rectangle rect = eo.getBounds();
                if (rect.width <= 0 || rect.height <= 0) continue;
                name = this.createAndPersistImage(sheet2, eo, null);
                this.buildEmbedObject(name, eo);
            }
            this._enforceShowGraph = false;
        }
    }

    private void transformTableTowsWhenPaging(Sheet sheet2) throws IOException {
        for (int i = this._row1; i <= this._row2; ++i) {
            this.buildRow(i);
        }
        this._sb.append("\r\n");
    }

    private void transformTableRows(Sheet sheet2) throws IOException {
        SortedAttributeSpanArray rowSpans = this._sheet.getRowSpans();
        int rowSpanN = rowSpans.size();
        int preEndIndex = -1;
        int begin = 0;
        if (this._paging) {
            begin = this._row1;
        }
        for (int i = 0; i < rowSpanN; ++i) {
            int j;
            SortedAttributeSpanArray.AttributeSpan rowSpan = rowSpans.getAttributeSpan(i);
            int index = rowSpan.getStart();
            int endIndex = rowSpan.getEnd();
            if (index > begin && preEndIndex == -1) {
                for (j = begin; j < index; ++j) {
                    this.buildRow(j);
                }
            }
            if (preEndIndex != -1 && index > preEndIndex + 1) {
                for (j = preEndIndex + 1; j < index; ++j) {
                    this.buildRow(j);
                }
            }
            if (endIndex - index >= 0) {
                for (j = index; j <= endIndex; ++j) {
                    this.buildRowSpan(rowSpan, j);
                }
            }
            preEndIndex = endIndex;
        }
        int colNum = this._sheet.getMaxRowIndex(false);
        if (preEndIndex < colNum) {
            for (int j = preEndIndex + 1; j <= colNum; ++j) {
                this.buildRow(j);
            }
        }
        this._sb.append("\r\n");
    }

    private void buildRow(int rowIdx) throws IOException {
        boolean flag = false;
        if (this.heightAdaptive) {
            int maxIndex = this._sheet.getMaxColIndex(true);
            for (int i = 0; i <= maxIndex; ++i) {
                Style style;
                Object obvalue;
                Cell cell = this._sheet.getCell(rowIdx, i, false);
                if (cell == null || (obvalue = (style = cell.getStyle()).get(ShareStyleAttributes.WRAP_TEXT)) == null || !((Boolean)obvalue).booleanValue()) continue;
                flag = true;
                break;
            }
        }
        if (!this.heightAdaptive || !flag) {
            this._sb.append("<tr style='height:");
            int height = this._rowHeights.getLength(rowIdx);
            if (height < 0) {
                height = this.getDefaultRowHeightOrColWidth(rowIdx, false);
            }
            this._sb.append(String.valueOf(height));
            this._sb.append("px'>\r\n");
        } else {
            this._sb.append("<tr>\r\n");
        }
        Row row = this._sheet.getRow(rowIdx, false);
        this.buildCells(row);
        this._sb.append("</tr>\r\n");
    }

    private void transformTableColumn(Sheet sheet) {
        SortedAttributeSpanArray colSpans = sheet.getColSpans();
        int colspanN = colSpans.size();
        int preEndIndex = -1;
        int width = -1;
        for (int i = 0; i < colspanN; ++i) {
            int j;
            SortedAttributeSpanArray.AttributeSpan colSpan = colSpans.getAttributeSpan(i);
            int index = colSpan.getStart();
            int endIndex = colSpan.getEnd();
            if (index > 0 && preEndIndex == -1) {
                for (j = 0; j < index; ++j) {
                    this._sb.append("<col ");
                    this._sb.append("style='width:");
                    width = this._colWidths.getLength(j);
                    if (width < 0) {
                        width = this.getDefaultRowHeightOrColWidth(j, true);
                    }
                    this._sb.append(String.valueOf(width)).append("px'>\r\n");
                }
            }
            if (preEndIndex != -1 && index > preEndIndex + 1) {
                for (j = preEndIndex + 1; j < index; ++j) {
                    this._sb.append("<col ");
                    this._sb.append("style='width:");
                    width = this._colWidths.getLength(j);
                    if (width < 0) {
                        width = this.getDefaultRowHeightOrColWidth(j, true);
                    }
                    this._sb.append(String.valueOf(width)).append("px'>\r\n");
                }
            }
            if (endIndex - index >= 0) {
                for (j = index; j <= endIndex; ++j) {
                    this._sb.append("<col ");
                    this._sb.append("style='width:");
                    width = this._colWidths.getLength(j);
                    if (width < 0) {
                        width = this.getDefaultRowHeightOrColWidth(j, true);
                    }
                    this._sb.append(String.valueOf(width)).append("px'>\r\n");
                }
            }
            preEndIndex = endIndex;
        }
        int colNum = sheet.getMaxColIndex(false);
        if (preEndIndex < colNum) {
            for (int j = preEndIndex + 1; j <= colNum; ++j) {
                this._sb.append("<col ");
                this._sb.append("style='width:");
                width = this._colWidths.getLength(j);
                if (width < 0) {
                    width = this.getDefaultRowHeightOrColWidth(j, true);
                }
                this._sb.append(String.valueOf(width)).append("px'>\r\n");
            }
        }
        this._sb.append("\r\n");
    }

    public Sheet getSheet() {
        return this._sheet;
    }

    public Style2Css getStyle2Css() {
        return this._2Css;
    }

    public void setSheet(Sheet sheet) {
        this._sheet = sheet;
        this.isResizedInRuntime();
    }

    public DivDim getDivDim() {
        return this._divDim;
    }

    public void setHyperLinksProps(SheetHyperLinksProps hyperLinksProps) {
        this._hyperLinksProps = hyperLinksProps;
    }

    static class HtmlBuffer {
        private StringBuffer buffer = new StringBuffer(4096);
        private OutputStream writer = null;

        HtmlBuffer() {
        }

        public OutputStream getWriter() {
            return this.writer;
        }

        public void setWriter(OutputStream writer) {
            this.writer = writer;
        }

        public StringBuffer append(String s) {
            this.buffer.append(s);
            if (this.writer != null) {
                try {
                    String str = this.buffer.toString();
                    byte[] tempBytes = str.getBytes("utf-8");
                    if (tempBytes.length >= 524288) {
                        this.writer.write(tempBytes);
                        this.writer.flush();
                        this.buffer.delete(0, this.buffer.length());
                    }
                    tempBytes = null;
                    Object var2_2 = null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return this.buffer;
        }

        public String toString() {
            return this.buffer.toString();
        }
    }
}

