/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.io.htm.extweb;

import com.kingdee.cosmic.ctrl.kds.io.htm.extweb.DivDim;
import com.kingdee.cosmic.ctrl.kds.io.htm.extweb.IDivDimStrategy;
import com.kingdee.cosmic.ctrl.kds.io.htm.extweb.MeasureCalculator;
import com.kingdee.cosmic.ctrl.kds.io.htm.extweb.SortedLengthArray;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedObject;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedhLayer;

public class DefaultDivDimStrategy
implements IDivDimStrategy {
    private Sheet _sheet;
    private int _row1;
    private int _row2;
    private boolean _paging;
    private boolean _enforceShowGraph;
    private boolean _countImage;
    private SortedLengthArray _colWidths;
    private SortedLengthArray _rowHeights;
    private MeasureCalculator _calc;

    public DefaultDivDimStrategy(Sheet sheet, int row1, int row2, boolean paging, SortedLengthArray colWidths, SortedLengthArray rowHeights, boolean enforceShowGraph, MeasureCalculator calc, boolean countImage) {
        this._sheet = sheet;
        this._row1 = row1;
        this._row2 = row2;
        this._paging = paging;
        this._colWidths = colWidths;
        this._rowHeights = rowHeights;
        this._enforceShowGraph = enforceShowGraph;
        this._calc = calc;
        this._countImage = countImage;
    }

    @Override
    public DivDim calc() {
        EmbedhLayer layer;
        int width = 0;
        int index = -1;
        int start = 0;
        int end = 0;
        int startCol = 0;
        int endCol = 0;
        if (this._paging) {
            start = this._row1;
            end = this._row2;
        } else {
            start = 0;
            end = this._sheet.getMaxRowIndex(true);
        }
        startCol = 0;
        endCol = this._sheet.getMaxColIndex(true);
        for (int j = startCol; j < endCol; ++j) {
            index = this._colWidths.getLength(j);
            if (index < 0) {
                width += this._calc.getDefaultRowHeightOrColWidth(index, true);
                continue;
            }
            width += index;
        }
        int height = 0;
        for (int i = start; i <= end; ++i) {
            index = this._rowHeights.getLength(i);
            if (index < 0) {
                height += this._calc.getDefaultRowHeightOrColWidth(i, false);
                continue;
            }
            height += index;
        }
        if (this._countImage && (layer = this._sheet.getEmbedments(false)) != null) {
            for (int i = 0; i < layer.size(); ++i) {
                EmbedObject eo = layer.getEmbed(i);
                if (this._paging) {
                    int rowBeginY = SheetBaseMath.getRowY(this._sheet, this._row1);
                    int rowEndY = SheetBaseMath.getRowY(this._sheet, this._row2);
                    int eoBeginY = eo.getY();
                    if ((eoBeginY < rowBeginY || rowEndY < eoBeginY) && !this._enforceShowGraph) continue;
                    int eoY = eo.getY() + eo.getHeight() - rowBeginY;
                    height = Math.max(height, eoY);
                } else {
                    int eoY = eo.getY() + eo.getHeight();
                    height = Math.max(height, eoY);
                }
                int eoX = eo.getX() + eo.getWidth();
                width = Math.max(width, eoX);
            }
        }
        DivDim div = new DivDim(width, height);
        return div;
    }
}

