/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.io.kds;

import com.kingdee.cosmic.ctrl.common.hyperlink.HyperLink;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.common.util.UnitConverter;
import com.kingdee.cosmic.ctrl.ext.util.MiscUtil;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kdf.export.EmbedObjectRectangle;
import com.kingdee.cosmic.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSAttributeSpan;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSBook;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSSheet;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSSheetPrintSetup;
import com.kingdee.cosmic.ctrl.kdf.util.render.splitrectangle.ISplitRectInfo;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import com.kingdee.cosmic.ctrl.kds.expans.model.ExtConst;
import com.kingdee.cosmic.ctrl.kds.expans.model.ExtProps;
import com.kingdee.cosmic.ctrl.kds.expans.model.collection.SortedExtPropFormulasArray;
import com.kingdee.cosmic.ctrl.kds.io.util.DiagonalHeaderImageUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.CellBlock;
import com.kingdee.cosmic.ctrl.kds.model.struct.DiagonalHeader;
import com.kingdee.cosmic.ctrl.kds.model.struct.MergeBlocks;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.cosmic.ctrl.kds.model.struct.SortedAttributeSpanArray;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.ChartRectEmbedment;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedObject;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.EChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.node.CellBlockNode;
import com.kingdee.cosmic.ctrl.kds.print.MultiPrintJobProvider;
import com.kingdee.cosmic.ctrl.kds.print.PrintBookTrans;
import com.kingdee.cosmic.ctrl.kds.util.CloseUtil;
import com.kingdee.cosmic.ctrl.print.config.IConfigModel;
import com.kingdee.cosmic.ctrl.print.config.PrintJobConfig;
import com.kingdee.cosmic.ctrl.print.config.attribute.HeadFootIntervalInfo;
import com.kingdee.cosmic.ctrl.print.config.attribute.PageIntervalInfo;
import com.kingdee.cosmic.ctrl.print.config.attribute.ZoomScaleInfo;
import com.kingdee.cosmic.ctrl.print.config.extendui.TablePageSetupModel;
import com.kingdee.cosmic.ctrl.print.config.ui.HeaderFooterModel;
import com.kingdee.cosmic.ctrl.print.config.ui.PageSetupModel;
import com.kingdee.cosmic.ctrl.print.extend.IMultiPrintJobProvider;
import com.kingdee.cosmic.ctrl.print.extend.MultiPrintJobManager;
import com.kingdee.cosmic.ctrl.print.printjob.table.PlugablePaginationAdvice;
import com.kingdee.cosmic.ctrl.print.printjob.table.SheetPrintJob;
import com.kingdee.cosmic.ctrl.print.resource.Resources;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.OrientationRequested;
import org.apache.log4j.Logger;

public class BookToKDSBook {
    private static final Logger logger = LogUtil.getPackageLogger(BookToKDSBook.class);
    private static final Class[] staticCheckCategorys = new Class[]{Media.class, OrientationRequested.class, ZoomScaleInfo.class, PageIntervalInfo.class, HeadFootIntervalInfo.class};

    public static KDSBook traslate(Book book) {
        return BookToKDSBook.traslate(book, null);
    }

    public static KDSBook traslate(Book book, String[] sheetNames) {
        KDSBook kdsbook = new KDSBook(book.getName());
        BookToKDSBook.traslate(book, kdsbook, sheetNames);
        return kdsbook;
    }

    public static void traslate(Book book, KDSBook kdsbook, String[] sheetNames) {
        if (sheetNames == null || sheetNames.length == 0) {
            int count = book.getSheetCount();
            for (int i = 0; i < count; ++i) {
                Sheet sheet = book.getSheet(i);
                if (sheet == null) continue;
                KDSSheet kdssheet = new KDSSheet(kdsbook, sheet.getSheetName(), (ShareStyleAttributes)sheet.getStyle());
                BookToKDSBook.traslateSheet(sheet, kdssheet, kdsbook);
                try {
                    kdsbook.addSheet(null, kdssheet);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        } else {
            int count = sheetNames.length;
            for (int i = 0; i < count; ++i) {
                Sheet sheet = book.getSheet(sheetNames[i]);
                if (sheet == null) continue;
                KDSSheet kdssheet = new KDSSheet(kdsbook, sheet.getSheetName(), (ShareStyleAttributes)sheet.getStyle());
                BookToKDSBook.traslateSheet(sheet, kdssheet, kdsbook);
                try {
                    kdsbook.addSheet(null, kdssheet);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        BookToKDSBook.translatePrintSetup(book, kdsbook);
    }

    private static void traslateSheet(Sheet sheet, KDSSheet kdssheet, KDSBook kdsbook) {
        kdssheet.setLeftToOutlineGroup(sheet.isLeftToOutlineGroup());
        kdssheet.setAboveOfOutlineGroup(sheet.isAboveOfOutlineGroup());
        kdssheet.getSheetStyleAttributes().setHided(sheet.isHide());
        BookToKDSBook.translateColumns(sheet, kdssheet);
        BookToKDSBook.translateRows(sheet, kdssheet);
        BookToKDSBook.translateCells(sheet, kdssheet, kdsbook);
        BookToKDSBook.translateMerger(sheet, kdssheet);
        BookToKDSBook.translateCharts(sheet, kdssheet);
        EmbedhLayer el = sheet.getEmbedments(false);
        try {
            if (el != null) {
                for (int i = 0; i < el.size(); ++i) {
                    EmbedObject eo = el.getEmbed(i);
                    if (eo instanceof EChart) continue;
                    int width = eo.getWidth();
                    int height = eo.getHeight();
                    if (width <= 0 || height <= 0) continue;
                    BufferedImage buffer = new BufferedImage(width, height, 2);
                    Graphics2D g = buffer.createGraphics();
                    ((Graphics)g).translate(-eo.getX(), -eo.getY());
                    eo.paintData(g);
                    ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)buffer, "png", bytes);
                    KDSBook.KDSImage image = new KDSBook.KDSImage(bytes.toByteArray(), 6);
                    Point p = eo.getBounds().getLocation();
                    Point p2 = new Point(p.x + eo.getWidth(), p.y + eo.getHeight());
                    int left = SheetBaseMath.colAtPoint(sheet, p);
                    image.setLeft(left);
                    int right = SheetBaseMath.colAtPoint(sheet, p2);
                    image.setRight(right);
                    int top = SheetBaseMath.rowAtPoint(sheet, p);
                    image.setTop(top);
                    int bottom = SheetBaseMath.rowAtPoint(sheet, p2);
                    image.setBottom(bottom);
                    image.setWidth(width);
                    image.setHeight(height);
                    image.setSheetName(sheet.getSheetName());
                    kdsbook.addImage(image);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void translateCharts(Sheet sheet, KDSSheet kdssheet) {
        EmbedhLayer layer = sheet.getEmbedments(false);
        if (layer != null) {
            int size = layer.size();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            for (int i = 0; i < size; ++i) {
                out.reset();
                EmbedObject eo = layer.getEmbed(i);
                if (!(eo instanceof ChartRectEmbedment)) continue;
                try {
                    ImageIO.write((RenderedImage)((ChartRectEmbedment)eo).exportToBufferedImage(), "PNG", out);
                    EmbedObjectRectangle rect = new EmbedObjectRectangle();
                    Rectangle bounds = eo.getBounds();
                    Point p = bounds.getLocation();
                    rect.row1 = SheetBaseMath.rowAtPoint(sheet, p);
                    rect.col1 = SheetBaseMath.colAtPoint(sheet, p);
                    int rowPostion = SheetBaseMath.getRowY(sheet, rect.row1);
                    int colPosition = SheetBaseMath.getColX(sheet, rect.col1);
                    rect.dy1 = (int)(254.0 * ((double)(p.y > rowPostion ? p.y - rowPostion : rowPostion - p.y) / (double)SheetBaseMath.getRowHeight(sheet, rect.row1)));
                    rect.dx1 = (int)(1023.0 * ((double)(p.x > colPosition ? p.x - colPosition : colPosition - p.x) / (double)SheetBaseMath.getColWidth(sheet, rect.col1)));
                    p.x += bounds.width;
                    p.y += bounds.height;
                    rect.row2 = SheetBaseMath.rowAtPoint(sheet, p);
                    rect.col2 = SheetBaseMath.colAtPoint(sheet, p);
                    int rowPostion2 = SheetBaseMath.getRowY(sheet, rect.row2);
                    int colPosition2 = SheetBaseMath.getColX(sheet, rect.col2);
                    rect.dy2 = (int)(254.0 * ((double)(p.y > rowPostion2 ? p.y - rowPostion2 : rowPostion2 - p.y) / (double)SheetBaseMath.getRowHeight(sheet, rect.row2)));
                    rect.dx2 = (int)(1023.0 * ((double)(p.x > colPosition2 ? p.x - colPosition2 : colPosition2 - p.x) / (double)SheetBaseMath.getColWidth(sheet, rect.col2)));
                    kdssheet.setEmbedhLayer(out.toByteArray(), rect);
                    continue;
                }
                catch (Exception ex) {
                    logger.error((Object)"err", (Throwable)ex);
                    System.out.println("-----------------------\u56fe\u8868\u5bfc\u51fa\u5931\u8d25!-------------------------");
                }
            }
        }
    }

    private static void translateColumns(Sheet sheet, KDSSheet kdssheet) {
        SortedAttributeSpanArray colSpans = sheet.getColSpans();
        int maxColIndex = sheet.getMaxColIndex();
        int oldIndex = -1;
        ArrayList<KDSAttributeSpan> kdsSpan = new ArrayList<KDSAttributeSpan>();
        for (int i = 0; i <= maxColIndex; ++i) {
            int index = colSpans.searchSpan(i);
            if (index < 0) {
                kdssheet.setColumnWidth(i, (float)UnitConverter.px2mm((int)sheet.getOriginalDefColWidth()));
                continue;
            }
            SortedAttributeSpanArray.AttributeSpan span = colSpans.getAttributeSpan(index);
            if (span.isVisible()) {
                kdssheet.setColumnWidth(i, (float)UnitConverter.px2mm((int)span.getOriginalLength()));
            } else {
                kdssheet.setColumnWidth(i, 0.0f);
            }
            if (oldIndex == index) continue;
            kdsSpan.add(new KDSAttributeSpan(span.getStart(), span.getEnd(), span.getSSA(), span.getLength(), span.isVisible(), span.getOutlineGroupLevel(), span.isCollapse()));
            oldIndex = index;
        }
        kdssheet.setColSpans(kdsSpan);
    }

    private static void translateRows(Sheet sheet, KDSSheet kdssheet) {
        SortedAttributeSpanArray rowSpans = sheet.getRowSpans();
        int maxRowIndex = sheet.getMaxRowIndex();
        int oldIndex = -1;
        ArrayList<KDSAttributeSpan> kdsSpan = new ArrayList<KDSAttributeSpan>();
        for (int i = 0; i <= maxRowIndex; ++i) {
            int index = rowSpans.searchSpan(i);
            if (index < 0) {
                kdssheet.setRowHeight(i, (float)UnitConverter.px2mm((int)sheet.getOriginalDefRowHeight()));
                continue;
            }
            SortedAttributeSpanArray.AttributeSpan span = rowSpans.getAttributeSpan(index);
            if (span.isVisible()) {
                kdssheet.setRowHeight(i, (float)UnitConverter.px2mm((int)span.getOriginalLength()));
            } else {
                kdssheet.setRowHeight(i, 0.0f);
            }
            if (oldIndex == index) continue;
            kdsSpan.add(new KDSAttributeSpan(span.getStart(), span.getEnd(), span.getSSA(), span.getLength(), span.isVisible(), span.getOutlineGroupLevel(), span.isCollapse()));
            oldIndex = index;
        }
        kdssheet.setRowSpans(kdsSpan);
    }

    private static void translateCells(Sheet sheet, KDSSheet kdssheet, KDSBook kdsBook) {
        Sheet.ICellsIterator iter = sheet.getCellsIterator(0, 0, sheet.getMaxRowIndex(), sheet.getMaxColIndex(), false, false);
        while (iter.hasNext()) {
            Cell cell = iter.next();
            BookToKDSBook.translateOneCell(cell, kdssheet, kdsBook);
        }
    }

    private static void translateOneCell(Cell cell, KDSSheet kdssheet, KDSBook kdsbook) {
        SortedExtPropFormulasArray formulas;
        boolean b2;
        DiagonalHeader header = cell.getDiagonalHeader();
        if (header != null && DiagonalHeaderImageUtil.isValidSplitRectInfo((ISplitRectInfo)header, cell)) {
            kdsbook.addImage(DiagonalHeaderImageUtil.translate(cell));
            return;
        }
        int rowIndex = cell.getRow();
        int colIndex = cell.getCol();
        Object value = cell.getValue().getValue();
        if (value == Variant.calcLast.getValue()) {
            value = null;
        }
        String formula = cell.getFormula();
        Style ssa = cell.getDisplayStyle();
        String text = cell.getText();
        String linkTo = "";
        if (null != cell.getHyperLink()) {
            linkTo = cell.getHyperLink().getLinkTo();
        }
        boolean bl = b2 = formula != null && formula.length() > 0 && formula.charAt(0) == '=';
        if (b2) {
            formula = formula.substring(1);
        }
        if (value instanceof Date || value instanceof Calendar) {
            value = cell.getText();
        } else if (value instanceof String && StringUtil.isEmptyString((String)((String)value))) {
            value = null;
        } else if (value instanceof CellBlockNode) {
            value = text;
        }
        ExtProps props = cell.getExtProps(false);
        if (props != null && (formulas = props.getFormulas(false)) != null && formulas.get(ExtConst.FORMULA_DISP_VALUE) != null) {
            value = text;
        }
        kdssheet.setCell(rowIndex, colIndex, value, b2 ? formula : null, (ShareStyleAttributes)ssa, text, linkTo);
        CellBlock merge = cell.getMerge(false);
        if (merge != null) {
            int r2 = merge.getRow2();
            for (int r1 = merge.getRow(); r1 <= r2; ++r1) {
                int c2 = merge.getCol2();
                for (int c1 = merge.getCol(); c1 <= c2; ++c1) {
                    if (r1 == rowIndex && c1 == colIndex) continue;
                    kdssheet.setCell(r1, c1, (Object)"", null, (ShareStyleAttributes)ssa, text);
                }
            }
        }
    }

    private static void translateMerger(Sheet sheet, KDSSheet kdssheet) {
        MergeBlocks mergeBlocks = sheet.getSheetOption().getMerger(false);
        if (mergeBlocks == null) {
            return;
        }
        for (int i = mergeBlocks.size() - 1; i >= 0; --i) {
            CellBlock merge = mergeBlocks.getBlock(i);
            int row = merge.getRow();
            int col = merge.getCol();
            kdssheet.getMerges().addMerge(row, col, merge.getRow2(), merge.getCol2());
            Cell cell = sheet.getCell(merge.getRow(), merge.getCol(), false);
            if (null == cell.getHyperLink()) continue;
            HyperLink hyper = new HyperLink();
            hyper.setLinkTo(cell.getHyperLink().getLinkTo());
            kdssheet.getCell(row, col, false).setHyperLink(hyper);
        }
    }

    private static String getMsg(String key) {
        return Resources.getMsg((String)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void translatePrintSetup(Book book, KDSBook kdsbook) {
        block32: {
            try {
                Properties props = new Properties();
                InputStream inputStream = null;
                try {
                    inputStream = Resources.class.getResourceAsStream("Resources_Papersize.properties");
                    props.load(inputStream);
                }
                catch (Exception ex) {
                    try {
                        MiscUtil.handleFileCheckingException(ex, null);
                        if (MiscUtil.shouldLog()) {
                            MiscUtil.log(ex);
                        }
                        props.setProperty("custom", "1");
                        props.setProperty("na-legal", "5");
                        props.setProperty("executive", "7");
                        props.setProperty("iso-a4", "9");
                        props.setProperty("na-number-10-envelope", "20");
                        props.setProperty("na-6x9-envelope", "27");
                        props.setProperty("na-7x9-envelope", "28");
                        props.setProperty("na-9x11-envelop", "11");
                        props.setProperty("monarch-envelope", "37");
                        props.setProperty("page", "\u9875\u7801");
                        props.setProperty("PageCount", "\u603b\u9875\u6570");
                        props.setProperty("Date", "\u65e5\u671f");
                        props.setProperty("Time", "\u65f6\u95f4");
                    }
                    catch (Throwable throwable) {
                        CloseUtil.close(inputStream);
                        throw throwable;
                    }
                    CloseUtil.close(inputStream);
                }
                CloseUtil.close(inputStream);
                MultiPrintJobProvider provider = new MultiPrintJobProvider(book);
                MultiPrintJobManager pm = new MultiPrintJobManager((IMultiPrintJobProvider)provider);
                PrintBookTrans.loadFromBook(pm, book);
                for (int i = book.getSheetCount() - 1; i >= 0; --i) {
                    OrientationRequested requested;
                    Sheet sheet = book.getSheet(i);
                    PlugablePaginationAdvice advice = sheet.getPlugablePaginationAdvice(true);
                    SheetPrintJob job = (SheetPrintJob)pm.getPrintJob(sheet.getID());
                    sheet.setPlugablePaginationAdvice(advice);
                    job.preparePagination();
                    sheet.setColPaginationPointsSnapshot(job.getTablePrintPagination().getColPaginationPointsSnapshot());
                    sheet.setRowPaginationPointsSnapshot(job.getTablePrintPagination().getRowPaginationPointsSnapshot());
                    KDSSheet kdssheet = kdsbook.getSheet((Object)i);
                    PrintJobConfig pc = pm.getPrinter().getPrintConfig().getJobConfig(sheet.getID());
                    KDSSheetPrintSetup kdsSetup = kdssheet.getPrintSetup();
                    if (kdsSetup != null || pc == null) continue;
                    kdsSetup = new KDSSheetPrintSetup();
                    IConfigModel model = pc.getConfig(BookToKDSBook.getMsg("tree.page"));
                    Class[] checkCategory = staticCheckCategorys;
                    PageSetupModel psm = (PageSetupModel)model;
                    if (psm.getCenterAlign() == PageSetupModel.CENTERALIGN_HORIZONTAL) {
                        kdsSetup.setHorizontalAlign(true);
                    } else if (psm.getCenterAlign() == PageSetupModel.CENTERALIGN_VERTICAL) {
                        kdsSetup.setVerticalAlign(true);
                    } else if (psm.getCenterAlign() == PageSetupModel.CENTERALIGN_CENTER) {
                        kdsSetup.setHorizontalAlign(true);
                        kdsSetup.setVerticalAlign(true);
                    }
                    PrintRequestAttributeSet set = psm.getPrintRequestAttributeSet();
                    Media media = (Media)set.get(checkCategory[0]);
                    String paperSize = props.getProperty(media.getName());
                    if (paperSize != null) {
                        kdsSetup.setPageSize((short)Integer.parseInt(paperSize));
                    }
                    kdsSetup.setLandScape((requested = (OrientationRequested)set.get(checkCategory[1])).getValue() == OrientationRequested.LANDSCAPE.getValue());
                    ZoomScaleInfo scale = (ZoomScaleInfo)set.get(checkCategory[2]);
                    if (!scale.isAutoFit()) {
                        kdsSetup.setAutoFit(false);
                        kdsSetup.setScale((short)(scale.getScale() * 100.0));
                    } else {
                        kdsSetup.setAutoFit(true);
                        kdsSetup.setWidthFit((short)scale.getAutoFitWidth());
                        kdsSetup.setHeightFit((short)scale.getAutoFitHeight());
                    }
                    PageIntervalInfo interval = (PageIntervalInfo)set.get(checkCategory[3]);
                    kdsSetup.setBottom(interval.getBottom(25400));
                    kdsSetup.setTop(interval.getTop(25400));
                    kdsSetup.setLeft(interval.getLeft(25400));
                    kdsSetup.setRight(interval.getRight(25400));
                    HeadFootIntervalInfo head = (HeadFootIntervalInfo)set.get(checkCategory[4]);
                    kdsSetup.setHeadDis(head.getHeadTop(25400));
                    kdsSetup.setFootDis(head.getFootBottom(25400));
                    model = pc.getConfig(BookToKDSBook.getMsg("tree.headerfooter"));
                    HeaderFooterModel hfm = (HeaderFooterModel)model;
                    HeadFootModel hm = hfm.getHeaderModel();
                    List rowList = hm.getRowList();
                    String page = props.getProperty("page");
                    String pageCount = props.getProperty("PageCount");
                    String date = props.getProperty("Date");
                    String time = props.getProperty("Time");
                    for (Object next : rowList) {
                        String title = BookToKDSBook.replaceStringByExcel(next.toString(), page, pageCount, date, time);
                        String[] children = title.split("&&\\|");
                        int length = children.length;
                        String temp = kdsSetup.getHeaderLeft();
                        if (temp == null) {
                            kdsSetup.setHeaderLeft(children[0]);
                        } else {
                            kdsSetup.setHeaderLeft(temp + "\n" + children[0]);
                        }
                        if (length < 2) continue;
                        temp = kdsSetup.getHeaderCenter();
                        if (temp == null) {
                            kdsSetup.setHeaderCenter(children[1]);
                        } else {
                            kdsSetup.setHeaderCenter(temp + "\n" + children[1]);
                        }
                        if (length < 3) continue;
                        temp = kdsSetup.getHeaderRight();
                        if (temp == null) {
                            kdsSetup.setHeaderRight(children[2]);
                            continue;
                        }
                        kdsSetup.setHeaderRight(temp + "\n" + children[2]);
                    }
                    HeadFootModel fm = hfm.getFooterModel();
                    rowList = fm.getRowList();
                    for (Object next : rowList) {
                        String title = BookToKDSBook.replaceStringByExcel(next.toString(), page, pageCount, date, time);
                        String[] children = title.split("&&\\|");
                        int length = children.length;
                        String temp = kdsSetup.getFooterLeft();
                        if (temp == null) {
                            kdsSetup.setFooterLeft(children[0]);
                        } else {
                            kdsSetup.setFooterLeft(temp + "\n" + children[0]);
                        }
                        if (length < 2) continue;
                        temp = kdsSetup.getFooterCenter();
                        if (temp == null) {
                            kdsSetup.setFooterCenter(children[1]);
                        } else {
                            kdsSetup.setFooterCenter(temp + "\n" + children[1]);
                        }
                        if (length < 3) continue;
                        temp = kdsSetup.getFooterRight();
                        if (temp == null) {
                            kdsSetup.setFooterRight(children[2]);
                            continue;
                        }
                        kdsSetup.setFooterRight(temp + "\n" + children[2]);
                    }
                    model = pc.getConfig(BookToKDSBook.getMsg("tree.stylusPrinterAdujust"));
                    model = pc.getConfig(BookToKDSBook.getMsg("tree.name"));
                    TablePageSetupModel tpsm = (TablePageSetupModel)model;
                    kdsSetup.setRowToCol(!tpsm.getOrder());
                    kdsSetup.setPrintColNum(tpsm.isColumnIndex());
                    kdsSetup.setPrintRowNum(tpsm.isRowIndex());
                    kdsSetup.setPrintGridLine(tpsm.isGrid());
                    kdsSetup.setNoColor(tpsm.isSingleColor());
                    kdsSetup.setPrintArea(tpsm.printAreasToList());
                    kdsSetup.setPrintTopTitleArea(tpsm.getTopTileRowList());
                    kdsSetup.setPrintLeftTitleArea(tpsm.getLeftTitleColumnList());
                    int[] extendedBreaks = sheet.getColPaginationPointsSnapshot();
                    short[] result = new short[extendedBreaks == null ? 0 : extendedBreaks.length - 1];
                    if (extendedBreaks != null) {
                        int length = extendedBreaks.length;
                        for (int j = 1; j < length; ++j) {
                            result[j - 1] = (short)extendedBreaks[j];
                        }
                        kdsSetup.setColBreaks(result);
                    }
                    result = new short[(extendedBreaks = sheet.getRowPaginationPointsSnapshot()) == null ? 0 : extendedBreaks.length - 1];
                    if (extendedBreaks != null) {
                        int length = extendedBreaks.length;
                        for (int j = 1; j < length; ++j) {
                            result[j - 1] = (short)extendedBreaks[j];
                        }
                        kdsSetup.setRowBreaks(result);
                    }
                    kdssheet.setPrintSetup(kdsSetup);
                }
            }
            catch (Exception ex) {
                MiscUtil.handleFileCheckingException(ex, null);
                if (!MiscUtil.shouldLog()) break block32;
                MiscUtil.log(ex);
            }
        }
    }

    private static String replaceStringByExcel(String str, String page, String pageCount, String date, String time) {
        str = str.replaceAll("&", "&&");
        str = str.replaceAll("PageCount", pageCount);
        str = str.replaceAll("Page", page);
        str = str.replaceAll("Date", date);
        str = str.replaceAll("Time", time);
        return str;
    }
}

