/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.io.kds.archives.kds540;

import com.kingdee.cosmic.ctrl.common.hyperlink.HyperLink;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kdf.util.style.LineStyle;
import com.kingdee.cosmic.ctrl.kdf.util.style.Pattern;
import com.kingdee.cosmic.ctrl.kdf.util.style.PenStyle;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import com.kingdee.cosmic.ctrl.kds.io.BookIOController;
import com.kingdee.cosmic.ctrl.kds.io.IBookFieldFlags;
import com.kingdee.cosmic.ctrl.kds.io.PrintHelper;
import com.kingdee.cosmic.ctrl.kds.io.kds.SectionJarInputStream;
import com.kingdee.cosmic.ctrl.kds.io.kds.SectionJarUtil;
import com.kingdee.cosmic.ctrl.kds.io.kds.archives.kds540.KDSConstants540;
import com.kingdee.cosmic.ctrl.kds.model.expr.Expr;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.BookProtection;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.Column;
import com.kingdee.cosmic.ctrl.kds.model.struct.Comment;
import com.kingdee.cosmic.ctrl.kds.model.struct.DiagonalHeader;
import com.kingdee.cosmic.ctrl.kds.model.struct.IBookProvider;
import com.kingdee.cosmic.ctrl.kds.model.struct.PrintSetup;
import com.kingdee.cosmic.ctrl.kds.model.struct.Protection;
import com.kingdee.cosmic.ctrl.kds.model.struct.Row;
import com.kingdee.cosmic.ctrl.kds.model.struct.Selection;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetOption;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetProxy;
import com.kingdee.cosmic.ctrl.kds.model.struct.SortedRowArray;
import com.kingdee.cosmic.ctrl.kds.model.struct.Span;
import com.kingdee.cosmic.ctrl.kds.model.struct.ViewSplitInfo;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedObject;
import com.kingdee.cosmic.ctrl.kds.model.struct.node.ConstNamedObjectNode;
import com.kingdee.cosmic.ctrl.kds.model.struct.node.NamedObjectNode;
import com.kingdee.cosmic.ctrl.kds.model.struct.validate.Validation;
import com.kingdee.cosmic.ctrl.kds.model.struct.validate.util.MessagedValidate;
import com.kingdee.cosmic.ctrl.kds.model.util.SortedCellBlockArray;
import com.kingdee.cosmic.ctrl.kds.util.KDSDataInputStream;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public final class KDSBinaryBook540
extends KDSConstants540
implements IBookProvider {
    private static final Logger logger = LogUtil.getPackageLogger(KDSBinaryBook540.class);
    private BookIOController _ctrl;
    private String _bookName;
    private int _sheetCount;
    private int _activeSheetIndex;
    private ArrayList _sheetInfos;
    private KDSDataInputStream _bookInfos;
    private int fileVersion;

    public KDSBinaryBook540(SectionJarInputStream sis, BookIOController ctrl) throws IOException {
        this._ctrl = ctrl;
        int size = sis.size();
        if (size < 1) {
            throw new IllegalArgumentException("bytes is illegal");
        }
        this.fileVersion = sis.getFileVersion();
        if (this.isHigherVersion(this.fileVersion)) {
            throw new IllegalArgumentException("Attempt to read kds files with a higher version ID.");
        }
        this._bookInfos = new KDSDataInputStream(sis.getSection(0));
        this.initBookBase(this._bookInfos);
        for (int i = 1; i < size; ++i) {
            SheetProxy si = (SheetProxy)this._sheetInfos.get(i - 1);
            si.setZipBytes(sis.getByteSection(i));
        }
    }

    @Override
    public int getActiveSheetIndex() {
        return this._activeSheetIndex;
    }

    @Override
    public String getBookName() {
        return this._bookName;
    }

    @Override
    public int getSheetCount() {
        return this._sheetCount;
    }

    @Override
    public SheetProxy getSheetProxy(int index) {
        return (SheetProxy)this._sheetInfos.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initBookOptions(Book book) {
        block13: {
            book.setFileVersion(this.fileVersion);
            block6: while (true) {
                try {
                    while (true) {
                        byte id;
                        if ((id = this._bookInfos.readByte()) == ID_BK_Protection) {
                            BookProtection bp = book.getProtection();
                            bp.setOperations(this._bookInfos.readInt());
                            bp.startWithEncryptedPassword(this._bookInfos.readString());
                            continue;
                        }
                        if (id == ID_BK_UserObject) {
                            String key = this._bookInfos.readString();
                            String strVal = this._bookInfos.readString();
                            if (this._ctrl != null && !this._ctrl.touchModeFlag(IBookFieldFlags.FLAG_BOOK_USEROBJECT)) continue;
                            Object value = this.getUoTransObject(key, strVal);
                            book.setUserObject(key, value);
                            continue;
                        }
                        if (id == ID_BK_Comment) {
                            String author = this._bookInfos.readString();
                            String text = this._bookInfos.readString();
                            if (this._ctrl != null && !this._ctrl.touchModeFlag(IBookFieldFlags.FLAG_CELL_COMMENT)) continue;
                            book.setComment(new Comment(author, text));
                            continue;
                        }
                        if (id == ID_BK_NamedNode) {
                            String name = this._bookInfos.readString();
                            String refersTo = this._bookInfos.readString();
                            NamedObjectNode nod = book.getNames().searchByName(name);
                            if (nod != null) {
                                if (nod instanceof ConstNamedObjectNode) continue;
                                Expr expr = book.getActiveSheet().getExpr(nod, refersTo);
                                nod.setExpr(expr);
                                continue;
                            }
                            Sheet sheet = book.getActiveSheet();
                            nod = NamedObjectNode.createUndefinedNamedObject(name, book, sheet);
                            try {
                                sheet.getRange(0, 0).setName(name, refersTo);
                                continue block6;
                            }
                            catch (SyntaxErrorException e) {
                                logger.error((Object)"err", (Throwable)e);
                                continue;
                            }
                        }
                        break block13;
                        break;
                    }
                }
                catch (IOException iOException) {
                    break block13;
                }
            }
            finally {
                this._bookInfos = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadSheet(Sheet sheet, byte[] bytes) {
        Book book = sheet.getBook();
        boolean oldCalc = book.isAutoCalculate();
        boolean oldEnable = book.getUndoManager().isEnable();
        boolean oldLoading = book.isLoading();
        boolean oldA1Style = sheet.getDeps().isA1Style();
        book.setLoading(true);
        book.setCalculate(false);
        book.getUndoManager().enable(false);
        sheet.getDeps().setA1Style(true);
        try {
            this.readSheet(sheet, new KDSDataInputStream((InputStream)SectionJarUtil.unzip(bytes)));
        }
        catch (IOException iOException) {
        }
        finally {
            book.setCalculate(oldCalc);
            book.getUndoManager().enable(oldEnable);
            book.setLoading(oldLoading);
            sheet.getDeps().setA1Style(oldA1Style);
        }
    }

    private void initBookBase(KDSDataInputStream is) throws IOException {
        this._bookName = is.readString();
        this._sheetCount = is.readInt();
        this._activeSheetIndex = is.readInt();
        this._sheetInfos = new ArrayList(this._sheetCount);
        for (int i = 0; i < this._sheetCount; ++i) {
            String sheetId = is.readString();
            String sheetName = is.readString();
            SheetProxy si = new SheetProxy(this, sheetId, sheetName);
            byte flags = is.readByte();
            boolean hide = this.touchFlag(flags, 1);
            boolean selected = this.touchFlag(flags, 2);
            boolean hasData = this.touchFlag(flags, 4);
            Color color = null;
            int rgb = is.readInt();
            if (rgb != 0xFFAFAF) {
                color = new Color(rgb, true);
            }
            si.setHide(hide);
            si.setSelected(selected);
            si.setHasData(hasData);
            si.setTabColor(color);
            this._sheetInfos.add(si);
        }
    }

    private Object getUoTransObject(String key, String strVal) {
        Book.IUserObjectProvider trans = null;
        if (this._ctrl != null) {
            trans = this._ctrl.getKmlUOTrans();
        }
        if (trans != null) {
            return trans.getObject(key, strVal);
        }
        return strVal;
    }

    private void readSheet(Sheet sheet, KDSDataInputStream is) throws IOException {
        ShareStyleAttributes ssa;
        int styleid;
        is.readByte();
        HashMap styles = new HashMap();
        byte id = is.readByte();
        if (id == ID_SH_Style) {
            this.readStyles(is, styles);
        }
        if ((styleid = is.readInt()) != -1 && (ssa = (ShareStyleAttributes)styles.get(styleid)) != null) {
            sheet.appendSSA(ssa);
        }
        is.readInt();
        while (true) {
            if ((id = is.readByte()) == ID_SH_Row) {
                this.readRow(sheet, is, styles);
                continue;
            }
            if (id == ID_SH_Col2) {
                this.readCol2(sheet, is);
                continue;
            }
            if (id == ID_SH_Extend) {
                this.readSheetExtends(sheet, is, styles);
                continue;
            }
            if (id != ID_SH_Option) break;
            this.readSheetOption(sheet, is, styles);
        }
    }

    private void readSheetExtends(Sheet sheet, KDSDataInputStream is, HashMap styles) throws IOException {
        while (true) {
            byte id;
            if ((id = is.readByte()) == ID_SE_NamedNode) {
                String name = is.readString();
                String refersTo = is.readString();
                NamedObjectNode nod = sheet.getBook().getNames().searchByName(name);
                if (nod != null) {
                    if (nod instanceof ConstNamedObjectNode) continue;
                    sheet.getBook().getNames().remove(nod);
                    sheet.getNames().insert(nod);
                    nod.setSheet(sheet);
                    nod.setRefersTo(refersTo);
                    continue;
                }
                try {
                    sheet.getRange(0, 0).setName(sheet.getSyntaxName() + '!' + name, refersTo);
                }
                catch (SyntaxErrorException e) {
                    logger.error((Object)"err", (Throwable)e);
                }
                continue;
            }
            if (id == ID_SE_UserObject) {
                String key = is.readString();
                String strVal = is.readString();
                Object value = this.getUoTransObject(key, strVal);
                sheet.setUserObject(key, value);
                continue;
            }
            if (id == ID_SE_Validation) {
                this.readValidation(sheet, is);
                continue;
            }
            if (id == ID_SE_Comment) {
                String author = is.readString();
                String text = is.readString();
                sheet.setComment(new Comment(author, text));
                continue;
            }
            if (id == ID_SE_RowSpan || id == ID_SE_ColSpan) {
                int start = is.readInt();
                int extent = is.readInt();
                Span span = new Span(start, start + extent - 1);
                int uid = is.readInt();
                ShareStyleAttributes ssa = null;
                if (uid != -1) {
                    ssa = (ShareStyleAttributes)styles.get(uid);
                }
                int length = is.readInt();
                boolean visible = this.touchFlag(is.readByte(), 1);
                if (id == ID_SE_ColSpan) {
                    sheet.getColSpans().setSpanAttribute(span, ssa, (Integer)length, (Boolean)visible, null, null, false);
                    continue;
                }
                sheet.getRowSpans().setSpanAttribute(span, ssa, (Integer)length, (Boolean)visible, null, null, false);
                continue;
            }
            if (id != ID_SE_Graph) break;
            String className = is.readString();
            byte[] data = is.readLengthBytes();
            try {
                EmbedObject emb = null;
                Class<?> clazz = Class.forName(className);
                emb = (EmbedObject)clazz.newInstance();
                if (emb == null) continue;
                emb.load(data, false);
                sheet.getEmbedments(true).addEmbed(emb);
            }
            catch (Exception e) {
                logger.error((Object)"err", (Throwable)e);
            }
        }
    }

    private void readValidation(Sheet sheet, KDSDataInputStream is) throws IOException {
        Validation val = new Validation(sheet, new MessagedValidate(), null);
        MessagedValidate mv = val.getMessagedValidate();
        mv.setTypeIndex(is.readInt());
        int quaIndex = is.readInt();
        mv.setQualifierIndex(quaIndex);
        val.setBlocks(SheetBaseMath.getSortedBlocks(sheet, is.readString(), true));
        mv.setImeMode(is.readByte());
        byte flags = is.readByte();
        mv.setCellRangeList(this.touchFlag(flags, 1));
        mv.setUseBlank(this.touchFlag(flags, 2));
        mv.setInputHide(this.touchFlag(flags, 4));
        mv.setErrorHide(this.touchFlag(flags, 8));
        String min = is.readString();
        String max = quaIndex <= 1 ? is.readString() : null;
        mv.setMinMax(min, max, sheet);
        mv.setInputTitle(is.readString());
        mv.setInputMessage(is.readString());
        mv.setErrorStyle(is.readString());
        mv.setErrorTitle(is.readString());
        mv.setErrorMessage(is.readString());
        sheet.getValidations().addValidation(val);
    }

    private void readSheetOption(Sheet sheet, KDSDataInputStream is, HashMap styles) throws IOException {
        SheetOption so = sheet.getSheetOption();
        so.setScale(is.readInt());
        int rgb = is.readInt();
        if (rgb != 0xFFAFAF) {
            so.setGridLineColor(new Color(rgb, true));
        }
        byte flags = is.readByte();
        so.setShowHoriLines(this.touchFlag(flags, 1));
        so.setShowVertLines(this.touchFlag(flags, 2));
        while (true) {
            Protection pro;
            byte id;
            if ((id = is.readByte()) == ID_SO_PrintSetup) {
                this.readPrintSetup(sheet, is, styles);
                continue;
            }
            if (id == ID_SO_Protection) {
                pro = sheet.getSheetOption().getProtection(true);
                boolean start = is.read() != 0;
                pro.setOperations(is.readInt());
                String str = is.readString();
                if (start) {
                    pro.startWithEncryptedPassword(str);
                    continue;
                }
                pro.setEncryptedPassword(str);
                continue;
            }
            if (id == ID_SO_EditBlocks) {
                pro = sheet.getSheetOption().getProtection(true);
                String name = is.readString();
                String pw = is.readString();
                String range = is.readString();
                Protection.EditableArea ea = pro.createEditableArea(name);
                ea.setEncryptedPassword(pw);
                ea.addAll(SheetBaseMath.getSortedBlocks(sheet, range, true));
                pro.addEditableArea(ea);
                continue;
            }
            if (id == ID_SO_Selection) {
                this.readSelection(sheet, is);
                continue;
            }
            if (id == ID_SO_SplitInfo) {
                this.readSplitInfo(sheet, is);
                continue;
            }
            if (id != ID_SO_Merge) break;
            this.readMerge(sheet, is);
        }
    }

    private void readPrintSetup(Sheet sheet, KDSDataInputStream is, HashMap styles) throws IOException {
        PrintSetup ps = sheet.getSheetOption().getPrintSetup(true);
        byte flags = is.readByte();
        ps.setLandScape(this.touchFlag(flags, 32));
        ps.setRowFirst(this.touchFlag(flags, 16));
        ps.setBlackWhite(this.touchFlag(flags, 8));
        ps.setHasGrid(this.touchFlag(flags, 4));
        ps.setHasRowHead(this.touchFlag(flags, 1));
        ps.setHasColHead(this.touchFlag(flags, 2));
        ps.setCenterHorizontal(is.readInt());
        ps.setCenterVertical(is.readInt());
        ps.setTopMargin(Float.intBitsToFloat(is.readInt()));
        ps.setBottomMargin(Float.intBitsToFloat(is.readInt()));
        ps.setLeftMargin(Float.intBitsToFloat(is.readInt()));
        ps.setRightMargin(Float.intBitsToFloat(is.readInt()));
        ps.setPagesizeIndex(is.readInt());
        ps.setPagesizeX(Float.intBitsToFloat(is.readInt()));
        ps.setPagesizeY(Float.intBitsToFloat(is.readInt()));
        if (this.fileVersion < 101) {
            ps.setScale(is.readInt());
        } else {
            ps.setAutoFit(is.readBoolean());
            ps.setScale(is.readInt());
            ps.setAutoFitWidth(is.readInt());
            ps.setAutoFitHeight(is.readInt());
        }
        ps.setHeadMargin(Float.intBitsToFloat(is.readInt()));
        ps.setHeadData(PrintHelper.genHeaderFootList(is.readString(), styles, true));
        ps.setFootAlign(is.readInt());
        ps.setHeadAlign(is.readInt());
        ps.setFootMargin(Float.intBitsToFloat(is.readInt()));
        ps.setFootData(PrintHelper.genHeaderFootList(is.readString(), styles, true));
    }

    private void readSelection(Sheet sheet, KDSDataInputStream is) throws IOException {
        int row = is.readInt();
        int col = is.readInt();
        String range = is.readString();
        Selection sel = sheet.getSheetOption().getSelection();
        ArrayList al = SheetBaseMath.getListBlocks(sheet, range, true);
        if (al != null) {
            sel.setData(al, 0, row, col);
        }
    }

    private void readMerge(Sheet sheet, KDSDataInputStream is) throws IOException {
        String range = is.readString();
        SortedCellBlockArray merges = SheetBaseMath.getSortedBlocks(sheet, range, true);
        sheet.getSheetOption().getMerger(true).addAll(merges);
    }

    private void readSplitInfo(Sheet sheet, KDSDataInputStream is) throws IOException {
        SheetOption so = sheet.getSheetOption();
        ViewSplitInfo vs = so.getViewSplitInfo();
        byte flags = is.readByte();
        so.setHide(this.touchFlag(flags, 1));
        so.setSelected(this.touchFlag(flags, 2));
        vs.setFreezed(this.touchFlag(flags, 4));
        vs.setActivePane(is.readInt());
        vs.setFirstRow(is.readInt());
        vs.setFirstCol(is.readInt());
        vs.setFirstRow2(is.readInt());
        vs.setFirstCol2(is.readInt());
        vs.setRowSplit(is.readInt());
        vs.setColSplit(is.readInt());
    }

    private void readCol2(Sheet sheet, KDSDataInputStream is) throws IOException {
        byte id;
        int index = is.readInt();
        Column colObject = sheet.getColumn(index, true);
        while ((id = is.readByte()) == ID_Col2_UserObject) {
            String key = is.readString();
            String strVal = is.readString();
            Object value = this.getUoTransObject(key, strVal);
            colObject.setUserObject(key, value);
        }
    }

    private void readRow(Sheet sheet, KDSDataInputStream is, HashMap styles) throws IOException {
        SortedRowArray rows = sheet.getRows();
        int rowIndex = is.readInt();
        Row row = new Row(sheet, rowIndex);
        rows.insert(row);
        while (true) {
            byte id;
            if ((id = is.readByte()) == ID_Row_UserObject) {
                String key = is.readString();
                String strVal = is.readString();
                Object value = this.getUoTransObject(key, strVal);
                row.setUserObject(key, value);
                continue;
            }
            if (id != ID_Cell) break;
            this.readCell(row, is, styles);
        }
    }

    private void readCell(Row row, KDSDataInputStream is, HashMap styles) throws IOException {
        block23: {
            Cell _bufCell = null;
            while (true) {
                byte id;
                if ((id = is.readByte()) == ID_Cell_Index) {
                    _bufCell = row.getCell(is.readInt(), true);
                    continue;
                }
                if (id == ID_Cell_StyleID) {
                    ShareStyleAttributes ssa;
                    int styleid = is.readInt();
                    if (styleid == -1 || (ssa = (ShareStyleAttributes)styles.get(styleid)) == null) continue;
                    if (_bufCell == null) {
                        _bufCell = row.getCell(row.getMaxIntMark() + 1, true);
                    }
                    _bufCell.setSSA(ssa);
                    continue;
                }
                if (id == ID_Cell_Formula) {
                    String fm = is.readString();
                    if (_bufCell == null) {
                        _bufCell = row.getCell(row.getMaxIntMark() + 1, true);
                    }
                    _bufCell.setFormula(fm);
                    continue;
                }
                if (id == ID_Cell_Value) {
                    Variant var;
                    String valueString;
                    byte type = is.readByte();
                    if (1 == type) {
                        valueString = is.readString();
                        var = new Variant(valueString, 11);
                    } else if (4 == type) {
                        valueString = is.readString();
                        var = new Variant(new BigDecimal(valueString), 10);
                    } else if (8 == type) {
                        valueString = is.readString();
                        var = new Variant(new BigDecimal(valueString), 10);
                        try {
                            var.setObject(var.toCalendar(), 13);
                        }
                        catch (SyntaxErrorException syntaxErrorException) {}
                    } else {
                        var = 2 == type ? new Variant(is.readBoolean(), 8) : Variant.nullVariant;
                    }
                    if (_bufCell == null) {
                        _bufCell = row.getCell(row.getMaxIntMark() + 1, true);
                    }
                    _bufCell.setValue(var);
                    continue;
                }
                if (id == ID_Cell_HyperLink) {
                    if (_bufCell == null) {
                        _bufCell = row.getCell(row.getMaxIntMark() + 1, true);
                    }
                    _bufCell.setHyperLink(new HyperLink("", is.readString()));
                    continue;
                }
                if (id == ID_Cell_UserObject) {
                    String key = is.readString();
                    String strVal = is.readString();
                    Object value = this.getUoTransObject(key, strVal);
                    if (_bufCell == null) {
                        _bufCell = row.getCell(row.getMaxIntMark() + 1, true);
                    }
                    _bufCell.setUserObject(key, value);
                    continue;
                }
                if (id == ID_Cell_Comment) {
                    String author = is.readString();
                    String text = is.readString();
                    if (_bufCell == null) {
                        _bufCell = row.getCell(row.getMaxIntMark() + 1, true);
                    }
                    _bufCell.setComment(new Comment(author, text));
                    continue;
                }
                if (id != ID_Cell_Diagonal) break;
                if (_bufCell == null) {
                    _bufCell = row.getCell(row.getMaxIntMark() + 1, true);
                }
                this.readDiagonal(_bufCell, is, styles);
            }
            if (_bufCell != null) break block23;
            _bufCell = row.getCell(row.getMaxIntMark() + 1, true);
        }
    }

    private void readDiagonal(Cell cell, KDSDataInputStream is, HashMap styles) throws IOException {
        int i;
        byte pos = is.readByte();
        int row = is.readInt();
        int col = is.readInt();
        int row2 = is.readInt();
        int col2 = is.readInt();
        String srowoffs = is.readString();
        String scoloffs = is.readString();
        DiagonalHeader dh = new DiagonalHeader();
        dh.setSheet(cell.getSheet());
        int[] rowOffs = null;
        if (!StringUtil.isEmptyString((String)srowoffs)) {
            String[] strs = srowoffs.split(",");
            rowOffs = new int[strs.length];
            for (int i2 = strs.length - 1; i2 >= 0; --i2) {
                rowOffs[i2] = Integer.parseInt(strs[i2]);
            }
        }
        int[] colOffs = null;
        if (!StringUtil.isEmptyString((String)scoloffs)) {
            String[] strs = scoloffs.split(",");
            colOffs = new int[strs.length];
            for (i = strs.length - 1; i >= 0; --i) {
                colOffs[i] = Integer.parseInt(strs[i]);
            }
        }
        dh.setRowCol(row, col, row2, col2);
        dh.setSplitInfo(Integer.valueOf(pos), rowOffs, colOffs);
        cell.setDiagonalHeader(dh);
        int size = dh.size();
        for (i = 0; i < size; ++i) {
            ShareStyleAttributes ssa;
            byte flags = is.readByte();
            dh.setLean((flags & 1) != 0, i);
            dh.setAutoZoom((flags & 2) != 0, i);
            dh.setDrawBackground((flags & 4) != 0, i);
            int uid = is.readInt();
            if (uid != -1 && (ssa = (ShareStyleAttributes)styles.get(uid)) != null) {
                dh.setStyle(cell.getSheet().getBook().getStyle(ssa), i);
            }
            dh.setText(is.readString(), i);
        }
    }

    private void readStyles(KDSDataInputStream is, HashMap styles) throws IOException {
        byte id;
        while ((id = is.readByte()) == ID_ST_BEGIN) {
            this.readStyle(is, styles);
        }
    }

    private void readStyle(KDSDataInputStream is, HashMap styles) throws IOException {
        block30: {
            StyleAttributes _cursa = Styles.getEmptySA();
            _cursa.setUID(is.readInt());
            while (true) {
                int intls;
                byte id;
                if ((id = is.readByte()) == ID_ST_Font) {
                    byte flags;
                    int colorRGB;
                    int size;
                    String fontName = is.readString();
                    if (!StringUtil.isEmptyString((String)fontName)) {
                        _cursa.setFontName(fontName);
                    }
                    if ((size = is.readInt()) != -1) {
                        _cursa.setFontSize(size);
                    }
                    if ((colorRGB = is.readInt()) != 0xFFAFAF) {
                        _cursa.setFontColor(new Color(colorRGB, true));
                    }
                    if (this.touchFlag(flags = is.readByte(), 1)) {
                        _cursa.setUnderline(true);
                    }
                    if (this.touchFlag(flags, 4)) {
                        _cursa.setBold(true);
                    }
                    if (this.touchFlag(flags, 8)) {
                        _cursa.setItalic(true);
                    }
                    if (!this.touchFlag(flags, 16)) continue;
                    _cursa.setStrikeThrough(true);
                    continue;
                }
                if (id == ID_ST_Align) {
                    byte flags;
                    int rotat;
                    int vval;
                    int hval = is.readInt();
                    if (hval != -1) {
                        _cursa.setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((int)hval));
                    }
                    if ((vval = is.readInt()) != -1) {
                        _cursa.setVerticalAlign(Styles.VerticalAlignment.getAlignment((int)vval));
                    }
                    if ((rotat = is.readInt()) != -1) {
                        _cursa.setRotation(rotat);
                    }
                    if (this.touchFlag(flags = is.readByte(), 1)) {
                        _cursa.setWrapText(true);
                    }
                    if (!this.touchFlag(flags, 2)) continue;
                    _cursa.setShrinkText(true);
                    continue;
                }
                if (id == ID_ST_TopBorder) {
                    String penName;
                    Styles.Position pos = Styles.Position.TOP;
                    intls = is.readInt();
                    _cursa.setBorderLineStyle(pos, LineStyle.getLineStyleByBits((int)intls));
                    int clrRGB = is.readInt();
                    if (clrRGB != 0xFFAFAF) {
                        _cursa.setBorderColor(pos, new Color(clrRGB, true));
                    }
                    if (StringUtil.isEmptyString((String)(penName = is.readString()))) continue;
                    _cursa.setBorderPenStyle(pos, PenStyle.getPenStyle((String)penName));
                    continue;
                }
                if (id == ID_ST_BottomBorder) {
                    String penName;
                    Styles.Position pos = Styles.Position.BOTTOM;
                    intls = is.readInt();
                    _cursa.setBorderLineStyle(pos, LineStyle.getLineStyleByBits((int)intls));
                    int clrRGB = is.readInt();
                    if (clrRGB != 0xFFAFAF) {
                        _cursa.setBorderColor(pos, new Color(clrRGB, true));
                    }
                    if (StringUtil.isEmptyString((String)(penName = is.readString()))) continue;
                    _cursa.setBorderPenStyle(pos, PenStyle.getPenStyle((String)penName));
                    continue;
                }
                if (id == ID_ST_LeftBorder) {
                    String penName;
                    Styles.Position pos = Styles.Position.LEFT;
                    intls = is.readInt();
                    _cursa.setBorderLineStyle(pos, LineStyle.getLineStyleByBits((int)intls));
                    int clrRGB = is.readInt();
                    if (clrRGB != 0xFFAFAF) {
                        _cursa.setBorderColor(pos, new Color(clrRGB, true));
                    }
                    if (StringUtil.isEmptyString((String)(penName = is.readString()))) continue;
                    _cursa.setBorderPenStyle(pos, PenStyle.getPenStyle((String)penName));
                    continue;
                }
                if (id == ID_ST_RightBorder) {
                    String penName;
                    Styles.Position pos = Styles.Position.RIGHT;
                    intls = is.readInt();
                    _cursa.setBorderLineStyle(pos, LineStyle.getLineStyleByBits((int)intls));
                    int clrRGB = is.readInt();
                    if (clrRGB != 0xFFAFAF) {
                        _cursa.setBorderColor(pos, new Color(clrRGB, true));
                    }
                    if (StringUtil.isEmptyString((String)(penName = is.readString()))) continue;
                    _cursa.setBorderPenStyle(pos, PenStyle.getPenStyle((String)penName));
                    continue;
                }
                if (id == ID_ST_LeftDiaBorder) {
                    String penName;
                    Styles.Position pos = Styles.Position.DIAGONALLEFT;
                    intls = is.readInt();
                    _cursa.setBorderLineStyle(pos, LineStyle.getLineStyleByBits((int)intls));
                    int clrRGB = is.readInt();
                    if (clrRGB != 0xFFAFAF) {
                        _cursa.setBorderColor(pos, new Color(clrRGB, true));
                    }
                    if (StringUtil.isEmptyString((String)(penName = is.readString()))) continue;
                    _cursa.setBorderPenStyle(pos, PenStyle.getPenStyle((String)penName));
                    continue;
                }
                if (id == ID_ST_RightDiaBorder) {
                    String penName;
                    Styles.Position pos = Styles.Position.DIAGONALRIGHT;
                    intls = is.readInt();
                    _cursa.setBorderLineStyle(pos, LineStyle.getLineStyleByBits((int)intls));
                    int clrRGB = is.readInt();
                    if (clrRGB != 0xFFAFAF) {
                        _cursa.setBorderColor(pos, new Color(clrRGB, true));
                    }
                    if (StringUtil.isEmptyString((String)(penName = is.readString()))) continue;
                    _cursa.setBorderPenStyle(pos, PenStyle.getPenStyle((String)penName));
                    continue;
                }
                if (id == ID_ST_Background) {
                    int pid;
                    int rgb = is.readInt();
                    if (rgb != 0xFFAFAF) {
                        _cursa.setBackground(new Color(rgb, true));
                    }
                    if ((pid = is.readInt()) >= 0) {
                        Pattern p = Pattern.getPattern((int)pid);
                        _cursa.setPattern(p);
                    }
                    if ((rgb = is.readInt()) == 0xFFAFAF) continue;
                    _cursa.setPatternColor(new Color(rgb, true));
                    continue;
                }
                if (id == ID_ST_NumberFormat) {
                    String nf = is.readString();
                    _cursa.setNumberFormat(nf);
                    continue;
                }
                if (id != ID_ST_Protection) break;
                byte flags = is.readByte();
                if (this.touchFlag(flags, 1)) {
                    _cursa.setHided(this.touchFlag(flags, 2));
                }
                if (!this.touchFlag(flags, 4)) continue;
                _cursa.setLocked(this.touchFlag(flags, 8));
            }
            if (_cursa.isEmpty()) break block30;
            styles.put(_cursa.getUID(), _cursa);
        }
    }
}

