/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.io.kml;

import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.cosmic.ctrl.kds.io.BookIOController;
import com.kingdee.cosmic.ctrl.kds.io.kml.AbsElement;
import com.kingdee.cosmic.ctrl.kds.io.kml.BookElement;
import com.kingdee.cosmic.ctrl.kds.io.kml.IKmlConstants;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.validate.Validation;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.FilenameUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class KmlToBook
implements IKmlConstants {
    private XmlToBookHandler _handler;
    private DataCache _dataCache;
    private ElementStack _elementStack;
    private BookIOController _ctrl;
    private HashMap _cells;
    private boolean fromExcelClipboard = false;

    public void setCells(HashMap cells) {
        this._cells = cells;
    }

    public HashMap getCells() {
        return this._cells;
    }

    public void setIOController(BookIOController ctrl) {
        this._ctrl = ctrl;
    }

    BookIOController getIOController() {
        return this._ctrl;
    }

    boolean touchModeFlag(int flag) {
        if (this._ctrl == null) {
            return true;
        }
        return this._ctrl.touchModeFlag(flag);
    }

    Book.IUserObjectProvider getKmlUOTrans() {
        if (this._ctrl == null) {
            return null;
        }
        return this._ctrl.getKmlUOTrans();
    }

    private SAXParserFactory createSAXParser() throws Exception {
        SAXParserFactory factory = null;
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Thread.currentThread().setContextClassLoader(KmlToBook.class.getClassLoader());
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            factory = SAXParserFactory.newInstance();
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                Thread.currentThread().setContextClassLoader(oldCL);
            }
            catch (SecurityException securityException) {}
        }
        return factory;
    }

    public Book load(InputSource is) throws Exception {
        return this.load(is, null);
    }

    public Book load(InputSource is, Book book) throws Exception {
        SAXParserFactory factory = this.createSAXParser();
        if (null != factory) {
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(is, (DefaultHandler)this.createHandler(book));
        }
        return this.getBook();
    }

    public Book load(String file) throws Exception {
        return this.load(file, null);
    }

    public Book load(String file, Book book) throws Exception {
        try (FileInputStream fileInputStream = new FileInputStream(FilenameUtils.normalize((String)file));){
            this.load(fileInputStream, book);
        }
        return this.getBook();
    }

    public Book load(InputStream is) throws Exception {
        return this.load(is, null);
    }

    public Book load(InputStream is, Book book) throws Exception {
        SAXParserFactory factory = this.createSAXParser();
        if (null != factory) {
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(is, (DefaultHandler)this.createHandler(book));
        }
        return this.getBook();
    }

    public Book getBook() {
        return this._dataCache.getBook();
    }

    public int getExpandedRowCount() {
        return this._dataCache.getExpandedRowCount();
    }

    public int getExpandedColumnCount() {
        return this._dataCache.getExpandedColumnCount();
    }

    private XmlToBookHandler createHandler(Book book) {
        this._handler = new XmlToBookHandler();
        this._dataCache = new DataCache();
        this._dataCache.setStyles(new HashMap());
        this._dataCache.setBook(book);
        this._elementStack = new ElementStack();
        this._elementStack.push(new BookElement());
        this._dataCache.setFromExcelClipboard(this.isFromExcelClipboard());
        return this._handler;
    }

    public boolean isFromExcelClipboard() {
        return this.fromExcelClipboard;
    }

    public void setFromExcelClipboard(boolean fromExcelClipboard) {
        this.fromExcelClipboard = fromExcelClipboard;
    }

    class XmlToBookHandler
    extends DefaultHandler {
        XmlToBookHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            AbsElement parser = KmlToBook.this._elementStack.getCurrentParser();
            parser.startElement(uri, localName, qName, attributes, KmlToBook.this._elementStack, KmlToBook.this._dataCache, KmlToBook.this);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            KmlToBook.this._elementStack.getCurrentParser().endElement(uri, localName, qName, KmlToBook.this._elementStack, KmlToBook.this._dataCache, KmlToBook.this);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            KmlToBook.this._elementStack.getCurrentParser().characters(ch, start, length, KmlToBook.this._elementStack, KmlToBook.this._dataCache, KmlToBook.this);
        }
    }

    static class ElementStack {
        private Stack parsers = new Stack();

        public void push(AbsElement parser) {
            this.parsers.push(parser);
        }

        public AbsElement pop() {
            return (AbsElement)this.parsers.pop();
        }

        public AbsElement getCurrentParser() {
            return (AbsElement)this.parsers.get(this.parsers.size() - 1);
        }
    }

    static class DataCache {
        static final String RowIndex = "RowIndex";
        static final String UOParent = "UOParent";
        static final String ValidateMin = "ValidateMin";
        static final String EPTCODE = "EPTPassword";
        private HashMap _datas = new HashMap();
        private int _expandedRowCount;
        private int _expandedColumnCount;
        private int _defCellIndex;
        private boolean fromExcelClipboard;
        private HashMap _names;

        DataCache() {
        }

        HashMap getNames() {
            if (this._names == null) {
                this._names = new HashMap();
            }
            return this._names;
        }

        void clear() {
            this._datas.clear();
        }

        Object get(Object key) {
            return this._datas.get(key);
        }

        void put(Object key, Object value) {
            this._datas.put(key, value);
        }

        void setActiveSheetIndex(String index) {
            this._datas.put("ActiveSheet", index);
        }

        String getActiveSheetIndex() {
            return (String)this._datas.get("ActiveSheet");
        }

        void setCurRowIndex(String strRowIndex) {
            this._datas.put(RowIndex, strRowIndex);
        }

        String getCurRowIndex() {
            return (String)this._datas.get(RowIndex);
        }

        int getDefaultCellIndex() {
            return this._defCellIndex;
        }

        void setDefaultCellIndex(int cellCount) {
            this._defCellIndex = cellCount;
        }

        Book getBook() {
            return (Book)this._datas.get("Workbook");
        }

        void setBook(Book book) {
            this._datas.put("Workbook", book);
        }

        HashMap getStyles() {
            return (HashMap)this._datas.get("Styles");
        }

        void setStyles(HashMap styles) {
            this._datas.put("Styles", styles);
        }

        String getEptPassword() {
            return (String)this._datas.get(EPTCODE);
        }

        void setEptPassowrd(String pw) {
            this._datas.put(EPTCODE, pw);
        }

        StyleAttributes getCurStyle() {
            return (StyleAttributes)this._datas.get("Style");
        }

        void setCurStyle(StyleAttributes sa) {
            this._datas.put("Style", sa);
        }

        Sheet getCurSheet() {
            return (Sheet)this._datas.get("Worksheet");
        }

        void setCurSheet(Sheet sheet) {
            this._datas.put("Worksheet", sheet);
        }

        Cell getCurCell() {
            return (Cell)this._datas.get("Cell");
        }

        void setCurCell(Cell cell) {
            this._datas.put("Cell", cell);
        }

        String getCurCellDataType() {
            return (String)this._datas.get("Type");
        }

        void setCurCellDataType(String type) {
            this._datas.put("Type", type);
        }

        void setCurCellTicked(String ticked) {
            this._datas.put("Ticked", ticked);
        }

        boolean isCurCellTicked() {
            return !StringUtil.isEmptyString((String)((String)this._datas.get("Ticked")));
        }

        int getExpandedColumnCount() {
            return this._expandedColumnCount;
        }

        void setExpandedColumnCount(int expandedColumnCount) {
            this._expandedColumnCount = expandedColumnCount;
        }

        int getExpandedRowCount() {
            return this._expandedRowCount;
        }

        void setExpandedRowCount(int expandedRowCount) {
            this._expandedRowCount = expandedRowCount;
        }

        void setCurUOParent(Object o) {
            this._datas.put(UOParent, o);
        }

        Object getCurUOParent() {
            return this._datas.get(UOParent);
        }

        String getCurUserObjectType() {
            return (String)this._datas.get("Type");
        }

        String getCurUserObjectKey() {
            return (String)this._datas.get("Key");
        }

        void setCurUserObjectType(String uoNodeType) {
            this._datas.put("Type", uoNodeType);
        }

        void setCurUserObjectKey(String uoNodeKey) {
            this._datas.put("Key", uoNodeKey);
        }

        void setCurValidation(Validation val) {
            this._datas.put("DataValidation", val);
        }

        Validation getCurValidation() {
            return (Validation)this._datas.get("DataValidation");
        }

        public boolean isFromExcelClipboard() {
            return this.fromExcelClipboard;
        }

        public void setFromExcelClipboard(boolean fromExcelClipboard) {
            this.fromExcelClipboard = fromExcelClipboard;
        }
    }
}

