/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.expr;

import com.kingdee.cosmic.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kds.model.expr.ExprUID;
import com.kingdee.cosmic.ctrl.kds.model.expr.IExprBuffer;
import com.kingdee.cosmic.ctrl.kds.model.expr.IExprNode;
import com.kingdee.cosmic.ctrl.kds.model.expr.TraceVariant;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.Dependents;
import com.kingdee.cosmic.ctrl.kds.model.struct.ICalculable;
import com.kingdee.cosmic.ctrl.kds.model.util.ObjectStack;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class ExprContext
extends Variant
implements IExprNode {
    private static final long serialVersionUID = -1718692131747450117L;
    private Book _book;
    private IExprBuffer _buffer;
    private int _calcUID;
    private ObjectStack _ownerStack;
    private ObjectStack _exprStack;
    private Variant[] _vars;
    private long[] _sepDays;
    private boolean _traceMode;
    private boolean _calcLastMode;
    private int _tracePos;
    private Object _tempRet;
    private ObjectStack _subExprStack;
    private boolean _subExecute;
    private boolean _excludeHidden = false;
    private Map<Variant, Variant> exprUidMap = new HashMap<Variant, Variant>();

    public ExprContext(Book book, IExprBuffer buffer) {
        this._book = book;
        this._buffer = buffer;
        this._exprStack = buffer.getStack();
        this._calcUID = ExprUID.getUID();
        this._ownerStack = new ObjectStack();
        this._subExprStack = new ObjectStack();
        this._sepDays = new long[6];
    }

    public ExprContext(Book book, ExprContext src) {
        this._book = src._book;
        this._buffer = src._buffer;
        this._calcUID = src._calcUID;
        this._traceMode = src._traceMode;
        this._ownerStack = src._ownerStack;
        this._exprStack = src._exprStack;
        this._subExprStack = src._subExprStack;
        this._sepDays = src._sepDays;
    }

    @Override
    public String toString() {
        return "ctx " + this._calcUID;
    }

    public void clear() {
        this._ownerStack.clear();
        if (this._exprStack != null) {
            this._exprStack.clear();
        }
        this._subExprStack.clear();
    }

    public Book getBook() {
        return this._book;
    }

    public ObjectStack getCurrentExprStack() {
        return this._exprStack;
    }

    public ObjectStack setCurrentExprStack(ObjectStack stk) {
        ObjectStack old = this._exprStack;
        this._exprStack = stk;
        return old;
    }

    public IExprBuffer getBuffer() {
        return this._buffer;
    }

    public Dependents getDeps() {
        return (Dependents)this._buffer;
    }

    public Variant[] getVars() {
        if (this._vars == null) {
            this._vars = new Variant[8];
            Arrays.fill(this._vars, Variant.nullVariant);
        }
        return this._vars;
    }

    public int getCalcUID() {
        return this._calcUID;
    }

    public void setCalcUID(int uid) {
        this._calcUID = uid;
    }

    public int getOwnerStackSize() {
        return this._ownerStack.size();
    }

    public ICalculable getExprOwner() {
        return (ICalculable)this._ownerStack.getTop();
    }

    public void pushExprOwner(ICalculable owner) {
        this._ownerStack.push(owner);
    }

    public void popExprOwner() {
        this._ownerStack.pop();
    }

    public void popExprOwnerN(int n) {
        this._ownerStack.popN(n);
    }

    public void pushSubExpr(TraceVariant expr) {
        this._subExprStack.push(expr);
    }

    public TraceVariant popSubExpr() {
        return (TraceVariant)this._subExprStack.pop();
    }

    public ObjectStack getSubExprStack() {
        return this._subExprStack;
    }

    public boolean hasSubExpr() {
        return !this._subExprStack.isEmpty();
    }

    public int getTracePos() {
        return this._tracePos;
    }

    public void setTracePos(int calcStep) {
        this._tracePos = calcStep;
    }

    public Object getTempRet() {
        return this._tempRet;
    }

    public void setTempRet(Object tempRet) {
        this._tempRet = tempRet;
    }

    public boolean isSubExecute() {
        return this._subExecute;
    }

    public void setSubExecute(boolean subExecute) {
        this._subExecute = subExecute;
    }

    public boolean isTraceMode() {
        return this._traceMode;
    }

    public boolean setTraceMode(boolean isExtendMode) {
        boolean old = this._traceMode;
        this._traceMode = isExtendMode;
        return old;
    }

    public boolean isCalcLastMode() {
        return this._calcLastMode;
    }

    public void setCalcLastMode(boolean calcLastMode) {
        this._calcLastMode = calcLastMode;
    }

    @Override
    public int getExprType() {
        return 32768;
    }

    @Override
    public void action(ExprContext ctx, ICalculable exprOwner) throws SyntaxErrorException {
        this._ownerStack.push(exprOwner);
        Variant var = ctx.isTraceMode() ? new TraceVariant(ctx, (Object)this) : this;
        ctx.getCurrentExprStack().push(var);
    }

    @Override
    public String decode(ExprContext ctx, ICalculable exprOwner) {
        return "";
    }

    public long[] getSepDays() {
        return this._sepDays;
    }

    public boolean isExcludeHidden() {
        return this._excludeHidden;
    }

    public void setExcludeHidden(boolean excludeHidden) {
        this._excludeHidden = excludeHidden;
    }

    public void clearExprUid() {
        this.exprUidMap.clear();
    }

    public void putExprUid(Variant key, Variant value) {
        this.exprUidMap.put(key, value);
    }

    public Variant getExprUid(Variant key) {
        return this.exprUidMap.get(key);
    }
}

