/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.expr;

import com.kingdee.cosmic.ctrl.extcommon.variant.ExprErr;
import com.kingdee.cosmic.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtFuncProvider;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtendFuncProvider;
import com.kingdee.cosmic.ctrl.kds.model.expr.ExcelFuncProvider;
import com.kingdee.cosmic.ctrl.kds.model.expr.ExceptionHandler;
import com.kingdee.cosmic.ctrl.kds.model.expr.ExprContext;
import com.kingdee.cosmic.ctrl.kds.model.expr.IExprNode;
import com.kingdee.cosmic.ctrl.kds.model.expr.IInnerFuncProvider;
import com.kingdee.cosmic.ctrl.kds.model.expr.TraceVariant;
import com.kingdee.cosmic.ctrl.kds.model.struct.ICalculable;
import com.kingdee.cosmic.ctrl.kds.model.struct.IMethodFillParameter;
import com.kingdee.cosmic.ctrl.kds.model.struct.INeedSheetInfo;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.HashMap;

public class ExprMethod
implements IExprNode {
    static final int Flag_Batch = 1;
    static final int Flag_Local = 2;
    static final int Flag_VarietyParams = 4;
    static final int Flag_NeedContext = 8;
    static final int Flag_NeedSheetInfo = 16;
    static final int Flag_FillParameter = 32;
    static final int Flag_SubTotal = 64;
    static final int Flag_NeedExpParam = 128;
    static final int Flag_InnerMethod = 256;
    static final int Flag_ExcelMethod = 512;
    static final int Flag_ExtFamilyMethod = 1024;
    static final int Flag_ExtensibleMethod = 2048;
    static final int Flag_ExtDataSetMethod = 4096;
    static final int Flag_ExtEnableMethod = 8192;
    static final int Flag_DynamicDataset = 16384;
    static final int Flag_ExtField = 32768;
    static final int Flag_Macro = 65536;
    private static final HashMap _datasetFuncs = new HashMap();
    private static final HashMap _dynamicDSFuncs;
    private static final HashMap _needExprParamFuncs;
    private Method _method;
    private Object _thisInst;
    private String _instName;
    private Class[] _paramTypes;
    private int _flags;

    public ExprMethod(String instName, Object thisInst, Method method, boolean batch, boolean local) {
        this._thisInst = thisInst;
        this._instName = instName;
        this._method = method;
        this._paramTypes = method.getParameterTypes();
        this.setFlag(1, batch);
        this.setFlag(2, local);
        if (thisInst instanceof IInnerFuncProvider) {
            this.setFlag(256, true);
            if (thisInst instanceof ExcelFuncProvider) {
                this.setFlag(512, true);
            } else {
                String methodName = method.getName();
                if (thisInst instanceof ExtendFuncProvider) {
                    this.setFlag(1024, true);
                    this.setFlag(2048, true);
                    if (methodName.equals("$E")) {
                        this.setFlag(8192, true);
                    }
                } else if (thisInst instanceof ExtFuncProvider) {
                    this.setFlag(1024, true);
                    if (_dynamicDSFuncs.containsKey(methodName)) {
                        this.setFlag(16384, true);
                    } else if (methodName.compareTo("FIELD") == 0) {
                        this.setFlag(32768, true);
                    } else if (methodName.compareTo("MACRO") == 0) {
                        this.setFlag(65536, true);
                    }
                }
                if (_datasetFuncs.containsKey(methodName)) {
                    this.setFlag(4096, true);
                }
            }
        } else if (thisInst instanceof INeedSheetInfo) {
            this.setFlag(16, true);
        }
        int len = this._paramTypes.length;
        if (len > 0) {
            Class cls;
            int varietyIndex = 0;
            if (this._paramTypes[0] == ExprContext.class) {
                this.setFlag(8, true);
                if (_needExprParamFuncs.containsKey(method.getName())) {
                    this.setFlag(128, true);
                }
                varietyIndex = 1;
            }
            if (len > varietyIndex && (cls = this._paramTypes[varietyIndex]).isArray() && cls.getComponentType() == Object.class) {
                String funcName;
                this.setFlag(4, true);
                if (thisInst instanceof ExcelFuncProvider && (funcName = method.getName()).equals("SUBTOTAL")) {
                    this.setFlag(64, true);
                }
            }
        }
    }

    private boolean touchFlag(int flag) {
        return (this._flags & flag) != 0;
    }

    private void setFlag(int flag, boolean set) {
        this._flags = set ? (this._flags |= flag) : (this._flags &= ~flag);
    }

    public String getName() {
        return this._method.getName();
    }

    public Method getMethod() {
        return this._method;
    }

    public Object getProviderInstance() {
        return this._thisInst;
    }

    public String getProviderName() {
        return this._instName;
    }

    public int getParamCount() {
        return this.touchFlag(8) ? this._paramTypes.length - 1 : this._paramTypes.length;
    }

    public boolean isBatchMethod() {
        return this.touchFlag(1);
    }

    public boolean isSubTotal() {
        return this.touchFlag(64);
    }

    public boolean isNeedSheetInfo() {
        return this.touchFlag(16);
    }

    public boolean isInnerMethod() {
        return this.touchFlag(256);
    }

    public boolean isExcelMethod() {
        return this.touchFlag(512);
    }

    public boolean isExtensibleMethod() {
        return this.touchFlag(2048);
    }

    public boolean isExtDataSetMethod() {
        return this.touchFlag(4096);
    }

    public boolean isExtFamilyMethod() {
        return this.touchFlag(1024);
    }

    public boolean isDynamicDataSetMethod() {
        return this.touchFlag(16384);
    }

    public boolean isExtField() {
        return this.touchFlag(32768);
    }

    public boolean isMacro() {
        return this.touchFlag(65536);
    }

    public boolean isExtEnableMethod() {
        return this.touchFlag(8192);
    }

    public boolean isFillParameter() {
        return this.touchFlag(32);
    }

    public boolean setFillParameter(boolean fill) {
        if (this._thisInst instanceof IMethodFillParameter) {
            this.setFlag(32, fill);
            return true;
        }
        return false;
    }

    public boolean isLocalMethod() {
        return this.touchFlag(2);
    }

    public boolean isVarietyParams() {
        return this.touchFlag(4);
    }

    public boolean isNeedContext() {
        return this.touchFlag(8);
    }

    public boolean isNeedExpParam() {
        return this.touchFlag(128);
    }

    public Object[] getProperArgs(Object[] args) throws SyntaxErrorException {
        if (this.getParamCount() != args.length) {
            ExprErr.goError(8L, "");
        }
        Object[] properArgs = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            Object param = args[i];
            properArgs[i] = param instanceof Variant ? this.getProperArg((Variant)param, this._paramTypes[i]) : param;
        }
        return properArgs;
    }

    public String toString() {
        return this._method.getName();
    }

    @Override
    public int getExprType() {
        return this.isInnerMethod() ? 256 : 128;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void action(ExprContext ctx, ICalculable exprOwner) throws SyntaxErrorException {
        exprStack = ctx.getCurrentExprStack();
        invoke = this.touchFlag(2) != false && this.touchFlag(1) == false;
        parameterPending = false;
        needContext = this.touchFlag(8);
        uid = invoke != false ? null : (Variant)exprStack.pop();
        traceMode = ctx.isTraceMode();
        step = traceMode != false ? ctx.getTracePos() : 0;
        args = null;
        if (this._paramTypes.length > 0) {
            args = new Object[this._paramTypes.length];
            for (i = this._paramTypes.length - 1; i >= 0; --i) {
                var = (Variant)exprStack.pop();
                args[i] = var;
                if (parameterPending || !var.getVariant().isPending()) continue;
                parameterPending = true;
            }
            if (traceMode && args.length > 0) {
                sv = (TraceVariant)args[0];
                step = sv.getTracePos() - 1;
                if (needContext) {
                    args[0] = sv.getValue();
                }
            }
            v0 = varietyIndex = needContext != false ? 1 : 0;
            if (this.touchFlag(4)) {
                args[varietyIndex] = ((Variant)args[varietyIndex]).getValue();
            } else if (invoke && !parameterPending) {
                for (i = this._paramTypes.length - 1; i >= 0; --i) {
                    args[i] = this.getProperArg((Variant)args[i], this._paramTypes[i]);
                }
            }
        }
        sheet = exprOwner.getSheet();
        ownerStackSize = 0;
        varResult = null;
        try {
            result = null;
            if (!parameterPending) {
                if (invoke) {
                    if (this.isNeedSheetInfo()) {
                        ((INeedSheetInfo)this._thisInst).setSheetName(sheet.getSheetName());
                    }
                    try {
                        if (needContext) {
                            ownerStackSize = ctx.getOwnerStackSize();
                        }
                        if (traceMode) {
                            ctx.setTraceMode(this.isExtFamilyMethod() == false);
                        }
                        result = this._method.invoke(this._thisInst, args);
                        if (!needContext || ownerStackSize <= 0) ** GOTO lbl67
                        ctx.popExprOwner();
                    }
                    finally {
                        if (traceMode) {
                            ctx.setTraceMode(traceMode);
                        }
                    }
                } else {
                    queryManager = sheet.getDeps().getQueryManager();
                    result = queryManager.getValue(this, args, sheet.getSheetName(), uid);
                    if (traceMode && (exprUid = ctx.getExprUid(uid)) != null && null != uid) {
                        exprUid.setObject(uid.getValue());
                    }
                    v1 = isExtBatchMethod = this._thisInst instanceof ExcelFuncProvider != false || this._thisInst instanceof ExtFuncProvider != false || this._thisInst instanceof ExtendFuncProvider != false;
                    if (!isExtBatchMethod && result != null) {
                        decimal = null;
                        try {
                            decimal = new BigDecimal(result.toString());
                            result = new Variant(decimal, 10);
                        }
                        catch (NumberFormatException e) {
                            result = new Variant(result.toString());
                        }
                    }
                }
            }
lbl67:
            // 8 sources

            varResult = parameterPending || !invoke && result == null ? Variant.pendResult : (result instanceof Variant ? (Variant)result : (result instanceof SyntaxErrorException ? new Variant(result, 16) : (result == null ? Variant.nullVariant : new Variant(result))));
        }
        catch (Exception e) {
            if (needContext) {
                ctx.popExprOwnerN(ctx.getOwnerStackSize() - ownerStackSize);
            }
            if (e instanceof InvocationTargetException && ((tar = ((InvocationTargetException)e).getTargetException()) == SyntaxErrorException.CALC_LAST || tar instanceof StackOverflowError)) {
                throw new SyntaxErrorException(0x200000L, "Calc Last", e);
            }
            fm = sheet.getDeps().getFunctionManager();
            obj = ExceptionHandler.handleInvokeException(e, fm);
            if (obj instanceof Variant) {
                exprStack.push(traceMode != false ? new TraceVariant((Variant)obj, step) : obj);
                return;
            }
            ExprErr.goError(128L, obj);
        }
        exprStack.push(traceMode != false ? new TraceVariant(varResult, step) : varResult);
    }

    @Override
    public String decode(ExprContext ctx, ICalculable exprOwner) {
        return this._method.getName();
    }

    private final Object getProperArg(Variant var, Class cls) throws SyntaxErrorException {
        Object obj;
        if (Variant.class.isAssignableFrom(cls)) {
            obj = var;
        } else if (var.isNumber()) {
            obj = cls == Integer.TYPE ? Integer.valueOf(var.intValue()) : (cls == Long.TYPE ? Long.valueOf(var.longValue()) : (cls == Float.TYPE ? Float.valueOf(var.floatValue()) : (cls == Double.TYPE ? Double.valueOf(var.doubleValue()) : (cls == Character.TYPE ? Character.valueOf(var.charValue()) : (cls == Byte.TYPE ? Byte.valueOf(var.byteValue()) : (cls == Integer.class ? Integer.valueOf(var.intValue()) : (cls == Character.class ? Character.valueOf(var.charValue()) : (cls == Short.class ? Short.valueOf(var.shortValue()) : (cls == String.class ? (var.isEmpty() || var.isNull() ? "" : var.getValue().toString()) : var.getValue())))))))));
        } else if (var.isString()) {
            Variant varNumber;
            if (this.isNumericClsType(cls) && var.isNumeric(varNumber = Variant.getNewEmptyVariant())) {
                return this.getProperArg(varNumber, cls);
            }
            obj = var.getValue();
        } else {
            obj = var.getValue();
        }
        return obj;
    }

    private final boolean isNumericClsType(Class cls) {
        return cls.equals(Integer.TYPE) || cls.equals(Long.TYPE) || cls.equals(Float.TYPE) || cls.equals(Double.TYPE) || cls.equals(Character.TYPE) || cls.equals(Byte.TYPE) || cls.equals(Integer.class) || cls.equals(Character.class) || cls.equals(Short.class) || cls.equals(Variant.class);
    }

    static {
        _datasetFuncs.put("FIELD", null);
        _datasetFuncs.put("FIELDS", null);
        _datasetFuncs.put("FIRST", null);
        _datasetFuncs.put("LAST", null);
        _datasetFuncs.put("SELECT1", null);
        _datasetFuncs.put("SELECTEX", null);
        _datasetFuncs.put("SELECT", null);
        _datasetFuncs.put("GROUP", null);
        _datasetFuncs.put("ENUMGROUP", null);
        _datasetFuncs.put("OVERLAP", null);
        _datasetFuncs.put("DISTINCT", null);
        _dynamicDSFuncs = new HashMap();
        _dynamicDSFuncs.put("QUERY", null);
        _dynamicDSFuncs.put("UNION", null);
        _dynamicDSFuncs.put("DS", null);
        _dynamicDSFuncs.put("POSJOIN", null);
        _dynamicDSFuncs.put("TRANSPOSE", null);
        _needExprParamFuncs = new HashMap();
        _needExprParamFuncs.put("DISTINCT", null);
        _needExprParamFuncs.put("ENUMGROUP", null);
        _needExprParamFuncs.put("GROUP", null);
        _needExprParamFuncs.put("OVERLAP", null);
        _needExprParamFuncs.put("SELECT", null);
        _needExprParamFuncs.put("SELECT1", null);
        _needExprParamFuncs.put("TREE", null);
        _needExprParamFuncs.put("EXS", null);
        _needExprParamFuncs.put("FIELDS", null);
        _needExprParamFuncs.put("FIRST", null);
        _needExprParamFuncs.put("LAST", null);
        _needExprParamFuncs.put("AND", null);
        _needExprParamFuncs.put("CASE", null);
        _needExprParamFuncs.put("CHOOSE", null);
        _needExprParamFuncs.put("IF", null);
        _needExprParamFuncs.put("INDEX", null);
        _needExprParamFuncs.put("OR", null);
    }
}

