/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct;

import com.kingdee.cosmic.ctrl.common.util.Password;
import com.kingdee.cosmic.ctrl.extcommon.util.SortedObjectArray;
import com.kingdee.cosmic.ctrl.kds.model.struct.AbstractProtection;
import com.kingdee.cosmic.ctrl.kds.model.struct.CellBlock;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.cosmic.ctrl.kds.model.util.SortedCellBlockArray;
import java.util.ArrayList;
import java.util.HashMap;

public final class Protection
extends AbstractProtection {
    public static final int NUM_ITEMS = 16;
    public static final int SELECT_LOCKED = 1;
    public static final int SELECT_UNLOCKED = 2;
    public static final int FORMAT_CELLS = 4;
    public static final int SIZE_COLS = 8;
    public static final int SIZE_ROWS = 16;
    public static final int INSERT_COLS = 32;
    public static final int INSERT_ROWS = 64;
    public static final int INSERT_HYPERLINKS = 128;
    public static final int DELETE_COLS = 256;
    public static final int DELETE_ROWS = 512;
    public static final int SORT = 1024;
    public static final int AUTO_FILTER = 2048;
    public static final int USE_PIVOTTABLES = 4096;
    public static final int EDIT_OBJECTS = 8192;
    public static final int EDIT_SCENARIOS = 16384;
    public static final int COMMONT = 32768;
    public static final int EDIT_CELL = 65536;
    public static final int UNHIDE_ROWS_Columns = 131072;
    private int _opers;
    private SortedEditalbeAreaArray _editableBlocks;
    private Sheet _sheet;

    public static HashMap getProtectState(Sheet sheet, CellBlock block, int cause) {
        HashMap<String, Comparable> state = new HashMap<String, Comparable>();
        state.put("Sheet", sheet);
        if (block != null) {
            state.put("Block", block);
        }
        state.put("Cause", Integer.valueOf(cause));
        return state;
    }

    Protection(Sheet sheet) {
        this._sheet = sheet;
        this.appendOperation(1);
        this.appendOperation(2);
    }

    @Override
    public void start(String pw) {
        super.start(pw);
    }

    public void copyFrom(Protection pro) {
        this._opers = pro._opers;
        this._isProtected = pro._isProtected;
        this._encryptPW = pro._encryptPW;
        if (pro._editableBlocks != null) {
            this._editableBlocks = new SortedEditalbeAreaArray();
            this._editableBlocks.copyFrom(pro.getEditableBlocks());
        }
    }

    @Override
    protected void customStart() {
        EmbedhLayer gl = this._sheet.getEmbedments(false);
        if (gl != null) {
            gl.cancelSelectedEmbeds();
        }
        if (this._editableBlocks != null) {
            int size = this._editableBlocks.size();
            for (int i = 0; i < size; ++i) {
                EditableArea array = (EditableArea)this._editableBlocks.get(i);
                array.setOpened(false);
            }
        }
        this._sheet.removeRelatedEdits();
        this._sheet.getBook().fireSheetPropertyChange(this._sheet, "", "", "Changed_SheetProtection");
    }

    @Override
    protected void customStop() {
        this._sheet.getBook().fireSheetPropertyChange(this._sheet, "", "", "Changed_SheetProtection");
    }

    public SortedEditalbeAreaArray getEditableBlocks() {
        return this._editableBlocks;
    }

    public EditableArea getEditableArea(String name, boolean create) {
        int index;
        if (this._editableBlocks == null) {
            this._editableBlocks = new SortedEditalbeAreaArray();
            index = -1;
        } else {
            index = this._editableBlocks.searchByName(name);
        }
        if (index < 0) {
            EditableArea ea = null;
            if (create) {
                ea = new EditableArea(name);
                this._editableBlocks.insert(index, ea);
            }
            return ea;
        }
        return (EditableArea)this._editableBlocks.get(index);
    }

    public EditableArea createEditableArea(String name) {
        return new EditableArea(name);
    }

    public void addEditableArea(EditableArea ea) {
        if (this._editableBlocks == null) {
            this._editableBlocks = new SortedEditalbeAreaArray();
        }
        this._editableBlocks.insert(ea);
    }

    public void removeEditableArea(String name) {
        int index;
        if (this._editableBlocks != null && (index = this._editableBlocks.searchByName(name)) >= 0) {
            this._editableBlocks.removeByPos(index);
        }
    }

    public int getOperations() {
        return this._opers;
    }

    public void setOperations(int opers) {
        this._opers = opers;
    }

    public void deleteOperations() {
        this._opers = 0;
    }

    public void appendOperation(int operation) {
        this._opers |= operation;
    }

    public void deleteOperation(int operation) {
        this._opers &= ~operation;
    }

    public boolean hasOperation(int operation) {
        return (this._opers & operation) != 0;
    }

    public boolean allowSelectLocked() {
        return !this._isProtected || (this._opers & 1) != 0;
    }

    public boolean allowSelectUnLocked() {
        return !this._isProtected || (this._opers & 2) != 0;
    }

    public boolean allowFormattingCells() {
        return !this._isProtected || (this._opers & 4) != 0;
    }

    public boolean allowFormattingColumns() {
        return !this._isProtected || (this._opers & 8) != 0;
    }

    public boolean allowFormattingRows() {
        return !this._isProtected || (this._opers & 0x10) != 0;
    }

    public boolean allowInsertingColumns() {
        return !this._isProtected || (this._opers & 0x20) != 0;
    }

    public boolean allowInsertingRows() {
        return !this._isProtected || (this._opers & 0x40) != 0;
    }

    public boolean allowInsertingHyperlinks() {
        return !this._isProtected || (this._opers & 0x80) != 0;
    }

    public boolean allowDeletingColumns() {
        return !this._isProtected || (this._opers & 0x100) != 0;
    }

    public boolean allowDeletingRows() {
        return !this._isProtected || (this._opers & 0x200) != 0;
    }

    public boolean allowSorting() {
        return !this._isProtected || (this._opers & 0x400) != 0;
    }

    public boolean allowFiltering() {
        return !this._isProtected || (this._opers & 0x800) != 0;
    }

    public boolean allowUsingPivotTables() {
        return !this._isProtected || (this._opers & 0x1000) != 0;
    }

    public boolean allowEditObjects() {
        return !this._isProtected || (this._opers & 0x2000) != 0;
    }

    public boolean allowEditScenarios() {
        return !this._isProtected || (this._opers & 0x4000) != 0;
    }

    boolean isEmptyEditBlocks() {
        return this._editableBlocks == null || this._editableBlocks.size() == 0;
    }

    public boolean allowUnhideColumnsACols() {
        return this._isProtected || (this._opers & 0x20000) != 0;
    }

    ArrayList getImpactEditblocks(SortedCellBlockArray result) {
        if (this.isEmptyEditBlocks()) {
            return null;
        }
        ArrayList<EditableArea> al = null;
        SortedCellBlockArray result2 = new SortedCellBlockArray();
        int size = this._editableBlocks.size();
        for (int i = 0; i < size; ++i) {
            EditableArea ea = (EditableArea)this._editableBlocks.get(i);
            ea.split(result, result2);
            if (!result.equals(result2)) {
                if (!ea._isOpened && !ea.confirm("")) {
                    if (al == null) {
                        al = new ArrayList<EditableArea>();
                    }
                    al.add(ea);
                }
                result.clear();
                result.copyFrom(result2);
                result2.clear();
                continue;
            }
            result2.clear();
        }
        return al;
    }

    public static class EditableArea
    extends SortedCellBlockArray
    implements Comparable {
        private boolean _isOpened;
        private String _name;
        private Password _password = new Password();

        public EditableArea(String name) {
            this.setName(name);
        }

        public void copyFrom(EditableArea eba) {
            super.copyFrom(eba);
            this._isOpened = eba._isOpened;
            this._password = eba._password;
            this._name = eba._name;
        }

        public void setName(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public void setPassword(String pw) {
            this._password.setPassword(pw);
        }

        public String getEncryptedPassword() {
            return this._password.getEncryptedPassword();
        }

        public void setEncryptedPassword(String pw) {
            this._password.setEncryptedPassword(pw);
        }

        public boolean confirm(String pw) {
            return this._password.confirm(pw);
        }

        public boolean checkPassword(String pw) {
            if (this.isOpened() || this.confirm(pw)) {
                this.setOpened(true);
                return true;
            }
            return false;
        }

        boolean isOpened() {
            return this._isOpened;
        }

        void setOpened(boolean opened) {
            this._isOpened = opened;
        }

        @Override
        public String toString() {
            return this._name;
        }

        public int compareTo(Object o) {
            if (o instanceof EditableArea) {
                return this._name.compareTo(((EditableArea)o)._name);
            }
            return -1;
        }
    }

    public static class SortedEditalbeAreaArray
    extends SortedObjectArray {
        private static final long serialVersionUID = -3676932094460571793L;

        public void copyFrom(SortedEditalbeAreaArray sa) {
            int size = sa.size();
            for (int i = 0; i < size; ++i) {
                EditableArea array = (EditableArea)sa.get(i);
                EditableArea newArray = new EditableArea(array._name);
                newArray.copyFrom(array);
                this.insert(newArray);
            }
        }

        public int searchByName(String name) {
            if (this.isEmpty()) {
                return -1;
            }
            int low = 0;
            int high = this._count - 1;
            while (low <= high) {
                int mid = low + high >> 1;
                Object midVal = this._array[mid];
                int cmp = ((EditableArea)midVal)._name.compareTo(name);
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            return -(low + 1);
        }
    }
}

