/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct;

import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.cosmic.ctrl.kds.core.ICellDisplayProvider;
import com.kingdee.cosmic.ctrl.kds.core.KDSpread;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadCellTextRender;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.model.expr.Expr;
import com.kingdee.cosmic.ctrl.kds.model.expr.IExprNode;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.CellBlock;
import com.kingdee.cosmic.ctrl.kds.model.struct.MergeBlocks;
import com.kingdee.cosmic.ctrl.kds.model.struct.Position;
import com.kingdee.cosmic.ctrl.kds.model.struct.PrintSetup;
import com.kingdee.cosmic.ctrl.kds.model.struct.Protection;
import com.kingdee.cosmic.ctrl.kds.model.struct.Range;
import com.kingdee.cosmic.ctrl.kds.model.struct.Row;
import com.kingdee.cosmic.ctrl.kds.model.struct.Selection;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.SortedAttributeSpanArray;
import com.kingdee.cosmic.ctrl.kds.model.struct.SortedSpanArray;
import com.kingdee.cosmic.ctrl.kds.model.struct.Span;
import com.kingdee.cosmic.ctrl.kds.model.struct.node.CellBlockNode;
import com.kingdee.cosmic.ctrl.kds.model.util.SortedCellBlockArray;
import com.kingdee.cosmic.ctrl.kds.model.util.SortedSheetArray;
import com.kingdee.cosmic.ctrl.kds.print.PrintBookTrans;
import com.kingdee.cosmic.ctrl.kds.print.PrintManager;
import com.kingdee.cosmic.ctrl.print.KDPrinter;
import com.kingdee.cosmic.ctrl.print.config.PrintJobConfig;
import com.kingdee.cosmic.ctrl.print.printjob.table.SheetPrintJob;
import com.kingdee.cosmic.ctrl.print.util.KDPrinterUtils;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.print.attribute.PrintRequestAttributeSet;

public class SheetBaseMath {
    public static final int EXCEED_MAX_RANGE = -1;
    public static final int UNDER_MIN_RANGE = -2;
    private static Rectangle buffRect = new Rectangle();
    public static int DataType_Number = 0;
    public static int DataType_Boolean = 1;
    public static int DataType_DateTime = 2;
    public static int DataType_Empty = 3;
    public static int DataType_Text = 4;

    public static boolean isSingleCellSelected(Sheet sheet) {
        Range range = sheet.getSelectionRange();
        if (range.size() > 1) {
            return false;
        }
        CellBlock block = range.getBlock(0);
        MergeBlocks mb = sheet.getMerger(false);
        if (block.isSingleCell()) {
            return true;
        }
        return mb != null && mb.isMerged(block);
    }

    public static Position getRightEmptyPosition(Sheet sheet, int row, int col) {
        CellBlock cb;
        Sheet.ICellsIterator iter = sheet.getCellsIterator(row, col + 1, row, 65535, false, true);
        Cell retCell = null;
        while (iter.hasNext()) {
            Cell cell = iter.next();
            if (retCell == null) {
                if (cell.getCol() > col + 1) break;
                retCell = cell;
                continue;
            }
            if (cell.getCol() > retCell.getCol() + 1) break;
            retCell = cell;
        }
        int retCol = col + 1;
        if (retCell != null) {
            retCol = retCell.getCol() + 1;
        }
        if (retCol > 65535) {
            return null;
        }
        MergeBlocks mb = sheet.getSheetOption().getMerger(false);
        if (mb != null && (cb = mb.searchBlock(row, retCol)) != null && !cb.isFirstCell(row, retCol)) {
            return null;
        }
        return new Position(row, retCol);
    }

    public static Position getDownEmptyPosition(Sheet sheet, int row, int col) {
        CellBlock cb;
        Sheet.ICellsIterator iter = sheet.getCellsIterator(row + 1, col, 1048575, col, false, true);
        Cell retCell = null;
        while (iter.hasNext()) {
            Cell cell = iter.next();
            if (retCell == null) {
                if (cell.getRow() > row + 1) break;
                retCell = cell;
                continue;
            }
            if (cell.getRow() > retCell.getRow() + 1) break;
            retCell = cell;
        }
        int retRow = row + 1;
        if (retCell != null) {
            retRow = retCell.getRow() + 1;
        }
        if (retRow > 1048575) {
            return null;
        }
        MergeBlocks mb = sheet.getSheetOption().getMerger(false);
        if (mb != null && (cb = mb.searchBlock(retRow, col)) != null && !cb.isFirstCell(retRow, col)) {
            return null;
        }
        return new Position(retRow, col);
    }

    public static Position getRightDataPosition(Sheet sheet, int row, int col, Position retPos) {
        int maxCol;
        if (retPos == null) {
            retPos = new Position();
        }
        MergeBlocks merger = sheet.getSheetOption().getMerger(false);
        CellBlock mb = null;
        if (merger != null) {
            mb = merger.searchBlock(row, col);
        }
        if (mb != null) {
            col = mb.getCol();
            row = mb.getRow2();
        }
        if (col < (maxCol = SheetBaseMath.getVisibleEndCol(sheet))) {
            SortedAttributeSpanArray colSpans = sheet.getColSpans();
            Cell curCell = sheet.getCell(row, col, false);
            boolean hasData = curCell != null && !curCell.isEmptyContent();
            Cell noEmptyCell = null;
            int emptyNum = 0;
            int ncol = col + 1;
            while (ncol <= maxCol) {
                int index = colSpans.searchSpan(ncol);
                if (index >= 0 && !colSpans.getAttributeSpan(index).isVisible()) {
                    ncol = colSpans.getSpan(index).getEnd() + 1;
                    continue;
                }
                Cell cell = sheet.getCell(row, ncol, false);
                if (cell == null || cell.isEmptyContent()) {
                    ++emptyNum;
                    if (noEmptyCell != null) {
                        ncol = noEmptyCell.getCol();
                        break;
                    }
                    ++ncol;
                    continue;
                }
                noEmptyCell = cell;
                if (emptyNum > 0 || !hasData) {
                    ncol = noEmptyCell.getCol();
                    break;
                }
                ++ncol;
            }
            if (ncol > maxCol) {
                ncol = maxCol;
            }
            col = ncol;
        }
        retPos.setRowCol(row, col);
        return retPos;
    }

    public static Position getLeftDataPosition(Sheet sheet, int row, int col, Position retPos) {
        int minCol;
        if (retPos == null) {
            retPos = new Position();
        }
        MergeBlocks merger = sheet.getSheetOption().getMerger(false);
        CellBlock mb = null;
        if (merger != null) {
            merger.searchBlock(row, col);
        }
        if (mb != null) {
            col = mb.getCol();
            row = mb.getRow();
        }
        if (col > (minCol = SheetBaseMath.getVisibleStartCol(sheet))) {
            int ncol;
            block15: {
                SortedAttributeSpanArray colSpans = sheet.getColSpans();
                Cell curCell = sheet.getCell(row, col, false);
                boolean hasData = curCell != null && !curCell.isEmptyContent();
                ncol = -2;
                int end = minCol;
                int start = col - 1;
                Span[] spans = colSpans.getSpans(end, start);
                if (spans != null) {
                    boolean forFirstNoEmpt = false;
                    for (int i = spans.length - 1; i >= 0; --i) {
                        if (((SortedAttributeSpanArray.AttributeSpan)spans[i]).isVisible()) continue;
                        end = spans[i].getEnd() + 1;
                        if (start >= end) {
                            ncol = SheetBaseMath.getLeftDataPosImpl(hasData, forFirstNoEmpt, sheet, row, end, start);
                            if (ncol > end || ncol >= 0 && (!hasData || hasData && ncol < start)) break block15;
                            if (ncol < 0) {
                                forFirstNoEmpt = true;
                            }
                        }
                        start = spans[i].getStart() - 1;
                    }
                    if (start >= minCol) {
                        int tempcol = SheetBaseMath.getLeftDataPosImpl(hasData, forFirstNoEmpt, sheet, row, minCol, start);
                        if (ncol == -2 || ncol >= 0 && tempcol == start) {
                            ncol = tempcol;
                        }
                    }
                } else {
                    ncol = SheetBaseMath.getLeftDataPosImpl(hasData, false, sheet, row, end, start);
                }
            }
            if (ncol < minCol) {
                ncol = minCol;
            }
            col = ncol;
        }
        retPos.setRowCol(row, col);
        return retPos;
    }

    private static final int getLeftDataPosImpl(boolean hasData, boolean forFirstNoEmpt, Sheet sheet, int row, int end, int start) {
        Cell endCell = null;
        Cell lastCell = null;
        Sheet.ICellsIterator iter = sheet.getCellsIterator(row, end, row, start, true, true);
        while (iter.hasNext()) {
            Cell cell;
            endCell = cell = iter.next();
            if (!hasData || forFirstNoEmpt) {
                return cell.getCol();
            }
            if (lastCell == null) {
                if (cell.getCol() < start) {
                    return cell.getCol();
                }
            } else if (cell.getCol() < lastCell.getCol() - 1) {
                return lastCell.getCol();
            }
            lastCell = cell;
        }
        if (endCell != null) {
            return endCell.getCol();
        }
        return -1;
    }

    public static Position getDownDataPosition(Sheet sheet, int row, int col, Position retPos) {
        int maxRow;
        if (retPos == null) {
            retPos = new Position();
        }
        MergeBlocks merger = sheet.getSheetOption().getMerger(false);
        CellBlock mergeBlock = null;
        if (merger != null) {
            mergeBlock = merger.searchBlock(row, col);
        }
        if (mergeBlock != null) {
            col = mergeBlock.getCol();
            row = mergeBlock.getRow2();
        }
        if (row < (maxRow = SheetBaseMath.getVisibleEndRow(sheet))) {
            SortedAttributeSpanArray rowSpans = sheet.getRowSpans();
            Cell curCell = sheet.getCell(row, col, false);
            boolean hasData = curCell != null && !curCell.isEmptyContent();
            Cell noEmptyCell = null;
            int emptyNum = 0;
            int nrow = row + 1;
            while (nrow <= maxRow) {
                int index = rowSpans.searchSpan(nrow);
                if (index >= 0 && !rowSpans.getAttributeSpan(index).isVisible()) {
                    nrow = rowSpans.getSpan(index).getEnd() + 1;
                    continue;
                }
                Cell cell = sheet.getCell(nrow, col, false);
                if (cell == null || cell.isEmptyContent()) {
                    ++emptyNum;
                    if (noEmptyCell != null) {
                        nrow = noEmptyCell.getRow();
                        break;
                    }
                    ++nrow;
                    continue;
                }
                noEmptyCell = cell;
                if (emptyNum > 0 || !hasData) {
                    nrow = noEmptyCell.getRow();
                    break;
                }
                ++nrow;
            }
            if (nrow > maxRow) {
                nrow = maxRow;
            }
            row = nrow;
        }
        retPos.setRowCol(row, col);
        return retPos;
    }

    public static Position getUpDataPosition(Sheet sheet, int row, int col, Position retPos) {
        int minRow;
        if (retPos == null) {
            retPos = new Position();
        }
        MergeBlocks merger = sheet.getSheetOption().getMerger(false);
        CellBlock mergeBlock = null;
        if (merger != null) {
            mergeBlock = merger.searchBlock(row, col);
        }
        if (mergeBlock != null) {
            col = mergeBlock.getCol();
            row = mergeBlock.getRow();
        }
        if (row > (minRow = SheetBaseMath.getVisibleStartRow(sheet))) {
            SortedAttributeSpanArray rowSpans = sheet.getRowSpans();
            Cell curCell = sheet.getCell(row, col, false);
            boolean hasData = curCell != null && !curCell.isEmptyContent();
            Cell noEmptyCell = null;
            int emptyNum = 0;
            int nrow = row - 1;
            while (nrow >= minRow) {
                int index = rowSpans.searchSpan(nrow);
                if (index >= 0 && !rowSpans.getAttributeSpan(index).isVisible()) {
                    nrow = rowSpans.getSpan(index).getStart() - 1;
                    continue;
                }
                Cell cell = sheet.getCell(nrow, col, false);
                if (cell == null || cell.isEmptyContent()) {
                    ++emptyNum;
                    if (noEmptyCell != null) {
                        nrow = noEmptyCell.getRow();
                        break;
                    }
                    --nrow;
                    continue;
                }
                noEmptyCell = cell;
                if (emptyNum > 0 || !hasData) {
                    nrow = noEmptyCell.getRow();
                    break;
                }
                --nrow;
            }
            if (nrow < minRow) {
                nrow = minRow;
            }
            row = nrow;
        }
        retPos.setRowCol(row, col);
        return retPos;
    }

    public static Position getRightDataPosition(Sheet sheet, int row, int col) {
        return SheetBaseMath.getRightDataPosition(sheet, row, col, new Position());
    }

    public static Position getLeftDataPosition(Sheet sheet, int row, int col) {
        return SheetBaseMath.getLeftDataPosition(sheet, row, col, new Position());
    }

    public static Position getDownDataPosition(Sheet sheet, int row, int col) {
        return SheetBaseMath.getDownDataPosition(sheet, row, col, new Position());
    }

    public static Position getUpDataPosition(Sheet sheet, int row, int col) {
        return SheetBaseMath.getUpDataPosition(sheet, row, col, new Position());
    }

    public static int getVisibleEndCol(Sheet sheet) {
        return SheetBaseMath.getLastVisibleCol(sheet, 65536);
    }

    public static int getVisibleStartCol(Sheet sheet) {
        return SheetBaseMath.getNextVisibleCol(sheet, -1);
    }

    public static int getVisibleEndRow(Sheet sheet) {
        return SheetBaseMath.getLastVisibleRow(sheet, 0x100000);
    }

    public static int getVisibleStartRow(Sheet sheet) {
        return SheetBaseMath.getNextVisibleRow(sheet, -1);
    }

    public static int getNextVisibleCol(Sheet sheet, int col) {
        return SheetBaseMath.getNextVisibleIndex(sheet, col, false);
    }

    public static int getNextVisibleRow(Sheet sheet, int row) {
        return SheetBaseMath.getNextVisibleIndex(sheet, row, true);
    }

    public static int getLastVisibleCol(Sheet sheet, int col) {
        return SheetBaseMath.getLastVisibleIndex(sheet, col, false);
    }

    public static int getLastVisibleRow(Sheet sheet, int row) {
        return SheetBaseMath.getLastVisibleIndex(sheet, row, true);
    }

    private static int getNextVisibleIndex(Sheet sheet, int rangeIndex, boolean bRow) {
        if (rangeIndex < 0) {
            rangeIndex = -1;
        }
        SortedAttributeSpanArray spans = bRow ? sheet.getRowSpans() : sheet.getColSpans();
        int index = spans.searchSpan(++rangeIndex);
        int count = spans.size();
        if (index >= 0) {
            for (int i = index; i < count; ++i) {
                SortedAttributeSpanArray.AttributeSpan span = spans.getAttributeSpan(i);
                int cmp = span.compareToPos(rangeIndex);
                if (cmp != 0 || span.isVisible()) {
                    return rangeIndex;
                }
                rangeIndex = span.getEnd() + 1;
            }
        }
        if (bRow && rangeIndex > 1048575) {
            rangeIndex = 1048575;
        } else if (!bRow && rangeIndex > 65535) {
            rangeIndex = 65535;
        }
        return rangeIndex;
    }

    private static int getLastVisibleIndex(Sheet sheet, int rangeIndex, boolean bRow) {
        if (bRow && rangeIndex > 1048575) {
            rangeIndex = 0x100000;
        } else if (!bRow && rangeIndex > 65535) {
            rangeIndex = 65536;
        }
        SortedAttributeSpanArray spans = bRow ? sheet.getRowSpans() : sheet.getColSpans();
        int index = spans.searchSpan(--rangeIndex);
        if (index >= 0) {
            for (int i = index; i >= 0; --i) {
                SortedAttributeSpanArray.AttributeSpan span = spans.getAttributeSpan(i);
                int cmp = span.compareToPos(rangeIndex);
                if (cmp != 0 || span.isVisible() && span.getLength() > 0) {
                    return rangeIndex;
                }
                rangeIndex = span.getStart() - 1;
            }
        }
        if (rangeIndex < 0) {
            rangeIndex = 0;
        }
        return rangeIndex;
    }

    public static boolean isOutBoundCell(int row, int col) {
        return row < 0 || col < 0 || row > 1048575 || col > 65535;
    }

    public static int getRowSpacing() {
        return 1;
    }

    public static int getColSpacing() {
        return 1;
    }

    public static int getRowSpacing(Sheet sheet, int row) {
        if (SheetBaseMath.isHideRow(sheet, row)) {
            return 0;
        }
        return SheetBaseMath.getRowSpacing();
    }

    public static int getColSpacing(Sheet sheet, int col) {
        if (SheetBaseMath.isHideCol(sheet, col)) {
            return 0;
        }
        return SheetBaseMath.getColSpacing();
    }

    public static boolean isHideRow(Sheet sheet, int row) {
        SortedAttributeSpanArray sa = sheet.getRowSpans();
        int index = sa.searchSpan(row);
        if (index < 0) {
            return false;
        }
        return !sa.getAttributeSpan(index).isVisible();
    }

    public static boolean isHideCol(Sheet sheet, int col) {
        SortedAttributeSpanArray sa = sheet.getColSpans();
        int index = sa.searchSpan(col);
        if (index < 0) {
            return false;
        }
        return !sa.getAttributeSpan(index).isVisible();
    }

    public static int getRowHeight(Sheet sheet, int row) {
        return SheetBaseMath.getRowHeight(sheet, row, true);
    }

    public static int getRowHeight(Sheet sheet, int row, boolean scale) {
        SortedAttributeSpanArray.AttributeSpan span;
        SortedAttributeSpanArray sa = sheet.getRowSpans();
        int index = sa.searchSpan(row);
        int height = index < 0 ? (scale ? sheet.getDefRowHeight() : sheet.getOriginalDefRowHeight()) : ((span = sa.getAttributeSpan(index)).isVisible() ? (scale ? span.getLength() : span.getOriginalLength()) : 0);
        return height;
    }

    public static int getColWidth(Sheet sheet, int col) {
        return SheetBaseMath.getColWidth(sheet, col, true);
    }

    public static int getColWidth(Sheet sheet, int col, boolean scale) {
        SortedAttributeSpanArray.AttributeSpan span;
        SortedAttributeSpanArray sa = sheet.getColSpans();
        int index = sa.searchSpan(col);
        int width = index < 0 ? (scale ? sheet.getDefColWidth() : sheet.getOriginalDefColWidth()) : ((span = sa.getAttributeSpan(index)).isVisible() ? (scale ? span.getLength() : span.getOriginalLength()) : 0);
        return width;
    }

    public static int getRowY(Sheet sheet, int row) {
        return SheetBaseMath.getRowY(sheet, row, true);
    }

    public static int getRowY(Sheet sheet, int row, boolean scale) {
        SortedAttributeSpanArray rowSpans = sheet.getRowSpans();
        int y = 0;
        int index = rowSpans.searchSpan(row);
        if (index < 0) {
            int numDefRows = row;
            int numHideRows = 0;
            for (int i = 0; i < -(index + 1); ++i) {
                SortedAttributeSpanArray.AttributeSpan span = rowSpans.getAttributeSpan(i);
                int num = span.getExtent();
                numDefRows -= num;
                if (span.isVisible()) {
                    y += num * (scale ? span.getLength() : span.getOriginalLength());
                    continue;
                }
                numHideRows += num;
            }
            y += numDefRows * (scale ? sheet.getDefRowHeight() : sheet.getOriginalDefRowHeight());
            y += (row - numHideRows) * SheetBaseMath.getRowSpacing();
        } else {
            int numDefRows = row;
            int numHideRows = 0;
            for (int i = 0; i < index; ++i) {
                SortedAttributeSpanArray.AttributeSpan span = rowSpans.getAttributeSpan(i);
                int num = span.getExtent();
                numDefRows -= num;
                if (span.isVisible()) {
                    y += num * (scale ? span.getLength() : span.getOriginalLength());
                    continue;
                }
                numHideRows += num;
            }
            SortedAttributeSpanArray.AttributeSpan curSpan = rowSpans.getAttributeSpan(index);
            int curNum = row - curSpan.getStart();
            numDefRows -= curNum;
            if (curSpan.isVisible()) {
                y += curNum * (scale ? curSpan.getLength() : curSpan.getOriginalLength());
            } else {
                numHideRows += curNum;
            }
            y += numDefRows * (scale ? sheet.getDefRowHeight() : sheet.getOriginalDefRowHeight());
            y += (row - numHideRows) * SheetBaseMath.getRowSpacing();
        }
        return y;
    }

    public static int getColX(Sheet sheet, int col) {
        return SheetBaseMath.getColX(sheet, col, true);
    }

    public static int getColX(Sheet sheet, int col, boolean scale) {
        SortedAttributeSpanArray colSpans = sheet.getColSpans();
        int x = 0;
        int index = colSpans.searchSpan(col);
        if (index < 0) {
            int numDefCols = col;
            int numHideCols = 0;
            for (int i = 0; i < -(index + 1); ++i) {
                SortedAttributeSpanArray.AttributeSpan span = colSpans.getAttributeSpan(i);
                int num = span.getExtent();
                numDefCols -= num;
                if (span.isVisible()) {
                    x += num * (scale ? span.getLength() : span.getOriginalLength());
                    continue;
                }
                numHideCols += num;
            }
            x += numDefCols * (scale ? sheet.getDefColWidth() : sheet.getOriginalDefColWidth());
            x += (col - numHideCols) * SheetBaseMath.getColSpacing();
        } else {
            int numDefRows = col;
            int numHideRows = 0;
            for (int i = 0; i < index; ++i) {
                SortedAttributeSpanArray.AttributeSpan span = colSpans.getAttributeSpan(i);
                int num = span.getExtent();
                numDefRows -= num;
                if (span.isVisible()) {
                    x += num * (scale ? span.getLength() : span.getOriginalLength());
                    continue;
                }
                numHideRows += num;
            }
            SortedAttributeSpanArray.AttributeSpan curSpan = colSpans.getAttributeSpan(index);
            int curNum = col - curSpan.getStart();
            numDefRows -= curNum;
            if (curSpan.isVisible()) {
                x += curNum * (scale ? curSpan.getLength() : curSpan.getOriginalLength());
            } else {
                numHideRows += curNum;
            }
            x += numDefRows * (scale ? sheet.getDefColWidth() : sheet.getOriginalDefColWidth());
            x += (col - numHideRows) * SheetBaseMath.getColSpacing();
        }
        return x;
    }

    public static int rowAtPoint(Sheet sheet, Point2D point) {
        int py = (int)point.getY();
        if (py < -1) {
            return -2;
        }
        SortedAttributeSpanArray rowSpans = sheet.getRowSpans();
        int defRowHeight = sheet.getDefRowHeight();
        if (rowSpans.isEmpty()) {
            int row = (py + 1) / (defRowHeight + SheetBaseMath.getRowSpacing());
            if (row <= 1048575) {
                return row;
            }
        } else {
            int curY = -1;
            SortedAttributeSpanArray.AttributeSpan firstSpan = rowSpans.getAttributeSpan(0);
            if (firstSpan.getStart() != 0 && (curY += firstSpan.getStart() * (defRowHeight + SheetBaseMath.getRowSpacing())) > py) {
                int row = (py + 1) / (defRowHeight + SheetBaseMath.getRowSpacing());
                return row;
            }
            int count = rowSpans.size();
            for (int i = 0; i < count; ++i) {
                SortedAttributeSpanArray.AttributeSpan span = rowSpans.getAttributeSpan(i);
                if (span.isVisible()) {
                    int oldY = curY;
                    if ((curY += span.getExtent() * (span.getLength() + SheetBaseMath.getRowSpacing())) > py) {
                        int row = span.getStart() + (py - oldY) / (span.getLength() + SheetBaseMath.getRowSpacing());
                        return row;
                    }
                }
                int defaultNums = 0;
                SortedAttributeSpanArray.AttributeSpan span2 = null;
                if (i < count - 1) {
                    span2 = rowSpans.getAttributeSpan(i + 1);
                    defaultNums = span2.getStart() - span.getEnd() - 1;
                } else {
                    defaultNums = 1048575 - span.getEnd();
                }
                int oldY = curY;
                if ((curY += defaultNums * (defRowHeight + SheetBaseMath.getRowSpacing())) > py) {
                    int row = span.getEnd() + 1 + (py - oldY) / (defRowHeight + SheetBaseMath.getRowSpacing());
                    return row;
                }
                if (curY != py) continue;
                if (span2 == null) {
                    return 1048575;
                }
                if (!span2.isVisible()) {
                    int row = span2.getEnd() + 1;
                    if (row > 1048575) {
                        row = 1048575;
                    }
                    return row;
                }
                return span2.getStart();
            }
        }
        return -1;
    }

    public static int colAtPoint(Sheet sheet, Point2D point) {
        int px = (int)point.getX();
        if (px < -1) {
            return -2;
        }
        SortedAttributeSpanArray colSpans = sheet.getColSpans();
        int defColW = sheet.getDefColWidth();
        if (colSpans.isEmpty()) {
            int col = (px + 1) / (defColW + SheetBaseMath.getColSpacing());
            if (col <= 65535) {
                return col;
            }
        } else {
            int curX = -1;
            SortedAttributeSpanArray.AttributeSpan firstSpan = colSpans.getAttributeSpan(0);
            if (firstSpan.getStart() != 0 && (curX += firstSpan.getStart() * (defColW + SheetBaseMath.getColSpacing())) > px) {
                int col = (px + 1) / (defColW + SheetBaseMath.getColSpacing());
                return col;
            }
            for (int i = 0; i < colSpans.size(); ++i) {
                SortedAttributeSpanArray.AttributeSpan span = colSpans.getAttributeSpan(i);
                if (span.isVisible()) {
                    int oldX = curX;
                    if ((curX += span.getExtent() * (span.getLength() + SheetBaseMath.getColSpacing())) > px) {
                        int col = span.getStart() + (px - oldX) / (span.getLength() + SheetBaseMath.getColSpacing());
                        return col;
                    }
                }
                int defaultNums = 0;
                SortedAttributeSpanArray.AttributeSpan span2 = null;
                if (i < colSpans.size() - 1) {
                    span2 = colSpans.getAttributeSpan(i + 1);
                    defaultNums = span2.getStart() - span.getEnd() - 1;
                } else {
                    defaultNums = 65535 - span.getEnd();
                }
                int oldX = curX;
                if ((curX += defaultNums * (defColW + SheetBaseMath.getColSpacing())) > px) {
                    int col = span.getEnd() + 1 + (px - oldX) / (defColW + SheetBaseMath.getColSpacing());
                    return col;
                }
                if (curX != px) continue;
                if (span2 == null) {
                    return 65535;
                }
                if (!span2.isVisible()) {
                    int col = span2.getEnd() + 1;
                    if (col > 65535) {
                        col = 65535;
                    }
                    return col;
                }
                return span2.getStart();
            }
        }
        return -1;
    }

    public static int dealInvalidRow(int row) {
        if (row == -1) {
            return 1048575;
        }
        if (row == -2) {
            return 0;
        }
        return row;
    }

    public static int dealInvalidCol(int col) {
        if (col == -1) {
            return 65535;
        }
        if (col == -2) {
            return 0;
        }
        return col;
    }

    public static int getRowInterval(Sheet sheet, int startRow, int endRow) {
        if (startRow == endRow) {
            return 0;
        }
        int maxRow = Math.max(endRow, startRow);
        int minRow = Math.min(endRow, startRow);
        int interval = SheetBaseMath.getRowY(sheet, maxRow) - SheetBaseMath.getRowY(sheet, minRow);
        return endRow > startRow ? interval : -interval;
    }

    public static int getColInterval(Sheet sheet, int startCol, int endCol) {
        if (startCol == endCol) {
            return 0;
        }
        int maxCol = Math.max(endCol, startCol);
        int minCol = Math.min(endCol, startCol);
        int interval = SheetBaseMath.getColX(sheet, maxCol) - SheetBaseMath.getColX(sheet, minCol);
        return endCol > startCol ? interval : -interval;
    }

    public static String getColumnName(Sheet sheet, int col) {
        return SheetBaseMath.getColumnName(col, 0, true, false);
    }

    public static String getRowName(Sheet sheet, int row) {
        return SheetBaseMath.getRowName(row, 0, true, false);
    }

    public static Rectangle getActualCellRect(Sheet sheet, int row, int col, boolean includeSpacing) {
        return SheetBaseMath.getActualCellRect(sheet, row, col, includeSpacing, new Rectangle());
    }

    public static Rectangle getActualCellRect(Sheet sheet, int row, int col, boolean includeSpacing, Rectangle retRect) {
        MergeBlocks merger = sheet.getSheetOption().getMerger(false);
        CellBlock mergeBlock = null;
        if (merger != null) {
            mergeBlock = merger.searchBlock(row, col);
        }
        if (mergeBlock != null) {
            return SheetBaseMath.getBlockRect(sheet, mergeBlock, includeSpacing, retRect);
        }
        return SheetBaseMath.getCellRect(sheet, row, col, includeSpacing, retRect);
    }

    public static Rectangle getCellRect(Sheet sheet, int row, int col, boolean includeSpacing) {
        return SheetBaseMath.getCellRect(sheet, row, col, includeSpacing, new Rectangle());
    }

    public static Rectangle getCellRect(Sheet sheet, int row, int col, boolean includeSpacing, Rectangle retRect) {
        int x = SheetBaseMath.getColX(sheet, col);
        int y = SheetBaseMath.getRowY(sheet, row);
        int w = SheetBaseMath.getColWidth(sheet, col);
        int h = SheetBaseMath.getRowHeight(sheet, row);
        if (includeSpacing) {
            retRect.setRect(x - 1, y - 1, w + 2 * SheetBaseMath.getColSpacing(), h + 2 * SheetBaseMath.getRowSpacing());
        } else {
            retRect.setRect(x, y, w, h);
        }
        return retRect;
    }

    public static Rectangle getBlockRect(Sheet sheet, CellBlock sb, boolean includeSpacing) {
        return SheetBaseMath.getBlockRect(sheet, sb, includeSpacing, new Rectangle());
    }

    public static Rectangle getBlockRect(Sheet sheet, CellBlock sb, boolean includeSpacing, Rectangle retRect) {
        return SheetBaseMath.getBlockRect(sheet, sb.getRow(), sb.getCol(), sb.getRow2(), sb.getCol2(), includeSpacing, retRect);
    }

    public static Rectangle getBlockRect(Sheet sheet, int row, int col, int row2, int col2, boolean includeSpacing) {
        return SheetBaseMath.getBlockRect(sheet, row, col, row2, col2, includeSpacing, new Rectangle());
    }

    public static Rectangle getBlockRect(Sheet sheet, int row, int col, int row2, int col2, boolean includeSpacing, Rectangle retRect) {
        if (row == row2 && col == col2) {
            return SheetBaseMath.getCellRect(sheet, row, col, includeSpacing, retRect);
        }
        int x1 = SheetBaseMath.getColX(sheet, col);
        int y1 = SheetBaseMath.getRowY(sheet, row);
        int x2 = col2 < 65535 ? SheetBaseMath.getColX(sheet, col2 + 1) - 2 : SheetBaseMath.getColX(sheet, col2) + SheetBaseMath.getColWidth(sheet, col2) - 1;
        int y2 = row2 < 1048575 ? SheetBaseMath.getRowY(sheet, row2 + 1) - 2 : SheetBaseMath.getRowY(sheet, row2) + SheetBaseMath.getRowHeight(sheet, row2) - 1;
        int w = x2 - x1 + 1;
        int h = y2 - y1 + 1;
        if (includeSpacing) {
            retRect.setRect(x1 - 1, y1 - 1, w + 2 * SheetBaseMath.getColSpacing(), h + 2 * SheetBaseMath.getRowSpacing());
        } else {
            retRect.setRect(x1, y1, w, h);
        }
        return retRect;
    }

    public static Rectangle getSelectionFillRect(Sheet sheet, CellBlock sb, Rectangle retRect) {
        retRect = SheetBaseMath.getBlockRect(sheet, sb, true, retRect);
        retRect = SheetBaseMath.bufferRect(retRect, 3, 3, -6, -6);
        return retRect;
    }

    public static Rectangle getSelectionFillRect(Sheet sheet, CellBlock sb) {
        return SheetBaseMath.getSelectionFillRect(sheet, sb, new Rectangle());
    }

    public static Area getSelectionArea(Sheet sheet) {
        Selection selection = sheet.getSheetOption().getSelection();
        Area area = new Area();
        Selection.SelectIterator it = selection.getSelectIterator();
        while (it.hasNext()) {
            CellBlock sb = it.next();
            buffRect = SheetBaseMath.getSelectionFillRect(sheet, sb, buffRect);
            area.add(new Area(buffRect));
        }
        return area;
    }

    public static Rectangle getRowHeaderRect(Sheet sheet, int row) {
        return SheetBaseMath.getRowHeaderRect(sheet, row, new Rectangle());
    }

    public static Rectangle getRowHeaderRect(Sheet sheet, int row, Rectangle retRect) {
        boolean x = false;
        int y = SheetBaseMath.getRowY(sheet, row);
        int w = sheet.getRowHeaderWidth();
        int h = SheetBaseMath.getRowHeight(sheet, row);
        retRect.setRect((double)x, y, w, h += 2 * SheetBaseMath.getRowSpacing());
        return retRect;
    }

    public static Rectangle getColHeaderRect(Sheet sheet, int col) {
        return SheetBaseMath.getColHeaderRect(sheet, col, new Rectangle());
    }

    public static Rectangle getColHeaderRect(Sheet sheet, int col, Rectangle retRect) {
        int x = SheetBaseMath.getColX(sheet, col);
        boolean y = false;
        int w = SheetBaseMath.getColWidth(sheet, col);
        int h = sheet.getColHeaderHeight();
        retRect.setRect(x, (double)y, w += 2 * SheetBaseMath.getColSpacing(), h);
        return retRect;
    }

    public static Rectangle getSelectionRect(Sheet sheet, CellBlock sb, Rectangle retRect) {
        retRect = SheetBaseMath.getBlockRect(sheet, sb, true, retRect);
        retRect = SheetBaseMath.bufferRect(retRect, -2, -2, 4, 4);
        return retRect;
    }

    public static Rectangle getSelectionRect(Sheet sheet, CellBlock sb) {
        Rectangle retRect = SheetBaseMath.getBlockRect(sheet, sb, true);
        retRect = SheetBaseMath.bufferRect(retRect, -2, -2, 4, 4);
        return retRect;
    }

    public static Rectangle getSelectionCornerRect(int viewX, int viewY, Rectangle blockRect, boolean isRow, boolean isCol, Rectangle retRect) {
        int x = blockRect.x;
        int y = blockRect.y;
        int w = blockRect.width;
        int h = blockRect.height;
        if (isRow) {
            retRect.setRect(Math.max(x, viewX) + 1, y + h - 3, 5.0, 5.0);
        } else if (isCol) {
            retRect.setRect(x + w - 3, Math.max(y, viewY) + 1, 5.0, 5.0);
        } else {
            retRect.setRect(x + w - 3, y + h - 3, 5.0, 5.0);
        }
        return retRect;
    }

    public static Rectangle getSelectionLeftRect(Rectangle blockRect, boolean isRow, boolean isCol, Rectangle retRect) {
        if (retRect == null) {
            retRect = new Rectangle();
        }
        int x = blockRect.x;
        int y = blockRect.y;
        int h = blockRect.height;
        retRect.setRect(x - 1, y + 2, 3.0, h - 4);
        return retRect;
    }

    public static Rectangle getSelectionTopRect(Rectangle blockRect, boolean isRow, boolean isCol, Rectangle retRect) {
        if (retRect == null) {
            retRect = new Rectangle();
        }
        int x = blockRect.x;
        int y = blockRect.y;
        int w = blockRect.width;
        retRect.setRect(x - 1, y - 1, w + 2, 3.0);
        return retRect;
    }

    public static Rectangle getSelectionRightRect(int viewY, Rectangle blockRect, boolean isRow, boolean isCol, Rectangle retRect) {
        if (retRect == null) {
            retRect = new Rectangle();
        }
        int x = blockRect.x;
        int y = blockRect.y;
        int w = blockRect.width;
        int h = blockRect.height;
        if (isRow) {
            retRect.setRect(x + w - 2, y + 2, 3.0, h - 4);
        } else if (isCol) {
            retRect.setRect(x + w - 2, Math.max(y, viewY), 3.0, y + h - Math.max(y, viewY) - 4);
        } else {
            retRect.setRect(x + w - 2, y + 2, 3.0, h - 6);
        }
        return retRect;
    }

    public static Rectangle getSelectionBottomRect(int viewX, Rectangle blockRect, boolean isRow, boolean isCol, Rectangle retRect) {
        if (retRect == null) {
            retRect = new Rectangle();
        }
        int x = blockRect.x;
        int y = blockRect.y;
        int w = blockRect.width;
        int h = blockRect.height;
        if (isRow) {
            retRect.setRect(Math.max(x, viewX), y + h - 2, x + w - Math.max(x, viewX) - 4, 3.0);
        } else if (isCol) {
            retRect.setRect(x - 1, y + h - 2, w - 3, 3.0);
        } else {
            retRect.setRect(x - 1, y + h - 2, w - 3, 3.0);
        }
        return retRect;
    }

    public static Rectangle getSelectionCornerRect(int viewX, int viewY, Rectangle blockRect, boolean isRow, boolean isCol) {
        return SheetBaseMath.getSelectionCornerRect(viewX, viewY, blockRect, isRow, isCol, new Rectangle());
    }

    public static Rectangle getSelectionLeftRect(Rectangle blockRect, boolean isRow, boolean isCol) {
        return SheetBaseMath.getSelectionLeftRect(blockRect, isRow, isCol, new Rectangle());
    }

    public static Rectangle getSelectionTopRect(Rectangle blockRect, boolean isRow, boolean isCol) {
        return SheetBaseMath.getSelectionTopRect(blockRect, isRow, isCol, new Rectangle());
    }

    public static Rectangle getSelectionRightRect(int viewY, Rectangle blockRect, boolean isRow, boolean isCol) {
        return SheetBaseMath.getSelectionRightRect(viewY, blockRect, isRow, isCol, new Rectangle());
    }

    public static Rectangle getSelectionBottomRect(int viewX, Rectangle blockRect, boolean isRow, boolean isCol) {
        return SheetBaseMath.getSelectionBottomRect(viewX, blockRect, isRow, isCol, new Rectangle());
    }

    public static int getSheetHeight(Sheet sheet) {
        return SheetBaseMath.getRowHeight(sheet, 1048575) + SheetBaseMath.getRowSpacing(sheet, 1048575) + SheetBaseMath.getRowY(sheet, 1048575);
    }

    public static int getSheetWidth(Sheet sheet) {
        return SheetBaseMath.getColWidth(sheet, 65535) + SheetBaseMath.getColSpacing(sheet, 65535) + SheetBaseMath.getColX(sheet, 65535);
    }

    public static Rectangle bufferRect(Rectangle rect, int dx, int dy, int dw, int dh) {
        rect.setRect(rect.getX() + (double)dx, rect.getY() + (double)dy, rect.getWidth() + (double)dw, rect.getHeight() + (double)dh);
        return rect;
    }

    public static Rectangle scaleRect(Rectangle rect, double scale) {
        rect.setRect(rect.getX() * scale, rect.getY() * scale, rect.getWidth() * scale, rect.getHeight() * scale);
        return rect;
    }

    public static String getColumnName(int col, int base, boolean bA1Style, boolean abs) {
        if (bA1Style) {
            col = abs ? ++col : (col += base + 1);
            char[] name = new char[8];
            int i = name.length;
            while (col > 0) {
                name[--i] = (char)(65 + (col - 1) % 26);
                col = (col - 1) / 26;
            }
            if (abs) {
                name[--i] = 36;
            }
            return new String(name, i, name.length - i);
        }
        StringBuilder sb = new StringBuilder(10);
        sb.append('C');
        if (abs) {
            sb.append(col + 1);
        } else if (col != base) {
            sb.append('[');
            sb.append(col - base);
            sb.append(']');
        }
        return sb.toString();
    }

    public static int getColumnIndexByName(String name) {
        int index = 0;
        char[] chars = name.toCharArray();
        int rate = 1;
        char A = 'A';
        for (int i = chars.length - 1; i >= 0; --i) {
            char bit = chars[i];
            if (bit < A || bit > 'z') {
                return -1;
            }
            index += (bit - A + 1) * rate;
            rate *= 26;
        }
        return --index;
    }

    public static String getRowName(int row, int base, boolean bA1Style, boolean abs) {
        StringBuilder sb = new StringBuilder();
        if (bA1Style) {
            if (abs) {
                sb.append('$');
            } else {
                row += base;
            }
            sb.append(row + 1);
        } else {
            sb.append('R');
            if (abs) {
                sb.append(row + 1);
            } else if (row != base) {
                sb.append('[');
                sb.append(row - base);
                sb.append(']');
            }
        }
        return sb.toString();
    }

    public static final String getBlockName(int row, int col, int row2, int col2, boolean bA1Style, boolean absRow, boolean absCol) {
        boolean isAll;
        StringBuilder sb = new StringBuilder();
        boolean isRow = col == 0 && col2 == 65535;
        boolean isCol = row == 0 && row2 == 1048575;
        boolean bl = isAll = isRow && isCol;
        if (bA1Style) {
            if (!isRow) {
                sb.append(SheetBaseMath.getColumnName(col, 0, bA1Style, absCol));
            }
            if (!isCol || isAll) {
                sb.append(SheetBaseMath.getRowName(row, 0, bA1Style, absRow));
            }
            if (row != row2 || col != col2) {
                sb.append(':');
                if (!isRow) {
                    sb.append(SheetBaseMath.getColumnName(col2, 0, bA1Style, absCol));
                }
                if (!isCol || isAll) {
                    sb.append(SheetBaseMath.getRowName(row2, 0, bA1Style, absRow));
                }
            }
        } else {
            if (!isCol || isAll) {
                sb.append(SheetBaseMath.getRowName(row, 0, bA1Style, absRow));
            }
            if (!isRow) {
                sb.append(SheetBaseMath.getColumnName(col, 0, bA1Style, absCol));
            }
            if (row != row2 || col != col2) {
                sb.append(':');
                if (!isCol || isAll) {
                    sb.append(SheetBaseMath.getRowName(row2, 0, bA1Style, absRow));
                }
                if (!isRow) {
                    sb.append(SheetBaseMath.getColumnName(col2, 0, bA1Style, absCol));
                }
            }
        }
        return sb.toString();
    }

    public static final String getBlockName(int row, int col, boolean bA1Style, boolean absRow, boolean absCol) {
        return SheetBaseMath.getBlockName(row, col, row, col, bA1Style, absRow, absCol);
    }

    public static final String getBlockName(CellBlock cb, boolean bA1Style, boolean abs) {
        return SheetBaseMath.getBlockName(cb._row, cb._col, cb._row2, cb._col2, bA1Style, abs, abs);
    }

    public static final String getBlockA1Name(int row, int col, boolean absRow, boolean absCol) {
        return SheetBaseMath.getBlockName(row, col, row, col, true, absRow, absCol);
    }

    public static final String getBlockA1Name(int row, int col, int row2, int col2, boolean abs) {
        return SheetBaseMath.getBlockName(row, col, row2, col2, true, abs, abs);
    }

    public static final String getBlockA1Name(CellBlock cb, boolean abs) {
        return SheetBaseMath.getBlockName(cb, true, abs);
    }

    public static final String getBlocksA1Name(SortedCellBlockArray sa, boolean abs) {
        return SheetBaseMath.getBlocksName(sa, true, abs);
    }

    public static final String getBlocksA1Name(CellBlock[] blocks, boolean abs) {
        return SheetBaseMath.getBlocksName(blocks, true, abs);
    }

    public static final String getBlocksA1Name(ArrayList blocks, boolean abs) {
        return SheetBaseMath.getBlocksName(blocks, true, abs);
    }

    public static final String getBlocksName(SortedCellBlockArray sa, boolean bA1Style, boolean abs) {
        int size = sa.size();
        CellBlock[] cbs = new CellBlock[size];
        for (int i = 0; i < size; ++i) {
            cbs[i] = sa.getBlock(i);
        }
        return SheetBaseMath.getBlocksName(cbs, bA1Style, abs);
    }

    public static final String getBlocksName(ArrayList blocks, boolean bA1Style, boolean abs) {
        StringBuilder sb = new StringBuilder();
        int size = blocks.size();
        for (int i = 0; i < size; ++i) {
            CellBlock cb = (CellBlock)blocks.get(i);
            sb.append(SheetBaseMath.getBlockName(cb._row, cb._col, cb._row2, cb._col2, bA1Style, abs, abs));
            sb.append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public static final String getBlocksName(CellBlock[] blocks, boolean bA1Style, boolean abs) {
        StringBuilder sb = new StringBuilder();
        for (CellBlock cb : blocks) {
            sb.append(SheetBaseMath.getBlockName(cb._row, cb._col, cb._row2, cb._col2, bA1Style, abs, abs));
            sb.append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public static final ArrayList getListBlocks(Sheet sheet, String formula, boolean a1Style) {
        boolean old = sheet.getDeps().isA1Style();
        if (old != a1Style) {
            sheet.getDeps().setA1Style(a1Style);
        }
        Expr expr = sheet.getExpr(null, formula);
        sheet.getDeps().setA1Style(old);
        IExprNode[] nodes = expr.getExprParams().getNodes();
        ArrayList<CellBlock> al = null;
        int len = nodes.length;
        for (int i = 0; i < len; ++i) {
            if (!(nodes[i] instanceof CellBlockNode)) continue;
            if (al == null) {
                al = new ArrayList<CellBlock>();
            }
            CellBlockNode cb = (CellBlockNode)nodes[i];
            al.add(CellBlock.getCellBlock(cb.getRow(), cb.getCol(), cb.getRow2(), cb.getCol2()));
        }
        return al;
    }

    public static final CellBlock[] getArrayBlocks(Sheet sheet, String formula, boolean a1Style) {
        ArrayList list = SheetBaseMath.getListBlocks(sheet, formula, a1Style);
        if (list == null) {
            return null;
        }
        return list.toArray(new CellBlock[0]);
    }

    public static final SortedCellBlockArray getSortedBlocks(Sheet sheet, String formula, boolean a1Style) {
        SortedCellBlockArray sa = new SortedCellBlockArray();
        sa.insertAll(SheetBaseMath.getArrayBlocks(sheet, formula, a1Style));
        return sa;
    }

    public static final ArrayList getListBlockNodes(Sheet sheet, String formula, boolean a1Style) {
        boolean old = sheet.getDeps().isA1Style();
        if (old != a1Style) {
            sheet.getDeps().setA1Style(a1Style);
        }
        Expr expr = sheet.getExpr(null, formula);
        sheet.getDeps().setA1Style(old);
        IExprNode[] nodes = expr.getExprParams().getNodes();
        ArrayList<IExprNode> al = null;
        int len = nodes.length;
        for (int i = 0; i < len; ++i) {
            if (!(nodes[i] instanceof CellBlockNode)) continue;
            if (al == null) {
                al = new ArrayList<IExprNode>();
            }
            al.add(nodes[i]);
        }
        return al;
    }

    public static final CellBlockNode[] getArrayBlockNodes(Sheet sheet, String formula, boolean a1Style) {
        ArrayList blockNodes = SheetBaseMath.getListBlockNodes(sheet, formula, a1Style);
        if (null != blockNodes) {
            return blockNodes.toArray(new CellBlockNode[0]);
        }
        return new CellBlockNode[0];
    }

    public static final SortedCellBlockArray getSortedBlockNodes(Sheet sheet, String formula, boolean a1Style) {
        SortedCellBlockArray sa = new SortedCellBlockArray();
        sa.insertAll(SheetBaseMath.getArrayBlockNodes(sheet, formula, a1Style));
        return sa;
    }

    public static final float getMaxRowHeight(Graphics2D g2d, KDSpread spread, Row row) {
        if (g2d == null) {
            return 0.0f;
        }
        Sheet.ICellsIterator iter = row.getCellsIterator(0, 65535, false, true);
        Sheet sheet = spread.getBook().getActiveSheet();
        int viewMode = sheet.getSheetOption().getCellDisplayMode();
        ICellDisplayProvider prov = spread.getCellDisplayProvider();
        float height = 0.0f;
        while (iter.hasNext()) {
            Cell cell = iter.next();
            FontMetrics fm = g2d.getFontMetrics((Font)cell.getStyle().getKDFont());
            Object value = prov.getBaseValue(cell, viewMode);
            if (!(value instanceof String)) continue;
            if (cell.getStyle().isWrapText()) {
                IBasicRender cellRender = prov.getBaseRender(cell, viewMode);
                if (!(cellRender instanceof SpreadCellTextRender)) continue;
                Rectangle rect = SheetBaseMath.getActualCellRect(sheet, cell.getRow(), cell.getCol(), false);
                rect.x = 0;
                rect.y = 0;
                float h = ((SpreadCellTextRender)cellRender).getPreferredHeight(g2d, rect, value, cell.getStyle());
                CellBlock block = sheet.getMergeBlock(cell);
                if (block != null) {
                    for (int i = cell.getRow() + 1; i <= block.getRow2(); ++i) {
                        h -= (float)SheetBaseMath.getRowHeight(sheet, i, true);
                    }
                }
                if (!(h > height)) continue;
                height = h;
                continue;
            }
            int h = fm.getHeight();
            int rotate = cell.getStyle().getRotation();
            if (rotate != 0) {
                int w = fm.stringWidth(cell.getText());
                if (Math.abs(rotate) == 90) {
                    h = w;
                } else {
                    double angel = Math.PI * (double)rotate / 180.0;
                    h = (int)((double)w * Math.cos(angel));
                }
            }
            if (!((float)h > height)) continue;
            height = h;
        }
        return height;
    }

    public static int detectRangeTitle(SpreadContext _context) {
        Sheet sheet = _context.getSpread().getBook().getActiveSheet();
        CellBlock cb = sheet.getSelectionRange().getBlock(0);
        int cbRow = cb.getRow();
        int cbCol = cb.getCol();
        int cbCol2 = cb.getCol2();
        int detectStatus = -1;
        if (cb.isSingleCol()) {
            Cell firstCell = sheet.getCell(cbRow, cbCol, false);
            int firstCellType = SheetBaseMath.getCellValueType(firstCell);
            Cell nextCell = sheet.getCell(cbRow + 1, cbCol, false);
            if (firstCellType != DataType_Empty && !SheetBaseMath.isDataTypeEqual(firstCell, nextCell)) {
                detectStatus = 0;
            } else {
                Cell prevCell = sheet.getCell(cbRow - 1, cbCol, false);
                int prevCellType = SheetBaseMath.getCellValueType(prevCell);
                if (prevCellType != DataType_Empty && !SheetBaseMath.isDataTypeEqual(prevCell, firstCell)) {
                    detectStatus = 1;
                }
            }
        } else if (cbCol2 - cbCol == 1) {
            Cell firstCell1 = sheet.getCell(cbRow, cbCol, false);
            int firstCellType1 = SheetBaseMath.getCellValueType(firstCell1);
            Cell firstCell2 = sheet.getCell(cbRow, cbCol + 1, false);
            int firstCellType2 = SheetBaseMath.getCellValueType(firstCell2);
            Cell nextCell1 = sheet.getCell(cbRow + 1, cbCol, false);
            Cell nextCell2 = sheet.getCell(cbRow + 1, cbCol + 1, false);
            if (firstCellType1 != DataType_Empty && !SheetBaseMath.isDataTypeEqual(firstCell1, nextCell1) || firstCellType2 != DataType_Empty && !SheetBaseMath.isDataTypeEqual(firstCell2, nextCell2)) {
                detectStatus = 0;
            } else {
                Cell prevCell1 = sheet.getCell(cbRow - 1, cbCol, false);
                int prevCellType1 = SheetBaseMath.getCellValueType(prevCell1);
                Cell prevCell2 = sheet.getCell(cbRow - 1, cbCol + 1, false);
                int prevCellType2 = SheetBaseMath.getCellValueType(prevCell2);
                if (prevCellType1 != DataType_Empty && !SheetBaseMath.isDataTypeEqual(prevCell1, firstCell1) || prevCellType2 != DataType_Empty && !SheetBaseMath.isDataTypeEqual(prevCell2, firstCell2)) {
                    detectStatus = 1;
                }
            }
        } else {
            int cellType;
            Cell cell;
            int i;
            boolean currentColsComplete = true;
            boolean prevColsComplete = true;
            for (i = cbCol + 1; i < cbCol2; ++i) {
                cell = sheet.getCell(cbRow, i, false);
                cellType = SheetBaseMath.getCellValueType(cell);
                if (cellType != DataType_Empty) continue;
                currentColsComplete = false;
                break;
            }
            for (i = cbCol + 1; i < cbCol2; ++i) {
                cell = sheet.getCell(cbRow - 1, i, false);
                cellType = SheetBaseMath.getCellValueType(cell);
                if (cellType != DataType_Empty) continue;
                prevColsComplete = false;
                break;
            }
            if (!currentColsComplete && !prevColsComplete) {
                detectStatus = -1;
            } else {
                int i2;
                boolean hasDifferentCellType;
                if (currentColsComplete) {
                    Cell nextCell;
                    Cell currentCell;
                    hasDifferentCellType = false;
                    for (i2 = cbCol + 1; i2 < cbCol2; ++i2) {
                        currentCell = sheet.getCell(cbRow, i2, false);
                        if (SheetBaseMath.isDataTypeEqual(currentCell, nextCell = sheet.getCell(cbRow + 1, i2, false))) continue;
                        hasDifferentCellType = true;
                        break;
                    }
                    if (hasDifferentCellType) {
                        detectStatus = 0;
                    } else {
                        currentCell = sheet.getCell(cbRow, cbCol, false);
                        nextCell = sheet.getCell(cbRow + 1, cbCol, false);
                        if (SheetBaseMath.getCellValueType(currentCell) != DataType_Empty && !SheetBaseMath.isDataTypeEqual(currentCell, nextCell)) {
                            detectStatus = 0;
                        }
                        currentCell = sheet.getCell(cbRow, cbCol2, false);
                        nextCell = sheet.getCell(cbRow + 1, cbCol2, false);
                        if (SheetBaseMath.getCellValueType(currentCell) != DataType_Empty && !SheetBaseMath.isDataTypeEqual(currentCell, nextCell)) {
                            detectStatus = 0;
                        }
                    }
                }
                if (prevColsComplete && detectStatus != 0) {
                    Cell currentCell;
                    Cell prevCell;
                    hasDifferentCellType = false;
                    for (i2 = cbCol + 1; i2 < cbCol2; ++i2) {
                        prevCell = sheet.getCell(cbRow - 1, i2, false);
                        if (SheetBaseMath.isDataTypeEqual(prevCell, currentCell = sheet.getCell(cbRow, i2, false))) continue;
                        hasDifferentCellType = true;
                        break;
                    }
                    if (hasDifferentCellType) {
                        detectStatus = 1;
                    } else {
                        prevCell = sheet.getCell(cbRow - 1, cbCol, false);
                        currentCell = sheet.getCell(cbRow, cbCol, false);
                        if (SheetBaseMath.getCellValueType(prevCell) != DataType_Empty && !SheetBaseMath.isDataTypeEqual(prevCell, currentCell)) {
                            detectStatus = 1;
                        }
                        prevCell = sheet.getCell(cbRow - 1, cbCol2, false);
                        currentCell = sheet.getCell(cbRow, cbCol2, false);
                        if (SheetBaseMath.getCellValueType(prevCell) != DataType_Empty && !SheetBaseMath.isDataTypeEqual(prevCell, currentCell)) {
                            detectStatus = 1;
                        }
                    }
                }
            }
        }
        return detectStatus;
    }

    private static boolean isDataTypeEqual(Cell cell1, Cell cell2) {
        int type1 = SheetBaseMath.getCellValueType(cell1);
        int type2 = SheetBaseMath.getCellValueType(cell2);
        if (type2 == DataType_Empty) {
            return true;
        }
        return type1 == type2;
    }

    public static int getCellValueType(Cell cell) {
        if (cell == null) {
            return DataType_Empty;
        }
        Variant var = cell.getValue();
        int vt = var.getVt();
        while (vt == 18) {
            vt = var.getVariant().getVt();
        }
        switch (vt) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                return DataType_Number;
            }
            case 8: {
                return DataType_Boolean;
            }
            case 12: 
            case 13: {
                return DataType_DateTime;
            }
            case 0: 
            case 16: 
            case 8192: 
            case 16384: {
                return DataType_Empty;
            }
        }
        return DataType_Text;
    }

    public static int getVariantValueType(Variant variant) {
        if (variant == null) {
            return DataType_Empty;
        }
        int vt = variant.getVt();
        while (vt == 18) {
            vt = variant.getVariant().getVt();
        }
        switch (vt) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                return DataType_Number;
            }
            case 8: {
                return DataType_Boolean;
            }
            case 12: 
            case 13: {
                return DataType_DateTime;
            }
            case 0: 
            case 16: 
            case 8192: 
            case 16384: {
                return DataType_Empty;
            }
        }
        return DataType_Text;
    }

    public static void unCancerizeCellBlock(Sheet sheet, CellBlock cb) {
        int row = cb.getRow();
        int row2 = cb.getRow2();
        int maxRow = sheet.getMaxRowIndex();
        int col = cb.getCol();
        int col2 = cb.getCol2();
        boolean westExpanded = false;
        boolean southExpanded = false;
        boolean eastExpanded = false;
        boolean isEmpty = false;
        while (true) {
            Sheet.ICellsIterator ri;
            if (!westExpanded && !isEmpty) {
                int left = col;
                ri = sheet.getCellsIterator(row, left, row2, left, false, true);
                while (!ri.hasData() && left <= col2 + 1) {
                    westExpanded = true;
                    ri = sheet.getCellsIterator(row, ++left, row2, left, false, true);
                }
                if (left > col2) {
                    isEmpty = true;
                } else {
                    col = left;
                }
            }
            if (!southExpanded && !isEmpty) {
                int bottom = row2;
                ri = sheet.getCellsIterator(bottom, col, bottom, col2, false, true);
                while (!ri.hasData() && bottom > maxRow) {
                    southExpanded = true;
                    ri = sheet.getCellsIterator(--bottom, col, bottom, col2, false, true);
                }
                if (bottom < row) {
                    isEmpty = true;
                } else {
                    row2 = bottom;
                }
            }
            if (!eastExpanded && !isEmpty) {
                int right = col2;
                ri = sheet.getCellsIterator(row, right, row2, right, false, true);
                while (!ri.hasData() && right >= col - 1) {
                    eastExpanded = true;
                    ri = sheet.getCellsIterator(row, --right, row2, right, false, true);
                }
                if (right < col) {
                    isEmpty = true;
                } else {
                    col2 = right;
                }
            }
            if (isEmpty) {
                cb.setRowCol(-1, -1, -1, -1);
                return;
            }
            if (!(westExpanded || southExpanded || eastExpanded)) {
                cb.setRowCol(row, col, row2, col2);
                return;
            }
            westExpanded = false;
            southExpanded = false;
            eastExpanded = false;
        }
    }

    public static void cancerizeCellBlock(Sheet sheet, CellBlock cb, boolean doWeatExpanded, boolean doSouthExpanded, boolean doEastExpanded) {
        SheetBaseMath.cancerizeCellBlock(sheet, cb, doWeatExpanded, doSouthExpanded, doEastExpanded, 1);
    }

    public static void cancerizeCellBlock(Sheet sheet, CellBlock cb, boolean doWeatExpanded, boolean doSouthExpanded, boolean doEastExpanded, int searchCount) {
        int row = cb.getRow();
        int row2 = cb.getRow2();
        int col = cb.getCol();
        int col2 = cb.getCol2();
        boolean westExpanded = false;
        boolean southExpanded = false;
        boolean eastExpanded = false;
        while (true) {
            Sheet.ICellsIterator ri;
            if (!westExpanded && col >= 1 && doWeatExpanded) {
                int left = col - 1;
                ri = sheet.getCellsIterator(row, left, row2, left, false, true);
                while (ri.hasData() && left >= 0) {
                    westExpanded = true;
                    ri = sheet.getCellsIterator(row, --left, row2, left, false, true);
                }
                col = left + 1;
            }
            if (!southExpanded && doSouthExpanded) {
                int bottom = row2 + searchCount;
                ri = sheet.getCellsIterator(row2 + 1, col, bottom, col2, false, true);
                while (ri.hasData()) {
                    southExpanded = true;
                    ri = sheet.getCellsIterator(++bottom, col, bottom, col2, false, true);
                }
                row2 = bottom - 1;
            }
            if (!eastExpanded && doEastExpanded) {
                int right = col2 + 1;
                ri = sheet.getCellsIterator(row, right, row2, right, false, true);
                while (ri.hasData()) {
                    eastExpanded = true;
                    ri = sheet.getCellsIterator(row, ++right, row2, right, false, true);
                }
                col2 = right - 1;
            }
            if (!(westExpanded || southExpanded || eastExpanded)) {
                cb.setRowCol(row, col, row2, col2);
                return;
            }
            westExpanded = false;
            southExpanded = false;
            eastExpanded = false;
        }
    }

    public static void rePageView(SpreadContext context) {
        PrintManager pm = context.getPrintManager();
        pm.reloadPrintJob();
        SortedSheetArray ssa = context.getSpread().getBook().getSelectSheets();
        for (int i = 0; i < ssa.size(); ++i) {
            Sheet sheet = ssa.getSheet(i);
            SheetPrintJob job = (SheetPrintJob)pm.getMultiPrintManager().getPrintJob(sheet.getID());
            job.preparePagination();
            sheet.setColPaginationPointsSnapshot(job.getTablePrintPagination().getColPaginationPointsSnapshot());
            sheet.setRowPaginationPointsSnapshot(job.getTablePrintPagination().getRowPaginationPointsSnapshot());
            sheet.setPageView(true);
            PrintSetup ps = sheet.getSheetOption().getPrintSetup(false);
            if (ps != null) continue;
            PrintBookTrans.saveToBook(pm, sheet.getBook(), new String[]{sheet.getID()});
            ps = sheet.getSheetOption().getPrintSetup(false);
        }
        pm.getMultiPrintManager().clear();
        context.repaint();
    }

    public static int getProperScaleRate(SpreadContext context) {
        double currentRate;
        Span span;
        int i;
        Sheet sheet = context.getBook().getActiveSheet();
        PrintManager pm = context.getPrintManager();
        KDPrinter printer = pm.getPrinter();
        PrintJobConfig pc = printer.getPrintConfig().getJobConfig(sheet.getID());
        if (pc == null) {
            pm.createAllPrintJobs();
            pc = pm.getPrinter().getPrintConfig().getJobConfig(sheet.getID());
        }
        PrintRequestAttributeSet printRequestSet = pc.getPrintRequestAttributeSet();
        Rectangle pageRect = KDPrinterUtils.getPageBounds((PrintRequestAttributeSet)printRequestSet, (int)KDPrinterUtils.SCREEN_RESOLUTION);
        double standardPageWidth = pageRect.getWidth();
        double standardPageHeight = pageRect.getHeight();
        SortedSpanArray rowSpans = sheet.getRowPageSpan();
        SortedSpanArray colSpans = sheet.getColPageSpan();
        double scaleRate = 1.0;
        if (rowSpans != null) {
            for (i = 0; i < rowSpans.size(); ++i) {
                span = rowSpans.getSpan(i);
                int currentPageHeight = 0;
                for (int j = span.getStart(); j <= span.getEnd(); ++j) {
                    currentPageHeight += SheetBaseMath.getRowHeight(sheet, j);
                }
                currentRate = scaleRate;
                if (currentPageHeight != 0) {
                    currentRate = standardPageHeight / (double)currentPageHeight;
                }
                if (!(currentRate < scaleRate)) continue;
                scaleRate = currentRate;
            }
        }
        if (colSpans != null) {
            for (i = 0; i < colSpans.size(); ++i) {
                span = colSpans.getSpan(i);
                int currentPageWidth = 0;
                for (int j = span.getStart(); j <= span.getEnd(); ++j) {
                    currentPageWidth += SheetBaseMath.getColWidth(sheet, j);
                }
                currentRate = scaleRate;
                if (currentPageWidth != 0) {
                    currentRate = standardPageWidth / (double)currentPageWidth;
                }
                if (!(currentRate < scaleRate)) continue;
                scaleRate = currentRate;
            }
        }
        return (int)(scaleRate * 100.0);
    }

    public static void setOutlineGroupHeaderInlinedAt(Sheet sheet, boolean isRow, Integer num) {
        if (isRow) {
            if (num != null) {
                sheet.setUserObject("ROW_INLINED_TREE_POSITION", num.toString());
            } else {
                sheet.removeUserObject("ROW_INLINED_TREE_POSITION");
            }
        } else if (num != null) {
            sheet.setUserObject("COLUMN_INLINED_TREE_POSITION", num.toString());
        } else {
            sheet.removeUserObject("COLUMN_INLINED_TREE_POSITION");
        }
    }

    public static void collapseGroupLevelTo(Sheet sheet, boolean rowDirection, int valve) {
        SortedCellBlockArray blocksHidden = new SortedCellBlockArray();
        SortedCellBlockArray blocksVisible = new SortedCellBlockArray();
        if (rowDirection) {
            int spanPos;
            int lastRowId;
            SortedAttributeSpanArray sasa = sheet.getRowSpans();
            int maxIndex = sheet.getMaxRowIndex(true);
            for (int i = 0; i <= maxIndex; ++i) {
                int pos = sasa.searchSpan(i);
                if (pos < 0) continue;
                SortedAttributeSpanArray.AttributeSpan as = (SortedAttributeSpanArray.AttributeSpan)sasa.get(pos);
                int level = as.getOutlineGroupLevel();
                if (level > valve) {
                    blocksHidden.insert(CellBlock.getCellBlock(as.getStart(), 0, as.getEnd(), 65535));
                    continue;
                }
                if (!as.isVisible() && level <= 0) continue;
                blocksVisible.insert(CellBlock.getCellBlock(as.getStart(), 0, as.getEnd(), 65535));
            }
            if (!blocksHidden.isEmpty()) {
                sheet.getRange(blocksHidden).setRowHidden(true);
            }
            if (!blocksVisible.isEmpty()) {
                sheet.getRange(blocksVisible).setRowHidden(false);
            }
            int firstRowId = sasa.isEmpty() ? Integer.MAX_VALUE : sasa.getAttributeSpan(0).getStart();
            int n = lastRowId = sasa.isEmpty() ? -1 : sasa.getAttributeSpan(sasa.size() - 1).getEnd();
            if (sheet.isAboveOfOutlineGroup()) {
                for (int rowId = firstRowId - 1; rowId <= lastRowId; ++rowId) {
                    spanPos = sasa.searchSpan(rowId);
                    int level = -1;
                    if (spanPos < 0) {
                        spanPos = sasa.searchSpan(rowId + 1);
                        if (spanPos < 0 || ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel() <= 0) continue;
                        level = 0;
                    } else {
                        level = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel();
                    }
                    int nextRowLevel = 0;
                    int nextSpanPos = sasa.searchSpan(rowId + 1);
                    if (nextSpanPos >= 0) {
                        nextRowLevel = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(nextSpanPos)).getOutlineGroupLevel();
                    }
                    if (level >= nextRowLevel) continue;
                    if (level < valve) {
                        sheet.getRowRange(rowId, rowId).setRowOutlineGroupCollapse(false);
                        continue;
                    }
                    sheet.getRowRange(rowId, rowId).setRowOutlineGroupCollapse(true);
                }
            } else {
                for (int rowId = firstRowId; rowId <= lastRowId + 1; ++rowId) {
                    spanPos = sasa.searchSpan(rowId);
                    int level = -1;
                    if (spanPos < 0) {
                        spanPos = sasa.searchSpan(rowId - 1);
                        if (spanPos < 0 || ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel() <= 0) continue;
                        level = 0;
                    } else {
                        level = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel();
                    }
                    int prevRowLevel = 0;
                    int prevSpanPos = sasa.searchSpan(rowId - 1);
                    if (prevSpanPos >= 0) {
                        prevRowLevel = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(prevSpanPos)).getOutlineGroupLevel();
                    }
                    if (level >= prevRowLevel) continue;
                    if (level < valve) {
                        sheet.getRowRange(rowId, rowId).setRowOutlineGroupCollapse(false);
                        continue;
                    }
                    sheet.getRowRange(rowId, rowId).setRowOutlineGroupCollapse(true);
                }
            }
        } else {
            int spanPos;
            int lastColId;
            SortedAttributeSpanArray sasa = sheet.getColSpans();
            int maxIndex = sheet.getMaxColIndex(true);
            for (int i = 0; i <= maxIndex; ++i) {
                int pos = sasa.searchSpan(i);
                if (pos < 0) continue;
                SortedAttributeSpanArray.AttributeSpan as = (SortedAttributeSpanArray.AttributeSpan)sasa.get(pos);
                int level = as.getOutlineGroupLevel();
                if (level > valve) {
                    blocksHidden.insert(CellBlock.getCellBlock(0, as.getStart(), 1048575, as.getEnd()));
                    continue;
                }
                if (!as.isVisible() && level <= 0) continue;
                blocksVisible.insert(CellBlock.getCellBlock(0, as.getStart(), 1048575, as.getEnd()));
            }
            if (!blocksHidden.isEmpty()) {
                sheet.getRange(blocksHidden).setColumnHidden(true);
            }
            if (!blocksVisible.isEmpty()) {
                sheet.getRange(blocksVisible).setColumnHidden(false);
            }
            int firstColId = sasa.isEmpty() ? Integer.MAX_VALUE : sasa.getAttributeSpan(0).getStart();
            int n = lastColId = sasa.isEmpty() ? -1 : sasa.getAttributeSpan(sasa.size() - 1).getEnd();
            if (sheet.isLeftToOutlineGroup()) {
                for (int colId = firstColId - 1; colId <= lastColId; ++colId) {
                    spanPos = sasa.searchSpan(colId);
                    int level = -1;
                    if (spanPos < 0) {
                        spanPos = sasa.searchSpan(colId + 1);
                        if (spanPos < 0 || ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel() <= 0) continue;
                        level = 0;
                    } else {
                        level = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel();
                    }
                    int nextColLevel = 0;
                    int nextSpanPos = sasa.searchSpan(colId + 1);
                    if (nextSpanPos >= 0) {
                        nextColLevel = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(nextSpanPos)).getOutlineGroupLevel();
                    }
                    if (level >= nextColLevel) continue;
                    if (level < valve) {
                        sheet.getColRange(colId, colId).setColumnOutlineGroupCollapse(false);
                        continue;
                    }
                    sheet.getColRange(colId, colId).setColumnOutlineGroupCollapse(true);
                }
            } else {
                for (int colId = firstColId; colId <= lastColId + 1; ++colId) {
                    spanPos = sasa.searchSpan(colId);
                    int level = -1;
                    if (spanPos < 0) {
                        spanPos = sasa.searchSpan(colId - 1);
                        if (spanPos < 0 || ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel() <= 0) continue;
                        level = 0;
                    } else {
                        level = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel();
                    }
                    int prevColLevel = 0;
                    int prevSpanPos = sasa.searchSpan(colId - 1);
                    if (prevSpanPos >= 0) {
                        prevColLevel = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(prevSpanPos)).getOutlineGroupLevel();
                    }
                    if (level >= prevColLevel) continue;
                    if (level < valve) {
                        sheet.getColRange(colId, colId).setColumnOutlineGroupCollapse(false);
                        continue;
                    }
                    sheet.getColRange(colId, colId).setColumnOutlineGroupCollapse(true);
                }
            }
        }
    }

    public static boolean isSecuritySheet(Sheet sheet) {
        Protection protection;
        return sheet != null && (protection = sheet.getSheetOption().getProtection(false)) != null && !protection.allowUnhideColumnsACols();
    }
}

