/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.browser;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.browser.IExecutePanel;
import com.kingdee.cosmic.ctrl.swing.KDButton;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDScrollPane;
import com.kingdee.cosmic.ctrl.swing.KDTextArea;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.net.URI;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class BrowserDebugPanel
extends KDPanel
implements IExecutePanel {
    private static final long serialVersionUID = 3607066771974330077L;
    private KDTextArea logTextArea;
    private volatile boolean componetsInited = false;
    private String debugID = "";
    private String debugURL = "";

    protected void initComponents() {
        KDPanel controlPanel = new KDPanel((LayoutManager)new BorderLayout());
        controlPanel.setBorder((Border)BorderFactory.createTitledBorder(CtrlEXTMessages.getMLS("debugPanel", "\u8c03\u8bd5\u9762\u677f")));
        KDTextArea textArea = new KDTextArea(10, 15);
        textArea.setText("");
        KDScrollPane scrollPane = new KDScrollPane((Component)textArea);
        this.logTextArea = new KDTextArea(5, 15);
        KDScrollPane logcrollPane = new KDScrollPane((Component)this.logTextArea);
        logcrollPane.setBorder((Border)BorderFactory.createTitledBorder(CtrlEXTMessages.getMLS("logConsole", "\u65e5\u5fd7\u63a7\u5236\u53f0")));
        controlPanel.add((Component)scrollPane, (Object)"Center");
        controlPanel.add((Component)logcrollPane, (Object)"South");
        KDPanel buttonPanel = new KDPanel((LayoutManager)new GridLayout(1, 4));
        KDButton submit = new KDButton(CtrlEXTMessages.getMLS("executeJSScript", "\u6267\u884cJS\u811a\u672c"));
        KDButton clear = new KDButton(CtrlEXTMessages.getMLS("clearScript", "\u6e05\u9664\u811a\u672c"));
        KDButton clearLog = new KDButton(CtrlEXTMessages.getMLS("clearLogs", "\u6e05\u9664\u65e5\u5fd7"));
        KDButton openDebugURL = new KDButton(CtrlEXTMessages.getMLS("browserDebugging", "\u6d4f\u89c8\u5668\u8c03\u8bd5"));
        buttonPanel.add((Component)submit);
        buttonPanel.add((Component)clear);
        buttonPanel.add((Component)clearLog);
        buttonPanel.add((Component)openDebugURL);
        clearLog.addActionListener(e -> this.logTextArea.setText(null));
        submit.addActionListener(e -> this.execute(textArea.getText()));
        clear.addActionListener(e -> textArea.setText(null));
        openDebugURL.addActionListener(e -> {
            try {
                URI uri = URI.create(this.getDebugURL());
                Desktop dp = Desktop.getDesktop();
                if (dp.isSupported(Desktop.Action.BROWSE)) {
                    dp.browse(uri);
                }
            }
            catch (Exception ex) {
                this.logTextArea.append(ex.getMessage());
            }
        });
        controlPanel.add((Component)buttonPanel, (Object)"North");
        this.add((Component)controlPanel, "North");
        this.logTextArea.append("init debug panel compelete.");
    }

    @Override
    public void execute(String script) {
        this.logTextArea.append(script);
    }

    @Override
    public Object executeResult(String script) {
        this.logTextArea.append(script);
        return null;
    }

    public void log(String s) {
        this.logTextArea.append(s);
        this.logTextArea.append("\n");
    }

    @Override
    public JComponent getMainComponent() {
        if (!this.componetsInited) {
            this.initComponents();
            this.componetsInited = true;
        }
        return this;
    }

    public String getDebugID() {
        return this.debugID;
    }

    public void setDebugID(String debugID) {
        this.debugID = debugID;
    }

    public String getDebugURL() {
        return this.debugURL;
    }

    public void setDebugURL(String debugURL) {
        this.debugURL = debugURL;
    }
}

