/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.dataset.calc;

import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.chart.ChartResultData;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.dataset.Category;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.dataset.DataFromDataset;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.dataset.ICategory;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.dataset.Series;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.dataset.SummaryType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.dataset.calc.AbstractChartKindOfCalc;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.dataset.calc.ChartMultiSeriesCalc;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ChartCombinationCalc1
extends AbstractChartKindOfCalc {
    private static ChartCombinationCalc1 calc;

    private ChartCombinationCalc1() {
    }

    public static ChartCombinationCalc1 getInstance() {
        if (calc == null) {
            calc = new ChartCombinationCalc1();
        }
        return calc;
    }

    @Override
    public ChartResultData calc(ExtDataSet extDS, DataFromDataset fromDataset) throws SyntaxErrorException {
        ChartResultData result = new ChartResultData();
        List<Series> seriesList = fromDataset.getSeries();
        if (seriesList == null || seriesList.isEmpty()) {
            return result;
        }
        String fieldCategory = fromDataset.getCategory();
        int colIndexGroup = extDS.getColumnIndexByName(fieldCategory).intValue();
        String[] groupKeys = null;
        int seriesSize = seriesList.size();
        Object[] seriesKeysAll = new Object[seriesSize];
        Object[] data = new Object[seriesSize];
        for (int i = 0; i < seriesSize; ++i) {
            Series series = seriesList.get(i);
            List<ICategory> categories = series.getCategories();
            if (categories == null || categories.isEmpty()) {
                return result;
            }
            HashMap<String, Object> mapReturn = null;
            String seriesType = series.getSeriesNameType();
            if ("fieldValue".equals(seriesType)) {
                mapReturn = this.calcForFieldValue(categories, extDS, colIndexGroup);
            } else if ("fieldName".equals(seriesType)) {
                mapReturn = this.calcForFieldName(categories, extDS, colIndexGroup);
            }
            if (mapReturn == null) continue;
            groupKeys = (String[])mapReturn.get("groupKeys");
            seriesKeysAll[i] = mapReturn.get("seriesKeys");
            data[i] = mapReturn.get("datas");
        }
        result.setData(data);
        result.setGroups(groupKeys);
        result.setSeries(seriesKeysAll);
        return result;
    }

    protected HashMap<String, Object> calcForFieldValue(List<ICategory> categories, ExtDataSet extDS, int colIndexGroup) throws SyntaxErrorException {
        Category category = (Category)categories.get(0);
        String summaryType = category.getSummaryType();
        SummaryType sType = SummaryType.getTypeByName(summaryType);
        ArrayList<String> listMaxSeries = new ArrayList<String>();
        LinkedHashMap<String, LinkedHashMap<String, Variant>> mapGroup = new LinkedHashMap<String, LinkedHashMap<String, Variant>>();
        HashMap<String, LinkedHashMap<String, Variant>> countGroup = new HashMap<String, LinkedHashMap<String, Variant>>();
        ChartMultiSeriesCalc.getInstance().calcBySummaryType(mapGroup, listMaxSeries, countGroup, colIndexGroup, null, extDS, category);
        LinkedHashMap<String, Variant> mapSeries = null;
        int lenGroup = mapGroup.size();
        int lenSeries = listMaxSeries.size();
        String[] seriesKeys = new String[lenSeries];
        listMaxSeries.toArray(seriesKeys);
        String[] groupKeys = new String[lenGroup];
        double[][] datas = new double[lenSeries][lenGroup];
        int count = 0;
        for (Map.Entry<String, LinkedHashMap<String, Variant>> entry : mapGroup.entrySet()) {
            groupKeys[count] = entry.getKey();
            mapSeries = entry.getValue();
            for (int k = 0; k < lenSeries; ++k) {
                String seriesName = seriesKeys[k];
                ChartMultiSeriesCalc.getInstance().setData(datas, mapSeries, countGroup, seriesName, k, count, entry.getKey(), sType);
            }
            ++count;
        }
        HashMap<String, Object> mapReturn = new HashMap<String, Object>();
        mapReturn.put("groupKeys", groupKeys);
        mapReturn.put("seriesKeys", seriesKeys);
        mapReturn.put("datas", datas);
        return mapReturn;
    }

    protected HashMap<String, Object> calcForFieldName(List<ICategory> categories, ExtDataSet extDS, int colIndexGroup) throws SyntaxErrorException {
        int lenSeries = categories.size();
        String[] seriesKeys = new String[lenSeries];
        String[] groupKeys = null;
        double[][] datas = null;
        LinkedHashMap<String, Variant> mapSeries = null;
        LinkedHashMap<String, LinkedHashMap<String, Variant>> mapGroup = new LinkedHashMap<String, LinkedHashMap<String, Variant>>();
        HashMap<String, LinkedHashMap<String, Variant>> countGroup = new HashMap<String, LinkedHashMap<String, Variant>>();
        for (int j = 0; j < lenSeries; ++j) {
            Category category = (Category)categories.get(j);
            String summaryType = category.getSummaryType();
            SummaryType sType = SummaryType.getTypeByName(summaryType);
            String sSeriesName = category.getSeriesName();
            String seriesValue = category.getSeriesValue();
            seriesKeys[j] = !StringUtil.isEmptyString((String)seriesValue) ? seriesValue : sSeriesName;
            ChartMultiSeriesCalc.getInstance().calcBySummaryType(mapGroup, null, countGroup, colIndexGroup, sSeriesName, extDS, category);
            if (j == 0) {
                int lenGroup = mapGroup.size();
                groupKeys = new String[lenGroup];
                datas = new double[lenSeries][lenGroup];
            }
            int count = 0;
            for (Map.Entry<String, LinkedHashMap<String, Variant>> entry : mapGroup.entrySet()) {
                groupKeys[count] = entry.getKey();
                mapSeries = entry.getValue();
                ChartMultiSeriesCalc.getInstance().setData(datas, mapSeries, countGroup, sSeriesName, j, count, entry.getKey(), sType);
                ++count;
            }
        }
        HashMap<String, Object> mapReturn = new HashMap<String, Object>();
        mapReturn.put("groupKeys", groupKeys);
        mapReturn.put("seriesKeys", seriesKeys);
        mapReturn.put("datas", datas);
        return mapReturn;
    }
}

