/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.dataset.calc;

import com.kingdee.cosmic.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.chart.ChartResultData;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.dataset.Category;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.dataset.DataFromDataset;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.dataset.ICategory;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.dataset.Series;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.dataset.SummaryType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.dataset.calc.AbstractChartKindOfCalc;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.dataset.calc.ChartCombinationCalc1;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.dataset.calc.ChartSingleSeriesCalc;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

public class ChartCombinationCalc2
extends AbstractChartKindOfCalc {
    private static ChartCombinationCalc2 calc;

    private ChartCombinationCalc2() {
    }

    public static ChartCombinationCalc2 getInstance() {
        if (calc == null) {
            calc = new ChartCombinationCalc2();
        }
        return calc;
    }

    @Override
    public ChartResultData calc(ExtDataSet extDS, DataFromDataset fromDataset) throws SyntaxErrorException {
        ChartResultData result = new ChartResultData();
        List<Series> seriesList = fromDataset.getSeries();
        if (seriesList == null || seriesList.isEmpty()) {
            return result;
        }
        String fieldCategory = fromDataset.getCategory();
        int colIndexGroup = extDS.getColumnIndexByName(fieldCategory).intValue();
        String[] groupKeys = null;
        int seriesSize = seriesList.size();
        String[] seriesKeys = null;
        Object[] seriesKeysAll = new Object[seriesSize];
        Object[] data = new Object[seriesSize];
        double[][] datas = null;
        String[] chartTypes = new String[seriesSize];
        String[] yAxisPosition = new String[seriesSize];
        for (int i = 0; i < seriesSize; ++i) {
            String showType;
            Series series = seriesList.get(i);
            List<ICategory> categories = series.getCategories();
            if (categories == null || categories.isEmpty()) {
                return result;
            }
            HashMap<String, Object> mapReturn = null;
            yAxisPosition[i] = series.getYAxisPosition();
            chartTypes[i] = showType = series.getChartShowType();
            int size = categories.size();
            String seriesType = series.getSeriesNameType();
            if ("fieldValue".equals(seriesType)) {
                Category category = (Category)categories.get(0);
                String summaryType = category.getSummaryType();
                String seriesName = category.getSeriesName();
                int colIndexName = extDS.getColumnIndexByName(seriesName).intValue();
                String seriesValue = category.getSeriesValue();
                if ("line".equals(showType)) {
                    seriesKeys = new String[]{seriesValue};
                    SummaryType sType = SummaryType.getTypeByName(summaryType);
                    LinkedHashMap<String, Variant> mapGroup = new LinkedHashMap<String, Variant>();
                    HashMap<String, Variant> countGroup = new HashMap<String, Variant>();
                    ChartSingleSeriesCalc.getInstance().calcBySummaryType(mapGroup, countGroup, colIndexGroup, colIndexName, extDS, sType, null);
                    size = mapGroup.size();
                    groupKeys = new String[size];
                    datas = ChartSingleSeriesCalc.getInstance().getData(mapGroup, countGroup, sType, groupKeys);
                } else {
                    mapReturn = ChartCombinationCalc1.getInstance().calcForFieldValue(categories, extDS, colIndexGroup);
                }
            } else if ("fieldName".equals(seriesType)) {
                mapReturn = ChartCombinationCalc1.getInstance().calcForFieldName(categories, extDS, colIndexGroup);
            }
            if (mapReturn != null) {
                groupKeys = (String[])mapReturn.get("groupKeys");
                seriesKeysAll[i] = mapReturn.get("seriesKeys");
                data[i] = mapReturn.get("datas");
                continue;
            }
            seriesKeysAll[i] = seriesKeys;
            data[i] = datas;
        }
        result.setData(data);
        result.setGroups(groupKeys);
        result.setSeries(seriesKeysAll);
        result.setShowTypes(chartTypes);
        result.setYAxisPostion(yAxisPosition);
        return result;
    }
}

