/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.dataset.calc;

import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.chart.ChartResultData;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.dataset.Category;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.dataset.DataFromDataset;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.dataset.ICategory;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.dataset.Series;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.dataset.SummaryType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.dataset.calc.AbstractChartKindOfCalc;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.dataset.calc.ChartSingleSeriesCalc;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

public class ChartCombinationCalc4
extends AbstractChartKindOfCalc {
    private static ChartCombinationCalc4 calc;

    private ChartCombinationCalc4() {
    }

    public static ChartCombinationCalc4 getInstance() {
        if (calc == null) {
            calc = new ChartCombinationCalc4();
        }
        return calc;
    }

    @Override
    public ChartResultData calc(ExtDataSet extDS, DataFromDataset fromDataset) throws SyntaxErrorException {
        ChartResultData result = new ChartResultData();
        List<Series> seriesList = fromDataset.getSeries();
        if (seriesList == null || seriesList.isEmpty()) {
            return result;
        }
        String fieldCategory = fromDataset.getCategory();
        int colIndexGroup = extDS.getColumnIndexByName(fieldCategory).intValue();
        String[] groupKeys = null;
        String[] seriesKeys = null;
        Object[] data = null;
        double[][] datas = null;
        String[] chartTypes = null;
        String[] yAxisPosition = null;
        int sizeSeries = seriesList.size();
        seriesKeys = new String[sizeSeries];
        chartTypes = new String[sizeSeries];
        yAxisPosition = new String[sizeSeries];
        data = new Object[sizeSeries];
        for (int i = 0; i < sizeSeries; ++i) {
            Series series = seriesList.get(i);
            List<ICategory> categories = series.getCategories();
            if (categories == null || categories.isEmpty()) {
                return result;
            }
            chartTypes[i] = series.getChartShowType();
            yAxisPosition[i] = series.getYAxisPosition();
            Category category = (Category)categories.get(0);
            String seriesValue = category.getSeriesValue();
            String summaryType = category.getSummaryType();
            String seriesName = category.getSeriesName();
            int colIndexName = extDS.getColumnIndexByName(seriesName).intValue();
            seriesKeys[i] = !StringUtil.isEmptyString((String)seriesValue) ? seriesValue : seriesName;
            SummaryType sType = SummaryType.getTypeByName(summaryType);
            LinkedHashMap<String, Variant> mapGroup = new LinkedHashMap<String, Variant>();
            HashMap<String, Variant> countGroup = new HashMap<String, Variant>();
            ChartSingleSeriesCalc.getInstance().calcBySummaryType(mapGroup, countGroup, colIndexGroup, colIndexName, extDS, sType, null);
            int size = mapGroup.size();
            groupKeys = new String[size];
            datas = ChartSingleSeriesCalc.getInstance().getData(mapGroup, countGroup, sType, groupKeys);
            data[i] = datas;
        }
        result.setData(data);
        result.setGroups(groupKeys);
        result.setSeries(seriesKeys);
        result.setShowTypes(chartTypes);
        result.setYAxisPostion(yAxisPosition);
        return result;
    }
}

