/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts;

import chrriis.dj.nativeswing.common.UIUtils;
import chrriis.dj.nativeswing.swtimpl.NativeInterface;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.browser.BrowserType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.EChartDisplayPanel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.constants.EChartsRenderType;
import com.kingdee.cosmic.ctrl.swing.KDFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.SwingUtilities;

public class EChartPanelTest {
    private EChartDisplayPanel displayPanel;
    private KDFrame frame;

    private static String getDemoScript() {
        return "option = {\r\n    title: {\r\n        text: '" + CtrlEXTMessages.getMLS("dailyElectricityUsageDistribution", "\u4e00\u5929\u7528\u7535\u91cf\u5206\u5e03") + "',\r\n        subtext: '" + CtrlEXTMessages.getMLS("purelyFictional", "\u7eaf\u5c5e\u865a\u6784") + "'\r\n    },\r\n    tooltip: {\r\n        trigger: 'axis',\r\n        axisPointer: {\r\n            type: 'cross'\r\n        }\r\n    },\r\n    xAxis: {\r\n        type: 'category',\r\n        boundaryGap: false,\r\n        data: ['00:00', '01:15', '02:30', '03:45', '05:00', '06:15', '07:30', '08:45', '10:00', '11:15', '12:30', '13:45', '15:00', '16:15', '17:30', '18:45', '20:00', '21:15', '22:30', '23:45']\r\n    },\r\n    yAxis: {\r\n        type: 'value',\r\n        axisLabel: {\r\n            formatter: '{value} W'\r\n        },\r\n        axisPointer: {\r\n            snap: true\r\n        }\r\n    },\r\n    visualMap: {\r\n        show: false,\r\n        dimension: 0,\r\n        pieces: [{\r\n            lte: 6,\r\n            color: 'green'\r\n        }, {\r\n            gt: 6,\r\n            lte: 8,\r\n            color: 'red'\r\n        }, {\r\n            gt: 8,\r\n            lte: 14,\r\n            color: 'green'\r\n        }, {\r\n            gt: 14,\r\n            lte: 17,\r\n            color: 'red'\r\n        }, {\r\n            gt: 17,\r\n            color: 'green'\r\n        }]\r\n    },\r\n    series: [\r\n        {\r\n            name: '" + CtrlEXTMessages.getMLS("electricityUsage", "\u7528\u7535\u91cf") + "',\r\n            type: 'line',\r\n            smooth: true,\r\n            data: [300, 280, 250, 260, 270, 300, 550, 500, 400, 390, 380, 390, 400, 500, 600, 750, 800, 700, 600, 400],\r\n            markArea: {\r\n                itemStyle: {\r\n                    color: 'rgba(255, 173, 177, 0.4)'\r\n                },\r\n                data: [ [{\r\n                    name: '" + CtrlEXTMessages.getMLS("morningPeak", "\u65e9\u9ad8\u5cf0") + "',\r\n                    xAxis: '07:30'\r\n                }, {\r\n                    xAxis: '10:00'\r\n                }], [{\r\n                    name: '" + CtrlEXTMessages.getMLS("eveningPeak", "\u665a\u9ad8\u5cf0") + "',\r\n                    xAxis: '17:30'\r\n                }, {\r\n                    xAxis: '21:15'\r\n                }] ]\r\n            }\r\n        }\r\n    ]\r\n};\r\nmyChart.setOption(option);\r\n";
    }

    private void addEchart(BrowserType type) {
        if (this.displayPanel == null) {
            EChartDisplayPanel.EChartDisPlayPanelBuidler buidler = EChartDisplayPanel.getBuidler();
            buidler.renderType(EChartsRenderType.SVG).browserType(type).charReadyFunction(b -> this.displayPanel.execute(EChartPanelTest.getDemoScript())).panelDebug(true);
            this.displayPanel = buidler.build();
            this.frame.add((Component)this.displayPanel.getDisplayPanel(), (Object)"Center");
        }
    }

    private void setup(BrowserType type) {
        this.frame = new KDFrame("echart testing");
        this.frame.setLayout((LayoutManager)new BorderLayout());
        this.frame.setDefaultCloseOperation(3);
        this.frame.setSize(800, 800);
        this.frame.setVisible(true);
        this.addEchart(type);
    }

    public static void main(String[] args) {
        BrowserType type = BrowserType.WEBVIEW;
        if (BrowserType.DJNATIVEBROWSER == type) {
            NativeInterface.open();
            UIUtils.setPreferredLookAndFeel();
            NativeInterface.runEventPump();
        }
        SwingUtilities.invokeLater(() -> {
            EChartPanelTest test = new EChartPanelTest();
            test.setup(type);
        });
    }
}

