/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.manager;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.browser.IExecutePanel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.function.IChartReadyFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class DefaultChartReadyManager
implements IChartReadyFunction {
    private static final Logger logger = LogUtil.getPackageLogger(DefaultChartReadyManager.class);
    private List<IChartReadyFunction> functions = new ArrayList<IChartReadyFunction>();
    private CountDownLatch latch = new CountDownLatch(1);

    @Override
    public void onReady(IExecutePanel browser) {
        for (IChartReadyFunction f : this.functions) {
            f.onReady(browser);
        }
        this.latch.countDown();
    }

    public boolean isDocumentReady() {
        return this.latch.getCount() == 0L;
    }

    public boolean waitDocumentIsReady() {
        try {
            if (!this.latch.await(5L, TimeUnit.SECONDS)) {
                logger.warn((Object)"\u7b49\u5f85\u65f6\u95f4\u5df2\u8fc7");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.error((Object)"err", (Throwable)e);
        }
        return this.isDocumentReady();
    }

    public void registeFunction(IChartReadyFunction f) {
        if (null != f) {
            this.functions.add(f);
        }
    }

    public void registeFunctionFirst(IChartReadyFunction f) {
        if (null != f) {
            this.functions.add(0, f);
        }
    }

    public void removeFunction(IChartReadyFunction f) {
        this.functions.remove(f);
    }
}

