/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.ColorUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.ShowNegativeComboBoxEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.SortEnum;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.TopNComboBoxEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.FusionGraphicsModel;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.AbstractFusionBean;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Chart;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Line;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Trendlines;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.chart.AbstractType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.QingChartType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.AbstractNormalChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.calculator.AbstractCalculator;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.calculator.AvgCalculator;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.util.QingTransferUtil;
import com.kingdee.cosmic.ctrl.swing.KDLabelContainer;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDRadioButton;
import java.awt.Color;
import java.awt.Component;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ChartDataTransferUtil {
    private static final String LABEL = "label";
    private static final String DATA = "data";

    private ChartDataTransferUtil() {
    }

    public static String[] parseValue2StringArray(Object obj) {
        if (obj instanceof String[]) {
            return (String[])obj;
        }
        if (obj instanceof String[][]) {
            return ((String[][])obj)[0];
        }
        if (obj == null || !obj.getClass().isArray()) {
            return new String[0];
        }
        int len = Array.getLength(obj);
        String[] ret = new String[len];
        for (int i = 0; i < len; ++i) {
            Variant[][] val = (Variant[][])Array.get(obj, i);
            if (val == null || val.length <= 0 || val[0].length <= 0) continue;
            ret[i] = val[0][0].getValue() == null ? "" : val[0][0].getValue().toString();
        }
        return ret;
    }

    public static List parseValue2StringArray(String[][] s) {
        if (s == null) {
            return null;
        }
        int len = Array.getLength(s);
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = 0; i < len; ++i) {
            String[] val = (String[])Array.get(s, i);
            if (null == val) continue;
            for (int j = 0; j < val.length; ++j) {
                ret.add(val[j]);
            }
        }
        return ret;
    }

    public static String[] parseStrings(FusionChartDataNode dataNode, String formulas, int flag) {
        if (StringUtil.isEmptyString((String)formulas)) {
            return new String[0];
        }
        Variant[][] values = dataNode.calcExpr(dataNode, formulas, flag);
        int row = values.length;
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = 0; i < row; ++i) {
            int col = values[i].length;
            for (int j = 0; j < col; ++j) {
                ret.add(values[i][j].toString());
            }
        }
        String[] str = new String[ret.size()];
        ret.toArray(str);
        return str;
    }

    public static String[][] parseStrings(FusionChartDataNode dataNode, String[] formulas) {
        int len = formulas.length;
        String[][] series = new String[len][];
        ArrayList<String> ret = new ArrayList<String>();
        for (int k = 0; k < len; ++k) {
            Variant[][] values = dataNode.calcExpr(dataNode, formulas[k], -1);
            if (null == values) continue;
            int row = values.length;
            for (int i = 0; i < row; ++i) {
                int col = values[i].length;
                for (int j = 0; j < col; ++j) {
                    ret.add(values[i][j].toString());
                }
            }
            String[] str = new String[ret.size()];
            ret.toArray(str);
            ret.clear();
            series[k] = str;
        }
        return series;
    }

    public static Object[] converToData(List<AbstractNormalChartModel.Series> series) {
        double[][] seriesData = new double[series.size()][];
        ArrayList<Double> list = new ArrayList<Double>();
        for (int i = 0; i < series.size(); ++i) {
            list.clear();
            List<AbstractNormalChartModel.INode> nodes = series.get(i).getNodes();
            for (int j = 0; j < nodes.size(); ++j) {
                list.add(Double.parseDouble(((AbstractNormalChartModel.Node)nodes.get(j)).getValue()));
            }
            seriesData[i] = list.stream().mapToDouble(d -> d).toArray();
        }
        return new Object[]{seriesData};
    }

    public static Object[] converToXYData(List<AbstractNormalChartModel.Series> series) {
        Object[] data = new Object[series.size()];
        for (int i = 0; i < series.size(); ++i) {
            List<AbstractNormalChartModel.INode> nodes = series.get(i).getNodes();
            double[][] seriesData = new double[nodes.size()][3];
            for (int j = 0; j < nodes.size(); ++j) {
                AbstractNormalChartModel.XYNode node = (AbstractNormalChartModel.XYNode)nodes.get(j);
                seriesData[j][0] = Double.parseDouble(node.getXAxisValue());
                seriesData[j][1] = Double.parseDouble(node.getYAxisValue());
                if (!StringUtil.isNumber((String)node.getZAxisValue())) continue;
                seriesData[j][2] = Double.parseDouble(node.getZAxisValue());
            }
            data[i] = seriesData;
        }
        return data;
    }

    public static int calcTopN(String descTopN) {
        int topN = Integer.MAX_VALUE;
        if (!StringUtil.isEmptyString((String)descTopN) && !TopNComboBoxEditor.getEmpty().equalsIgnoreCase(descTopN)) {
            Pattern compile = Pattern.compile("\\d+");
            Matcher matcher = compile.matcher(descTopN);
            while (matcher.find()) {
                topN = Integer.parseInt(matcher.group(0));
            }
        }
        return topN;
    }

    public static HashMap sortProcess(Object[] label, double[] data, SortEnum sortType, boolean isPieType, boolean isModulus) {
        switch (sortType) {
            case ASC: {
                boolean isAsc = true;
                double mix = Double.MAX_VALUE;
                return ChartDataTransferUtil.sort(label, data, mix, isAsc, isModulus);
            }
            case DESC: {
                boolean isAsc = false;
                double mix = -1.7976931348623157E308;
                return ChartDataTransferUtil.sort(label, data, mix, isAsc, isModulus);
            }
        }
        HashMap<String, Object[]> map = new HashMap<String, Object[]>();
        map.put(LABEL, label);
        map.put(DATA, data);
        return map;
    }

    public static HashMap sort(Object[] label, double[] data, double mix, boolean isAsc, boolean isModulus) {
        int i;
        int tempJ = -1;
        HashMap<String, Object[]> map = new HashMap<String, Object[]>();
        double[] newData = new double[data.length];
        Object[] newLabel = new Object[label.length];
        int len = data.length;
        HashSet<Object> dSet = new HashSet<Object>(len);
        if (isModulus) {
            for (i = 0; i < len; ++i) {
                if (Double.isNaN(data[i])) {
                    data[i] = 0.0;
                    continue;
                }
                if (!(data[i] < 0.0)) continue;
                data[i] = 0.0 - data[i];
                dSet.add(label[i]);
            }
        }
        for (i = 0; i < len; ++i) {
            double miax = mix;
            for (int j = 0; j < len; ++j) {
                if (Double.isNaN(data[j])) {
                    data[j] = 0.0;
                }
                int result = Double.compare(miax, data[j]);
                if (!(isAsc ? result > 0 : result < 0)) continue;
                tempJ = j;
                miax = data[j];
            }
            newData[i] = miax;
            if (tempJ < 0) continue;
            data[tempJ] = mix;
            newLabel[i] = label[tempJ];
        }
        for (i = 0; i < data.length; ++i) {
            if (isModulus && dSet.contains(newLabel[i])) {
                newData[i] = 0.0 - newData[i];
            }
            data[i] = newData[i];
            label[i] = newLabel[i];
        }
        map.put(LABEL, newLabel);
        map.put(DATA, newData);
        return map;
    }

    public static SortEnum loadSortType(FusionChartDataNode dataNode) {
        SortEnum sortType = SortEnum.NORMAL;
        Object[] datas = (Object[])dataNode.getData(FusionChartDataNode.CHART_CAPTION);
        if (datas != null && datas.length >= 42) {
            sortType = SortEnum.getSortEnum(((Variant[][])datas[41])[0][0].toString());
        }
        return sortType;
    }

    public static boolean isPieType(FlashChartType chartType) {
        return QingChartType.QING_CT_PIE.equals(chartType) || QingChartType.QING_CT_RING_PIE.equals(chartType) || QingChartType.QING_CT_ROSE_PIE.equals(chartType);
    }

    public static KDLabelContainer changeDataByChartType(KDLabelContainer dataArea_AllC, String chartTypeName) {
        if (QingChartType.QING_CT_PRING_PIE.getName().equals(chartTypeName)) {
            dataArea_AllC.setBoundLabelText(CtrlEXTMessages.getMLS("targetValueArea", "\u76ee\u6807\u503c\u533a\u57df"));
        } else {
            dataArea_AllC.setBoundLabelText(CtrlEXTMessages.getMLS("dataArea", "\u6570\u636e\u533a\u57df"));
        }
        return dataArea_AllC;
    }

    public static KDLabelContainer changeGroupByChartType(KDLabelContainer dataArea_GroupC, String chartTypeName) {
        if (QingChartType.QING_CT_DIAL.getName().equals(chartTypeName)) {
            dataArea_GroupC.setBoundLabelText(CtrlEXTMessages.getMLS("pointerDataArea", "\u6307\u9488\u6570\u636e\u533a\u57df"));
        } else if (QingChartType.QING_CT_PRING_PIE.getName().equals(chartTypeName)) {
            dataArea_GroupC.setBoundLabelText(CtrlEXTMessages.getMLS("actualValueArea", "\u5b9e\u9645\u503c\u533a\u57df"));
        } else {
            dataArea_GroupC.setBoundLabelText(CtrlEXTMessages.getMLS("categoryArea", "\u5206\u7c7b(\u7ec4\u522b)\u533a\u57df"));
        }
        return dataArea_GroupC;
    }

    public static void addAll(Collection collection, Object[] elements) {
        int size = elements.length;
        for (int i = 0; i < size; ++i) {
            collection.add(elements[i]);
        }
    }

    public static boolean isXYQingChart(AbstractType type) {
        return QingChartType.QING_CT_SCATTER_PLOT.equals(type) || QingChartType.QING_CT_SCATTER.equals(type);
    }

    public static void applyChartTrendlineColor(Chart chart, AbstractFusionBean bean) {
        Color colorValue = bean.getTrendlineColor().getColorValue();
        chart.trendlineColor = ColorUtil.colorToHexStr((Color)colorValue);
    }

    public static boolean isNoSupportedLink(FusionGraphicsModel model) {
        FlashChartType type = model.getChartType();
        return type == FlashChartType.FLASH_CT_GANTT || type == FlashChartType.FLASH_CT_DASHBOARD || type == FlashChartType.FLASH_CT_BUBBLE || type == FlashChartType.FLASH_CT_SCATTER || type == FlashChartType.FLASH_CT_AREA2D || type == FlashChartType.FLASH_CT_MS_AREA2D || type == FlashChartType.FLASH_CT_SCROLL_AREA2D || type == FlashChartType.FLASH_CT_ST_AREA2D || type == QingChartType.QING_CT_PRING_PIE || type == QingChartType.QING_CT_DIAL || type == QingChartType.QING_CT_WATERFALL || type == QingChartType.QING_CT_RADAR || type == QingChartType.QING_CT_MSRADAR || type == QingChartType.QING_CT_MSSUNBURST || type == QingChartType.QING_CT_MSRECTTREE;
    }

    public static boolean isNoSupportTransfered(FusionGraphicsModel model) {
        FlashChartType type = model.getChartType();
        return type == QingChartType.QING_CT_PRING_PIE || type == QingChartType.QING_CT_COMBINA || type == QingChartType.QING_CT_MS_COMBINA || type == QingChartType.QING_CT_SCATTER || type == QingChartType.QING_CT_SCATTER_PLOT || type == QingChartType.QING_CT_DIAL || type == FlashChartType.FLASH_CT_ST_MS_COL2D || type == FlashChartType.FLASH_CT_ST_COL3DLINE_DY || type == FlashChartType.FLASH_CT_ST_MS_COL2DLINE_DY || type == FlashChartType.FLASH_CT_BUBBLE || type == FlashChartType.FLASH_CT_SCATTER || type == FlashChartType.FLASH_CT_CANDLESTICK || type == FlashChartType.FLASH_CT_GANTT || type == FlashChartType.FLASH_CT_COL3D_LINE || type == FlashChartType.FLASH_CT_COL3D_LINE_DY || type == FlashChartType.FLASH_CT_DASHBOARD;
    }

    public static void applyNoSupportedSeries(FlashChartType type, KDPanel series, KDLabelContainer seriesContainer, KDRadioButton columnButton) {
        if (ChartDataTransferUtil.isDialOrPRing(type)) {
            series.remove((Component)seriesContainer);
            series.remove((Component)columnButton);
        } else {
            series.add((Component)seriesContainer);
            series.add((Component)columnButton);
        }
    }

    public static Object[] sortedMSTChart(double[][] data, SortEnum sortType, Object[] group) {
        int j;
        int i;
        int len = data[0].length;
        double[] dataZeroSrc = new double[len];
        double[] dataZeroSorted = new double[len];
        for (int j2 = 0; j2 < len; ++j2) {
            double sum = 0.0;
            for (int i2 = 0; i2 < data.length; ++i2) {
                sum += data[i2][j2];
            }
            dataZeroSrc[j2] = sum;
            dataZeroSorted[j2] = sum;
        }
        ChartDataTransferUtil.sortProcess(group, dataZeroSrc, sortType, false, false);
        double[][] oldData = new double[data.length][len];
        for (int i3 = 0; i3 < data.length; ++i3) {
            oldData[i3] = Arrays.copyOf(data[i3], data[i3].length);
        }
        int[] ints = new int[len];
        for (i = 0; i < len; ++i) {
            for (j = 0; j < len; ++j) {
                if (dataZeroSorted[j] != dataZeroSrc[i]) continue;
                ints[i] = j;
            }
        }
        for (i = 0; i < data.length; ++i) {
            for (j = 0; j < data[i].length; ++j) {
                data[i][j] = oldData[i][ints[j]];
            }
        }
        return group;
    }

    public static Object[] sortedPChart(double[][] data, SortEnum sortType, Object[] group) {
        int j;
        int i;
        int len = data[0].length;
        double[] dataZeroSrc = Arrays.copyOf(data[1], data[1].length);
        double[] dataZeroSorted = Arrays.copyOf(data[1], data[1].length);
        ChartDataTransferUtil.sortProcess(group, dataZeroSrc, sortType, false, false);
        double[][] oldData = new double[data.length][len];
        for (int i2 = 0; i2 < data.length; ++i2) {
            oldData[i2] = Arrays.copyOf(data[i2], data[i2].length);
        }
        int[] ints = new int[len];
        for (i = 0; i < len; ++i) {
            for (j = 0; j < len; ++j) {
                if (dataZeroSorted[j] != dataZeroSrc[i]) continue;
                ints[i] = j;
            }
        }
        for (i = 0; i < data.length; ++i) {
            for (j = 0; j < data[i].length; ++j) {
                data[i][j] = oldData[i][ints[j]];
            }
        }
        return group;
    }

    public static double[][] parseValue2Double(Object[] d, Boolean isFillNullWithZero) {
        int len = 0;
        for (int i = 0; i < d.length; ++i) {
            Variant[][] variants = (Variant[][])d[i];
            len += variants.length;
        }
        double[][] datas = new double[len][];
        int index = 0;
        for (int k = 0; k < d.length; ++k) {
            Variant[][] variants = (Variant[][])d[k];
            for (int i = 0; i < variants.length; ++i) {
                datas[index] = new double[variants[i].length];
                for (int j = 0; j < variants[i].length; ++j) {
                    String str;
                    String string = str = variants[i][j].getValue() == null ? "" : variants[i][j].getValue().toString();
                    if (!StringUtil.isNumber((String)str)) {
                        if (isFillNullWithZero.booleanValue()) {
                            datas[index][j] = 0.0;
                            continue;
                        }
                        datas[index][j] = Double.NaN;
                        continue;
                    }
                    datas[index][j] = Double.parseDouble(str);
                }
                ++index;
            }
        }
        return datas;
    }

    public static ArrayList parseValue2String(Variant[][] variants) {
        int len = variants.length;
        int dataLen = variants[0].length;
        ArrayList<String> data = new ArrayList<String>();
        for (int i = 0; i < len; ++i) {
            for (int j = 0; j < dataLen; ++j) {
                if (StringUtil.isEmptyString((String)variants[i][j].toString())) {
                    data.add(null);
                    continue;
                }
                data.add(String.valueOf(variants[i][j]));
            }
        }
        return data;
    }

    public static Variant[][] povitDoubles(Variant[][] data) {
        Variant[][] newData = new Variant[data[0].length][data.length];
        for (int j = 0; j < data.length; ++j) {
            for (int k = 0; k < data[0].length; ++k) {
                newData[k][j] = data[j][k];
            }
        }
        return newData;
    }

    public static void sortTreeByMeasure(int len, List<AbstractNormalChartModel.TreeChartNode> treeChartNodeList, List<AbstractNormalChartModel.TreeChartNode> copyList) {
        int i;
        Double[] dataZeroSrc = new Double[len];
        Double[] dataZeroSorted = new Double[len];
        for (i = 0; i < len; ++i) {
            Double sum = 0.0;
            List<AbstractNormalChartModel.TreeChartNode> treeChartNodeChildrenList = treeChartNodeList.get(i).getChildren();
            for (int j = 0; j < treeChartNodeChildrenList.size(); ++j) {
                sum = sum + Double.parseDouble(treeChartNodeChildrenList.get(j).getSize());
            }
            dataZeroSrc[i] = sum;
            dataZeroSorted[i] = sum;
        }
        Arrays.sort(dataZeroSorted, Collections.reverseOrder());
        for (i = 0; i < len; ++i) {
            for (int j = 0; j < len; ++j) {
                if (dataZeroSorted[i].compareTo(dataZeroSrc[j]) != 0) continue;
                copyList.add(treeChartNodeList.get(j));
            }
        }
    }

    public static void removeNegative(AbstractNormalChartModel chartModel, Chart chart) {
        if (ShowNegativeComboBoxEditor.getIgnore().equals(chart.chartShowNegative)) {
            List<AbstractNormalChartModel.Series> series = chartModel.getSeries();
            for (int i = 0; i < series.size(); ++i) {
                List<AbstractNormalChartModel.INode> nodes = series.get(i).getNodes();
                for (AbstractNormalChartModel.Node node : nodes) {
                    if (!(Double.parseDouble(node.getValue()) < 0.0)) continue;
                    node.setText("0");
                    node.setValue("0");
                }
            }
        }
    }

    public static boolean isDialOrPRing(AbstractType type) {
        return type == QingChartType.QING_CT_DIAL || type == QingChartType.QING_CT_PRING_PIE;
    }

    public static Integer parseInteger(String str) {
        if (str == null) {
            return null;
        }
        if (str.matches("[0-9]*")) {
            return Integer.valueOf(str);
        }
        return Double.valueOf(str).intValue();
    }

    public static boolean isEqual(String str, int num) {
        if (str == null) {
            return false;
        }
        return str.equals(String.valueOf(num)) || str.equals(num + ".0");
    }

    public static List<List<AbstractNormalChartModel.PaintableLine>> configureTrendlinePaintableLine(Object[] data, AbstractFusionBean bean) {
        AbstractCalculator calculator = null;
        AbstractCalculator.Refline refline = new AbstractCalculator.Refline();
        ArrayList<AbstractNormalChartModel.PaintableLine> paintableLines = new ArrayList<AbstractNormalChartModel.PaintableLine>();
        Trendlines trendlines = bean.getTrendlines();
        if (trendlines == null || trendlines.lines == null || trendlines.lines.length == 0) {
            return null;
        }
        for (int i = 0; i < data.length; ++i) {
            double[][] seriesData = (double[][])data[i];
            int len = seriesData.length;
            for (int j = 0; j < len; ++j) {
                for (int k = 0; k < seriesData[0].length; ++k) {
                    double value = seriesData[j][k];
                    if ("NaN".equalsIgnoreCase(String.valueOf(value))) {
                        value = 0.0;
                    }
                    if (calculator == null) {
                        Line leftLine = trendlines.lines[0];
                        Line rightLine = trendlines.lines[1];
                        refline.setValue(leftLine.startValue);
                        refline.setFormat(QingTransferUtil.XMLtoQingNumFormat(bean.getChartNumberFormat().getXmlValue()));
                        if (rightLine.displayvalue != null) {
                            refline.setLabel(rightLine.displayvalue.trim());
                        }
                        calculator = AbstractCalculator.create(refline);
                    }
                    calculator.joinCalc(BigDecimal.valueOf(value));
                }
            }
            if (calculator == null) continue;
            if (calculator instanceof AvgCalculator) {
                ((AvgCalculator)calculator).reductionCountByNumber(len);
            }
            paintableLines.add(calculator.getLine());
        }
        return Collections.singletonList(paintableLines);
    }
}

