/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls;

import com.github.abel533.echarts.Option;
import com.github.abel533.echarts.code.SeriesType;
import com.github.abel533.echarts.data.Data;
import com.github.abel533.echarts.series.Series;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.AbstractFusionBean;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Chart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.constants.EChartsType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.AbstractAxisTransfer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import java.util.List;

public class AbstractStackedTransfer<B extends AbstractFusionBean>
extends AbstractAxisTransfer<B> {
    private Data last = null;
    private int lastSeriesIndex = -1;
    private int lastDataIndexIndex = -1;

    public AbstractStackedTransfer(EChartsType type, String desc) {
        super(type, desc);
        this.setyValueAxis(true);
    }

    @Override
    protected void setBlowZeroDataRoundEdges(Data d, boolean x, int seriesIndex, int dataIndex) {
        super.setBlowZeroDataRoundEdges(d, x, seriesIndex, dataIndex);
        if (this.lastDataIndexIndex == dataIndex && seriesIndex > this.lastSeriesIndex && null != this.last) {
            this.last.itemStyle().normal().barBorderRadius(null);
        }
        this.last = d;
        this.lastSeriesIndex = seriesIndex;
        this.lastDataIndexIndex = dataIndex;
    }

    private void resetDataRoundEdges(List<Series> series, boolean x) {
        Object d;
        int i;
        int[] index = new int[series.get(0).getData().size()];
        for (i = series.size() - 1; i >= 0; --i) {
            List data = series.get(i).getData();
            for (int j = 0; j < data.size(); ++j) {
                d = data.get(j);
                if (d instanceof Data || index[j] != 0) continue;
                index[j] = i;
            }
        }
        for (i = 0; i < index.length; ++i) {
            int serialIndex = index[i];
            if (serialIndex == series.size() - 1) continue;
            List data = series.get(serialIndex).getData();
            d = data.get(i);
            Data sData = new Data();
            sData.setValue(d);
            if (this.isxValueAxis()) {
                sData.itemStyle().normal().barBorderRadius((Object)new Integer[]{0, 10, 10, 0});
            } else if (this.isyValueAxis()) {
                sData.itemStyle().normal().barBorderRadius((Object)new Integer[]{10, 10, 0, 0});
            }
            data.set(i, sData);
        }
    }

    @Override
    public String afterScript(B b, FusionChartDataNode data, Option p) {
        String s = super.afterScript(b, data, p);
        if ("1".equals(((AbstractFusionBean)b).getChart().useRoundEdges)) {
            this.resetDataRoundEdges(p.getSeries(), this.isxValueAxis());
        }
        return s;
    }

    @Override
    protected void configureSeriesFillet(Option p, Chart chart) {
        if ("1".equals(chart.useRoundEdges)) {
            for (int i = 0; i < p.getSeries().size(); ++i) {
                if (((Series)p.getSeries().get(i)).getType() != SeriesType.bar) continue;
                if (i == p.getSeries().size() - 1) {
                    this.piantBorderRadius((Series)p.getSeries().get(i));
                    return;
                }
                if (((Series)p.getSeries().get(i + 1)).getType() == SeriesType.bar && ((Series)p.getSeries().get(i + 1)).getStack() == ((Series)p.getSeries().get(i)).getStack()) continue;
                this.piantBorderRadius((Series)p.getSeries().get(i));
            }
        }
    }

    private void piantBorderRadius(Series s) {
        if (this.isxValueAxis()) {
            s.itemStyle().normal().barBorderRadius((Object)new Integer[]{0, 10, 10, 0});
        } else if (this.isyValueAxis()) {
            s.itemStyle().normal().barBorderRadius((Object)new Integer[]{10, 10, 0, 0});
        }
    }
}

