/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls;

import com.github.abel533.echarts.Option;
import com.github.abel533.echarts.json.GsonOption;
import com.kingdee.cosmic.ctrl.common.util.ColorUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.extend.pattern.NumberFormatTemplateEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.extend.pattern.PatternNode;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.AbstractFusionBean;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Chart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.constants.EChartsType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.IModelTransfer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.TransferUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.script.JSUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.util.EChartUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractTransferImpl<B extends AbstractFusionBean>
implements IModelTransfer<B, FusionChartDataNode> {
    private EChartsType type;
    private String desc;
    private List<Color> colorList = new ArrayList<Color>();

    public AbstractTransferImpl(EChartsType type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public EChartsType getType() {
        return this.type;
    }

    public void setType(EChartsType type) {
        this.type = type;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    @Override
    public Option mockOption(B bean) {
        return new GsonOption();
    }

    @Override
    public String initMockScript(B bean) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.buildColors(bean));
        builder.append(this.build95PecentColors(bean));
        builder.append(this.build75PecentColors(bean));
        builder.append(EChartUtils.getNumberFormatAndTipsFormat(bean));
        builder.append(this.setBorderAlphaJS(((AbstractFusionBean)bean).getBorderAlpha().getIntegerValue()));
        return builder.toString();
    }

    @Override
    public String initScript(B bean, FusionChartDataNode data) {
        ((AbstractFusionBean)bean).toXML(data);
        Chart chart = ((AbstractFusionBean)bean).getChart();
        StringBuilder builder = new StringBuilder();
        builder.append(this.buildColors(bean)).append(this.build95PecentColors(bean)).append(this.build75PecentColors(bean)).append(this.setBorderAlphaJS(Integer.parseInt(StringUtil.isEmptyString((String)chart.borderAlpha) ? "100" : chart.borderAlpha)));
        String formatXML = data.getNumberFormatXML();
        PatternNode valueNode = NumberFormatTemplateEditor.parsePattern(formatXML, null, null);
        PatternNode node = NumberFormatTemplateEditor.parsePattern(chart.dataLabelFormat == null ? formatXML : chart.dataLabelFormat, null, null);
        PatternNode yAxisNode = NumberFormatTemplateEditor.parsePattern(chart.yAxisFormat == null ? formatXML : chart.yAxisFormat, null, null);
        PatternNode xAxisNode = NumberFormatTemplateEditor.parsePattern(chart.xAxisFormat == null ? formatXML : chart.xAxisFormat, null, null);
        builder.append(this.initNumberFormatVar(node));
        String optionJS = String.format("var formatterOption ={format:'%s',overrideGroupSep:'%s',overrideDecSep:'%s',overrideNegSign:'%s',isPercentage:%b,locale:'cn'};", node.getPatternWithoutPS(), Character.valueOf(node.getThousandSeparator()), Character.valueOf(node.getDecimalSeparator()), Character.valueOf('-'), node.isPercentNumber());
        String optionValueJS = String.format("var formatterValueOption ={format:'%s',overrideGroupSep:'%s',overrideDecSep:'%s',overrideNegSign:'%s',isPercentage:%b,prefix:'%s',suffix:'%s',locale:'cn'};", valueNode.getPatternWithoutPS(), Character.valueOf(valueNode.getThousandSeparator()), Character.valueOf(valueNode.getDecimalSeparator()), Character.valueOf('-'), valueNode.isPercentNumber(), valueNode.getPrefix(), valueNode.getSuffix());
        String optionYAxisJS = String.format("var formatterYAxisOption ={format:'%s',overrideGroupSep:'%s',overrideDecSep:'%s',overrideNegSign:'%s',isPercentage:%b,prefix:'%s',suffix:'%s',locale:'cn'};", yAxisNode.getPatternWithoutPS(), Character.valueOf(yAxisNode.getThousandSeparator()), Character.valueOf(yAxisNode.getDecimalSeparator()), Character.valueOf('-'), yAxisNode.isPercentNumber(), yAxisNode.getPrefix(), yAxisNode.getSuffix());
        String optionXAxisJS = String.format("var formatterXAxisOption ={format:'%s',overrideGroupSep:'%s',overrideDecSep:'%s',overrideNegSign:'%s',isPercentage:%b,prefix:'%s',suffix:'%s',locale:'cn'};", xAxisNode.getPatternWithoutPS(), Character.valueOf(xAxisNode.getThousandSeparator()), Character.valueOf(xAxisNode.getDecimalSeparator()), Character.valueOf('-'), xAxisNode.isPercentNumber(), xAxisNode.getPrefix(), xAxisNode.getSuffix());
        builder.append(optionJS);
        builder.append(optionValueJS);
        builder.append(optionYAxisJS);
        builder.append(optionXAxisJS);
        builder.append(JSUtils.NUMBERFORMATFUNCTION_TEMPLATE);
        builder.append(JSUtils.VALUEAXIS_NUMBERFORMATFUNCTION);
        builder.append(JSUtils.SERIES_NUMBERFORMATFUNCTION);
        builder.append(JSUtils.TOOLTIPS_NUMBERFORMATFUNCTION);
        if (((AbstractFusionBean)bean).getChartType() == FlashChartType.FLASH_CT_RADAR) {
            builder.append(JSUtils.RADARTOOLTIP_NUMBERFORMATFUNCTION);
        }
        return builder.toString();
    }

    private String initNumberFormatVar(PatternNode node) {
        StringBuilder sb = new StringBuilder();
        String prefixJS = String.format("var prefix = '%s';", node.getPrefix());
        String suffixJS = String.format("var suffix = '%s';", node.getSuffix());
        String rSuffixJS = String.format("var rSuffix = '%s';", node.getrSuffix());
        sb.append(prefixJS).append(suffixJS).append(rSuffixJS);
        return sb.toString();
    }

    private String setBorderAlphaJS(int alpha) {
        return String.format("$(chartDiv).css('border','1px solid');$(chartDiv).css('border-color','%s');", String.format("rgba(0,0,0,%f)", (double)alpha / 100.0));
    }

    public String buildColors(B bean) {
        StringBuilder builder = new StringBuilder("var colors=[");
        List<String> colors = ((AbstractFusionBean)bean).initColors();
        this.colorList.clear();
        for (String color : colors) {
            builder.append('\'');
            Color c = ColorUtil.parseColor((String)('#' + color));
            this.colorList.add(c);
            builder.append(TransferUtils.toCSSRGBAString(c));
            builder.append('\'');
            builder.append(',');
        }
        builder.append("];");
        return builder.toString();
    }

    public String buildColorStops(int count, int right, int down, int left, int up, int colorLength) {
        return TransferUtils.buildColorStops("", count, right, down, left, up, colorLength);
    }

    public String buildColorStopsLeft(int count, int colorLength) {
        return this.buildColorStops(count, 0, 0, 1, 0, colorLength);
    }

    public String buildColorStopsUp(int count, int colorLength) {
        return this.buildColorStops(count, 0, 0, 0, 1, colorLength);
    }

    private String build95PecentColors(B bean) {
        StringBuilder builder = new StringBuilder("var colors7c=[");
        List<String> colors = ((AbstractFusionBean)bean).initColors();
        for (String color : colors) {
            builder.append('\'');
            Color c = ColorUtil.parseColor((String)('#' + color));
            c = new Color(c.getRed(), c.getGreen(), c.getBlue(), (int)((double)c.getAlpha() * 0.95));
            builder.append(TransferUtils.toCSSRGBAString(c));
            builder.append('\'');
            builder.append(',');
        }
        builder.append("];");
        return builder.toString();
    }

    private String build75PecentColors(B bean) {
        StringBuilder builder = new StringBuilder("var colors75c=[");
        List<String> colors = ((AbstractFusionBean)bean).initColors();
        for (String color : colors) {
            builder.append('\'');
            Color c = ColorUtil.parseColor((String)('#' + color));
            c = new Color(c.getRed(), c.getGreen(), c.getBlue(), (int)((double)c.getAlpha() * 0.75));
            builder.append(TransferUtils.toCSSRGBAString(c));
            builder.append('\'');
            builder.append(',');
        }
        builder.append("];");
        return builder.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("echart type:").append(this.type.name()).append('\n').append("desc :").append(this.desc);
        return builder.toString();
    }

    public Option getDefaultOption() {
        return new GsonOption();
    }

    public String resizeScript(int width, int height) {
        return String.format("var div=chartDiv; div.style.width=%d+\"px\"; div.style.height=%d+\"px\";myChart.resize();", width, height);
    }

    @Override
    public String afterScript(B bean, FusionChartDataNode data, Option p) {
        return "myChart.setOption(option, true);";
    }

    @Override
    public Option transfer2Opiton(B b, FusionChartDataNode d) {
        return this.getDefaultOption();
    }

    public List<Color> getColorList() {
        return this.colorList;
    }

    @Override
    public String afterMockScript(B bean) {
        return "myChart.setOption(option, true);";
    }
}

