/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.area;

import com.github.abel533.echarts.Option;
import com.github.abel533.echarts.axis.Axis;
import com.github.abel533.echarts.axis.CategoryAxis;
import com.github.abel533.echarts.axis.ValueAxis;
import com.github.abel533.echarts.code.AxisType;
import com.github.abel533.echarts.code.PointerType;
import com.github.abel533.echarts.code.Symbol;
import com.github.abel533.echarts.code.Trigger;
import com.github.abel533.echarts.json.Var;
import com.github.abel533.echarts.series.Line;
import com.github.abel533.echarts.series.Series;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.ChartFillColorComboBoxEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.area.Area2DBean;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.constants.EChartsType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.AbstractLineTransfer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.script.JSUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.util.EChartUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import java.util.Arrays;
import java.util.Collections;

public class Area2DBeanTransferImpl
extends AbstractLineTransfer<Area2DBean> {
    public Area2DBeanTransferImpl() {
        super(EChartsType.LINE, CtrlEXTMessages.getMLS("areaChart2D", "2D\u9762\u79ef\u56fe"));
    }

    @Override
    public String initScript(Area2DBean bean, FusionChartDataNode dataNode) {
        String s = super.initScript(bean, dataNode);
        EChartUtils.checkChartDataIsNull((Object[])((double[][])dataNode.getData()), bean.getLables());
        return s;
    }

    @Override
    public Option transfer2Opiton(Area2DBean bean, FusionChartDataNode dataNode) {
        Option p = super.transfer2Opiton(bean, dataNode);
        p.legend().show(Boolean.FALSE);
        String[] labels = bean.getLables();
        double[][] data = (double[][])dataNode.getData();
        Line line = new Line();
        line.areaStyle();
        ValueAxis valueAxis = new ValueAxis();
        valueAxis.name(bean.getChart().yScaleUnit);
        p.yAxis().add(valueAxis);
        CategoryAxis caxis = new CategoryAxis();
        caxis.setBoundaryGap((Object)Boolean.FALSE);
        for (String label : labels) {
            caxis.data().add(label);
        }
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                line.data().add(data[i][j]);
            }
        }
        p.tooltip().trigger(Trigger.axis);
        p.tooltip().axisPointer().type(PointerType.shadow);
        p.xAxis().add(caxis);
        p.series().add(line);
        return p;
    }

    @Override
    public void configureTooltipFormatter(FusionChartDataNode data, Option p) {
        Object formatter;
        Var f;
        if (null != p.getTooltip() && null != (f = JSUtils.getTooltipFormatterVar(true, true, false, formatter = p.getTooltip().formatter())) && !StringUtil.isEmptyString((String)f.getStr())) {
            p.getTooltip().formatter((Object)f);
        }
    }

    @Override
    public Option mockOption(Area2DBean bean) {
        Option p = super.mockOption(bean);
        EChartUtils.configPlotGradientColor(bean, p);
        Var tooltipFormatter = JSUtils.getTooltipFormatterVar(true, true, false, null);
        p.tooltip().formatter((Object)tooltipFormatter);
        CategoryAxis caxis = new CategoryAxis();
        caxis.setData(Arrays.asList("Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"));
        EChartUtils.configAxisText(bean, (Axis)caxis);
        caxis.setBoundaryGap((Object)Boolean.FALSE);
        p.xAxis().add(caxis);
        CategoryAxis yAxis = new CategoryAxis();
        yAxis.type(AxisType.value);
        EChartUtils.configAxisLucency(bean, (Axis)yAxis, true);
        p.yAxis().add(yAxis);
        p.tooltip().trigger(Trigger.axis);
        p.legend().data(Collections.singletonList(CtrlEXTMessages.getMLS("year2020", "2020\u5e74")));
        p.legend().show(Boolean.valueOf(false));
        Line line = new Line();
        line.name(CtrlEXTMessages.getMLS("year2020", "2020\u5e74"));
        line.areaStyle();
        line.setData(Arrays.asList(820, 932, 901, 934, 1290, 1330, 1320));
        EChartUtils.configShowValue(bean, (Series)line);
        line.symbol(Symbol.emptyCircle);
        EChartUtils.configTrendline(bean, (Series)line);
        EChartUtils.configPlotBorder(bean, (Series)line);
        p.series().add(line);
        EChartUtils.configMaxMinValue(bean, p, 1330.0, 0.0);
        EChartUtils.configSort(bean, p);
        EChartUtils.configBorder(bean, p);
        return p;
    }

    @Override
    public String initMockScript(Area2DBean bean) {
        if (ChartFillColorComboBoxEditor.getGradient().equals(bean.getChart_plotGradientColor())) {
            return super.initMockScript(bean) + EChartUtils.getPlotGradientColor(this.isyValueAxis(), this.isxValueAxis(), this.getColorList());
        }
        return super.initMockScript(bean);
    }
}

