/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.bar;

import com.github.abel533.echarts.Option;
import com.github.abel533.echarts.axis.Axis;
import com.github.abel533.echarts.axis.CategoryAxis;
import com.github.abel533.echarts.axis.ValueAxis;
import com.github.abel533.echarts.code.Position;
import com.github.abel533.echarts.data.SeriesData;
import com.github.abel533.echarts.json.Var;
import com.github.abel533.echarts.series.Bar;
import com.github.abel533.echarts.series.Series;
import com.github.abel533.echarts.style.ItemStyle;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.ChartFillColor1ComboBoxEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.ChartFillColorComboBoxEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.bar.Bar2DBean;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Chart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.constants.EChartsType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.AbstractBarTransfer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.script.JSUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.util.EChartUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;

public class Bar2DBeanTransferImpl
extends AbstractBarTransfer<Bar2DBean> {
    public Bar2DBeanTransferImpl() {
        super(EChartsType.BAR, CtrlEXTMessages.getMLS("barChart2D", "2D\u6761\u5f62\u56fe"));
    }

    @Override
    public String initScript(Bar2DBean bean, FusionChartDataNode dataNode) {
        String s = super.initScript(bean, dataNode);
        double[][] data = (double[][])dataNode.getData();
        EChartUtils.checkChartDataIsNull((Object[])data, bean.getLables());
        return s;
    }

    @Override
    public Option transfer2Opiton(Bar2DBean bean, FusionChartDataNode dataNode) {
        Option p = super.transfer2Opiton(bean, dataNode);
        String[] labels = bean.getLables();
        Chart chart = bean.getChart();
        double[][] data = (double[][])dataNode.getData();
        Bar bar = new Bar();
        ValueAxis valueAxis = new ValueAxis();
        valueAxis.name(chart.yScaleUnit);
        valueAxis.position((Object)Position.right);
        p.xAxis().add(valueAxis);
        CategoryAxis caxis = new CategoryAxis();
        for (String label : labels) {
            caxis.data().add(label);
        }
        int size = this.getColorList().size();
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                if (ChartFillColor1ComboBoxEditor.getHetero().equals(chart.plotGradientColor)) {
                    SeriesData seriesData = new SeriesData((Object)data[i][j]);
                    seriesData.itemStyle().color((Object)new Var("colors[" + j % size + "]"));
                    bar.data().add(seriesData);
                    continue;
                }
                bar.data().add(data[i][j]);
            }
        }
        p.yAxis().add(caxis);
        p.series().add(bar);
        return p;
    }

    @Override
    public Option mockOption(Bar2DBean bean) {
        Option p = super.mockOption(bean);
        EChartUtils.configPlotGradientColor(bean, p);
        Var tooltipFormatter = JSUtils.getTooltipFormatterVar(true, true, false, null);
        p.tooltip().formatter((Object)tooltipFormatter);
        p.grid().containLabel(Boolean.TRUE);
        CategoryAxis caxis = new CategoryAxis();
        caxis.setData(Arrays.asList(CtrlEXTMessages.getMLS("brazil", "\u5df4\u897f"), CtrlEXTMessages.getMLS("indonesia", "\u5370\u5c3c"), CtrlEXTMessages.getMLS("unitedStates", "\u7f8e\u56fd"), CtrlEXTMessages.getMLS("india", "\u5370\u5ea6"), CtrlEXTMessages.getMLS("china", "\u4e2d\u56fd"), CtrlEXTMessages.getMLS("worldPopulation", "\u4e16\u754c\u4eba\u53e3(\u767e\u4e07)")));
        EChartUtils.configAxisText(bean, (Axis)caxis);
        p.yAxis().add(caxis);
        ValueAxis valueAxis = new ValueAxis();
        valueAxis.setBoundaryGap(Arrays.asList(0.0, 0.01));
        EChartUtils.configAxisLucency(bean, (Axis)valueAxis, true);
        p.xAxis().add(valueAxis);
        Bar bar1 = new Bar();
        List<Color> colorList = this.getColorList();
        int size = colorList.size();
        if (ChartFillColor1ComboBoxEditor.getHetero().equals(bean.getChart_plotGradientColor())) {
            bar1.data(new Object[]{new SeriesData((Object)182, new ItemStyle().color((Object)new Var("colors[" + 0 % size + "]"))), new SeriesData((Object)234, new ItemStyle().color((Object)new Var("colors[" + 1 % size + "]"))), new SeriesData((Object)290, new ItemStyle().color((Object)new Var("colors[" + 2 % size + "]"))), new SeriesData((Object)1049, new ItemStyle().color((Object)new Var("colors[" + 3 % size + "]"))), new SeriesData((Object)1317, new ItemStyle().color((Object)new Var("colors[" + 4 % size + "]"))), new SeriesData((Object)6302, new ItemStyle().color((Object)new Var("colors[" + 5 % size + "]")))});
        } else {
            bar1.setData(Arrays.asList(182, 234, 290, 1049, 1317, 6302));
        }
        EChartUtils.configShowValue(bean, (Series)bar1);
        EChartUtils.configTrendline(bean, (Series)bar1);
        EChartUtils.configAngleRound(bean, (Series)bar1);
        EChartUtils.configPlotBorder(bean, (Series)bar1);
        p.series().add(bar1);
        EChartUtils.configMaxMinValue(bean, p, 6302.0, 0.0);
        EChartUtils.configSort(bean, p);
        EChartUtils.configBorder(bean, p);
        return p;
    }

    @Override
    public String initMockScript(Bar2DBean bean) {
        if (ChartFillColorComboBoxEditor.getGradient().equals(bean.getChart_plotGradientColor())) {
            return super.initMockScript(bean) + EChartUtils.getPlotGradientColor(this.isyValueAxis(), this.isxValueAxis(), this.getColorList());
        }
        return super.initMockScript(bean);
    }
}

