/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.column;

import com.github.abel533.echarts.Option;
import com.github.abel533.echarts.axis.Axis;
import com.github.abel533.echarts.axis.CategoryAxis;
import com.github.abel533.echarts.axis.ValueAxis;
import com.github.abel533.echarts.code.AxisType;
import com.github.abel533.echarts.code.PointerType;
import com.github.abel533.echarts.code.Trigger;
import com.github.abel533.echarts.json.Var;
import com.github.abel533.echarts.series.Bar;
import com.github.abel533.echarts.series.Series;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.ChartFillColorComboBoxEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.column.StackedColumn2DBean;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.constants.EChartsType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.AbstractStackedTransfer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.script.JSUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.util.EChartUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import java.util.Arrays;

public class StackedColumn2DBeanTransferImpl
extends AbstractStackedTransfer<StackedColumn2DBean> {
    public StackedColumn2DBeanTransferImpl() {
        super(EChartsType.BAR, CtrlEXTMessages.getMLS("stackedColumnChart2D", "\u5806\u79ef2D\u67f1\u5f62\u56fe"));
    }

    @Override
    public String initScript(StackedColumn2DBean bean, FusionChartDataNode dataNode) {
        String s = super.initScript(bean, dataNode);
        double[][] data = (double[][])dataNode.getData();
        EChartUtils.checkChartDataIsNull((Object[])data, dataNode.getGroupKeys(), (String[])dataNode.getSeriesKeys());
        return s;
    }

    @Override
    public Option transfer2Opiton(StackedColumn2DBean bean, FusionChartDataNode dataNode) {
        Option p = super.transfer2Opiton(bean, dataNode);
        String[] labels = dataNode.getGroupKeys();
        double[][] data = (double[][])dataNode.getData();
        String[] series = (String[])dataNode.getSeriesKeys();
        ValueAxis valueAxis = new ValueAxis();
        valueAxis.nameTextStyle().width(Integer.valueOf(35));
        valueAxis.name(bean.getChart().yScaleUnit);
        p.yAxis().add(valueAxis);
        if (null != p.getTooltip()) {
            p.tooltip().trigger(Trigger.axis);
            p.tooltip().axisPointer().type(PointerType.shadow);
        }
        CategoryAxis caxis = new CategoryAxis();
        for (String label : labels) {
            caxis.data().add(label);
        }
        for (int i = 0; i < data.length; ++i) {
            Bar bar = new Bar();
            bar.stack("total");
            bar.name(series[i]);
            for (int j = 0; j < data[i].length; ++j) {
                bar.data().add(data[i][j]);
            }
            p.series().add(bar);
        }
        p.xAxis().add(caxis);
        return p;
    }

    @Override
    public Option mockOption(StackedColumn2DBean bean) {
        Option p = super.mockOption(bean);
        EChartUtils.configPlotGradientColor(bean, p);
        Var tooltipFormatter = JSUtils.getTooltipFormatterVar(true, true, true, null);
        p.tooltip().formatter((Object)tooltipFormatter);
        CategoryAxis caxis = new CategoryAxis();
        caxis.setData(Arrays.asList("Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"));
        EChartUtils.configAxisText(bean, (Axis)caxis);
        p.xAxis().add(caxis);
        CategoryAxis yAxis = new CategoryAxis();
        yAxis.type(AxisType.value);
        EChartUtils.configAxisLucency(bean, (Axis)yAxis, true);
        p.yAxis().add(yAxis);
        p.tooltip().trigger(Trigger.axis);
        p.tooltip().axisPointer().type(PointerType.shadow);
        p.legend().data(Arrays.asList(CtrlEXTMessages.getMLS("year2020", "2020\u5e74"), CtrlEXTMessages.getMLS("year2021", "2021\u5e74")));
        Bar bar1 = new Bar();
        bar1.name(CtrlEXTMessages.getMLS("year2020", "2020\u5e74"));
        bar1.stack("total");
        bar1.setData(Arrays.asList(120, 200, 150, 80, 70, 110, 130));
        EChartUtils.configShowValue(bean, (Series)bar1);
        EChartUtils.configTrendline(bean, (Series)bar1);
        EChartUtils.configPlotBorder(bean, (Series)bar1);
        Bar bar2 = new Bar();
        bar2.name(CtrlEXTMessages.getMLS("year2021", "2021\u5e74"));
        bar2.stack("total");
        bar2.setData(Arrays.asList(50, 120, 200, 30, 120, 60, 150));
        EChartUtils.configShowValue(bean, (Series)bar2);
        EChartUtils.configAngleRound(bean, (Series)bar2);
        EChartUtils.configPlotBorder(bean, (Series)bar2);
        EChartUtils.configTrendLineOnTop(bean, (Series)bar2);
        p.series().add(bar1);
        p.series().add(bar2);
        EChartUtils.configMaxMinValue(bean, p, 350.0, 0.0);
        EChartUtils.configBorder(bean, p);
        return p;
    }

    @Override
    public String afterMockScript(StackedColumn2DBean bean) {
        String str = "";
        if (bean.getChart_useRoundEdges().getBooleanValue().booleanValue()) {
            str = str + JSUtils.STACKED_DROUNDCORNERSRESIZE;
        }
        return str + super.afterMockScript(bean);
    }

    @Override
    public String afterScript(StackedColumn2DBean b, FusionChartDataNode data, Option p) {
        String s = super.afterScript(b, data, p);
        if ("1".equals(b.getChart().useRoundEdges)) {
            s = s + JSUtils.STACKED_DROUNDCORNERSRESIZE;
        }
        return s;
    }

    @Override
    public String initMockScript(StackedColumn2DBean bean) {
        if (ChartFillColorComboBoxEditor.getGradient().equals(bean.getChart_plotGradientColor())) {
            return super.initMockScript(bean) + EChartUtils.getPlotGradientColor(this.isyValueAxis(), this.isxValueAxis(), this.getColorList());
        }
        return super.initMockScript(bean);
    }
}

