/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.column;

import com.github.abel533.echarts.Option;
import com.github.abel533.echarts.axis.Axis;
import com.github.abel533.echarts.axis.CategoryAxis;
import com.github.abel533.echarts.axis.ValueAxis;
import com.github.abel533.echarts.code.AxisType;
import com.github.abel533.echarts.code.PointerType;
import com.github.abel533.echarts.code.Symbol;
import com.github.abel533.echarts.code.Trigger;
import com.github.abel533.echarts.json.Var;
import com.github.abel533.echarts.series.Bar;
import com.github.abel533.echarts.series.PictorialBar;
import com.github.abel533.echarts.series.Series;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.column.StackedColumn3DBean;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.constants.EChartsType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.TransferUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.AbstractStackedTransfer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.script.JSUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.util.EChartUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import java.util.Arrays;

public class StackedColumn3DBeanTransferImpl
extends AbstractStackedTransfer<StackedColumn3DBean> {
    public StackedColumn3DBeanTransferImpl() {
        super(EChartsType.BAR3D, CtrlEXTMessages.getMLS("stacked3DColumnChart", "\u5806\u79ef3D\u67f1\u72b6\u56fe"));
    }

    @Override
    public String initScript(StackedColumn3DBean bean, FusionChartDataNode dataNode) {
        double[][] data = (double[][])dataNode.getData();
        EChartUtils.checkChartDataIsNull((Object[])data, dataNode.getGroupKeys(), (String[])dataNode.getSeriesKeys());
        return super.initScript(bean, dataNode) + this.buildColorStopsLeft(data.length, bean.initColors().size());
    }

    @Override
    public Option transfer2Opiton(StackedColumn3DBean bean, FusionChartDataNode dataNode) {
        double[][] data = (double[][])dataNode.getData();
        Object[] series = (String[])dataNode.getSeriesKeys();
        ValueAxis valueAxis = new ValueAxis();
        valueAxis.nameTextStyle().width(Integer.valueOf(35));
        valueAxis.name(bean.getChart().yScaleUnit);
        Option p = super.transfer2Opiton(bean, dataNode);
        p.yAxis().add(valueAxis);
        if (null != p.getLegend()) {
            p.legend().data(series);
        }
        if (null != p.getTooltip()) {
            p.tooltip().trigger(Trigger.axis);
            p.tooltip().axisPointer().type(PointerType.shadow);
        }
        CategoryAxis caxis = new CategoryAxis();
        for (String group : this.groups) {
            caxis.data().add(group);
        }
        double[] proportion = TransferUtils.getStackedDiamondProportion(data);
        for (int i = 0; i < data.length; ++i) {
            Bar bar = new Bar();
            bar.z(Integer.valueOf(1));
            bar.name((String)series[i]);
            bar.itemStyle().normal().color((Object)("function(){return colorStop" + i + " ;}"));
            PictorialBar p2 = new PictorialBar();
            p2.name((String)series[i]);
            p2.z(Integer.valueOf(2));
            p2.tooltip().trigger(Trigger.none);
            p2.symbol((Object)"diamond");
            p2.symbolOffset((Object)0, (Object)"-50%");
            p2.itemStyle().normal().color((Object)"function(index){return colors[((index.seriesIndex + 1) / 2 -1)  % colors.length];}");
            p2.symbolSize((Object)new String[]{"100%", proportion[i] * 30.0 + "%"});
            p2.setSymbolPosition((Object)"end");
            for (int j = 0; j < data[i].length; ++j) {
                bar.stack(this.groups[j]);
                bar.data().add(data[i][j]);
                if (StringUtil.isEmptyString((String)bean.getChart().yAxisMaxValue)) {
                    p2.data().add(TransferUtils.stackValueGroupByNeg(data, j, i, data[i][j] < 0.0));
                    continue;
                }
                Object[] values = (Object[])dataNode.getFormula(FusionChartDataNode.XY_MAX_MIN);
                if (values == null || values.length == 0 || !StringUtil.isEmptyString((String)String.valueOf(values[2]))) {
                    p2.data().add(Math.min(Double.parseDouble(bean.getChart().yAxisMaxValue), TransferUtils.stackValueGroupByNeg(data, j, i, data[i][j] < 0.0)));
                    continue;
                }
                p2.data().add(TransferUtils.stackValueGroupByNeg(data, j, i, data[i][j] < 0.0));
            }
            p.series().add(bar);
            p.series().add(p2);
        }
        p.xAxis().add(caxis);
        return p;
    }

    @Override
    public String initMockScript(StackedColumn3DBean bean) {
        return super.initMockScript(bean) + this.buildColorStopsLeft(5, bean.initColors().size());
    }

    @Override
    public Option mockOption(StackedColumn3DBean bean) {
        Option p = super.mockOption(bean);
        Var tooltipFormatter = JSUtils.getTooltipFormatterVar(true, true, true, null);
        p.tooltip().formatter((Object)tooltipFormatter);
        CategoryAxis caxis = new CategoryAxis();
        caxis.setData(Arrays.asList("2018", "2019", "2020", "2021"));
        EChartUtils.configAxisText(bean, (Axis)caxis);
        p.xAxis().add(caxis);
        CategoryAxis yAxis = new CategoryAxis();
        yAxis.type(AxisType.value);
        EChartUtils.configAxisLucency(bean, (Axis)yAxis, true);
        p.yAxis().add(yAxis);
        p.tooltip().trigger(Trigger.axis);
        p.tooltip().axisPointer().type(PointerType.shadow);
        p.legend().data(Arrays.asList(CtrlEXTMessages.getMLS("shanghai", "\u4e0a\u6d77"), CtrlEXTMessages.getMLS("guangdong", "\u5e7f\u4e1c"), CtrlEXTMessages.getMLS("zhejiang", "\u6d59\u6c5f"), CtrlEXTMessages.getMLS("jiangxi", "\u6c5f\u897f"), CtrlEXTMessages.getMLS("shanxi", "\u5c71\u897f")));
        Bar bar1 = new Bar();
        bar1.name(CtrlEXTMessages.getMLS("shanghai", "\u4e0a\u6d77"));
        bar1.stack("2021");
        bar1.itemStyle().normal().color((Object)new Var("function(){return colorStop0;}"));
        bar1.setData(Arrays.asList(542.0, 642.0, 801.0, 874.0));
        PictorialBar pbar1 = new PictorialBar();
        pbar1.itemStyle().normal().color((Object)new Var("colors[0  % colors.length]"));
        pbar1.tooltip().trigger(Trigger.none);
        pbar1.symbol(Symbol.diamond);
        pbar1.symbolSize(Arrays.asList("100%", "15"));
        pbar1.symbolOffset(new Object[]{0, "-50%"});
        pbar1.setSymbolPosition((Object)"end");
        pbar1.data(new Object[]{542.0, 642.0, 801.0, 874.0});
        EChartUtils.configShowValue(bean, (Series)bar1);
        EChartUtils.configTrendline(bean, (Series)bar1);
        EChartUtils.configPlotBorder(bean, (Series)bar1);
        EChartUtils.configPlotBorder(bean, (Series)pbar1);
        EChartUtils.configTrendLineOnTop(bean, (Series)bar1);
        EChartUtils.configRhombusTrendLineOnTop(bean, (Series)pbar1);
        p.series().add(bar1);
        p.series().add(pbar1);
        Bar bar2 = new Bar();
        bar2.name(CtrlEXTMessages.getMLS("guangdong", "\u5e7f\u4e1c"));
        bar2.stack("2021");
        bar2.itemStyle().normal().color((Object)new Var("function(){return colorStop1;}"));
        bar2.setData(Arrays.asList(549.0, 564.0, 625.0, 673.0));
        PictorialBar pbar2 = new PictorialBar();
        pbar2.itemStyle().normal().color((Object)new Var("colors[1  % colors.length]"));
        pbar2.tooltip().trigger(Trigger.none);
        pbar2.symbol(Symbol.diamond);
        pbar2.symbolSize(Arrays.asList("100%", "15"));
        pbar2.symbolOffset(new Object[]{0, "-50%"});
        pbar2.setSymbolPosition((Object)"end");
        pbar2.data(new Object[]{1091.0, 1206.0, 1426.0, 1547.0});
        EChartUtils.configShowValue(bean, (Series)bar2);
        EChartUtils.configPlotBorder(bean, (Series)bar2);
        EChartUtils.configPlotBorder(bean, (Series)pbar2);
        EChartUtils.configTrendLineOnTop(bean, (Series)bar2);
        EChartUtils.configRhombusTrendLineOnTop(bean, (Series)pbar2);
        p.series().add(bar2);
        p.series().add(pbar2);
        Bar bar3 = new Bar();
        bar3.name(CtrlEXTMessages.getMLS("zhejiang", "\u6d59\u6c5f"));
        bar3.stack("2021");
        bar3.itemStyle().normal().color((Object)new Var("function(){return colorStop2;}"));
        bar3.setData(Arrays.asList(526.0, 541.0, 563.0, 605.0));
        PictorialBar pbar3 = new PictorialBar();
        pbar3.itemStyle().normal().color((Object)new Var("colors[2  % colors.length]"));
        pbar3.tooltip().trigger(Trigger.none);
        pbar3.symbol(Symbol.diamond);
        pbar3.symbolSize(Arrays.asList("100%", "15"));
        pbar3.symbolOffset(new Object[]{0, "-50%"});
        pbar3.setSymbolPosition((Object)"end");
        pbar3.data(new Object[]{1617.0, 1747.0, 1989.0, 2152.0});
        EChartUtils.configShowValue(bean, (Series)bar3);
        EChartUtils.configPlotBorder(bean, (Series)bar3);
        EChartUtils.configPlotBorder(bean, (Series)pbar3);
        EChartUtils.configTrendLineOnTop(bean, (Series)bar3);
        EChartUtils.configRhombusTrendLineOnTop(bean, (Series)pbar3);
        p.series().add(bar3);
        p.series().add(pbar3);
        Bar bar4 = new Bar();
        bar4.name(CtrlEXTMessages.getMLS("jiangxi", "\u6c5f\u897f"));
        bar4.stack("2021");
        bar4.itemStyle().normal().color((Object)new Var("function(){return colorStop3;}"));
        bar4.setData(Arrays.asList(436.0, 455.0, 463.0, 488.0));
        PictorialBar pbar4 = new PictorialBar();
        pbar4.itemStyle().normal().color((Object)new Var("colors[3  % colors.length]"));
        pbar4.tooltip().trigger(Trigger.none);
        pbar4.symbol(Symbol.diamond);
        pbar4.symbolSize(Arrays.asList("100%", "15"));
        pbar4.symbolOffset(new Object[]{0, "-50%"});
        pbar4.setSymbolPosition((Object)"end");
        pbar4.data(new Object[]{2053.0, 2202.0, 2452.0, 2640.0});
        EChartUtils.configShowValue(bean, (Series)bar4);
        EChartUtils.configPlotBorder(bean, (Series)bar4);
        EChartUtils.configPlotBorder(bean, (Series)pbar4);
        EChartUtils.configTrendLineOnTop(bean, (Series)bar4);
        EChartUtils.configRhombusTrendLineOnTop(bean, (Series)pbar4);
        p.series().add(bar4);
        p.series().add(pbar4);
        Bar bar5 = new Bar();
        bar5.name(CtrlEXTMessages.getMLS("shanxi", "\u5c71\u897f"));
        bar5.stack("2021");
        bar5.itemStyle().normal().color((Object)new Var("function(){return colorStop4;}"));
        bar5.setData(Arrays.asList(401.0, 412.0, 425.0, 436.0));
        PictorialBar pbar5 = new PictorialBar();
        pbar5.itemStyle().normal().color((Object)new Var("colors[4  % colors.length]"));
        pbar5.tooltip().trigger(Trigger.none);
        pbar5.symbol(Symbol.diamond);
        pbar5.symbolSize(Arrays.asList("100%", "15"));
        pbar5.symbolOffset(new Object[]{0, "-50%"});
        pbar5.setSymbolPosition((Object)"end");
        pbar5.data(new Object[]{2454.0, 2614.0, 2877.0, 3076.0});
        EChartUtils.configShowValue(bean, (Series)bar5);
        EChartUtils.configPlotBorder(bean, (Series)bar5);
        EChartUtils.configPlotBorder(bean, (Series)pbar5);
        EChartUtils.configTrendLineOnTop(bean, (Series)bar5);
        EChartUtils.configRhombusTrendLineOnTop(bean, (Series)pbar5);
        p.series().add(bar5);
        p.series().add(pbar5);
        EChartUtils.configMaxMinValue(bean, p, 3076.0, 0.0);
        EChartUtils.hideDrawRB(bean, p, 3076.0);
        EChartUtils.configBorder(bean, p);
        return p;
    }

    @Override
    public String afterMockScript(StackedColumn3DBean bean) {
        return super.afterMockScript(bean) + JSUtils.ONLEGENDCHANGED_FUNCTION;
    }

    @Override
    public String afterScript(StackedColumn3DBean b, FusionChartDataNode data, Option p) {
        String script = super.afterScript(b, data, p);
        return script + JSUtils.ONLEGENDCHANGED_FUNCTION;
    }
}

