/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.gantt;

import com.github.abel533.echarts.AbstractData;
import com.github.abel533.echarts.Option;
import com.github.abel533.echarts.axis.Axis;
import com.github.abel533.echarts.axis.CategoryAxis;
import com.github.abel533.echarts.axis.ValueAxis;
import com.github.abel533.echarts.code.AxisType;
import com.github.abel533.echarts.code.LineType;
import com.github.abel533.echarts.code.Position;
import com.github.abel533.echarts.code.SeriesType;
import com.github.abel533.echarts.code.Trigger;
import com.github.abel533.echarts.code.Y;
import com.github.abel533.echarts.json.Var;
import com.github.abel533.echarts.series.Bar;
import com.github.abel533.echarts.series.Series;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.gantt.GanttBean;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Chart;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.constants.EChartsType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.ChartDataTransferUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.TransferUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.AbstractBarTransfer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.util.EChartUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import com.kingdee.cosmic.ctrl.swing.util.CtrlFormatUtilities;
import java.lang.reflect.Array;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.log4j.Logger;

public class GanttBeanTransferImpl
extends AbstractBarTransfer<GanttBean> {
    private static final Logger logger = LogUtil.getPackageLogger(GanttBeanTransferImpl.class);
    private Calendar cal = Calendar.getInstance(CtrlFormatUtilities.getTimeZone());
    private SimpleDateFormat dateFormat;
    private static final String STACKKEY = "plan";

    public GanttBeanTransferImpl() {
        super(EChartsType.BAR, CtrlEXTMessages.getMLS("ganttChart", "\u7518\u7279\u56fe"));
    }

    @Override
    public Option transfer2Opiton(GanttBean bean, FusionChartDataNode dataNode) {
        Bar b;
        Option p = super.transfer2Opiton(bean, dataNode);
        String[] captions = bean.buildChartCaptions1(dataNode);
        Chart chart = bean.getChart();
        Object val = dataNode.getData(FusionChartDataNode.GANTT_TASK_START);
        boolean isHour = dataNode.getDateFormat();
        this.dateFormat = isHour ? new SimpleDateFormat("yyyy/M/dd HH:mm:ss") : new SimpleDateFormat("yyyy/M/dd");
        String[] startDate = null;
        if (val != null) {
            try {
                startDate = bean.parseDate((Variant[][])Array.get(val, 0));
            }
            catch (Exception e) {
                throw new IllegalArgumentException(CtrlEXTMessages.getMLS("plannedStartTimeSettingError", "\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4\u8bbe\u7f6e\u9519\u8bef"), e);
            }
        } else {
            throw new RuntimeException(CtrlEXTMessages.getMLS("plannedStartTimeEmpty", "\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4\u4e3a\u7a7a"));
        }
        String[] endDate = null;
        val = dataNode.getData(FusionChartDataNode.GANTT_TASK_END);
        if (val != null) {
            try {
                endDate = bean.parseDate((Variant[][])Array.get(val, 0));
            }
            catch (Exception e) {
                throw new IllegalArgumentException(CtrlEXTMessages.getMLS("plannedEndTimeSettingError", "\u8ba1\u5212\u7ed3\u675f\u65f6\u95f4\u8bbe\u7f6e\u9519\u8bef"), e);
            }
        } else {
            throw new RuntimeException(CtrlEXTMessages.getMLS("plannedEndTimeEmpty", "\u8ba1\u5212\u7ed3\u675f\u65f6\u95f4\u4e3a\u7a7a"));
        }
        if ((endDate == null || endDate.length == 0) && null != startDate) {
            val = dataNode.getData(FusionChartDataNode.GANTT_TASK_WORKLOAD);
            Object[][] workload = (Object[][])Array.get(val, 0);
            endDate = new String[startDate.length];
            try {
                for (int i = 0; i < startDate.length; ++i) {
                    this.cal.setTime(bean.parse(startDate[i]));
                    if (isHour) {
                        this.cal.add(11, ((Variant)workload[0][i]).intValue());
                    } else {
                        this.cal.add(5, ((Variant)workload[0][i]).intValue());
                    }
                    endDate[i] = this.dateFormat.format(this.cal.getTime());
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException(CtrlEXTMessages.getMLS("conversionWorkloadError", "\u8f6c\u6362\u5de5\u4f5c\u8d1f\u8f7d\u51fa\u9519\uff1a"), e);
            }
        }
        String[] startDateAC = null;
        val = dataNode.getData(FusionChartDataNode.GANTT_TASK_START_PLAN);
        if (val != null) {
            try {
                startDateAC = bean.parseDate((Variant[][])Array.get(val, 0));
            }
            catch (Exception e) {
                throw new IllegalArgumentException(CtrlEXTMessages.getMLS("actualStartTimeSettingError", "\u5b9e\u9645\u5f00\u59cb\u65f6\u95f4\u8bbe\u7f6e\u9519\u8bef"), e);
            }
        }
        String[] endDateAC = null;
        val = dataNode.getData(FusionChartDataNode.GANTT_TASK_END_PLAN);
        if (val != null) {
            try {
                endDateAC = bean.parseDate((Variant[][])Array.get(val, 0));
            }
            catch (Exception e) {
                logger.error((Object)"err", (Throwable)e);
            }
        }
        if (startDateAC != null && (endDateAC == null || endDateAC.length == 0)) {
            val = dataNode.getData(FusionChartDataNode.GANTT_TASK_WORKLOAD);
            Object[][] workload = (Object[][])Array.get(val, 0);
            endDateAC = new String[startDateAC.length];
            try {
                for (int i = 0; i < startDateAC.length; ++i) {
                    this.cal.setTime(bean.parse(startDateAC[i]));
                    if (isHour) {
                        this.cal.add(11, ((Variant)workload[0][i]).intValue());
                    } else {
                        this.cal.add(5, ((Variant)workload[0][i]).intValue());
                    }
                    endDateAC[i] = this.dateFormat.format(this.cal.getTime());
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException(CtrlEXTMessages.getMLS("conversionActualWorkloadError", "\u8f6c\u6362\u5b9e\u9645\u5de5\u4f5c\u8d1f\u8f7d\u51fa\u9519\uff1a"), e);
            }
        }
        ValueAxis valueAxis = new ValueAxis();
        valueAxis.position((Object)"top");
        p.xAxis().add(valueAxis);
        CategoryAxis caxis = new CategoryAxis();
        String[] names = null;
        val = dataNode.getData(FusionChartDataNode.GANTT_TASK_NAME);
        if (val != null) {
            names = bean.parse(Array.get(val, 0));
            int maxLableLength = 0;
            for (String label : names) {
                maxLableLength = Math.max(maxLableLength, label.length());
                caxis.data().add(label);
            }
        }
        p.tooltip().trigger(Trigger.axis);
        p.tooltip().formatter((Object)new Var("function(params){var res = params[0].name + '</br>';var time = 0;for(var n = 0; n < params.length; n++){time = params[n].data; var d = new Date(Number(time));var dateStr = d.getFullYear() + '-' + (d.getMonth() + 1) + '-' + d.getDate() + '</br>';res = res + params[n].seriesName + ':' + dateStr;}return res;}"));
        long min = 0L;
        if (startDate == null || endDate == null) {
            return null;
        }
        try {
            min = this.dateFormat.parse(startDate[0]).getTime();
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(CtrlEXTMessages.getMLS("timeParsingError", "\u89e3\u6790\u65f6\u95f4\u51fa\u9519\uff1a"), e);
        }
        long max = 0L;
        Bar startDateBar = new Bar();
        startDateBar.name(CtrlEXTMessages.getMLS("plannedStartDate", "\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4"));
        startDateBar.itemStyle().color((Object)"rgba(255,255,255,0)");
        for (int i = 0; i < startDate.length; ++i) {
            try {
                long startDateTime = this.dateFormat.parse(startDate[i]).getTime();
                min = Math.min(startDateTime, min);
                startDateBar.data().add(startDateTime);
                continue;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(CtrlEXTMessages.getMLS("timeParsingError", "\u89e3\u6790\u65f6\u95f4\u51fa\u9519\uff1a"), e);
            }
        }
        p.series().add(startDateBar);
        Bar endDateBar = new Bar();
        endDateBar.name(CtrlEXTMessages.getMLS("plannedEndDate", "\u8ba1\u5212\u7ed3\u675f\u65f6\u95f4"));
        endDateBar.itemStyle().color((Object)"rgba(255,255,255,0)");
        for (int i = 0; i < endDate.length; ++i) {
            try {
                long endTime = this.dateFormat.parse(endDate[i]).getTime();
                max = Math.max(endTime, max);
                endDateBar.data().add(endTime);
                continue;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(CtrlEXTMessages.getMLS("timeParsingError", "\u89e3\u6790\u65f6\u95f4\u51fa\u9519\uff1a"), e);
            }
        }
        p.series().add(endDateBar);
        Bar startDateACBar = null;
        if (null != startDateAC) {
            startDateACBar = new Bar();
            startDateACBar.name(CtrlEXTMessages.getMLS("actualStartDate", "\u5b9e\u9645\u5f00\u59cb\u65f6\u95f4"));
            startDateACBar.itemStyle().color((Object)"rgba(255,255,255,0)");
            for (int i = 0; i < startDateAC.length; ++i) {
                try {
                    long startDateACTime = this.dateFormat.parse(startDateAC[i]).getTime();
                    startDateACBar.data().add(startDateACTime);
                    continue;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(CtrlEXTMessages.getMLS("timeParsingError", "\u89e3\u6790\u65f6\u95f4\u51fa\u9519\uff1a"), e);
                }
            }
            p.series().add(startDateACBar);
        }
        Bar endDateACBar = null;
        if (null != endDateAC) {
            endDateACBar = new Bar();
            endDateACBar.name(CtrlEXTMessages.getMLS("actualEndDate", "\u5b9e\u9645\u7ed3\u675f\u65f6\u95f4"));
            endDateACBar.itemStyle().color((Object)"rgba(255,255,255,0)");
            for (int i = 0; i < endDateAC.length; ++i) {
                try {
                    long endACTime = this.dateFormat.parse(endDateAC[i]).getTime();
                    max = Math.max(endACTime, max);
                    endDateACBar.data().add(endACTime);
                    continue;
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException(CtrlEXTMessages.getMLS("timeParsingError", "\u89e3\u6790\u65f6\u95f4\u51fa\u9519\uff1a"), e);
                }
            }
            p.series().add(endDateACBar);
        }
        for (int i = 0; i < p.getSeries().size(); ++i) {
            Series s = (Series)p.series().get(i);
            if (s.getType() != SeriesType.bar) continue;
            b = (Bar)s;
            for (int j = 0; j < b.data().size(); ++j) {
                String timePlan = "";
                if (null != captions && captions.length > 11 && captions[11].equalsIgnoreCase("true")) {
                    b.markLine().label().show(Boolean.TRUE);
                    b.markLine().label().position((Object)"insideMiddle");
                    b.markLine().label().textStyle().fontSize(ChartDataTransferUtil.parseInteger(captions[7]));
                    b.markLine().label().color("#000");
                    if (names != null) {
                        timePlan = names[j];
                    }
                }
                if (b.name().equals(CtrlEXTMessages.getMLS("plannedStartDate", "\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4")) || b.name().equals(CtrlEXTMessages.getMLS("plannedEndDate", "\u8ba1\u5212\u7ed3\u675f\u65f6\u95f4"))) {
                    b.markLine().lineStyle().color((Object)new Var("colors[0]"));
                    if (b.name().equals(CtrlEXTMessages.getMLS("plannedStartDate", "\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4"))) {
                        b.markLine().lineStyle().color((Object)"rgba(255,255,255,0)");
                        b.markPoint().label().color("rgba(255,255,255,0)");
                    }
                    if (timePlan.length() < 1) {
                        b.markLine().label().show(Boolean.FALSE);
                    }
                    if (b.name().equals(CtrlEXTMessages.getMLS("plannedEndDate", "\u8ba1\u5212\u7ed3\u675f\u65f6\u95f4"))) {
                        this.configureDisplayBar((Series)b, startDateBar, endDateBar, timePlan, j);
                        if (null != captions && captions.length > 24 && captions[24].equalsIgnoreCase("true")) {
                            this.configureTimePoint((Series)b, startDateBar.data().get(j).toString(), j);
                            b.markPoint().label().position(Position.insideLeft);
                        }
                        if (null != captions && captions.length > 25 && captions[25].equalsIgnoreCase("true")) {
                            this.configureTimePoint((Series)b, endDateBar.data().get(j).toString(), j);
                            b.markPoint().label().position(Position.insideRight);
                        }
                    }
                    if (null == captions || captions.length <= 9) continue;
                    b.markPoint().label().textStyle().fontSize(ChartDataTransferUtil.parseInteger(captions[8]));
                    continue;
                }
                if (!b.name().equals(CtrlEXTMessages.getMLS("actualStartDate", "\u5b9e\u9645\u5f00\u59cb\u65f6\u95f4")) && !b.name().equals(CtrlEXTMessages.getMLS("actualEndDate", "\u5b9e\u9645\u7ed3\u675f\u65f6\u95f4")) || null == startDateAC || null == endDateAC) continue;
                b.markLine().lineStyle().color((Object)new Var("colors[1]"));
                if (b.name().equals(CtrlEXTMessages.getMLS("actualStartDate", "\u5b9e\u9645\u5f00\u59cb\u65f6\u95f4"))) {
                    b.markLine().lineStyle().color((Object)"rgba(255,255,255,0)");
                    b.markPoint().label().color("rgba(255,255,255,0)");
                }
                if (b.name().equals(CtrlEXTMessages.getMLS("actualEndDate", "\u5b9e\u9645\u7ed3\u675f\u65f6\u95f4"))) {
                    this.configureDisplayBar((Series)b, startDateACBar, endDateACBar, "", j);
                    if (startDateACBar != null && null != captions && captions.length > 12 && captions[12].equalsIgnoreCase("true")) {
                        this.configureTimePoint((Series)b, startDateACBar.data().get(j).toString(), j);
                        b.markPoint().label().position(Position.insideLeft);
                    }
                    if (null != captions && captions.length > 13 && captions[13].equalsIgnoreCase("true")) {
                        this.configureTimePoint((Series)b, endDateACBar.data().get(j).toString(), j);
                        b.markPoint().label().position(Position.insideRight);
                    }
                }
                if (null == captions || captions.length <= 9) continue;
                b.markPoint().label().textStyle().fontSize(ChartDataTransferUtil.parseInteger(captions[8]));
            }
        }
        valueAxis.axisLabel().formatter((Object)new Var("function (value, index) { var date = new Date(value);if(value.value){date = new Date(value.value);}var texts = [(date.getFullYear()),(date.getMonth() + 1), date.getDate()];return texts.join('/');}"));
        valueAxis.setMin((Object)min);
        valueAxis.setMax((Object)max);
        p.yAxis().add(caxis);
        p.legend().show(Boolean.FALSE);
        if (null != captions && captions.length > 14) {
            for (Series s : p.getSeries()) {
                if (s.getType() != SeriesType.bar) continue;
                b = (Bar)s;
                b.markLine().lineStyle().width(Integer.valueOf(captions[14]));
            }
        }
        return p;
    }

    private void configureDisplayBar(Series s, Bar startBarData, Bar endBarData, String name, int index) {
        if (s instanceof Bar) {
            Bar b = (Bar)s;
            b.markLine().symbol((Object)"none");
            b.markLine().lineStyle().type(LineType.solid);
            b.markLine().tooltip().show(Boolean.FALSE);
            TransferUtils.setTrendLineValue((AbstractData)b.markLine(), "[{name:'%s', coord:[%s,%s]},{coord:[%s,%s]}]", name, startBarData.data().get(index).toString(), index + "", endBarData.data().get(index).toString(), index + "");
        }
    }

    private void configureTimePoint(Series s, String name, int index) {
        if (s instanceof Bar) {
            Bar b = (Bar)s;
            b.markPoint().symbolSize((Object)1);
            b.markPoint().label().color("#000");
            b.markPoint().label().textStyle().fontSize(Integer.valueOf(12));
            b.markPoint().label().formatter((Object)new Var("function (params) { var v = 0;if(params.data && params.data.coord){v =  params.data.coord[0];} var d = new Date(v);var dateStr = d.getFullYear() + '-' + (d.getMonth() + 1) + '-' + d.getDate();return dateStr;}"));
            TransferUtils.setTrendLineValue((AbstractData)b.markPoint(), "{value:'%s', coord:[%s,%s]}", name, name, index + "");
        }
    }

    @Override
    public String initMockScript(GanttBean b) {
        return super.initMockScript(b);
    }

    @Override
    public Option mockOption(GanttBean bean) {
        Option p = super.mockOption(bean);
        p.tooltip().trigger(Trigger.axis);
        p.legend().show(Boolean.valueOf(false));
        CategoryAxis vaxis = new CategoryAxis();
        vaxis.type(AxisType.value);
        vaxis.position(Y.top);
        vaxis.axisLabel().textStyle().fontSize(Integer.valueOf(12));
        vaxis.axisLabel().textStyle().fontFamily("SimSun");
        vaxis.splitLine().lineStyle().opacity(Double.valueOf(0.5));
        vaxis.splitArea().show(Boolean.valueOf(true));
        vaxis.splitArea().areaStyle().opacity(Double.valueOf(0.5));
        vaxis.min((Object)"1147017600000");
        vaxis.max((Object)"1150732800000");
        vaxis.axisLabel().formatter((Object)new Var("function (value, index) { var date = new Date(value);if(value.value){date = new Date(value.value);}var texts = [(date.getFullYear()),(date.getMonth() + 1), date.getDate()];return texts.join('/');}"));
        CategoryAxis caxis = new CategoryAxis();
        caxis.data(new Object[]{CtrlEXTMessages.getMLS("projectDetermination", "\u9879\u76ee\u786e\u5b9a"), CtrlEXTMessages.getMLS("questionnaireDesign", "\u95ee\u5377\u8bbe\u8ba1"), CtrlEXTMessages.getMLS("trialVisit", "\u8bd5\u8bbf"), CtrlEXTMessages.getMLS("questionnaireDetermination", "\u95ee\u5377\u786e\u5b9a"), CtrlEXTMessages.getMLS("fieldExecution", "\u5b9e\u5730\u6267\u884c"), CtrlEXTMessages.getMLS("dataEntry", "\u6570\u636e\u5f55\u5165"), CtrlEXTMessages.getMLS("dataAnalysis", "\u6570\u636e\u5206\u6790"), CtrlEXTMessages.getMLS("reportSubmission", "\u62a5\u544a\u63d0\u4ea4")});
        vaxis.splitLine().lineStyle().opacity(Double.valueOf((double)bean.getChart_divLineAlpha().getIntegerValue().intValue() / 100.0));
        vaxis.splitArea().show(Boolean.valueOf(true));
        vaxis.splitArea().areaStyle().opacity(Double.valueOf((double)bean.getChart_alternateHGridAlpha().getIntegerValue().intValue() / 100.0));
        caxis.axisLabel().textStyle().fontFamily(bean.getChartBaseFontName());
        caxis.axisLabel().textStyle().setFontSize(bean.getProcessFontSize().getIntegerValue());
        vaxis.axisLabel().textStyle().fontFamily(bean.getChartBaseFontName());
        vaxis.axisLabel().textStyle().setFontSize(bean.getProcessHeadFontSize().getIntegerValue());
        p.xAxis().add(vaxis);
        p.yAxis().add(caxis);
        p.tooltip().formatter((Object)new Var("function(params){var res = params[0].name + '</br>';var time = 0;for(var n = 0; n < params.length; n++){time = params[n].data; var d = new Date(Number(time));var dateStr = d.getFullYear() + '-' + (d.getMonth() + 1) + '-' + d.getDate() + '</br>';res = res + params[n].seriesName + ':' + dateStr;}return res;}"));
        Bar bar = new Bar();
        bar.name(CtrlEXTMessages.getMLS("plannedStartDate", "\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4"));
        bar.itemStyle().color((Object)"rgba(255,255,255,0)");
        bar.markLine().symbol((Object)"none");
        bar.markLine().lineStyle().color((Object)"rgba(255,255,255,0)");
        bar.markLine().lineStyle().type(LineType.solid);
        bar.markLine().lineStyle().width(bean.getTaskHeight().getIntegerValue());
        bar.label().show(Boolean.valueOf(false));
        bar.markLine().data(new Object[]{new Var("[{name:'',coord:[1147017600000, 0]},{coord:[1147449600000, 0]}]"), new Var("[{name:'',coord:[1147363200000, 1]},{coord:[1147622400000, 1]}]"), new Var("[{name:'',coord:[1147449600000, 2]},{coord:[1147708800000, 2]}]"), new Var("[{name:'',coord:[1147622400000, 3]},{coord:[1147708800000, 3]}]"), new Var("[{name:'',coord:[1147708800000, 4]},{coord:[1148572800000, 4]}]"), new Var("[{name:'',coord:[1148572800000, 5]},{coord:[1149004800000, 5]}]"), new Var("[{name:'',coord:[1148918400000, 6]},{coord:[1149177600000, 6]}]"), new Var("[{name:'',coord:[1149177600000, 7]},{coord:[1149696000000, 7]}]")});
        bar.label().normal().color((Object)"#000");
        bar.label().normal().show(Boolean.valueOf(false));
        bar.data(new Object[]{"1147017600000", "1147363200000", "1147449600000", "1147622400000", "1147708800000", "1148572800000", "1148918400000", "1149177600000"});
        p.series().add(bar);
        bar = new Bar();
        bar.name(CtrlEXTMessages.getMLS("plannedEndDate", "\u8ba1\u5212\u7ed3\u675f\u65f6\u95f4"));
        bar.itemStyle().color((Object)"rgba(255,255,255,0)");
        bar.markPoint().symbolSize((Object)1);
        bar.markPoint().label().formatter((Object)new Var("function (params) { var v = 0;if(params.data && params.data.coord){v =  params.data.coord[0];} var d = new Date(v);var dateStr = d.getFullYear() + '-' + (d.getMonth() + 1) + '-' + d.getDate();return dateStr;}"));
        bar.markPoint().label().textStyle().fontSize(bean.getProcessHeadFontSize().getIntegerValue());
        bar.markPoint().label().color("#000");
        if (bean.getShowStartTime().getBooleanValue().booleanValue()) {
            bar.markPoint().label().position(Position.insideLeft);
            bar.markPoint().data(new Object[]{new Var("{value:'1147017600000',coord:[1147017600000,0]},{value:'1147363200000',coord:[1147363200000,1]},{value:'1147449600000',coord:[1147449600000,2]},{value:'1147622400000',coord:[1147622400000,3]},{value:'1147708800000',coord:[1147708800000,4]},{value:'1148572800000',coord:[1148572800000,5]},{value:'1148918400000',coord:[1148918400000,6]},{value:'1149177600000',coord:[1149177600000,7]}")});
        }
        if (bean.getShowEndTime().getBooleanValue().booleanValue()) {
            bar.markPoint().label().position(Position.insideRight);
            bar.markPoint().data(new Object[]{new Var("{value:'1147449600000',coord:[1147449600000,0]},{value:'1147622400000',coord:[1147622400000,1]},{value:'1147708800000',coord:[1147708800000,2]},{value:'1147708800000',coord:[1147708800000,3]},{value:'1148572800000',coord:[1148572800000,4]},{value:'1149004800000',coord:[1149004800000,5]},{value:'1149177600000',coord:[1149177600000,6]},{value:'1149696000000',coord:[1149696000000,7]}")});
        }
        bar.markLine().symbol((Object)"none");
        bar.markLine().lineStyle().color((Object)new Var("colors[0]"));
        bar.markLine().lineStyle().type(LineType.solid);
        bar.markLine().lineStyle().width(bean.getTaskHeight().getIntegerValue());
        if (!bean.getTaskShowLabels().getBooleanValue().booleanValue()) {
            bar.markLine().label().show(Boolean.valueOf(false));
        }
        bar.markLine().label().textStyle().fontSize(bean.getProcessFontSize().getIntegerValue());
        bar.markLine().label().position(Position.insideMiddle);
        bar.markLine().label().color("#000");
        bar.label().show(Boolean.valueOf(false));
        bar.markLine().data(new Object[]{new Var("[{name:'" + CtrlEXTMessages.getMLS("projectDetermination", "\u9879\u76ee\u786e\u5b9a") + "',coord:[1147017600000, 0]},{coord:[1147449600000, 0]}]"), new Var("[{name:'" + CtrlEXTMessages.getMLS("questionnaireDesign", "\u95ee\u5377\u8bbe\u8ba1") + "',coord:[1147363200000, 1]},{coord:[1147622400000, 1]}]"), new Var("[{name:'" + CtrlEXTMessages.getMLS("trialVisit", "\u8bd5\u8bbf") + "',coord:[1147449600000, 2]},{coord:[1147708800000, 2]}]"), new Var("[{name:'" + CtrlEXTMessages.getMLS("questionnaireDetermination", "\u95ee\u5377\u786e\u5b9a") + "',coord:[1147622400000, 3]},{coord:[1147708800000, 3]}]"), new Var("[{name:'" + CtrlEXTMessages.getMLS("fieldExecution", "\u5b9e\u5730\u6267\u884c") + "',coord:[1147708800000, 4]},{coord:[1148572800000, 4]}]"), new Var("[{name:'" + CtrlEXTMessages.getMLS("dataEntry", "\u6570\u636e\u5f55\u5165") + "',coord:[1148572800000, 5]},{coord:[1149004800000, 5]}]"), new Var("[{name:'" + CtrlEXTMessages.getMLS("dataAnalysis", "\u6570\u636e\u5206\u6790") + "',coord:[1148918400000, 6]},{coord:[1149177600000, 6]}]"), new Var("[{name:'" + CtrlEXTMessages.getMLS("reportSubmission", "\u62a5\u544a\u63d0\u4ea4") + "',coord:[1149177600000, 7]},{coord:[1149696000000, 7]}]")});
        bar.label().normal().color((Object)"#000");
        bar.label().normal().show(Boolean.valueOf(false));
        bar.data(new Object[]{"1147449600000", "1147622400000", "1147708800000", "1147708800000", "1148572800000", "1149004800000", "1149177600000", "1149696000000"});
        p.series().add(bar);
        bar = new Bar();
        bar.name(CtrlEXTMessages.getMLS("actualStartDate", "\u5b9e\u9645\u5f00\u59cb\u65f6\u95f4"));
        bar.itemStyle().color((Object)"rgba(255,255,255,0)");
        bar.markLine().symbol((Object)"none");
        bar.markLine().lineStyle().color((Object)"rgba(255,255,255,0)");
        bar.markLine().lineStyle().type(LineType.solid);
        bar.markLine().lineStyle().width(bean.getTaskHeight().getIntegerValue());
        bar.label().show(Boolean.valueOf(false));
        bar.markLine().data(new Object[]{new Var("[{name:'',coord:[1147104000000, 0]},{coord:[1147536000000, 0]}]"), new Var("[{name:'',coord:[1147536000000, 1]},{coord:[1147622400000, 1]}]"), new Var("[{name:'',coord:[1147622400000, 2]},{coord:[1147881600000, 2]}]"), new Var("[{name:'',coord:[1147795200000, 3]},{coord:[1147968000000, 3]}]"), new Var("[{name:'',coord:[1148054400000, 4]},{coord:[1149091200000, 4]}]"), new Var("[{name:'',coord:[1149177600000, 5]},{coord:[1149696000000, 5]}]"), new Var("[{name:'',coord:[1149696000000, 6]},{coord:[1150041600000, 6]}]"), new Var("[{name:'',coord:[1150128000000, 7]},{coord:[1150732800000, 7]}]")});
        bar.label().normal().color((Object)"#000");
        bar.label().normal().show(Boolean.valueOf(false));
        bar.data(new Object[]{"1147104000000", "1147536000000", "1147622400000", "1147795200000", "1147054400000", "1148505440000", "1149177600000", "1150128000000"});
        p.series().add(bar);
        bar = new Bar();
        bar.name(CtrlEXTMessages.getMLS("actualEndDate", "\u5b9e\u9645\u7ed3\u675f\u65f6\u95f4"));
        bar.itemStyle().color((Object)"rgba(255,255,255,0)");
        bar.markPoint().symbolSize((Object)1);
        bar.markPoint().label().formatter((Object)new Var("function (params) { var v = 0;if(params.data && params.data.coord){v =  params.data.coord[0];} var d = new Date(v);var dateStr = d.getFullYear() + '-' + (d.getMonth() + 1) + '-' + d.getDate();return dateStr;}"));
        bar.markPoint().label().textStyle().fontSize(bean.getProcessHeadFontSize().getIntegerValue());
        bar.markPoint().label().color("#000");
        if (bean.getTaskShowStartDate().getBooleanValue().booleanValue()) {
            bar.markPoint().label().position(Position.insideLeft);
            bar.markPoint().data(new Object[]{new Var("{value:'1147104000000',coord:[1147104000000,0]},{value:'1147536000000',coord:[1147536000000,1]},{value:'1147622400000',coord:[1147622400000,2]},{value:'1147795200000',coord:[1147795200000,3]},{value:'1148054400000',coord:[1148054400000,4]},{value:'1149177600000',coord:[1149177600000,5]},{value:'1149696000000',coord:[1149696000000,6]},{value:'1150128000000',coord:[1150128000000,7]}")});
        }
        if (bean.getTaskShowEndDate().getBooleanValue().booleanValue()) {
            bar.markPoint().label().position(Position.insideRight);
            bar.markPoint().data(new Object[]{new Var("{value:'1147536000000',coord:[1147536000000,0]},{value:'1147622400000',coord:[1147622400000,1]},{value:'1147881600000',coord:[1147881600000,2]},{value:'1147968000000',coord:[1147968000000,3]},{value:'1149091200000',coord:[1149091200000,4]},{value:'1149696000000',coord:[1149696000000,5]},{value:'1150041600000',coord:[1150041600000,6]},{value:'1150732800000',coord:[1150732800000,7]}")});
        }
        bar.markLine().label().show(Boolean.valueOf(false));
        bar.markLine().symbol((Object)"none");
        bar.markLine().lineStyle().color((Object)new Var("colors[1]"));
        bar.markLine().lineStyle().type(LineType.solid);
        bar.markLine().lineStyle().width(bean.getTaskHeight().getIntegerValue());
        bar.markLine().label().textStyle().fontSize(bean.getProcessFontSize().getIntegerValue());
        bar.markLine().label().position(Position.insideMiddle);
        bar.markLine().label().color("#000");
        bar.label().show(Boolean.valueOf(false));
        bar.markLine().data(new Object[]{new Var("[{name:'" + CtrlEXTMessages.getMLS("projectDetermination", "\u9879\u76ee\u786e\u5b9a") + "',coord:[1147104000000, 0]},{coord:[1147536000000, 0]}]"), new Var("[{name:'" + CtrlEXTMessages.getMLS("questionnaireDesign", "\u95ee\u5377\u8bbe\u8ba1") + "',coord:[1147536000000, 1]},{coord:[1147622400000, 1]}]"), new Var("[{name:'" + CtrlEXTMessages.getMLS("trialVisit", "\u8bd5\u8bbf") + "',coord:[1147622400000, 2]},{coord:[1147881600000, 2]}]"), new Var("[{name:'" + CtrlEXTMessages.getMLS("questionnaireDetermination", "\u95ee\u5377\u786e\u5b9a") + "',coord:[1147795200000, 3]},{coord:[1147968000000, 3]}]"), new Var("[{name:'" + CtrlEXTMessages.getMLS("fieldExecution", "\u5b9e\u5730\u6267\u884c") + "',coord:[1148054400000, 4]},{coord:[1149091200000, 4]}]"), new Var("[{name:'" + CtrlEXTMessages.getMLS("dataEntry", "\u6570\u636e\u5f55\u5165") + "',coord:[1149177600000, 5]},{coord:[1149696000000, 5]}]"), new Var("[{name:'" + CtrlEXTMessages.getMLS("dataAnalysis", "\u6570\u636e\u5206\u6790") + "',coord:[1149696000000, 6]},{coord:[1150041600000, 6]}]"), new Var("[{name:'" + CtrlEXTMessages.getMLS("reportSubmission", "\u62a5\u544a\u63d0\u4ea4") + "',coord:[1150128000000, 7]},{coord:[1150732800000, 7]}]")});
        bar.label().normal().color((Object)"#000");
        bar.label().normal().show(Boolean.valueOf(false));
        bar.data(new Object[]{"1147536000000", "1147622400000", "1147881600000", "1147968000000", "1149091200000", "1149696000000", "1150041600000", "1150732800000"});
        p.series().add(bar);
        EChartUtils.configBorder(bean, p);
        return p;
    }

    @Override
    protected void configureAxisFont(GanttBean b, Option p, FusionChartDataNode data) {
        String[] captions = b.buildChartCaptions1(data);
        String fontName = captions.length > 18 ? captions[18] : CtrlEXTMessages.getMLS("simSun", "\u5b8b\u4f53");
        p.textStyle().fontSize(Integer.valueOf(captions.length >= 7 ? ChartDataTransferUtil.parseInteger(captions[6]) : 12));
        p.textStyle().fontFamily(fontName);
        this.configureAxisLabel(p, captions, fontName);
    }

    private void configureAxisLabel(Option p, String[] captions, String fontName) {
        if (null != p.getxAxis()) {
            for (Axis s : p.getxAxis()) {
                s.axisLabel().textStyle().fontFamily(fontName);
                s.axisLabel().textStyle().fontSize(Integer.valueOf(captions.length > 8 ? ChartDataTransferUtil.parseInteger(captions[8]) : 12));
            }
        }
        if (null != p.getyAxis()) {
            for (Axis s : p.getyAxis()) {
                s.axisLabel().textStyle().fontFamily(fontName);
                s.axisLabel().textStyle().fontSize(Integer.valueOf(captions.length > 7 ? ChartDataTransferUtil.parseInteger(captions[7]) : 12));
            }
        }
    }

    @Override
    protected void configureScaleMark(Option p, Chart chart) {
        List axis = new ArrayList();
        if (super.isyValueAxis()) {
            axis = p.getyAxis();
        } else if (super.isxValueAxis()) {
            axis = p.getxAxis();
        }
        if (null != axis && !axis.isEmpty()) {
            Axis y = (Axis)axis.get(0);
            y.splitArea().show(Boolean.TRUE);
            y.splitLine().lineStyle().opacity(Double.valueOf(StringUtil.isEmptyString((String)chart.divLineAlpha) ? 0.5 : Double.parseDouble(chart.divLineAlpha) / 100.0));
            y.splitArea().areaStyle().opacity(Double.valueOf(StringUtil.isEmptyString((String)chart.canvasBgAlpha) ? 0.0 : Double.parseDouble(chart.canvasBgAlpha) / 100.0));
        }
    }

    @Override
    public String afterScript(GanttBean b, FusionChartDataNode data, Option p) {
        for (Series s : p.getSeries()) {
            if (s.getType() != SeriesType.bar) continue;
            Bar bar = (Bar)s;
            bar.label().normal().show(Boolean.FALSE);
        }
        return super.afterScript(b, data, p);
    }

    @Override
    protected void configureValueAxis(Option p, Chart chart, FusionChartDataNode data) {
    }
}

