/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.pie;

import com.github.abel533.echarts.Option;
import com.github.abel533.echarts.code.Easing;
import com.github.abel533.echarts.code.RoseType;
import com.github.abel533.echarts.data.PieData;
import com.github.abel533.echarts.json.Var;
import com.github.abel533.echarts.series.Pie;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.NumberStyleComboBoxEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.SortEnum;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.pie.Pie3DBean;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Chart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.constants.EChartsType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.AbstractSmoothTransfer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.script.JSUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.util.EChartUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import java.util.Arrays;

public class Pie3DBeanTransferImpl
extends AbstractSmoothTransfer<Pie3DBean> {
    private String showType = NumberStyleComboBoxEditor.getShowTypeNumber();

    public Pie3DBeanTransferImpl() {
        super(EChartsType.PIE, CtrlEXTMessages.getMLS("threeDPieChart", "3D\u997c\u56fe"));
    }

    @Override
    public String initScript(Pie3DBean bean, FusionChartDataNode dataNode) {
        String s = super.initScript(bean, dataNode);
        double[][] data = (double[][])dataNode.getData();
        EChartUtils.checkChartDataIsNull((Object[])data, bean.getLables());
        return s;
    }

    @Override
    public Option transfer2Opiton(Pie3DBean bean, FusionChartDataNode dataNode) {
        Option p = super.transfer2Opiton(bean, dataNode);
        Object[] labels = bean.getLables();
        double[][] data = (double[][])dataNode.getData();
        if (null != p.getLegend()) {
            p.legend().data(labels);
        }
        Pie pie = new Pie();
        Chart chart = bean.getChart();
        pie.left((Object)chart.chartLeftMargin);
        pie.top((Object)String.valueOf(EChartUtils.getChartTopMargin(bean)));
        pie.right((Object)chart.chartRightMargin);
        pie.bottom((Object)chart.chartBottomMargin);
        if ("1".equals(chart.showLabels)) {
            p.tooltip().formatter((Object)"{b} {d}%");
        }
        pie.radius((Object)"65%");
        boolean showValue = true;
        if ("0".equals(chart.showValues)) {
            showValue = false;
        }
        if (!StringUtil.isEmptyString((String)chart.showType)) {
            this.showType = chart.showType;
        }
        String formatter = EChartUtils.getFormatter(showValue, this.showType);
        pie.label().normal().setFormatter((Object)formatter);
        pie.label().normal().color((Object)"#000");
        pie.roseType(RoseType.radius);
        pie.animationEasing(Easing.elasticOut);
        pie.itemStyle().shadowColor((Object)"rgba(0, 0, 0, 0.5)");
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                int length = i * data.length + j;
                Object name = "";
                if (length <= labels.length - 1) {
                    name = labels[length];
                }
                double d = data[i][j];
                PieData pieData = new PieData((String)name, (Object)Math.abs(d));
                if (d < 0.0) {
                    pieData.setNegative(Boolean.TRUE);
                }
                pie.data().add(pieData);
            }
        }
        p.series().add(pie);
        return p;
    }

    @Override
    public Option mockOption(Pie3DBean bean) {
        Option p = super.mockOption(bean);
        Pie pie = new Pie("");
        Var tooltipFormatter = JSUtils.getTooltipFormatterVar(true, true, true, "{b} {d}%");
        if (bean.getChart_showLabels() != null && bean.getChart_showLabels().getBooleanValue().booleanValue()) {
            p.tooltip().formatter((Object)tooltipFormatter);
        }
        pie.itemStyle().shadowColor((Object)"rgba(0, 0, 0, 0.5)");
        pie.radius((Object)"65%");
        String formatter = EChartUtils.getFormatter(bean.getChart_showValues().getBooleanValue(), bean.getShowType());
        Var format = JSUtils.getSeriesNumberFormatFunctionVar(true, formatter);
        pie.label().normal().setFormatter((Object)format);
        pie.roseType(RoseType.radius);
        pie.animationEasing(Easing.elasticOut);
        if (SortEnum.ASC == bean.getSortType()) {
            pie.setData(Arrays.asList(new PieData(CtrlEXTMessages.getMLS("video", "\u89c6\u9891"), (Object)300), new PieData(CtrlEXTMessages.getMLS("advertising", "\u5e7f\u544a"), (Object)484), new PieData(CtrlEXTMessages.getMLS("email", "\u90ae\u4ef6"), (Object)580), new PieData(CtrlEXTMessages.getMLS("directVisit", "\u76f4\u63a5\u8bbf\u95ee"), (Object)735), new PieData(CtrlEXTMessages.getMLS("search", "\u641c\u7d22"), (Object)1048)));
        } else {
            pie.setData(Arrays.asList(new PieData(CtrlEXTMessages.getMLS("search", "\u641c\u7d22"), (Object)1048), new PieData(CtrlEXTMessages.getMLS("directVisit", "\u76f4\u63a5\u8bbf\u95ee"), (Object)735), new PieData(CtrlEXTMessages.getMLS("email", "\u90ae\u4ef6"), (Object)580), new PieData(CtrlEXTMessages.getMLS("advertising", "\u5e7f\u544a"), (Object)484), new PieData(CtrlEXTMessages.getMLS("video", "\u89c6\u9891"), (Object)300)));
        }
        p.series().add(pie);
        return p;
    }

    @Override
    public String afterMockScript(Pie3DBean bean) {
        String s = JSUtils.getPositionJS(String.valueOf(EChartUtils.getChartTopMargin(bean)), bean.getChart_chartLeftMargin(), String.valueOf(EChartUtils.getChartBottomMargin(bean)), String.valueOf(EChartUtils.getChartRightMargin(bean)));
        return s + JSUtils.RESIZE_ADJUSTPOSITION_FUNCTION + JSUtils.ADJUSTPOSITION_FUNCTION + "myChart.setOption(option, true);";
    }
}

