/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.scatter;

import com.github.abel533.echarts.Option;
import com.github.abel533.echarts.axis.Axis;
import com.github.abel533.echarts.axis.CategoryAxis;
import com.github.abel533.echarts.axis.ValueAxis;
import com.github.abel533.echarts.code.AxisType;
import com.github.abel533.echarts.code.LineType;
import com.github.abel533.echarts.code.Position;
import com.github.abel533.echarts.code.Symbol;
import com.github.abel533.echarts.json.Var;
import com.github.abel533.echarts.series.MarkLine;
import com.github.abel533.echarts.series.Scatter;
import com.github.abel533.echarts.series.Series;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.xy.ScatterBean;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Chart;
import com.kingdee.cosmic.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.constants.EChartsType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.TransferUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.AbstractXYTransfer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.script.JSUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.util.EChartUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class ScatterBeanTransferImpl
extends AbstractXYTransfer<ScatterBean> {
    private static final Logger logger = LogUtil.getPackageLogger(ScatterBeanTransferImpl.class);

    public ScatterBeanTransferImpl() {
        super(EChartsType.SCATTER, CtrlEXTMessages.getMLS("scatterChart", "\u6563\u70b9\u56fe"));
        this.setxValueAxis(true);
    }

    @Override
    public Option transfer2Opiton(ScatterBean bean, FusionChartDataNode dataNode) {
        Option p = super.transfer2Opiton(bean, dataNode);
        Chart chart = bean.getChart();
        if (null != p.getTooltip()) {
            p.tooltip().setFormatter((Object)"{a} <br/>{c}");
        }
        if (null != p.getLegend()) {
            p.legend().data(this.seriesNames);
        }
        int step = bean.getSetp();
        boolean isSeriesByCol = dataNode.isSerialByCol();
        for (int j = 0; j < this.seriesNames.length; ++j) {
            Double[] pdata;
            Object y;
            int i;
            Object values;
            int n;
            Scatter sc = new Scatter();
            sc.setName((String)this.seriesNames[j]);
            sc.setSymbol((Object)Symbol.diamond);
            if (!StringUtil.isEmptyString((String)chart.labelSetting)) {
                sc.label().normal().show(Boolean.TRUE);
                sc.label().normal().position(Position.top);
                sc.label().normal().color((Object)"#000");
                sc.label().normal().formatter((Object)"{a}");
            }
            String scaling = "1.0";
            if (StringUtil.isNumber((String)chart.zAxisScaling)) {
                scaling = String.valueOf(Double.parseDouble(chart.zAxisScaling));
            }
            sc.symbolSize((Object)String.format("function(data){ return 10 * %s;}", scaling));
            if (isSeriesByCol) {
                for (n = 0; n < this.dataValues.length; ++n) {
                    Object x;
                    if (this.dataValues[n] instanceof Variant[][]) {
                        values = (Variant[][])this.dataValues[n];
                        for (i = 0; i < ((Variant[][])values).length; ++i) {
                            if (values[i].length < 2) {
                                throw new RuntimeException(CtrlEXTMessages.getMLS("dataError", "\u6570\u636e\u9519\u8bef"));
                            }
                            try {
                                x = values[i][j * step].doubleValue();
                                y = values[i][j * step + 1].doubleValue();
                                this.dmaxX = Math.max(this.dmaxX, (double)x);
                                this.dmaxY = Math.max(this.dmaxY, (double)y);
                                this.dminX = Math.min(this.dminX, (double)x);
                                this.dminY = Math.min(this.dminY, (double)y);
                                pdata = new Double[]{(double)x, (double)y};
                                TransferUtils.configreVerticalLine(chart, sc, pdata[0].intValue());
                                sc.data().add(pdata);
                                continue;
                            }
                            catch (SyntaxErrorException e) {
                                logger.error((Object)"err", (Throwable)e);
                            }
                        }
                        continue;
                    }
                    values = (double[][])this.dataValues[n];
                    for (i = 0; i < ((Variant[][])values).length; ++i) {
                        if (values[i].length < 2) {
                            throw new RuntimeException(CtrlEXTMessages.getMLS("dataError", "\u6570\u636e\u9519\u8bef"));
                        }
                        x = values[i][0];
                        y = values[i][1];
                        this.dmaxX = Math.max(this.dmaxX, (double)x);
                        this.dmaxY = Math.max(this.dmaxY, (double)y);
                        this.dminX = Math.min(this.dminX, (double)x);
                        this.dminY = Math.min(this.dminY, (double)y);
                        pdata = new Double[]{(double)x, (double)y};
                        TransferUtils.configreVerticalLine(chart, sc, pdata[0].intValue());
                        sc.data().add(pdata);
                    }
                }
            } else {
                for (n = 0; n < this.dataValues.length; ++n) {
                    if (this.dataValues[n] instanceof Variant[][]) {
                        values = (Variant[][])this.dataValues[n];
                        if (((Variant[][])values).length < 2) {
                            throw new RuntimeException(CtrlEXTMessages.getMLS("dataError", "\u6570\u636e\u9519\u8bef"));
                        }
                        for (i = 0; i < values[j * step].length; ++i) {
                            try {
                                double x = values[j * step][i].doubleValue();
                                y = values[j * step + 1][i].doubleValue();
                                this.dmaxX = Math.max(this.dmaxX, x);
                                this.dmaxY = Math.max(this.dmaxY, (double)y);
                                this.dminX = Math.min(this.dminX, x);
                                this.dminY = Math.min(this.dminY, (double)y);
                                pdata = new Double[]{x, (double)y};
                                TransferUtils.configreVerticalLine(chart, sc, pdata[0].intValue());
                                sc.data().add(pdata);
                                continue;
                            }
                            catch (SyntaxErrorException e) {
                                logger.error((Object)"err", (Throwable)e);
                            }
                        }
                        continue;
                    }
                    if (!(this.dataValues[n] instanceof double[][])) continue;
                    values = (double[][])this.dataValues[n];
                    if (((Variant[][])values).length < 2) {
                        throw new RuntimeException(CtrlEXTMessages.getMLS("dataError", "\u6570\u636e\u9519\u8bef"));
                    }
                    for (i = 0; i < values[j * step].length; ++i) {
                        Variant x = values[j * step][i];
                        y = values[j * step + 1][i];
                        this.dmaxX = Math.max(this.dmaxX, (double)x);
                        this.dmaxY = Math.max(this.dmaxY, (double)y);
                        this.dminX = Math.min(this.dminX, (double)x);
                        this.dminY = Math.min(this.dminY, (double)y);
                        pdata = new Double[]{(double)x, (double)y};
                        TransferUtils.configreVerticalLine(chart, sc, pdata[0].intValue());
                        sc.data().add(pdata);
                    }
                }
            }
            p.series().add(sc);
        }
        ValueAxis xAxis = new ValueAxis();
        xAxis.name(bean.getChart().chart_xUnitText);
        xAxis.position((Object)Position.right);
        p.xAxis().add(xAxis);
        p.yAxis().add(new ValueAxis().name(bean.getChart().yScaleUnit));
        if ("1".equals(chart.showCategrotiesVerticalLine)) {
            for (Axis axis : p.getxAxis()) {
                axis.show(Boolean.FALSE);
            }
        }
        return p;
    }

    @Override
    public String afterScript(ScatterBean b, FusionChartDataNode data, Option p) {
        return super.afterScript(b, data, p);
    }

    @Override
    public Option mockOption(ScatterBean bean) {
        Option p = super.mockOption(bean);
        Var tooltipFormatter = JSUtils.getTooltipFormatterVar(true, true, true, "{a} <br/>{c}");
        p.tooltip().formatter((Object)tooltipFormatter);
        ValueAxis xAxis = new ValueAxis();
        if (bean.getChartXStartValue() != null) {
            xAxis.max((Object)bean.getChartXStartValue());
        }
        if (bean.getChartXEndValue() != null) {
            xAxis.min((Object)bean.getChartXEndValue());
        }
        EChartUtils.configAxisLucency(bean, (Axis)xAxis, false);
        p.xAxis().add(xAxis);
        CategoryAxis yAxis = new CategoryAxis();
        yAxis.type(AxisType.value);
        EChartUtils.configAxisLucency(bean, (Axis)yAxis, true);
        p.yAxis().add(yAxis);
        Scatter scatter = new Scatter();
        scatter.name(CtrlEXTMessages.getMLS("aqiIndex", "AQI\u6307\u6570"));
        scatter.setSymbolSize((Object)10);
        scatter.setSymbol((Object)Symbol.diamond);
        scatter.setData(Arrays.asList({10.0, 8.04}, {8.07, 6.95}, {13.0, 7.58}, {9.05, 8.81}, {11.0, 8.33}, {14.0, 7.66}, {13.4, 6.81}, {10.0, 6.33}, {14.0, 8.96}, {12.5, 6.82}, {9.15, 7.2}, {11.5, 7.2}, {3.03, 4.23}, {12.2, 7.83}, {2.02, 4.47}, {1.05, 3.33}, {4.05, 4.96}, {6.03, 7.24}, {12.0, 6.26}, {12.0, 8.84}, {7.08, 5.82}, {5.02, 5.68}));
        if (bean.getShowCategrotiesVerticalLine().getBooleanValue().booleanValue()) {
            xAxis.show(Boolean.FALSE);
            MarkLine markLine = scatter.markLine();
            markLine.symbol((Object)"none");
            markLine.lineStyle().opacity(Double.valueOf(0.5));
            markLine.lineStyle().type(LineType.solid);
            markLine.data(new Object[]{new Var("{label:{position:'start',color:'#000'},itemStyle:{color:'#000'}, xAxis: 8.07}")});
            markLine.data(new Object[]{new Var("{label:{position:'start',color:'#000'},itemStyle:{color:'#000'}, xAxis: 13.0}")});
            markLine.data(new Object[]{new Var("{label:{position:'start',color:'#000'},itemStyle:{color:'#000'}, xAxis: 9.05}")});
            markLine.data(new Object[]{new Var("{label:{position:'start',color:'#000'},itemStyle:{color:'#000'}, xAxis: 11.0}")});
            markLine.data(new Object[]{new Var("{label:{position:'start',color:'#000'},itemStyle:{color:'#000'}, xAxis: 14.0}")});
            markLine.data(new Object[]{new Var("{label:{position:'start',color:'#000'},itemStyle:{color:'#000'}, xAxis: 13.4}")});
            markLine.data(new Object[]{new Var("{label:{position:'start',color:'#000'},itemStyle:{color:'#000'}, xAxis: 10.0}")});
            markLine.data(new Object[]{new Var("{label:{position:'start',color:'#000'},itemStyle:{color:'#000'}, xAxis: 14.0}")});
            markLine.data(new Object[]{new Var("{label:{position:'start',color:'#000'},itemStyle:{color:'#000'}, xAxis: 12.5}")});
            markLine.data(new Object[]{new Var("{label:{position:'start',color:'#000'},itemStyle:{color:'#000'}, xAxis: 9.15}")});
            markLine.data(new Object[]{new Var("{label:{position:'start',color:'#000'},itemStyle:{color:'#000'}, xAxis: 11.5}")});
            markLine.data(new Object[]{new Var("{label:{position:'start',color:'#000'},itemStyle:{color:'#000'}, xAxis: 3.03}")});
            markLine.data(new Object[]{new Var("{label:{position:'start',color:'#000'},itemStyle:{color:'#000'}, xAxis: 12.2}")});
            markLine.data(new Object[]{new Var("{label:{position:'start',color:'#000'},itemStyle:{color:'#000'}, xAxis: 2.02}")});
            markLine.data(new Object[]{new Var("{label:{position:'start',color:'#000'},itemStyle:{color:'#000'}, xAxis: 1.05}")});
            markLine.data(new Object[]{new Var("{label:{position:'start',color:'#000'},itemStyle:{color:'#000'}, xAxis: 4.05}")});
            markLine.data(new Object[]{new Var("{label:{position:'start',color:'#000'},itemStyle:{color:'#000'}, xAxis: 6.03}")});
            markLine.data(new Object[]{new Var("{label:{position:'start',color:'#000'},itemStyle:{color:'#000'}, xAxis: 12.0}")});
            markLine.data(new Object[]{new Var("{label:{position:'start',color:'#000'},itemStyle:{color:'#000'}, xAxis: 7.08}")});
            markLine.data(new Object[]{new Var("{label:{position:'start',color:'#000'},itemStyle:{color:'#000'}, xAxis: 5.02}")});
        }
        EChartUtils.configTrendline(bean, (Series)scatter);
        Float value = bean.getZAxisScaling().getFloatValue();
        scatter.symbolSize((Object)String.format("function(data){return 10 * %s;}", value));
        if (!StringUtil.isEmptyString((String)bean.getLabelSetting())) {
            scatter.label().normal().show(Boolean.TRUE);
            scatter.label().normal().position(Position.top);
            scatter.label().normal().color((Object)"#000");
            scatter.label().normal().formatter((Object)"{a}");
        }
        p.series().add(scatter);
        EChartUtils.configMaxMinValue(bean, p, 8.96, 0.0);
        EChartUtils.configBorder(bean, p);
        return p;
    }
}

