/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.image;

import com.kingdee.cosmic.ctrl.kds.model.struct.embed.image.IImageModel;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.util.WeakHashMap;

public abstract class AbstractImageModel
implements IImageModel {
    protected static WeakHashMap _imageCache;
    protected static final Component component;
    protected static final MediaTracker tracker;
    private static int mediaTrackerID;

    protected synchronized void add(Object key, Object value) {
        if (_imageCache == null) {
            _imageCache = new WeakHashMap();
        }
        _imageCache.put(key, value);
    }

    protected void discard(Object key) {
        if (_imageCache == null || key == null) {
            return;
        }
        _imageCache.remove(key);
    }

    protected boolean contain(Object key) {
        if (_imageCache == null || key == null) {
            return false;
        }
        return _imageCache.containsKey(key);
    }

    protected Object get(Object key) {
        if (_imageCache == null || key == null) {
            return null;
        }
        return _imageCache.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadEnsured(Image image) {
        MediaTracker mediaTracker = tracker;
        synchronized (mediaTracker) {
            int id = this.getNextID();
            tracker.addImage(image, id);
            try {
                tracker.waitForID(id, 0L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            tracker.removeImage(image, id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextID() {
        MediaTracker mediaTracker = tracker;
        synchronized (mediaTracker) {
            return ++mediaTrackerID;
        }
    }

    static {
        component = new Component(){};
        tracker = new MediaTracker(component);
    }
}

