/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.image;

import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.image.ImageNameSpace;
import java.util.Arrays;

public class ImageFullPath {
    private ImageNameSpace nameSpace;
    private String categoryName;
    private String imageName;
    private String userName;
    public static final String SEPARATOR = "/";

    public ImageFullPath(ImageNameSpace nameSpace, String categoryName, String imageName) {
        this.nameSpace = nameSpace;
        this.categoryName = categoryName;
        this.imageName = imageName;
    }

    public ImageFullPath() {
    }

    public ImageNameSpace getNameSpace() {
        return this.nameSpace;
    }

    public void setNameSpace(ImageNameSpace nameSpace) {
        this.nameSpace = nameSpace;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public String getImageName() {
        return this.imageName;
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void fromString(String imageFullPath) {
        int i = 0;
        String[] split = imageFullPath.split(SEPARATOR);
        ImageNameSpace imageNameSpace = ImageNameSpace.fromPersistentString(split[i++]);
        boolean isUser = imageNameSpace == ImageNameSpace.USER || imageNameSpace == ImageNameSpace.GALLERY_USER;
        this.setNameSpace(imageNameSpace);
        this.setUserName(isUser ? split[i++] : null);
        CharSequence[] categoryNames = Arrays.copyOfRange(split, i, split.length - 1);
        this.setCategoryName(String.join((CharSequence)SEPARATOR, categoryNames));
        this.setImageName(split[split.length - 1]);
    }

    public String parseToString() {
        String userNameStub = !StringUtil.isEmptyString((String)this.userName) ? SEPARATOR + this.getUserName() : "";
        return ImageNameSpace.toPersistentString(this.nameSpace) + userNameStub + SEPARATOR + this.categoryName + SEPARATOR + this.imageName;
    }
}

