/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.image;

import com.kingdee.cosmic.ctrl.kds.model.struct.embed.image.AbstractImageModel;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class ReferredImageModel
extends AbstractImageModel {
    private String embedUid = null;
    private String fileName = null;
    private byte[] imageData;

    public ReferredImageModel() {
    }

    public ReferredImageModel(byte[] imageData) {
        this.imageData = imageData;
    }

    @Override
    public Image getImage() throws IOException {
        Image image;
        if (this.imageData == null) {
            return null;
        }
        if (this.contain(this.imageData) && (image = (Image)this.get(this.imageData)) != null) {
            return image;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.imageData);
        ImageReader reader = ImageIO.getImageReadersByFormatName("gif").next();
        ImageInputStream ciis = ImageIO.createImageInputStream(new ByteArrayInputStream(this.imageData));
        reader.setInput(ciis, false);
        int noi = reader.getNumImages(true);
        image = noi > 1 ? Toolkit.getDefaultToolkit().createImage(this.imageData) : ImageIO.read(byteArrayInputStream);
        this.loadEnsured(image);
        this.add(this.imageData, image);
        return image;
    }

    @Override
    public byte[] getImageData() throws IOException {
        return this.imageData;
    }

    @Override
    public void dispose() {
        if (this.imageData == null) {
            return;
        }
        this.discard(this.imageData);
    }

    public String getEmbedUid() {
        return this.embedUid;
    }

    public void setEmbedUid(String embedUid) {
        this.embedUid = embedUid;
    }

    public void setImageData(byte[] imageData) {
        this.imageData = imageData;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }
}

