/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.image;

import com.kingdee.cosmic.ctrl.kds.model.struct.embed.image.AbstractImageModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.image.ImageFullPath;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class ReferredPathImageModel
extends AbstractImageModel {
    private ImageFullPath imageFullPath = null;
    private byte[] imageData;

    @Override
    public Image getImage() throws IOException {
        Image image;
        if (this.imageData == null) {
            return null;
        }
        if (this.contain(this.imageData) && (image = (Image)this.get(this.imageData)) != null) {
            return image;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.imageData);
        ImageReader reader = ImageIO.getImageReadersByFormatName("gif").next();
        ImageInputStream ciis = ImageIO.createImageInputStream(new ByteArrayInputStream(this.imageData));
        reader.setInput(ciis, false);
        int noi = reader.getNumImages(true);
        image = noi > 1 ? Toolkit.getDefaultToolkit().createImage(this.imageData) : ImageIO.read(byteArrayInputStream);
        this.loadEnsured(image);
        this.add(this.imageData, image);
        return image;
    }

    @Override
    public byte[] getImageData() throws IOException {
        return this.imageData;
    }

    @Override
    public void dispose() {
        if (this.imageData == null) {
            return;
        }
        this.discard(this.imageData);
    }

    public ImageFullPath getImageFullPath() {
        return this.imageFullPath;
    }

    public void setImageFullPath(ImageFullPath imageFullPath) {
        this.imageFullPath = imageFullPath;
    }

    public void setImageData(byte[] imageData) {
        this.imageData = imageData;
    }

    public String toString() {
        return "";
    }
}

