/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts;

import chrriis.dj.nativeswing.common.WebServer;
import chrriis.dj.nativeswing.swtimpl.components.JWebBrowser;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserFunction;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.ext.ui.icons.ResourceManager;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.IExecuteableDisplayPanel;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.FusionGraphicsModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.INativeEmbedment;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.browser.BrowserType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.browser.IExecutePanel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.browser.djbrowser.KDNativeBrowserPanel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.browser.jfx.KDWebViewPanel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.function.DocumentReadyFunction;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.function.IChartReadyFunction;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.manager.DefaultChartReadyManager;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.script.JSUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartModelUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.function.DefaultQingChartMouseClickFunction;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.function.IQingChartClickEventHandler;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.util.QingTransferUtil;
import com.kingdee.cosmic.ctrl.swing.KDMenuItem;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDPopupMenu;
import com.kingdee.cosmic.ctrl.swing.KDWorkButton;
import com.kingdee.util.Uuid;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.application.Platform;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import netscape.javascript.JSObject;
import org.apache.log4j.Logger;

public class QingChartDisplayPanel
extends KDPanel
implements INativeEmbedment,
IExecuteableDisplayPanel {
    private static final Logger LOGGER = Logger.getLogger(QingChartDisplayPanel.class);
    private IExecutePanel webBrowser;
    private FusionGraphicsModel model;
    private boolean showPopMenu = false;
    private boolean showDemoData;
    private BrowserType browserType;
    private String chartID = Uuid.create().toString();
    private final transient DefaultChartReadyManager readyFunctionManager = new DefaultChartReadyManager();
    private final transient DefaultQingChartMouseClickFunction clickHandlerManager = new DefaultQingChartMouseClickFunction("qingChartClickFunction");
    private AtomicBoolean inited = new AtomicBoolean(false);
    private final Queue<String> scriptQueue = new LinkedList<String>();
    private transient DocumentReadyFunction documentReadyFunction = new DocumentReadyFunction("ready", this.readyFunctionManager);

    public QingChartDisplayPanel(IChartReadyFunction function, FusionGraphicsModel model, boolean showPopMenu, boolean showDemoData) {
        this.model = model;
        this.showDemoData = showDemoData;
        this.showPopMenu = showPopMenu;
        this.browserType = BrowserType.WEBVIEW;
        this.setLayout(new BorderLayout());
        this.readyFunctionManager.registeFunction(new DisplayPanelReadyInitializer());
        this.readyFunctionManager.registeFunction(function);
        this.initcomponents();
    }

    private void initcomponents() {
        if (BrowserType.DJNATIVEBROWSER == this.browserType) {
            this.initDJBrowser();
            this.add(this.webBrowser.getMainComponent(), "Center");
        } else if (BrowserType.WEBVIEW == this.browserType) {
            this.initWebView();
            this.add(this.webBrowser.getMainComponent(), "Center");
            SwingUtilities.invokeLater(() -> {
                KDWebViewPanel webViewPanel = (KDWebViewPanel)this.webBrowser;
                webViewPanel.reload();
            });
        }
        if (this.showPopMenu) {
            this.getNativeComponent().addMouseListener(new QingChartRefreshListener());
        }
    }

    private void initDJBrowser() {
        this.webBrowser = new KDNativeBrowserPanel(WebServer.getDefaultWebServer().getClassPathResourceURL(this.getClass().getName(), "./qing-rpt-chart.html"), null, false);
        JWebBrowser browser = ((KDNativeBrowserPanel)this.webBrowser).getBrowser();
        browser.registerFunction((WebBrowserFunction)new DocumentReadyFunction("readyfunction", this.readyFunctionManager, this.webBrowser));
    }

    private void initWebView() {
        WebServer server = WebServer.getDefaultWebServer();
        String url = server.getClassPathResourceURL(this.getClass().getName(), "./qing-rpt-chart.html") + "?t=" + System.currentTimeMillis();
        this.webBrowser = new KDWebViewPanel(url, f -> {
            JSObject window = JSUtils.getWindow(this.webBrowser);
            this.documentReadyFunction.setPanel(this.webBrowser);
            Object ready = window.getMember("isReady");
            if (Boolean.TRUE.equals(ready)) {
                this.inited.set(true);
                this.readyFunctionManager.onReady(this.webBrowser);
                this.registerOnClickFunction(this.webBrowser);
            }
        }, false, true, false);
    }

    private void registerOnClickFunction(IExecutePanel browser) {
        if (BrowserType.DJNATIVEBROWSER == this.browserType) {
            JWebBrowser jWebBrowser = ((KDNativeBrowserPanel)browser).getBrowser();
            jWebBrowser.registerFunction((WebBrowserFunction)this.clickHandlerManager);
        } else if (BrowserType.WEBVIEW == this.browserType) {
            LOGGER.debug((Object)"regist click function.");
            JSObject window = JSUtils.getWindow(this.webBrowser);
            window.setMember("qingClick", this.clickHandlerManager);
        }
    }

    public void execute(String script) {
        LOGGER.debug((Object)("QingChartDisplayPanel execute: " + script));
        if (BrowserType.WEBVIEW == this.browserType) {
            Platform.runLater(() -> this.webBrowser.execute(script));
        } else {
            this.webBrowser.execute(script);
        }
    }

    @Override
    public boolean execute() {
        FlashChartModel chartModel;
        if (null == this.model || (chartModel = FlashChartModelUtils.conevert2FlashModel(this.model)) == null) {
            return false;
        }
        chartModel.setFrameWorkType(this.model.getFramworkType());
        String script = QingTransferUtil.buildScript(chartModel, this.showDemoData);
        if (!this.inited.get()) {
            LOGGER.debug((Object)"qingChart initing not compeleted script queued.");
            this.scriptQueue.add(script);
            return false;
        }
        this.execute(script);
        return true;
    }

    public Object executeResult(String script) {
        LOGGER.debug((Object)("EChartDisplayPanel executeResult: " + script));
        return this.webBrowser.executeResult(script);
    }

    @Override
    public void setModel(FusionGraphicsModel model) {
        this.model = model;
    }

    @Override
    public JComponent getDisplayPanel() {
        return this;
    }

    @Override
    public Component getNativeComponent() {
        if (this.webBrowser instanceof INativeEmbedment) {
            return ((INativeEmbedment)((Object)this.webBrowser)).getNativeComponent();
        }
        return this.webBrowser.getMainComponent();
    }

    public String getChartID() {
        return this.chartID;
    }

    public boolean isChartInited() {
        return this.readyFunctionManager.isDocumentReady();
    }

    public void registerClickHandler(IQingChartClickEventHandler handler) {
        this.clickHandlerManager.registerHandler(handler);
    }

    public void removeClickHandler(IQingChartClickEventHandler handler) {
        this.clickHandlerManager.removeHandler(handler);
    }

    public void close() {
        LOGGER.debug((Object)"browser close.");
    }

    public class DisplayPanelReadyInitializer
    implements IChartReadyFunction {
        @Override
        public void onReady(IExecutePanel browser) {
            this.executeInitScripts(browser);
            this.registerChartID(browser);
            QingChartDisplayPanel.this.inited.set(true);
            QingChartDisplayPanel.this.scriptQueue.forEach(QingChartDisplayPanel.this::execute);
            QingChartDisplayPanel.this.scriptQueue.clear();
        }

        private void executeInitScripts(IExecutePanel browser) {
            browser.execute("document.oncontextmenu = function () { return false; };");
        }

        public Object executeResult(String script) {
            LOGGER.debug((Object)("QingChartDisplayPanel executeResult: " + script));
            return QingChartDisplayPanel.this.webBrowser.executeResult(script);
        }

        private void registerChartID(IExecutePanel browser) {
            browser.execute("chartID='" + QingChartDisplayPanel.this.chartID + "';");
        }
    }

    public class QingChartRefreshListener
    extends MouseAdapter {
        private KDPopupMenu popMenu = new KDPopupMenu();

        public QingChartRefreshListener() {
            KDMenuItem menuItem = new KDMenuItem();
            menuItem.setUI(null);
            KDWorkButton btnBefresh = new KDWorkButton((Icon)ResourceManager.getImageIcon("tbtn_Refresh.gif"));
            btnBefresh.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    QingChartDisplayPanel.this.execute();
                    e.consume();
                }
            });
            btnBefresh.setToolTipText(CtrlEXTMessages.getMLS("refresh", "\u5237\u65b0"));
            menuItem.add((Component)btnBefresh);
            this.popMenu.add((JMenuItem)menuItem);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!this.popMenu.isVisible()) {
                this.showMenu();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (!this.popMenu.isVisible()) {
                this.showMenu();
            }
        }

        public void showMenu() {
            Component p = QingChartDisplayPanel.this.getNativeComponent();
            int y = p.getY();
            int x = p.getX() + p.getWidth() - 30;
            this.popMenu.show(p, x, y);
            this.popMenu.setVisible(true);
        }
    }
}

