/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.column;

import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Chart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.column.AbstractColumnChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.json.JsonLocation;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.AbstractNormalChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.Legends;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.MultiSeriesChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.sort.ISortChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.sort.SortMSChartByPChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.QingStyle;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.util.QingTransferUtil;
import com.kingdee.cosmic.ctrl.kds.util.JsonUtil;
import java.nio.charset.StandardCharsets;

public class MSColumnChart
extends AbstractColumnChart {
    private Legends.DiscreteColorLegend legend;
    protected ISortChart sortChart;

    @Override
    protected void configDemoCustomStyle(FlashChartModel model) {
        super.configDemoCustomStyle(model);
        this.sortChart.sortChart(model, this.chartModel);
        this.collectLegend();
        Chart chart = model.getBean().getChart();
        this.addStyle(QingStyle.SHOW_LEGEND, chart);
        this.addStyle(QingStyle.Y_RULERSCALE, chart);
        this.addStyle(QingStyle.Y_AXIS_NUMBER_FORMAT, chart);
        this.addStyle(QingStyle.Y_RULERSTART, chart);
    }

    @Override
    public AbstractNormalChartModel createChartModel() {
        MultiSeriesChartModel chartModel = new MultiSeriesChartModel();
        this.setChartModel(chartModel);
        return chartModel;
    }

    @Override
    public AbstractNormalChartModel loadDemoData() {
        this.sortChart = new SortMSChartByPChart();
        String columnJson = QingTransferUtil.getResourceAsString(JsonLocation.class, "mscolumn.json", StandardCharsets.UTF_8);
        JsonUtil.CustomJsonParser jsonParser = new JsonUtil.CustomJsonParser();
        jsonParser.addCustomDecoder(AbstractNormalChartModel.INode.class, new AbstractNormalChartModel.INode.JsonDecoder());
        return JsonUtil.decodeFromString(jsonParser, columnJson, MultiSeriesChartModel.class);
    }

    @Override
    public void collectLegend() {
        super.collectLegend();
        this.setLegend(this.colorConfirmer.createLegend());
    }

    public Legends.DiscreteColorLegend getLegend() {
        return this.legend;
    }

    public void setLegend(Legends.DiscreteColorLegend legend) {
        this.legend = legend;
    }
}

