/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.column;

import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.AbstractFusionBean;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Chart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.ChartDataTransferUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.column.AbstractColumnChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.json.JsonLocation;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.AbstractNormalChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.Legends;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.MultiSeriesChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.sort.ISortChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.sort.SortMSChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.QingStyle;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.util.QingTransferUtil;
import com.kingdee.cosmic.ctrl.kds.util.JsonUtil;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class STColumnChart
extends AbstractColumnChart {
    private Legends.DiscreteColorLegend legend;
    private ISortChart sortChart;

    public Legends.DiscreteColorLegend getLegend() {
        return this.legend;
    }

    public void setLegend(Legends.DiscreteColorLegend legend) {
        this.legend = legend;
    }

    @Override
    protected void configDemoCustomStyle(FlashChartModel model) {
        super.configDemoCustomStyle(model);
        this.sortChart.sortChart(model, this.chartModel);
        this.collectLegend();
        Chart chart = model.getBean().getChart();
        this.addStyle(QingStyle.SHOW_LEGEND, chart);
        this.addStyle(QingStyle.Y_AXIS_NUMBER_FORMAT, chart);
    }

    @Override
    public AbstractNormalChartModel loadDemoData() {
        this.sortChart = new SortMSChart();
        String columnJson = QingTransferUtil.getResourceAsString(JsonLocation.class, "stcolumn.json", StandardCharsets.UTF_8);
        JsonUtil.CustomJsonParser jsonParser = new JsonUtil.CustomJsonParser();
        jsonParser.addCustomDecoder(AbstractNormalChartModel.INode.class, new AbstractNormalChartModel.INode.JsonDecoder());
        return JsonUtil.decodeFromString(jsonParser, columnJson, MultiSeriesChartModel.class);
    }

    @Override
    public AbstractNormalChartModel createChartModel() {
        MultiSeriesChartModel chartModel = new MultiSeriesChartModel();
        this.setChartModel(chartModel);
        return chartModel;
    }

    @Override
    public void collectLegend() {
        super.collectLegend();
        this.setLegend(this.colorConfirmer.createLegend());
    }

    @Override
    protected void configureTrendline(FlashChartModel model) {
        AbstractFusionBean bean = model.getBean();
        Chart chart = bean.getChart();
        Object[] data = ChartDataTransferUtil.converToData(this.chartModel.getSeries());
        List<List<AbstractNormalChartModel.PaintableLine>> lists = ChartDataTransferUtil.configureTrendlinePaintableLine(data, bean);
        this.chartModel.setPaintableLines(lists);
        this.addStyle(QingStyle.REFLINE_COLOR, chart);
        this.addStyle(QingStyle.REFLINE_COLOR_HOVER, chart);
        this.addStyle(QingStyle.REFLINE_TIPS_COLOR, chart);
    }
}

