/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.dial;

import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Chart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.AbstractQingChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.json.JsonLocation;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.AbstractNormalChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.DiscreteColorConfirmer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.SingleSeriesChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.QingStyle;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.util.QingTransferUtil;
import com.kingdee.cosmic.ctrl.kds.util.JsonUtil;
import java.nio.charset.StandardCharsets;

public class DialChart
extends AbstractQingChart {
    @Override
    public AbstractNormalChartModel loadDemoData() {
        String dialJson = QingTransferUtil.getResourceAsString(JsonLocation.class, "dial.json", StandardCharsets.UTF_8);
        JsonUtil.CustomJsonParser jsonParser = new JsonUtil.CustomJsonParser();
        jsonParser.addCustomDecoder(AbstractNormalChartModel.INode.class, new AbstractNormalChartModel.INode.JsonDecoder());
        return JsonUtil.decodeFromString(jsonParser, dialJson, SingleSeriesChartModel.class);
    }

    @Override
    public void configDemoCustomStyle(FlashChartModel model) {
        super.configDemoCustomStyle(model);
        Chart chart = model.getBean().getChart();
        this.addStyle(QingStyle.DATALABEL_TYPE, chart);
        this.addStyle(QingStyle.DATALABEL_FORMAT, chart);
        this.addStyle(QingStyle.PAN_STYLE, chart);
        this.addStyle(QingStyle.DATA_LABEL_OVERLAPPABLE, chart);
        this.addStyle(QingStyle.ARC_DEGREE, chart);
        this.addStyle(QingStyle.SHOW_RULER_MARK_LABEL, chart);
        this.addStyle(QingStyle.POINTER_NAME, chart);
        this.addStyle(QingStyle.NUMERAL_FORMAT, chart);
        this.configureDataName(chart.seriesName);
    }

    @Override
    public void collectLegend() {
        this.colorConfirmer = new DiscreteColorConfirmer(this.colors.toArray(new String[0]), Integer.MAX_VALUE);
        for (int i = 0; i < this.chartModel.getScopes().size(); ++i) {
            AbstractNormalChartModel.AxisValueScope scope = this.chartModel.getScopes().get(i);
            scope.setColor((String)this.colors.get(i % this.colors.size()));
        }
    }

    @Override
    public AbstractNormalChartModel createChartModel() {
        SingleSeriesChartModel chartModel = new SingleSeriesChartModel();
        this.setChartModel(chartModel);
        return chartModel;
    }
}

