/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.funnel;

import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.AbstractFusionBean;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Chart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.AbstractQingChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.json.JsonLocation;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.AbstractNormalChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.DiscreteColorConfirmer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.Legends;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.SingleSeriesChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.sort.ISortChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.sort.SortSingleChartByFunnel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.QingStyle;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.util.QingTransferUtil;
import com.kingdee.cosmic.ctrl.kds.util.JsonUtil;
import java.nio.charset.StandardCharsets;

public class SimilarFunnelChart
extends AbstractQingChart {
    private Legends.DiscreteColorLegend legend;
    private ISortChart sortChart;

    @Override
    public AbstractNormalChartModel loadDemoData() {
        this.sortChart = new SortSingleChartByFunnel();
        String funnelJson = QingTransferUtil.getResourceAsString(JsonLocation.class, "funnel.json", StandardCharsets.UTF_8);
        JsonUtil.CustomJsonParser jsonParser = new JsonUtil.CustomJsonParser();
        jsonParser.addCustomDecoder(AbstractNormalChartModel.INode.class, new AbstractNormalChartModel.INode.JsonDecoder());
        return JsonUtil.decodeFromString(jsonParser, funnelJson, SingleSeriesChartModel.class);
    }

    @Override
    public void configDemoCustomStyle(FlashChartModel model) {
        super.configDemoCustomStyle(model);
        this.sortChart.sortChart(model, this.chartModel);
        this.collectLegend();
        AbstractFusionBean bean = model.getBean();
        Chart chart = bean.getChart();
        this.addStyle(QingStyle.SHOW_LEGEND, chart);
        this.addStyle(QingStyle.SHOW_NEGATIVE, chart);
        this.addStyle(QingStyle.FUNNEL_LADDER, chart);
        this.addStyle(QingStyle.LABEL_NAME, chart);
        this.addStyle(QingStyle.LABEL_VALUE, chart);
        this.addStyle(QingStyle.LABEL_PERCENT, chart);
        this.addStyle(QingStyle.RATIO_BY, chart);
        this.addStyle(QingStyle.RATIO_FORMAT, chart);
        this.configureTypeTitle(chart.categoryTitle);
        this.configureDataName(chart.seriesName);
    }

    @Override
    public AbstractNormalChartModel createChartModel() {
        SingleSeriesChartModel chartModel = new SingleSeriesChartModel();
        this.setChartModel(chartModel);
        return chartModel;
    }

    @Override
    public void collectLegend() {
        int colorsNum = this.colors.size();
        this.colorConfirmer = new DiscreteColorConfirmer(this.colors.toArray(new String[0]), Integer.MAX_VALUE);
        for (int i = 0; i < this.chartModel.getCategories().size(); ++i) {
            AbstractNormalChartModel.Category category = this.chartModel.getCategories().get(i);
            category.setOrderingValue(i);
            category.setColor((String)this.colors.get(i % colorsNum));
            this.colorConfirmer.getColor(category, category.getLabel());
        }
        this.setLegend(this.colorConfirmer.createLegend());
    }

    public Legends.DiscreteColorLegend getLegend() {
        return this.legend;
    }

    public void setLegend(Legends.DiscreteColorLegend legend) {
        this.legend = legend;
    }
}

