/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.pie;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Chart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.AbstractQingChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.json.JsonLocation;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.AbstractNormalChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.Legends;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.SingleSeriesChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.QingStyle;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.util.QingTransferUtil;
import com.kingdee.cosmic.ctrl.kds.util.JsonUtil;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class PRingPieChart
extends AbstractQingChart {
    private Legends.DiscreteColorLegend legend;

    @Override
    public AbstractNormalChartModel loadDemoData() {
        String pieJson = QingTransferUtil.getResourceAsString(JsonLocation.class, "pringpie.json", StandardCharsets.UTF_8);
        JsonUtil.CustomJsonParser jsonParser = new JsonUtil.CustomJsonParser();
        jsonParser.addCustomDecoder(AbstractNormalChartModel.INode.class, new AbstractNormalChartModel.INode.JsonDecoder());
        return JsonUtil.decodeFromString(jsonParser, pieJson, SingleSeriesChartModel.class);
    }

    @Override
    public void collectLegend() {
        super.collectLegend();
        List<AbstractNormalChartModel.Series> seriesList = this.chartModel.getSeries();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < seriesList.size(); ++i) {
            AbstractNormalChartModel.Series series = seriesList.get(i);
            list.add(series.getName());
        }
        this.setLegend(this.colorConfirmer.createProcessRingLegend(list));
    }

    @Override
    public AbstractNormalChartModel createChartModel() {
        SingleSeriesChartModel chartModel = new SingleSeriesChartModel();
        this.setChartModel(chartModel);
        return chartModel;
    }

    @Override
    public String initDemoScript(FlashChartModel model) {
        super.initDemoScript(model);
        Chart chart = model.getBean().getChart();
        List<AbstractNormalChartModel.Series> series = this.chartModel.getSeries();
        ArrayList<String> list = new ArrayList<String>();
        list.add(StringUtil.isEmptyString((String)chart.categoryTitle) ? CtrlEXTMessages.getMLS("targetValue", "\u76ee\u6807\u503c") : chart.categoryTitle);
        list.add(StringUtil.isEmptyString((String)chart.seriesName) ? CtrlEXTMessages.getMLS("actualValue", "\u5b9e\u9645\u503c") : chart.seriesName);
        for (int i = 0; i < series.size(); ++i) {
            series.get(i).setName(list.get(i));
            series.get(i).setColor((String)this.colors.get(i));
        }
        this.setLegend(this.colorConfirmer.createProcessRingLegend(list));
        this.addStyle(QingStyle.OVERLAP_SHRINKING_RATIO, chart);
        this.addStyle(QingStyle.PERCENTAGE_DIGIT, chart);
        this.addStyle(QingStyle.PERCENTAGE_CEILING, chart);
        if (StringUtil.isEmptyString((String)chart.labelDesc)) {
            chart.labelDesc = CtrlEXTMessages.getMLS("conversionRate", "\u5b8c\u6210\u7387");
        }
        this.addStyle(QingStyle.LABEL_DESC, chart);
        this.addStyle(QingStyle.SHOW_LEGEND, chart);
        this.addStyle(QingStyle.SHOW_DATALABEL, chart);
        int w = model.getBean().getChartWidth() == 0 ? 691 : model.getBean().getChartWidth() + 10;
        int h = model.getBean().getChartHeight() == 0 ? 240 : model.getBean().getChartHeight() + 6;
        return String.format("funChartDoDraw('%s','%s', %d, %d)", model.getChartType().getName(), this, w, h);
    }

    public void setLegend(Legends.DiscreteColorLegend legend) {
        this.legend = legend;
    }
}

