/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.tree;

import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Chart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.ChartDataTransferUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.QingChartType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.AbstractQingChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.AbstractNormalChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.DiscreteColorConfirmer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.Legends;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.TreeChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.QingStyle;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.util.QingTransferUtil;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public class AbstractTreeChart
extends AbstractQingChart {
    public Legends.DiscreteColorLegend legend;
    public AbstractNormalChartModel.TreeChartNode lengendNode;

    @Override
    protected void configDemoCustomStyle(FlashChartModel model) {
        model.getBean().buildChart(model.getDataNode());
        this.setTreeChartModel(this.loadDemoData());
        this.colors = QingTransferUtil.toRGBA(model.getBean().initColors());
        this.configureDemo(model);
        Chart chart = model.getBean().getChart();
        this.sortedDemo(this.treeChartModel, model);
        this.collectLegend();
        this.configureTreeDataName(chart.seriesName);
        this.addStyle(QingStyle.SHOW_LEGEND, chart);
        this.addStyle(QingStyle.SHOW_DATALABEL, chart);
        this.addStyle(QingStyle.SHOW_NEGATIVE, chart);
    }

    public TreeChartModel createTreeChartModel() {
        TreeChartModel treeChartModel = new TreeChartModel();
        this.setTreeChartModel(treeChartModel);
        return treeChartModel;
    }

    @Override
    public AbstractNormalChartModel createChartModel() {
        TreeChartModel chartModel = new TreeChartModel();
        this.setChartModel(chartModel);
        return chartModel;
    }

    public void setTreeChartModel(TreeChartModel treeChartModel) {
        this.treeChartModel = treeChartModel;
    }

    @Override
    public void collectLegend() {
        this.colorConfirmer = new DiscreteColorConfirmer(this.colors.toArray(new String[0]), Integer.MAX_VALUE);
        int[] count = new int[1];
        if (this.lengendNode != null) {
            this.setLegendColor(this.lengendNode, this.colorConfirmer, count, new LinkedList<String>());
        } else {
            this.setLegendColor(this.treeChartModel.getRoot(), this.colorConfirmer, count, new LinkedList<String>());
        }
        this.setLegend(this.colorConfirmer.createLegend());
    }

    public void setLegendColor(AbstractNormalChartModel.TreeChartNode treeChartModel, DiscreteColorConfirmer colorConfirmer, int[] count, List<String> circle) {
        List<AbstractNormalChartModel.TreeChartNode> children = treeChartModel.getChildren();
        if (children == null || children.size() == 0) {
            return;
        }
        for (int i = 0; i < children.size(); ++i) {
            if (children.get(i).getLabel() == null) {
                children.get(i).setLabel("");
            }
            this.setLegendColor(children.get(i), colorConfirmer, count, circle);
            if (children.get(i).getColor() == null || circle.contains(children.get(i).getLabel())) continue;
            AbstractNormalChartModel.TreeChartNode treeChartNode = children.get(i);
            treeChartNode.setOrderingValue(count[0]);
            colorConfirmer.getRectTreeColor(treeChartNode, treeChartNode.getLabel());
            count[0] = count[0] + 1;
            circle.add(treeChartNode.getLabel());
        }
    }

    @Override
    protected void configureDemo(FlashChartModel model) {
        super.configureDemo(model);
        Chart chart = model.getBean().getChart();
        String newLeftMargin = String.valueOf(Double.parseDouble(chart.chartLeftMargin) + 135.5);
        if (model.getBean().getChartWidth() == 0 && (model.getChartType() == QingChartType.QING_CT_RECTTREE || model.getChartType() == QingChartType.QING_CT_MSRECTTREE)) {
            this.addStyle("leftMargin", newLeftMargin);
            this.addStyle("rightMargin", newLeftMargin);
        }
    }

    public Legends.DiscreteColorLegend getLegend() {
        return this.legend;
    }

    public void setLegend(Legends.DiscreteColorLegend legend) {
        this.legend = legend;
    }

    @Override
    public TreeChartModel loadDemoData() {
        return null;
    }

    public void sortedDemo(TreeChartModel treeChartModel, FlashChartModel model) {
        List<AbstractNormalChartModel.TreeChartNode> treeChartNodeList = treeChartModel.getRoot().getChildren();
        ArrayList<AbstractNormalChartModel.TreeChartNode> copyList = new ArrayList<AbstractNormalChartModel.TreeChartNode>(treeChartNodeList.size());
        treeChartModel.setMeasureFormat(QingTransferUtil.XMLtoQingNumFormat(model.getBean().getChartNumberFormat().getXmlValue()));
        int len = treeChartNodeList.size();
        ChartDataTransferUtil.sortTreeByMeasure(len, treeChartNodeList, copyList);
        treeChartModel.getRoot().setChildren(copyList);
        for (int i = 0; i < copyList.size(); ++i) {
            ((AbstractNormalChartModel.TreeChartNode)copyList.get(i)).setColor((String)this.colors.get(i % this.colors.size()));
        }
    }

    public void addAll(List<AbstractNormalChartModel.TreeChartNode> collection, List<AbstractNormalChartModel.TreeChartNode> elements) {
        int size = elements.size();
        for (int i = 0; i < size; ++i) {
            collection.add(elements.get(i));
        }
    }

    public void sortedName(TreeChartModel treeChartModel) {
        int i;
        List<AbstractNormalChartModel.TreeChartNode> treeChartNodeList = treeChartModel.getRoot().getChildren();
        ArrayList<AbstractNormalChartModel.TreeChartNode> copyList = new ArrayList<AbstractNormalChartModel.TreeChartNode>(treeChartNodeList.size());
        this.addAll(copyList, treeChartNodeList);
        copyList.sort(new Comparator<AbstractNormalChartModel.TreeChartNode>(){

            @Override
            public int compare(AbstractNormalChartModel.TreeChartNode o1, AbstractNormalChartModel.TreeChartNode o2) {
                return Collator.getInstance(Locale.CHINA).compare(o1.getLabel(), o2.getLabel());
            }
        });
        for (i = 0; i < copyList.size(); ++i) {
            ((AbstractNormalChartModel.TreeChartNode)copyList.get(i)).setColor((String)this.colors.get(i % this.colors.size()));
        }
        for (i = 0; i < treeChartNodeList.size(); ++i) {
            String color = ((AbstractNormalChartModel.TreeChartNode)copyList.get(copyList.indexOf(treeChartNodeList.get(i)))).getColor();
            treeChartNodeList.get(i).setColor(color);
        }
        this.lengendNode = new AbstractNormalChartModel.TreeChartNode();
        this.lengendNode.setChildren(copyList);
    }
}

