/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer;

import com.kingdee.cosmic.ctrl.common.LanguageManager;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.extend.pattern.NumberFormatTemplateEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.AbstractFusionBean;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Chart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.QingChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.AbstractQingChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.AbstractTrendLineChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.AbstractNormalChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.TreeChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.calculator.AbstractCalculator;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.IQingChartTransfer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.QingStyle;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.util.QingTransferUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractQingChartTransfer
implements IQingChartTransfer {
    protected List<String> colors;
    protected AbstractFusionBean bean;
    protected FusionChartDataNode dataNode;
    protected Chart chart;
    protected AbstractQingChart qingChart;
    protected AbstractNormalChartModel chartModel;
    protected TreeChartModel treeChartModel;
    protected boolean dataEmpty = true;
    protected AbstractCalculator calculator;
    protected AbstractCalculator.Refline refline = new AbstractCalculator.Refline();

    @Override
    public void prepare(FlashChartModel model) {
        this.bean = model.getBean();
        this.dataNode = model.getDataNode();
        this.bean.toXML(this.dataNode);
        this.chart = this.bean.getChart();
        this.colors = QingTransferUtil.toRGBA(this.bean.initColors());
    }

    @Override
    public AbstractQingChart process(FlashChartModel model) {
        this.checkChartData();
        this.collectCategories();
        this.collectSeries();
        return this.qingChart;
    }

    @Override
    public void after() {
        this.qingChart.addStyle(QingStyle.BACKGROUND, this.chart);
        this.qingChart.addStyle(QingStyle.BORDER_ALPHA, this.chart);
        this.qingChart.addStyle(QingStyle.NUMBER_FORMAT, this.chart);
        this.qingChart.addStyle(QingStyle.DATA_LABEL_OVERLAPPABLE, this.chart);
        this.qingChart.addStyle("chartTitle", this.chart.caption);
        this.qingChart.addStyle("chartTitleFontSize", this.chart.captionFontSize);
        this.qingChart.addStyle("chartDeputyTitle", this.chart.subCaption);
        this.qingChart.addStyle("chartDeputyTitleFontSize", this.chart.subCaptionFontSize);
        this.qingChart.addStyle("chartTitleFontName", this.chart.captionFontName);
        this.qingChart.addStyle(QingStyle.CHART_TITLE_COLOR, this.chart);
        this.qingChart.addStyle("chartDeputyTitleFontName", this.chart.subCaptionFontName);
        this.qingChart.addStyle(QingStyle.CHART_DEPUTY_TITLE_COLOR, this.chart);
        this.qingChart.addStyle("chartTitleAlign", this.chart.captionAlign);
        this.qingChart.addStyle("legendFontSize", this.chart.baseFontSize);
        this.qingChart.addStyle("dataLabelFontSize", this.chart.baseFontSize);
        this.qingChart.addStyle("axisFontSize", this.chart.baseFontSize);
        this.qingChart.addStyle("rulerFontSize", this.chart.baseFontSize);
        this.qingChart.addStyle("reflineTipsFontSize", this.chart.baseFontSize);
        this.configureLocation();
        this.personalizedStyle();
    }

    protected void checkChartData() {
        if ("cell".equals(this.dataNode.getDataFrom())) {
            Object data = this.dataNode.getData();
            String[] groupKeys = this.dataNode.getGroupKeys();
            if (data == null) {
                throw new RuntimeException(CtrlEXTMessages.getMLS("dataEmpty", "\u6570\u636e\u4e3a\u7a7a"));
            }
            if (groupKeys == null) {
                throw new RuntimeException(CtrlEXTMessages.getMLS("categoryEmpty", "\u5206\u7c7b\u4e3a\u7a7a"));
            }
            if (groupKeys.length == 1 && StringUtil.isEmptyString((String)groupKeys[0])) {
                this.addEmptyTips();
            }
        } else if ("dataset".equals(this.dataNode.getDataFrom())) {
            Object data = this.dataNode.getData();
            String[] groupKeys = this.dataNode.getGroupKeys();
            if (data == null) {
                throw new RuntimeException(CtrlEXTMessages.getMLS("dataEmpty", "\u6570\u636e\u4e3a\u7a7a"));
            }
            if (this.checkDataIsEmpty(data, groupKeys)) {
                this.addEmptyTips();
            }
        }
    }

    private boolean checkDataIsEmpty(Object data, String[] groupKeys) {
        boolean bEmpty = false;
        boolean bGroupEmpty = false;
        if (groupKeys == null || groupKeys.length == 1 && StringUtil.isEmptyString((String)groupKeys[0])) {
            bGroupEmpty = true;
        }
        if (data instanceof double[][]) {
            double[][] d = (double[][])data;
            if (d.length == 0 || d[0].length == 0) {
                bEmpty = true;
            } else if (bGroupEmpty && d.length == 1 && d[0].length == 1 && (Double.isNaN(d[0][0]) || d[0][0] == 0.0)) {
                bEmpty = true;
            }
        } else if (data instanceof Object[][] && (((Object[][])data).length == 0 || ((Object[][])data)[0].length == 0)) {
            bEmpty = true;
        } else if (data instanceof Object[] && ((Object[])data).length == 0) {
            bEmpty = true;
        }
        return bEmpty;
    }

    protected void addEmptyTips() {
        if (this.qingChart.getStyle("dataEmpty") == null) {
            this.qingChart.addStyle("dataEmpty", String.valueOf(this.dataEmpty));
            this.qingChart.addStyle("dataEmptyMsg", CtrlEXTMessages.getMLS("noDataToDisplay", "\u6ca1\u6709\u53ef\u5c55\u73b0\u7684\u6570\u636e"));
        }
    }

    protected void collectCategories() {
        String[] groupKeys = this.getGroupKeys();
        int topN = this.calcTopN();
        ArrayList<AbstractNormalChartModel.Category> categoryList = new ArrayList<AbstractNormalChartModel.Category>(groupKeys.length);
        for (int i = 0; i < groupKeys.length; ++i) {
            AbstractNormalChartModel.Category category = new AbstractNormalChartModel.Category();
            if (this.fillColorToCategory()) {
                category.setColor(this.colors.get(i % this.colors.size()));
            }
            if (i < topN) {
                category.setLabel(this.formatValue(groupKeys[i]));
                categoryList.add(category);
            }
            if (i != topN) continue;
            String otherLabel = LanguageManager.getLangMessage((String)"others", QingChart.class, (String)"\u5176\u5b83");
            category.setLabel(otherLabel);
            category.setValue(Arrays.asList(groupKeys).subList(i, groupKeys.length).toString());
            categoryList.add(category);
            break;
        }
        this.chartModel.setCategoryTitle(this.chart.categoryTitle);
        this.chartModel.setCategories(categoryList);
    }

    protected void collectSeries() {
        Object[] data = this.getSeriesData();
        String[] seriesKeys = this.getSeriesKeys();
        ArrayList<AbstractNormalChartModel.Series> seriesList = new ArrayList<AbstractNormalChartModel.Series>(8);
        for (int i = 0; i < data.length; ++i) {
            double[][] seriesData = (double[][])data[i];
            this.collectSingleSeries(seriesData, i, seriesKeys, seriesList, seriesData.length);
        }
        this.chartModel.setSeries(seriesList);
    }

    protected final void collectSingleSeries(double[][] seriesData, int index, String[] seriesKeys, List<AbstractNormalChartModel.Series> seriesList, int limitLen) {
        for (int j = 0; j < limitLen; ++j) {
            AbstractNormalChartModel.Series series = new AbstractNormalChartModel.Series();
            series.setName(seriesKeys[j]);
            series.setSeriesFieldValueText(seriesKeys[j], seriesKeys[j]);
            ArrayList<AbstractNormalChartModel.INode> arrNode = new ArrayList<AbstractNormalChartModel.INode>(8);
            for (int k = 0; k < seriesData[0].length; ++k) {
                String value = String.valueOf(seriesData[j][k]);
                if (value.equalsIgnoreCase("NaN")) {
                    if (this.treeChartModel != null) {
                        value = "0";
                    } else {
                        arrNode.add(null);
                        continue;
                    }
                }
                AbstractNormalChartModel.Node node = new AbstractNormalChartModel.Node();
                String formatXml = this.bean.getChartNumberFormat().getXmlValue();
                String formateValue = NumberFormatTemplateEditor.applayPattern(value, formatXml, this.chart.numberPrefix, this.chart.numberSuffix);
                node.setValue(value);
                node.setText(formateValue);
                arrNode.add(node);
            }
            series.setColor(this.colors.get((index * seriesData.length + j) % this.colors.size()));
            series.setNodes(arrNode);
            series.setAxisIndex(index);
            series.setFormatString(QingTransferUtil.toQingNumFormat(this.chart));
            seriesList.add(series);
        }
    }

    protected abstract String[] getGroupKeys();

    protected abstract Object[] getSeriesData();

    protected abstract String[] getSeriesKeys();

    protected final String formatValue(Object value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    protected void configureSeriesProp(AbstractNormalChartModel.Series series) {
    }

    protected int calcTopN() {
        return Integer.MAX_VALUE;
    }

    protected int calcNeagtiveTopN() {
        return Integer.MAX_VALUE;
    }

    protected void formatNodeNumber(AbstractNormalChartModel.Node node) {
        if (node == null || node.getValue() == null) {
            return;
        }
        String formatXml = this.bean.getChartNumberFormat().getXmlValue();
        String text = NumberFormatTemplateEditor.applayPattern(node.getValue(), formatXml, this.chart.numberPrefix, this.chart.numberSuffix);
        node.setText(text);
    }

    protected abstract boolean fillColorToCategory();

    protected abstract void personalizedStyle();

    private void configureLocation() {
        this.qingChart.addStyle(QingStyle.CHART_TOP_MARGIN, this.chart);
        this.qingChart.addStyle(QingStyle.CHART_BOTTOM_MARGIN, this.chart);
        this.qingChart.addStyle(QingStyle.CHART_LEFT_MARGIN, this.chart);
        this.qingChart.addStyle(QingStyle.CHART_RIGHT_MARGIN, this.chart);
    }

    protected void configureAxisFeature() {
        this.configureTrendline();
    }

    protected void configureTrendline() {
        List<List<AbstractNormalChartModel.PaintableLine>> lists = AbstractTrendLineChart.configureTrendlinePaintableLine(this.getSeriesData(), this.bean);
        if (lists == null) {
            return;
        }
        this.chartModel.setPaintableLines(lists);
    }
}

