/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.impl.dial;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.AbstractQingChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.dial.DialChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.AbstractNormalChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.QingStyle;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.SingleSeriesQingChartTransfer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.util.QingTransferUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

public class DialTransferImpl
extends SingleSeriesQingChartTransfer {
    @Override
    public void prepare(FlashChartModel model) {
        super.prepare(model);
        this.qingChart = new DialChart();
        this.qingChart.setColors(this.colors);
        this.chartModel = this.qingChart.createChartModel();
    }

    @Override
    public AbstractQingChart process(FlashChartModel model) {
        this.checkChartData();
        this.collectScopes();
        this.collectSeries();
        this.qingChart.collectLegend();
        return this.qingChart;
    }

    protected void collectScopes() {
        Object[] data = this.getSeriesData();
        ArrayList<AbstractNormalChartModel.AxisValueScope> scopeList = new ArrayList<AbstractNormalChartModel.AxisValueScope>(8);
        HashSet<Double> scopeSet = new HashSet<Double>(8);
        for (int i = 0; i < data.length; ++i) {
            double[][] scopesData = (double[][])data[i];
            for (int j = 0; j < scopesData.length; ++j) {
                for (int k = 0; k < scopesData[j].length; ++k) {
                    String value = String.valueOf(scopesData[j][k]);
                    if (value.equalsIgnoreCase("NaN")) {
                        scopeSet.add(0.0);
                        continue;
                    }
                    scopeSet.add(scopesData[j][k]);
                }
            }
        }
        Object[] scopes = scopeSet.toArray(new Double[scopeSet.size()]);
        Arrays.sort(scopes);
        boolean hasZero = false;
        for (int i = 0; i < scopes.length - 1; ++i) {
            AbstractNormalChartModel.AxisValueScope scope = new AbstractNormalChartModel.AxisValueScope();
            if (i == 0) {
                if ((Double)scopes[i] > 0.0) {
                    hasZero = true;
                    AbstractNormalChartModel.AxisValueScope zeroScope = new AbstractNormalChartModel.AxisValueScope();
                    zeroScope.setMin("0");
                    zeroScope.setMax(String.valueOf(scopes[i]));
                    zeroScope.setColor((String)this.colors.get((i * scopes.length + i) % this.colors.size()));
                    scopeList.add(zeroScope);
                }
                scope.setMin(String.valueOf(scopes[i]));
            } else {
                scope.setMin(String.valueOf(scopes[i]));
            }
            scope.setMax(String.valueOf(scopes[i + 1]));
            if (hasZero) {
                scope.setColor((String)this.colors.get((i * scopes.length + i + 1) % this.colors.size()));
            } else {
                scope.setColor((String)this.colors.get((i * scopes.length + i) % this.colors.size()));
            }
            scopeList.add(scope);
        }
        this.chartModel.setScopes(scopeList);
    }

    @Override
    protected void collectSeries() {
        String[] seriesKeys = this.getGroupKeys();
        ArrayList<AbstractNormalChartModel.Series> seriesList = new ArrayList<AbstractNormalChartModel.Series>(8);
        AbstractNormalChartModel.Series series = new AbstractNormalChartModel.Series();
        ArrayList<AbstractNormalChartModel.INode> arrNode = new ArrayList<AbstractNormalChartModel.INode>(8);
        AbstractNormalChartModel.Node node = new AbstractNormalChartModel.Node();
        series.setName(StringUtils.isEmpty((String)this.chart.seriesName) ? CtrlEXTMessages.getMLS("KEY_VALIDATION_value", "\u6570\u503c") : this.chart.seriesName);
        double value = 0.0;
        boolean isEmpty = true;
        for (int i = 0; i < seriesKeys.length; ++i) {
            if (!StringUtil.isNumber((String)seriesKeys[i])) continue;
            isEmpty = false;
            value += Double.parseDouble(seriesKeys[i]);
        }
        node.setValue(isEmpty ? this.chart.dataEmptyInstead : String.valueOf(value));
        node.setText(node.getValue());
        this.formatNodeNumber(node);
        arrNode.add(node);
        series.setNodes(arrNode);
        series.setFormatString(QingTransferUtil.toQingNumFormat(this.chart));
        seriesList.add(series);
        this.chartModel.setSeries(seriesList);
    }

    @Override
    protected void checkChartData() {
        Object data = this.dataNode.getData();
        String[] groupKeys = this.dataNode.getGroupKeys();
        if (data == null) {
            throw new RuntimeException(CtrlEXTMessages.getMLS("dataAreaEmpty", "\u6570\u636e\u533a\u57df\u4e3a\u7a7a"));
        }
        if (groupKeys == null) {
            throw new RuntimeException(CtrlEXTMessages.getMLS("pointerDataAreaEmpty", "\u6307\u9488\u6570\u636e\u533a\u57df\u4e3a\u7a7a"));
        }
        if (groupKeys.length == 1 && StringUtil.isEmptyString((String)groupKeys[0])) {
            this.addEmptyTips();
        }
    }

    @Override
    public void personalizedStyle() {
        super.personalizedStyle();
        this.qingChart.addStyle(QingStyle.ARC_DEGREE, this.chart);
        this.qingChart.addStyle(QingStyle.PAN_STYLE, this.chart);
        this.qingChart.addStyle(QingStyle.SHOW_RULER_MARK_LABEL, this.chart);
        this.qingChart.addStyle(QingStyle.DATALABEL_TYPE, this.chart);
        this.qingChart.addStyle(QingStyle.DATALABEL_FORMAT, this.chart);
        this.qingChart.addStyle(QingStyle.POINTER_NAME, this.chart);
        this.qingChart.addStyle(QingStyle.NUMERAL_FORMAT, this.chart);
    }
}

