/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.impl.funnel;

import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.ShowNegativeComboBoxEditor;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.funnel.FunnelChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.AbstractNormalChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.Legends;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.sort.SortSingleChartByFunnel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.QingStyle;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.SingleSeriesQingChartTransfer;
import java.util.Iterator;
import java.util.List;

public class FunnelTransferImpl
extends SingleSeriesQingChartTransfer {
    @Override
    public void prepare(FlashChartModel model) {
        super.prepare(model);
        this.qingChart = new FunnelChart();
        this.qingChart.setColors(this.colors);
        this.chartModel = this.qingChart.createChartModel();
    }

    @Override
    protected boolean fillColorToCategory() {
        return true;
    }

    @Override
    public void personalizedStyle() {
        super.personalizedStyle();
        this.qingChart.addStyle(QingStyle.SHOW_LEGEND, this.chart);
        this.qingChart.addStyle(QingStyle.SHOW_NEGATIVE, this.chart);
        this.qingChart.addStyle(QingStyle.FUNNEL_LADDER, this.chart);
        this.qingChart.addStyle(QingStyle.LABEL_NAME, this.chart);
        this.qingChart.addStyle(QingStyle.LABEL_VALUE, this.chart);
        this.qingChart.addStyle(QingStyle.LABEL_PERCENT, this.chart);
        this.qingChart.addStyle(QingStyle.RATIO_BY, this.chart);
        this.qingChart.addStyle(QingStyle.RATIO_FORMAT, this.chart);
    }

    @Override
    public void after() {
        super.after();
        this.removeNegative();
        this.applySort();
    }

    private void removeNegative() {
        if (ShowNegativeComboBoxEditor.getIgnore().equals(this.chart.chartShowNegative)) {
            List<AbstractNormalChartModel.Series> series = this.chartModel.getSeries();
            List<AbstractNormalChartModel.Category> categories = this.chartModel.getCategories();
            Legends.DiscreteColorLegend legend = ((FunnelChart)this.qingChart).getLegend();
            List<AbstractNormalChartModel.INode> nodes = series.get(0).getNodes();
            Iterator<AbstractNormalChartModel.INode> iterator = nodes.iterator();
            int i = 0;
            int cursor = 0;
            while (iterator.hasNext()) {
                AbstractNormalChartModel.INode node = iterator.next();
                if (node == null) {
                    ++i;
                    continue;
                }
                if (Double.parseDouble(((AbstractNormalChartModel.Node)node).getValue()) < 0.0) {
                    iterator.remove();
                    categories.remove(i - cursor);
                    ++cursor;
                }
                ++i;
            }
        }
    }

    private void applySort() {
        SortSingleChartByFunnel.sortChart(this.chartModel, this.chart);
        this.qingChart.collectLegend();
    }
}

