/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.impl.pie;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.AbstractQingChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.pie.PRingPieChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.AbstractNormalChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.QingStyle;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.SingleSeriesQingChartTransfer;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;

public class PRingPieTransferImpl
extends SingleSeriesQingChartTransfer {
    @Override
    public void prepare(FlashChartModel model) {
        super.prepare(model);
        this.qingChart = new PRingPieChart();
        this.qingChart.setColors(this.colors);
        this.chartModel = this.qingChart.createChartModel();
    }

    @Override
    protected Object[] getSeriesData() {
        int i;
        double[][] tarData = (double[][])super.getSeriesData()[0];
        String[] actData = super.getGroupKeys();
        double[] datas = new double[]{0.0, 0.0};
        for (i = 0; i < tarData.length; ++i) {
            for (int j = 0; j < tarData[i].length; ++j) {
                if ("NaN".equals(String.valueOf(tarData[i][j]))) continue;
                datas[0] = datas[0] + tarData[i][j];
            }
        }
        for (i = 0; i < actData.length; ++i) {
            if (!StringUtil.isNumber((String)actData[i])) continue;
            datas[1] = datas[1] + Double.parseDouble(actData[i]);
        }
        return new Object[]{datas};
    }

    @Override
    protected void collectCategories() {
        double[] categories = (double[])this.getSeriesData()[0];
        ArrayList<AbstractNormalChartModel.Category> categoryList = new ArrayList<AbstractNormalChartModel.Category>(categories.length);
        for (int i = 0; i < categories.length; ++i) {
            AbstractNormalChartModel.Category category = new AbstractNormalChartModel.Category();
            category.setColor((String)this.colors.get(i % this.colors.size()));
            category.setLabel(this.formatValue(categories[i]));
            category.setValue(String.valueOf(categories[i]));
            categoryList.add(category);
        }
        this.chartModel.setCategories(categoryList);
    }

    @Override
    protected void collectSeries() {
        double[] data = (double[])this.getSeriesData()[0];
        String[] seriesKeys = this.getSeriesKeys();
        ArrayList<AbstractNormalChartModel.Series> seriesList = new ArrayList<AbstractNormalChartModel.Series>(8);
        double[][] tarData = new double[1][1];
        double[][] actData = new double[1][1];
        tarData[0][0] = data[0];
        actData[0][0] = data[1];
        seriesKeys[0] = StringUtils.isEmpty((String)this.chart.categoryTitle) ? CtrlEXTMessages.getMLS("targetValue", "\u76ee\u6807\u503c") : this.chart.categoryTitle;
        this.collectSingleSeries(tarData, 0, seriesKeys, seriesList, 1);
        seriesKeys[0] = StringUtils.isEmpty((String)this.chart.seriesName) ? CtrlEXTMessages.getMLS("actualValue", "\u5b9e\u9645\u503c") : this.chart.seriesName;
        this.collectSingleSeries(actData, 1, seriesKeys, seriesList, 1);
        for (int i = 0; i < seriesList.size(); ++i) {
            this.formatNodeNumber((AbstractNormalChartModel.Node)((AbstractNormalChartModel.Series)seriesList.get(i)).getNodes().get(0));
        }
        this.chartModel.setSeries(seriesList);
    }

    @Override
    public AbstractQingChart process(FlashChartModel model) {
        AbstractQingChart qingChart = super.process(model);
        qingChart.collectLegend();
        return qingChart;
    }

    @Override
    protected void checkChartData() {
        Object data = this.dataNode.getData();
        String[] groupKeys = this.dataNode.getGroupKeys();
        if (data == null) {
            throw new RuntimeException(CtrlEXTMessages.getMLS("targetValueAreaEmpty", "\u76ee\u6807\u503c\u533a\u57df\u4e3a\u7a7a"));
        }
        if (groupKeys == null) {
            throw new RuntimeException(CtrlEXTMessages.getMLS("actualValueAreaEmpty", "\u5b9e\u9645\u503c\u533a\u57df\u4e3a\u7a7a"));
        }
        if (data instanceof double[][] && ((double[][])data).length == 1 && ((double[][])data)[0].length == 1 && Double.isNaN(((double[][])data)[0][0]) || groupKeys.length == 1 && StringUtil.isEmptyString((String)groupKeys[0])) {
            this.addEmptyTips();
        }
    }

    @Override
    public void personalizedStyle() {
        super.personalizedStyle();
        this.qingChart.addStyle(QingStyle.OVERLAP_SHRINKING_RATIO, this.chart);
        this.qingChart.addStyle(QingStyle.PERCENTAGE_DIGIT, this.chart);
        this.qingChart.addStyle(QingStyle.PERCENTAGE_CEILING, this.chart);
        this.qingChart.addStyle(QingStyle.LABEL_DESC, this.chart);
        this.qingChart.addStyle(QingStyle.SHOW_LEGEND, this.chart);
    }
}

