/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.impl.scatter;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.extend.pattern.NumberFormatTemplateEditor;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.ChartDataTransferUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.AbstractQingChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.scatter.SimilarScatterPlotChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.AbstractNormalChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.AbstractQingChartTransfer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.transfer.QingStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;

public class SimilarScatterPlotImpl
extends AbstractQingChartTransfer {
    @Override
    public void prepare(FlashChartModel model) {
        super.prepare(model);
    }

    @Override
    public AbstractQingChart process(FlashChartModel model) {
        this.checkChartData();
        this.configureTrendline();
        this.collectSeries();
        this.qingChart.collectLegend();
        return this.qingChart;
    }

    @Override
    protected String[] getGroupKeys() {
        return null;
    }

    @Override
    protected Object[] getSeriesData() {
        if ("cell".equals(this.dataNode.getDataFrom())) {
            if (this.dataNode.getDataWithoutCalc() != null) {
                return (Object[])this.dataNode.getDataWithoutCalc();
            }
            Variant[][] oldData = (Variant[][])((Object[])this.dataNode.getData(FusionChartDataNode.XY_X))[0];
            if (!this.dataNode.isSerialByCol()) {
                oldData = ChartDataTransferUtil.povitDoubles(oldData);
            }
            String[] oldSeries = this.getCellSeriesKeys();
            String[] series = this.getSeriesKeys();
            double[][][] data = new double[series.length][][];
            for (int i = 0; i < series.length; ++i) {
                LinkedList<double[]> list = new LinkedList<double[]>();
                for (int j = 0; j < oldSeries.length; ++j) {
                    if (!oldSeries[j].equals(series[i])) continue;
                    if (oldData[j].length < 2) {
                        throw new RuntimeException(CtrlEXTMessages.getMLS("dataAreaInputError", "\u6570\u636e\u533a\u57df\u8f93\u5165\u9519\u8bef"));
                    }
                    double[] d = new double[3];
                    if (StringUtil.isEmptyString((String)String.valueOf(oldData[j][0])) || StringUtil.isEmptyString((String)String.valueOf(oldData[j][1]))) continue;
                    d[0] = Double.parseDouble(String.valueOf(oldData[j][0]));
                    d[1] = Double.parseDouble(String.valueOf(oldData[j][1]));
                    if (this.isSactter()) {
                        d[2] = oldData[j].length < 3 || StringUtil.isEmptyString((String)String.valueOf(oldData[j][2])) ? 1.0 : Double.parseDouble(String.valueOf(oldData[j][2]));
                    }
                    list.add(d);
                }
                data[i] = (double[][])list.toArray((T[])new double[list.size()][]);
            }
            this.dataNode.setData(data);
            return data;
        }
        return (Object[])this.dataNode.getData();
    }

    @Override
    protected String[] getSeriesKeys() {
        if ("cell".equals(this.dataNode.getDataFrom())) {
            if (this.dataNode.getSeriesKeysWithoutCalc() != null) {
                return (String[])this.dataNode.getSeriesKeysWithoutCalc();
            }
            String[] oldSeries = this.getCellSeriesKeys();
            LinkedHashSet<String> series = new LinkedHashSet<String>(oldSeries.length);
            series.addAll(Arrays.asList(oldSeries));
            String[] arrSeries = series.toArray(new String[series.size()]);
            this.dataNode.setSerieskeys(arrSeries);
            return arrSeries;
        }
        return (String[])this.dataNode.getSeriesKeys();
    }

    private String[] getCellSeriesKeys() {
        Variant[][] data = (Variant[][])((Object[])this.dataNode.getData(FusionChartDataNode.XY_Series))[0];
        ArrayList<String> ret = new ArrayList<String>();
        int row = data.length;
        for (int i = 0; i < row; ++i) {
            int col = data[i].length;
            for (int j = 0; j < col; ++j) {
                if (data[i][j] instanceof com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.Variant) {
                    ret.add(((com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.Variant)data[i][j]).getText());
                    continue;
                }
                ret.add(data[i][j].toString());
            }
        }
        String[] series = new String[ret.size()];
        ret.toArray(series);
        return series;
    }

    @Override
    protected void collectSeries() {
        double[][] seriesData;
        int i;
        ArrayList<AbstractNormalChartModel.Category> categoryList = new ArrayList<AbstractNormalChartModel.Category>(8);
        ArrayList<AbstractNormalChartModel.Series> seriesList = new ArrayList<AbstractNormalChartModel.Series>(8);
        Object[] data = this.getSeriesData();
        String[] seriesKeys = this.getSeriesKeys();
        int len = 0;
        for (i = 0; i < data.length; ++i) {
            seriesData = (double[][])data[i];
            len += seriesData.length;
        }
        categoryList = new ArrayList(seriesKeys.length);
        for (i = 0; i < seriesKeys.length; ++i) {
            int k;
            seriesData = (double[][])data[i];
            String value = seriesKeys[i];
            AbstractNormalChartModel.Series series = new AbstractNormalChartModel.Series();
            series.setName(value);
            series.setSeriesFieldValueText(value, value);
            ArrayList<AbstractNormalChartModel.INode> arrNode = new ArrayList<AbstractNormalChartModel.INode>(8);
            for (k = 0; k < len; ++k) {
                arrNode.add(null);
            }
            for (k = 0; k < seriesData.length; ++k) {
                String zValue = null;
                String xValue = String.valueOf(seriesData[k][0]);
                String yValue = String.valueOf(seriesData[k][1]);
                if (this.isSactter() && seriesData[k].length > 2) {
                    zValue = String.valueOf(seriesData[k][2]);
                }
                if (StringUtil.isEmptyString((String)xValue) || StringUtil.isEmptyString((String)yValue) || xValue.equalsIgnoreCase("NaN") || yValue.equalsIgnoreCase("NaN")) continue;
                AbstractNormalChartModel.Category category = new AbstractNormalChartModel.Category();
                category.setColor((String)this.colors.get(i % this.colors.size()));
                category.setValue(value);
                if (this.isSactter() && zValue != null) {
                    category.setLabel(NumberFormatTemplateEditor.applayPattern(xValue, this.chart.dataLabelFormat) + ", " + NumberFormatTemplateEditor.applayPattern(yValue, this.chart.dataLabelFormat) + ", " + NumberFormatTemplateEditor.applayPattern(zValue, this.chart.dataLabelFormat) + ", " + value);
                } else {
                    category.setLabel(NumberFormatTemplateEditor.applayPattern(xValue, this.chart.dataLabelFormat) + ", " + NumberFormatTemplateEditor.applayPattern(yValue, this.chart.dataLabelFormat) + ", " + value);
                }
                categoryList.add(category);
                AbstractNormalChartModel.XYNode xyNode = new AbstractNormalChartModel.XYNode();
                xyNode.setXAxisValue(xValue);
                xyNode.setYAxisValue(yValue);
                if (this.isSactter() && zValue != null) {
                    xyNode.setZAxisValue(zValue);
                } else {
                    xyNode.setZAxisValue("0");
                }
                arrNode.set(categoryList.indexOf(category), xyNode);
            }
            series.setColor((String)this.colors.get((i * seriesData.length + 1) % this.colors.size()));
            series.setNodes(arrNode);
            series.setAxisIndex(i);
            seriesList.add(series);
        }
        this.chartModel.setSeries(seriesList);
        this.chartModel.setCategoryTitle(this.chart.seriesName == null ? CtrlEXTMessages.getMLS("KEY_VALIDATION_value", "\u6570\u503c") : this.chart.seriesName);
        this.chartModel.setCategories(categoryList);
    }

    @Override
    protected void configureTrendline() {
        List<List<AbstractNormalChartModel.PaintableLine>> lists = SimilarScatterPlotChart.configureXYTrendlinePaintableLine(this.getSeriesData(), this.bean);
        this.chartModel.setPaintableLines(lists);
    }

    @Override
    protected boolean fillColorToCategory() {
        return true;
    }

    @Override
    public void personalizedStyle() {
        this.qingChart.addStyle(QingStyle.Y_RULERSTART, this.chart);
        this.qingChart.addStyle(QingStyle.Y_UNITTEXT, this.chart);
        this.qingChart.addStyle(QingStyle.Y_AXIS_NUMBER_FORMAT, this.chart);
        this.qingChart.addStyle(QingStyle.X_UNITTEXT, this.chart);
        this.qingChart.addStyle(QingStyle.X_AXIS_NUMBER_FORMAT, this.chart);
        this.qingChart.addStyle(QingStyle.X_RULERSTART, this.chart);
        ChartDataTransferUtil.applyChartTrendlineColor(this.chart, this.bean);
        this.qingChart.addStyle(QingStyle.REFLINE_COLOR, this.chart);
        this.qingChart.addStyle(QingStyle.REFLINE_COLOR_HOVER, this.chart);
        this.qingChart.addStyle(QingStyle.REFLINE_TIPS_COLOR, this.chart);
        this.qingChart.addStyle(QingStyle.SHOW_LEGEND, this.chart);
    }

    @Override
    protected void checkChartData() {
        if ("dataset".equals(this.dataNode.getDataFrom())) {
            String[] seriesKeys = this.getSeriesKeys();
            if (seriesKeys == null || seriesKeys.length == 0) {
                this.addEmptyTips();
            }
        } else {
            Object[] data = (Object[])this.dataNode.getData(FusionChartDataNode.XY_X);
            if (data == null || data.length == 0) {
                throw new RuntimeException(CtrlEXTMessages.getMLS("dataEmpty", "\u6570\u636e\u4e3a\u7a7a"));
            }
            Object[] oData = (Object[])this.dataNode.getData(FusionChartDataNode.XY_Series);
            if (oData == null || oData.length == 0) {
                throw new RuntimeException(CtrlEXTMessages.getMLS("seriesEmpty", "\u7cfb\u5217\u4e3a\u7a7a"));
            }
        }
    }

    protected boolean isSactter() {
        return false;
    }
}

