/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.util;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.ColorUtil;
import com.kingdee.cosmic.ctrl.common.util.FileUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.SortEnum;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.extend.pattern.NumberFormatTemplateEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.extend.pattern.PatternNode;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.AbstractFusionBean;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Chart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.ChartDataTransferUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.QingChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.QingChartFactory;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.chart.AbstractQingChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.model.chart.TreeChartModel;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class QingTransferUtil {
    private static final Logger log = Logger.getLogger(QingTransferUtil.class);

    public static String getChartName(FlashChartType chartType) {
        return chartType.getName();
    }

    public static String buildScript(FlashChartModel model, boolean showDemoData) {
        FlashChartType chartType = model.getChartType();
        AbstractQingChart qingChart = QingChartFactory.getQingChart(chartType);
        if (showDemoData) {
            return qingChart.initDemoScript(model);
        }
        String ret = "";
        try {
            ret = qingChart.initScript(model);
        }
        catch (Exception e) {
            log.error((Object)"\u56fe\u8868\u6267\u884c\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            String msg = CtrlEXTMessages.getMLS("chartExecutionError", "\u56fe\u8868\u6267\u884c\u9519\u8bef:") + e.getMessage();
            ret = QingTransferUtil.getResourceAsString(QingChart.class, "js/error/errorScript.js", StandardCharsets.UTF_8);
            ret = ret + String.format("wrapError('%s', %d);", msg, model.getBean().getChartHeight());
        }
        return ret;
    }

    public static String getResourceAsString(Class<?> cls, String resourceName) {
        return QingTransferUtil.getResourceAsString(cls, resourceName, StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getResourceAsString(Class<?> cls, String resourceName, Charset chartSet) {
        InputStream in;
        if (resourceName.endsWith(".json")) {
            String language = Locale.getDefault().getLanguage();
            String str = "";
            switch (language) {
                case "zh": 
                case "zh-ch": {
                    str = "CN";
                    break;
                }
                case "en": {
                    str = "US";
                    break;
                }
                case "zh-tw": {
                    str = "TW";
                    break;
                }
                default: {
                    str = "US";
                }
            }
            resourceName = resourceName.replace(".json", "_" + str + ".json");
        }
        if (null != (in = cls.getResourceAsStream(resourceName))) {
            try {
                String string = new String(FileUtil.loadStream2byte((InputStream)in), chartSet);
                return string;
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.error((Object)"err", (Throwable)e);
                }
            }
        }
        return null;
    }

    public static String toQingNumFormat(Chart chart) {
        String str = QingTransferUtil.configCommonPostive(chart);
        String prefix = chart.numberPrefix != null ? chart.numberPrefix : "";
        String suffix = chart.numberSuffix != null ? chart.numberSuffix : "";
        return prefix + str + suffix + ";" + prefix + "-" + str + suffix;
    }

    private static String configCommonPostive(Chart chart) {
        if (chart.decimals == null) {
            return "#,##0.00";
        }
        StringBuilder positive = new StringBuilder();
        if ("1".equalsIgnoreCase(chart.formatNumber)) {
            positive.append("#").append(chart.thousandSeparator).append("##");
        }
        positive.append("0");
        if (!StringUtil.isEmptyString((String)chart.decimals)) {
            int iDecimals = Integer.parseInt(chart.decimals);
            if (iDecimals > 0) {
                positive.append(chart.decimalSeparator);
            }
            for (int i = 0; i < iDecimals; ++i) {
                positive.append("0");
            }
        }
        if ("1".equalsIgnoreCase(chart.percent)) {
            positive.insert(0, "{-2}");
        }
        return positive.toString();
    }

    public static String XMLtoQingNumFormat(String formatXml) {
        PatternNode patternNode = NumberFormatTemplateEditor.parsePattern(formatXml, null, null);
        String str = QingTransferUtil.configXMLCommonPostive(patternNode);
        String prefix = patternNode.getPrefix();
        String suffix = patternNode.getSuffix();
        return prefix + str + suffix + ";" + prefix + "-" + str + suffix;
    }

    private static String configXMLCommonPostive(PatternNode patternNode) {
        StringBuilder positive = new StringBuilder();
        if (patternNode.isFormatNumber()) {
            positive.append("#").append(patternNode.getThousandSeparator()).append("##");
        }
        positive.append("0");
        int decimals = patternNode.getDecimals();
        if (decimals != 0) {
            if (decimals > 0) {
                positive.append(patternNode.getDecimalSeparator());
            }
            for (int i = 0; i < decimals; ++i) {
                positive.append("0");
            }
        }
        if (patternNode.isPercentNumber()) {
            positive.insert(0, "{-2}");
        }
        return positive.toString();
    }

    public static List<String> toRGBA(List<String> colors) {
        if (colors == null) {
            return Collections.emptyList();
        }
        ArrayList<String> ret = new ArrayList<String>(colors.size());
        for (String color : colors) {
            ret.add(ColorUtil.strToRgba((String)color));
        }
        return ret;
    }

    public static List<String> sortedMSTreeByMeasure(double[][] data, SortEnum sortType, List<String> group, Boolean modulus) {
        int len = data.length;
        double[] dataZeroSorted = new double[len];
        for (int j = 0; j < len; ++j) {
            double sum = 0.0;
            for (int i = 0; i < data[0].length; ++i) {
                if (!modulus.booleanValue() && data[j][i] < 0.0) continue;
                if (modulus.booleanValue() && data[j][i] < 0.0) {
                    data[j][i] = 0.0 - data[j][i];
                }
                sum += data[j][i];
            }
            dataZeroSorted[j] = sum;
        }
        Object[] listToArr = group.toArray();
        ChartDataTransferUtil.sortProcess(listToArr, dataZeroSorted, sortType, false, modulus);
        ArrayList<String> newGroup = new ArrayList<String>(group.size());
        for (int j = 0; j < listToArr.length; ++j) {
            newGroup.add((String)listToArr[j]);
        }
        return newGroup;
    }

    public static void collectCaptions(TreeChartModel treeChartModel, Chart chart, AbstractFusionBean bean) {
        ArrayList<String> list = new ArrayList<String>(8);
        list.add(chart.groupTitle == null ? CtrlEXTMessages.getMLS("group", "\u5206\u7ec4") : chart.groupTitle);
        list.add(chart.categoryTitle == null ? CtrlEXTMessages.getMLS("category", "\u5206\u7c7b") : chart.categoryTitle);
        String formatXml = bean.getChartNumberFormat().getXmlValue();
        treeChartModel.setMeasureFormat(QingTransferUtil.XMLtoQingNumFormat(formatXml));
        treeChartModel.setLabelCaptions(list);
        treeChartModel.setSizeCaption(chart.seriesName == null ? CtrlEXTMessages.getMLS("KEY_VALIDATION_value", "\u6570\u503c") : chart.seriesName);
    }
}

