/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.filter;

import com.kingdee.cosmic.ctrl.extcommon.digitalstyle.Format;
import com.kingdee.cosmic.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.cosmic.ctrl.kds.model.struct.filter.AbstractAutoFilter;
import com.kingdee.cosmic.ctrl.kds.model.struct.filter.AlgorithmUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.filter.AutoFilterConstants;
import com.kingdee.cosmic.ctrl.kds.model.struct.filter.CellValueModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.filter.ISheetAutoFilter;
import java.util.Calendar;
import java.util.Date;

public class SheetCustomAutoFilter
extends AbstractAutoFilter {
    protected byte operator1 = (byte)-1;
    protected byte operator2 = (byte)-1;
    protected String value1;
    protected String value2;
    private transient Variant variantValue1;
    private transient Variant variantValue2;
    protected byte link;

    protected SheetCustomAutoFilter(Sheet sheet, int colIndex) {
        super(sheet, colIndex);
    }

    @Override
    public ISheetAutoFilter changedColIndex(int colIndex) {
        return new SheetCustomAutoFilter(this.sheet, colIndex, this.operator1, this.value1, this.link, this.operator2, this.value2);
    }

    public SheetCustomAutoFilter(Sheet sheet, int colIndex, byte operator1, String value1, byte link, byte operator2, String value2) {
        super(sheet, colIndex);
        this.operator1 = operator1;
        this.operator2 = operator2;
        this.value1 = value1;
        this.value2 = value2;
        this.link = link;
    }

    public SheetCustomAutoFilter(Sheet sheet, int colIndex, byte operator1, String value1) {
        super(sheet, colIndex);
        this.operator1 = operator1;
        this.value1 = value1;
        this.link = 1;
    }

    protected CellValueModel preValue(Cell cell) {
        String text;
        Variant value;
        if (cell == null || cell.isEmptyContent2()) {
            value = Variant.emptyVariant;
            text = "";
        } else {
            value = cell.getValue();
            if (value.isDate()) {
                int vt = value.getVt();
                Object oValue = value.getValue();
                Date date = null;
                if (oValue instanceof Date) {
                    date = (Date)oValue;
                } else if (oValue instanceof Calendar) {
                    date = Variant.calendarToGMTDate((Calendar)oValue);
                }
                Calendar calendar = Variant.getGMTCalender();
                calendar.clear();
                if (date != null) {
                    calendar.setTime(date);
                }
                int HH = calendar.get(11);
                int NN = calendar.get(12);
                int SS = calendar.get(13);
                text = HH != 0 || NN != 0 || SS != 0 ? AlgorithmUtil.sd_yyyy_MM_dd_HH_mm_ss.get().format(date) : AlgorithmUtil.sd_yyyy_MM_dd.get().format(date);
            } else {
                text = cell.getText();
            }
        }
        return new CellValueModel(value, text);
    }

    @Override
    protected void beforeDoFilter() {
        this.variantValue1 = Format.parseData(this.value1 == null ? "" : this.value1, true);
        this.variantValue2 = Format.parseData(this.value2 == null ? "" : this.value2, true);
    }

    @Override
    protected boolean matchFilter(Cell cell) {
        CellValueModel cellValue = this.preValue(cell);
        if (this.link == 1) {
            return this.execOperator(cellValue.getValue(), cellValue.getText(), this.operator1, this.variantValue1, this.value1) && this.execOperator(cellValue.getValue(), cellValue.getText(), this.operator2, this.variantValue2, this.value2);
        }
        return this.execOperator(cellValue.getValue(), cellValue.getText(), this.operator1, this.variantValue1, this.value1) || this.execOperator(cellValue.getValue(), cellValue.getText(), this.operator2, this.variantValue2, this.value2);
    }

    private boolean execOperator(Variant operand, String text, byte operator, Variant operand2, String text2) {
        if (operator == -1) {
            return true;
        }
        if (AutoFilterConstants.O_EQUAL == operator) {
            return this.equal(operand, text, operand2, text2);
        }
        if (AutoFilterConstants.O_NOT_EQUAL == operator) {
            return !this.equal(operand, text, operand2, text2);
        }
        if (AutoFilterConstants.O_GREATER_THAN == operator) {
            return this.greaterThan(operand, operand2);
        }
        if (AutoFilterConstants.O_GREATER_THAN_OR_EQUAL == operator) {
            return this.greaterThan(operand, operand2) || this.equal(operand, text, operand2, text2);
        }
        if (AutoFilterConstants.O_LESS_THAN == operator) {
            return this.lessThan(operand, operand2);
        }
        if (AutoFilterConstants.O_LESS_THAN_OR_EQUAL == operator) {
            return this.lessThan(operand, operand2) || this.equal(operand, text, operand2, text2);
        }
        if (AutoFilterConstants.O_START_WITH == operator) {
            return this.startWith(text, text2);
        }
        if (AutoFilterConstants.O_NOT_START_WITH == operator) {
            return !this.startWith(text, text2);
        }
        if (AutoFilterConstants.O_END_WITH == operator) {
            return this.endWith(text, text2);
        }
        if (AutoFilterConstants.O_NOT_END_WITH == operator) {
            return !this.endWith(text, text2);
        }
        if (AutoFilterConstants.O_CONTAIN == operator) {
            return this.contain(text, text2);
        }
        if (AutoFilterConstants.O_NOT_CONTAIN == operator) {
            return !this.contain(text, text2);
        }
        return false;
    }

    private boolean equal(Variant operand, String text, Variant operand2, String text2) {
        int vt1 = SheetBaseMath.getVariantValueType(operand);
        int vt2 = SheetBaseMath.getVariantValueType(operand2);
        if (text2.equals(text)) {
            return true;
        }
        if (vt1 != vt2 && (vt1 != SheetBaseMath.DataType_Number && vt1 != SheetBaseMath.DataType_DateTime || vt2 != SheetBaseMath.DataType_Number && vt2 != SheetBaseMath.DataType_DateTime)) {
            return false;
        }
        if (vt1 == vt2 && vt1 == SheetBaseMath.DataType_Empty) {
            return true;
        }
        return operand.equals(operand2);
    }

    private boolean greaterThan(Variant operand, Variant operand2) {
        int vt1 = SheetBaseMath.getVariantValueType(operand);
        if (vt1 == SheetBaseMath.DataType_Empty) {
            return false;
        }
        int vt2 = SheetBaseMath.getVariantValueType(operand2);
        if (vt1 != vt2 && (vt1 != SheetBaseMath.DataType_Number && vt1 != SheetBaseMath.DataType_DateTime || vt2 != SheetBaseMath.DataType_Number && vt2 != SheetBaseMath.DataType_DateTime)) {
            return false;
        }
        boolean result = false;
        try {
            result = operand.greaterThan(operand2);
        }
        catch (SyntaxErrorException syntaxErrorException) {
            // empty catch block
        }
        return result;
    }

    private boolean lessThan(Variant operand, Variant operand2) {
        int vt1 = SheetBaseMath.getVariantValueType(operand);
        if (vt1 == SheetBaseMath.DataType_Empty) {
            return false;
        }
        int vt2 = SheetBaseMath.getVariantValueType(operand2);
        if (vt1 != vt2 && (vt1 != SheetBaseMath.DataType_Number && vt1 != SheetBaseMath.DataType_DateTime || vt2 != SheetBaseMath.DataType_Number && vt2 != SheetBaseMath.DataType_DateTime)) {
            return false;
        }
        boolean result = false;
        try {
            result = operand.lessThan(operand2);
        }
        catch (SyntaxErrorException syntaxErrorException) {
            // empty catch block
        }
        return result;
    }

    private boolean startWith(String text, String operand2) {
        return AlgorithmUtil.matches(operand2 + "*", text);
    }

    private boolean endWith(String text, String operand2) {
        return AlgorithmUtil.matches("*" + operand2, text);
    }

    private boolean contain(String text, String operand2) {
        return AlgorithmUtil.matches("*" + operand2 + "*", text);
    }

    public byte getCustomType() {
        if (this.operator2 == -1) {
            if (AutoFilterConstants.O_EQUAL == this.operator1) {
                return AutoFilterConstants.CUSTOM_TYPE_EQUAL;
            }
            if (this.dataItemModel.getDataType() != 1 && AutoFilterConstants.O_NOT_EQUAL == this.operator1) {
                return AutoFilterConstants.CUSTOM_TYPE_NOT_EQUAL;
            }
            if (this.dataItemModel.getDataType() != 4 && AutoFilterConstants.O_GREATER_THAN == this.operator1) {
                return AutoFilterConstants.CUSTOM_TYPE_GREATER_THAN;
            }
            if (this.dataItemModel.getDataType() == 3 && AutoFilterConstants.O_GREATER_THAN_OR_EQUAL == this.operator1) {
                return AutoFilterConstants.CUSTOM_TYPE_GREATER_THAN_OR_EQUAL;
            }
            if (this.dataItemModel.getDataType() != 4 && AutoFilterConstants.O_LESS_THAN == this.operator1) {
                return AutoFilterConstants.CUSTOM_TYPE_LESS_THAN;
            }
            if (this.dataItemModel.getDataType() == 3 && AutoFilterConstants.O_LESS_THAN_OR_EQUAL == this.operator1) {
                return AutoFilterConstants.CUSTOM_TYPE_LESS_THAN_OR_EQUAL;
            }
            if (this.dataItemModel.getDataType() == 4 && AutoFilterConstants.O_START_WITH == this.operator1) {
                return AutoFilterConstants.CUSTOM_TYPE_START_WITH;
            }
            if (this.dataItemModel.getDataType() == 4 && AutoFilterConstants.O_END_WITH == this.operator1) {
                return AutoFilterConstants.CUSTOM_TYPE_END_WITH;
            }
            if (this.dataItemModel.getDataType() == 4 && AutoFilterConstants.O_CONTAIN == this.operator1) {
                return AutoFilterConstants.CUSTOM_TYPE_CONTAIN;
            }
            if (this.dataItemModel.getDataType() == 4 && AutoFilterConstants.O_NOT_CONTAIN == this.operator1) {
                return AutoFilterConstants.CUSTOM_TYPE_NOT_CONTAIN;
            }
            return AutoFilterConstants.CUSTOM_TYPE_CUSTOM;
        }
        if (this.dataItemModel.getDataType() != 3 && AutoFilterConstants.O_GREATER_THAN_OR_EQUAL == this.operator1 && AutoFilterConstants.O_LESS_THAN_OR_EQUAL == this.operator2) {
            return AutoFilterConstants.CUSTOM_TYPE_BETWEEN;
        }
        return AutoFilterConstants.CUSTOM_TYPE_CUSTOM;
    }

    @Override
    public int getAutoFilterType() {
        return 5;
    }

    public byte getOperator1() {
        return this.operator1;
    }

    public byte getOperator2() {
        return this.operator2;
    }

    public String getValue1() {
        return this.value1;
    }

    public String getValue2() {
        return this.value2;
    }

    public byte getLink() {
        return this.link;
    }
}

