/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.undo;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.kds.model.struct.undo.IUndoableEdit;
import com.kingdee.cosmic.ctrl.kds.model.struct.undo.UndoException;

public class AbstractUndoableEdit
implements IUndoableEdit {
    boolean hasBeenDone = true;
    boolean alive = true;

    protected static final String getUndoName() {
        return CtrlEXTMessages.getMLS("undo2", "\u64a4\u9500 ");
    }

    protected static final String getRedoName() {
        return CtrlEXTMessages.getMLS("redo3", "\u6062\u590d ");
    }

    @Override
    public void undo() throws UndoException {
        if (!this.canUndo()) {
            throw new UndoException("Undo");
        }
        this.hasBeenDone = false;
    }

    @Override
    public boolean canUndo() {
        return this.alive && this.hasBeenDone;
    }

    @Override
    public void redo() throws UndoException {
        if (!this.canRedo()) {
            throw new UndoException("Redo");
        }
        this.hasBeenDone = true;
    }

    @Override
    public boolean canRedo() {
        return this.alive && !this.hasBeenDone;
    }

    @Override
    public void die() {
        this.alive = false;
    }

    @Override
    public boolean addEdit(IUndoableEdit anEdit) {
        return false;
    }

    @Override
    public boolean replaceEdit(IUndoableEdit anEdit) {
        return false;
    }

    @Override
    public boolean isSignificant() {
        return true;
    }

    @Override
    public String getPresentationName() {
        return "";
    }

    @Override
    public String getUndoPresentationName() {
        return AbstractUndoableEdit.getUndoName() + this.getPresentationName();
    }

    @Override
    public String getRedoPresentationName() {
        return AbstractUndoableEdit.getRedoName() + this.getPresentationName();
    }
}

