/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.validate;

import com.kingdee.cosmic.ctrl.ext.reporting.model.design.IEditorDefine;
import com.kingdee.cosmic.ctrl.ext.reporting.model.design.NullEditorDefine;
import com.kingdee.cosmic.ctrl.kds.model.struct.CellBlock;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.validate.util.MessagedValidate;
import com.kingdee.cosmic.ctrl.kds.model.util.SortedCellBlockArray;
import java.util.ArrayList;

public final class Validation {
    private SortedCellBlockArray _blocks;
    private MessagedValidate _validate;
    private IEditorDefine _editorDefine;
    private Sheet _sheet;
    private boolean _isReportingValidation = true;

    public Validation(Sheet sheet, MessagedValidate validate, SortedCellBlockArray blocks) {
        this._validate = validate;
        this._blocks = blocks;
        this._sheet = sheet;
    }

    public Validation getClippedCopy(int left, int top, int right, int bottom) {
        ArrayList<CellBlock> blocks = new ArrayList<CellBlock>();
        for (int i = 0; i < this._blocks.size(); ++i) {
            CellBlock cb = this._blocks.getBlock(i).intersection(top, left, bottom, right);
            if (cb == null) continue;
            blocks.add(cb);
        }
        if (blocks.size() == 0) {
            return null;
        }
        SortedCellBlockArray scba = new SortedCellBlockArray();
        for (int i = 0; i < blocks.size(); ++i) {
            scba.insert(blocks.get(i));
        }
        return new Validation(this._sheet, this._validate, scba);
    }

    public SortedCellBlockArray getBlocks() {
        return this._blocks;
    }

    public void setBlocks(SortedCellBlockArray blocks) {
        this._blocks = blocks;
    }

    public MessagedValidate getMessagedValidate() {
        return this._validate;
    }

    public void setMessagedValidate(MessagedValidate vm) {
        this._validate = vm;
    }

    public void setEditorDefine(IEditorDefine ed) {
        this._editorDefine = ed;
    }

    public IEditorDefine getEditorDefine() {
        if (this._editorDefine == null) {
            this._editorDefine = new NullEditorDefine();
        }
        return this._editorDefine;
    }

    public Sheet getSheet() {
        return this._sheet;
    }

    public void setReportingValidation(boolean isReportingValidation) {
        this._isReportingValidation = isReportingValidation;
    }

    public boolean isReportingValidation() {
        return this._isReportingValidation;
    }
}

